<?php

/**
 * The template for displaying page title in page title section
 *
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

if (is_search()) :
	$seedone_search_query = esc_html(get_search_query());
	if ((bool) trim($seedone_search_query) === false) :
		echo esc_html__('Search', 'seedone');
	else :
		echo esc_html__('Search Results for: ', 'seedone');
		echo esc_html($seedone_search_query);
	endif;

	return;
endif;

if (is_home()) :
	$seedone_title = seedone_option('blog_page_name', esc_html__('Blog', 'seedone'));
	echo esc_html($seedone_title);

	return;
endif;

if (is_404()) :
	$seedone_title = esc_html__('404', 'seedone');
	echo esc_html($seedone_title);

	return;
endif;

if (function_exists('is_shop')) :
	if (is_shop()) :
		$seedone_title = esc_html__('Shop', 'seedone');
		echo esc_html($seedone_title);

		return;
	endif;
endif;

if (is_singular()) :
	the_title();

	return;
endif;

if (is_archive()) :
	$seedone_hide_tax_name_class = seedone_option('title_hide_taxonomy_name', '') ? 'hide-tax-name' : 'tax-name';
	echo '<span class="' . esc_attr($seedone_hide_tax_name_class) . '">';
	the_archive_title();
	echo '</span>';

	return;
endif;
