<?php

/**
 * The template for displaying all default single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<div class="title-wrap">

		<div class="author-post">By <?php the_author(); ?><h3 class="background-author">Post</h3>
		</div>
		<?php the_title('<div class="entry-title" itemprop="headline"><span>', '</span></div>'); ?>
	</div>
	<?php

	seedone_post_thumbnail('seedone-single-post');

	?>
	<div class="item-content">
		<?php

		$seedone_show_title = !seedone_option('title_show_title', '') && get_the_title();
		if ($seedone_show_title) :
		?>
			<header class="entry-header">
				<?php the_title('<h1 class="entry-title" itemprop="headline"><span>', '</span></h1>'); ?>
			</header>
		<?php
		else :
			echo '<h4 class="hidden" itemscope="itemscope" itemprop="headline" itemtype="https://schema.org/Text">' . esc_html(get_the_title()) . '</h4>';
		endif; //show_title
		?>

		<div class="entry-content" itemprop="text">
			<footer class="entry-footer entry-footer-top">
				<?php seedone_entry_meta(true, true, false, false, true, true); ?>
			</footer>
			<!-- .entry-footer -->
			<?php
			the_content();

			wp_link_pages(
				seedone_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->

		<footer class="entry-footer entry-footer-bottom">
			<div class="meta-tags">
				<?php
				seedone_entry_meta(false, false, false, true, false, false);
				?>
			</div>
		</footer>
		<!-- .entry-footer -->
		<?php
		if (function_exists('seedone_share_this')) {
			seedone_share_this();
		}
		?>
	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->
<?php

get_template_part('template-parts/post/bio');
//bio

seedone_post_nav();

//seedone_related_posts(get_the_ID());

// If comments are open or we have at least one comment, load up the comment template.
if (comments_open() || get_comments_number()) {
	comments_template();
}
?>