<?php

/**
 * The template to display post author bio
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$seedone_author_id = get_the_author_meta('ID');

$seedone_show_bio   = seedone_option('blog_single_show_author_bio', true);
$seedone_author_bio = get_the_author_meta('description', $seedone_author_id);

if (empty($seedone_show_bio) || empty($seedone_author_bio)) {
	return;
}

//SEO additional fields
$seedone_twitter_url 	  = get_the_author_meta('twitter', $seedone_author_id);
$seedone_facebook_url     = get_the_author_meta('facebook', $seedone_author_id);
$seedone_linkedin_url     = get_the_author_meta('linkedin', $seedone_author_id);
$seedone_instagram_url    = get_the_author_meta('instagram', $seedone_author_id);
$seedone_youtube_url      = get_the_author_meta('youtube', $seedone_author_id);
$seedone_custom_image_url = get_the_author_meta('custom_profile_image', $seedone_author_id);
?>
<div class="author-meta">
	<div class="side-item has-post-thumbnail">
		<div class="item-media">
			<?php
			if (!empty($seedone_custom_image_url)) {
				echo '<img src="' . esc_url($seedone_custom_image_url) . '" alt="' . esc_attr(get_the_author_meta('display_name', $seedone_author_id)) . '">';
			} else {
				echo get_avatar($seedone_author_id, 700);
			}
			?>
		</div><!-- eof .item-media -->
		<div class="item-content">
			<?php
			$seedone_about_word = seedone_option('blog_single_author_bio_about_word');
			if (!empty($seedone_about_word)) :
			?>
				<p class="about-author-heading">
					<?php echo esc_html($seedone_about_word); ?>
				</p>
			<?php endif; ?>
			<h5 class="author-name mt-0">
				<?php
				the_author();
				//echo wp_kses_post( get_the_author_meta( 'display_name', $seedone_author_id ) );
				?>
			</h5>
			<?php if (!empty($seedone_author_bio)) : ?>
				<p class="author-bio">
					<?php echo wp_kses_post($seedone_author_bio); ?>
				</p>
			<?php
			endif; //author_bio
			if ($seedone_twitter_username || $seedone_facebook_url || $seedone_linkedin_url || $seedone_instagram_url || $seedone_youtube_url) :
			?>
				<span class="social-links author-social">
					<?php

					if ($seedone_facebook_url) :
						seedone_social_link('facebook', $seedone_facebook_url);
					endif;
					if ($seedone_twitter_url) :
						seedone_social_link('twitter', $seedone_twitter_url);
					endif;
					if ($seedone_instagram_url) :
						seedone_social_link('instagram', $seedone_instagram_url);
					endif;
					if ($seedone_linkedin_url) :
						seedone_social_link('linkedin', $seedone_linkedin_url);
					endif;
					if ($seedone_youtube_url) :
						seedone_social_link('youtube', $seedone_youtube_url);
					endif;
					?>
				</span><!-- eof .author-social -->
			<?php endif; //author social 
			?>
		</div><!-- eof .item-content -->
	</div><!-- eof author-meta -->
</div>
<?php
