<?php

/**
 * The main template file
 * Also used in the Customizer preview
 * It contains the index.php file but without header and footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$seedone_show_title = seedone_get_feed_shot_title();
$seedone_layout     = seedone_get_feed_layout();
$seedone_layout_gap = seedone_get_feed_gap();

//layout may contain columns count separated by space and 'masonry' word after columns count
$seedone_layout         = explode(' ', $seedone_layout);
$seedone_columns_number = (!empty($seedone_layout[1])) ? absint($seedone_layout[1]) : '';
$seedone_masonry        = (!empty($seedone_layout[2]) && 'masonry' === $seedone_layout[2]) ? true : false;
$seedone_grid_class     = (!empty($seedone_masonry)) ? 'masonry' : 'grid-wrapper';
$seedone_layout         = $seedone_layout[0];
$seedone_columns        = (!empty($seedone_columns_number)) ? true : false;

//additional css classes for #layout div element
$seedone_layout_class  = 'layout-' . $seedone_layout;
$seedone_layout_class .= !empty($seedone_columns) ? ' layout-cols-' . $seedone_columns_number : ' layout-cols-1';
$seedone_layout_class .= !empty($seedone_layout_gap) ? ' layout-gap-' . $seedone_layout_gap : ' layout-gap-default';

if (!empty($seedone_masonry)) {
	seedone_enqueue_masonry_action();
}

if (have_posts()) :
?>
	<div id="layout" class="<?php echo esc_attr($seedone_layout_class); ?>">
		<?php if (!empty($seedone_show_title)) : ?>
			<h1 class="archive-title">
				<span><?php get_template_part('template-parts/title/title-text'); ?></span>
			</h1>
		<?php
		endif; //show_title

		if (is_category()) :
			$seedone_category_description = category_description();
			if (!empty($seedone_category_description)) {
				echo '<div class="category-description">' . wp_kses_post($seedone_category_description) . '</div><!-- .category-description -->';
			}
		endif; //is_category

		if (!empty($seedone_columns)) :
			// read about masonry layout here:
			// https://masonry.desandro.com/options.html
			// https://github.com/desandro/masonry/issues/549
		?>
			<div class="grid-columns-wrapper">
				<div class="<?php echo esc_attr($seedone_grid_class); ?>">
					<div class="grid-sizer"></div>
				<?php
			endif; //columns

			// Load posts loop.
			while (have_posts()) :

				the_post();
				get_template_part('template-parts/blog/' . $seedone_layout . '/content');

			endwhile;

			if (!empty($seedone_columns)) :
				?>
				</div><!-- .<?php echo esc_html($seedone_grid_class); ?>-->
			</div><!-- .grid-columns-wrapper -->
		<?php
			endif; //columns

			// Previous/next page navigation.
			the_posts_pagination(
				seedone_get_the_posts_pagination_atts()
			);

		?>
	</div><!-- #layout -->
<?php
else :

	// If no content, include the "No posts found" template.
	get_template_part('template-parts/content', 'none');

endif; //have_posts
