<?php
/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
//topline text
$seedone_text = seedone_option( 'meta_topline_text', '' );

$seedone_fluid              = seedone_option( 'topline_fluid' ) ? '-fluid' : '';
$seedone_topline_background = seedone_option( 'topline_background', '' );
$seedone_font_size          = seedone_option( 'topline_font_size', '' );
?>
<div id="topline" class="topline <?php echo esc_attr( $seedone_topline_background . ' ' . $seedone_font_size ); ?>">
	<div class="container<?php echo esc_attr( $seedone_fluid ); ?>">
		<?php if ( ! empty( $seedone_text ) ) : ?>
			<div id="topline_dropdown" class="dropdown">
				<button id="topline_dropdown_toggle" class="nav-btn type-dots"
						aria-controls="topline_dropdown"
						aria-expanded="false"
						aria-label="<?php esc_attr_e( 'Topline Info Toggler', 'seedone' ); ?>"
				>
					<span></span>
				</button>

				<span class="dropdown-menu dropdown-menu-md topline-custom-text">
					<?php if ( ! empty( $seedone_text ) ) : ?>
						<span>
						<?php echo wp_kses_post( $seedone_text ); ?>
						</span>
					<?php endif; //text ?>
				</span><!-- .topline-custom-text -->
			</div><!-- #topline_dropdown -->
			<?php
		endif; //! empty text
		seedone_social_links();
		?>
	</div><!-- .container -->
</div><!-- #topline -->
