<?php
/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$seedone_fluid              = seedone_option( 'topline_fluid' ) ? '-fluid' : '';
$seedone_topline_background = seedone_option( 'topline_background', '' );
$seedone_font_size          = seedone_option( 'topline_font_size', '' );
?>
<div id="topline" class="topline <?php echo esc_attr( $seedone_topline_background . ' ' . $seedone_font_size ); ?>">
	<div class="container<?php echo esc_attr( $seedone_fluid ); ?>">
		<?php if ( has_nav_menu( 'topline' ) ) : ?>
			<div id="topline_dropdown" class="dropdown">
				<button id="topline_dropdown_toggle" class="nav-btn type-dots"
						aria-controls="topline_dropdown"
						aria-expanded="false"
						aria-label="<?php esc_attr_e( 'Topline Menu Toggler', 'seedone' ); ?>"
				>
					<span></span>
				</button>
				<div class="dropdown-menu dropdown-menu-md topline-menu-dropdown">
					<nav class="topline-navigation" aria-label="<?php esc_attr_e( 'Topline Menu', 'seedone' ); ?>">
						<?php
						wp_nav_menu(
							array(
								'theme_location' => 'topline',
								'menu_class'     => 'topline-menu',
								'container'      => false,
								'depth'          => 1,
							)
						);
						?>
					</nav><!-- .topline-navigation -->
				</div><!-- .site-meta -->
			</div><!-- #topline_dropdown -->
			<?php
		endif; //has_nav_menu

		seedone_social_links();

		?>
	</div><!-- .container -->
</div><!-- #topline -->
