<?php
/**
 * The logo template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$seedone_custom_logo         = seedone_option( 'custom_logo' );
$seedone_logo_image_class    = ( ! empty( $seedone_custom_logo ) ) ? 'with-image' : 'no-image';
$seedone_logo_text_primary   = seedone_option( 'logo_text_primary' );
$seedone_logo_text_secondary = seedone_option( 'logo_text_secondary' );
$seedone_logo_background     = seedone_option( 'logo_background' );
$seedone_logo_x_padding      = seedone_option( 'logo_padding_horizontal' );
$seedone_logo_padding_class  = ( ! empty( $seedone_logo_x_padding ) ) ? 'px' : '';

//if no text - get blog name for primary text
if ( empty( $seedone_logo_text_primary ) && empty( $seedone_logo_text_secondary ) && empty( $seedone_custom_logo ) ) {
	$seedone_logo_text_primary = get_bloginfo( 'name' );
}
?>
<a class="logo logo-between <?php echo esc_attr( $seedone_logo_image_class . ' ' . $seedone_logo_background . ' ' . $seedone_logo_padding_class ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" itemprop="url">
	<?php if ( ! empty( $seedone_logo_text_primary ) ) : ?>
		<span class="logo-text-primary">
			<?php echo wp_kses_post( $seedone_logo_text_primary ); ?>
		</span><!-- .logo-text-primary -->
		<?php
	endif;

	//image
	echo wp_get_attachment_image( $seedone_custom_logo, 'full' );

	if ( ! empty( $seedone_logo_text_secondary ) ) :
		?>
		<span class="logo-text-secondary">
		<?php echo wp_kses_post( $seedone_logo_text_secondary ); ?>
	</span><!-- .logo-text-secondary -->
	<?php endif; ?>
</a><!-- .logo -->
