<?php

/**
 * The footer section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//this footer displays only widgets so if has no widgets - it will be hidden
if (!is_active_sidebar('sidebar-footer-top')) {
    if (is_customize_preview()) {
        echo '<footer id="footer" class="d-none"></footer>';
    }
    return;
}

$seedone_fluid = seedone_option('footer_fluid') ? '-fluid' : '';

$seedone_footer_background    = seedone_option('footer_background', '');
$seedone_extra_padding_top    = seedone_option('footer_extra_padding_top', '');
$seedone_extra_padding_bottom = seedone_option('footer_extra_padding_bottom', '');

$seedone_border_top        = seedone_option('footer_border_top', '');
$seedone_border_bottom     = seedone_option('footer_border_bottom', '');
$seedone_font_size         = seedone_option('footer_font_size', '');
$seedone_footer_layout_gap = seedone_option('footer_layout_gap', '');

$seedone_background_image = seedone_section_background_image_array('footer');
?>
<footer id="footer" class="footer footer-10 <?php echo esc_attr($seedone_footer_background . ' ' . $seedone_font_size . ' ' . $seedone_background_image['class']); ?>" <?php echo (!empty($seedone_background_image['url'])) ? 'style="background-image: url(' . esc_url($seedone_background_image['url']) . ');"' : ''; ?>>
    <?php
    if ('full' === $seedone_border_top) {
        echo wp_kses_post('<hr class="section-hr">');
    }
    ?>
    <div class="container<?php echo esc_attr($seedone_fluid . ' ' . $seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
        <?php
        if ('container' === $seedone_border_top) {
            echo wp_kses_post('<hr class="section-hr">');
        }

        ?>

        <div class="footer-widgets-wrap <?php echo esc_attr('layout-gap-' . $seedone_footer_layout_gap); ?>">
            <div class="grid-wrapper">
                <div class="footer-widgets-top">
                    <div class="widgets-block-top">
                        <?php dynamic_sidebar('sidebar-footer-top'); ?>
                    </div>
                </div>
                <div class="footer-widgets layout-cols-3">
                    <div class="grid-item">
                        <?php dynamic_sidebar('sidebar-footer-1'); ?>
                    </div>
                    <div class="d-flex grid-item">
                        <div class="widgets-block-2">
                            <?php dynamic_sidebar('sidebar-footer-2'); ?>
                        </div>
                        <div class="widgets-block-3 <?php echo esc_attr('pl-' . $seedone_footer_layout_gap / 2); ?>">
                            <?php dynamic_sidebar('sidebar-footer-3'); ?>
                        </div>
                    </div>
                    <div class="d-flex grid-item">
                        <div class="widgets-block-4">
                            <?php dynamic_sidebar('sidebar-footer-4'); ?>
                        </div>
                        <div class="widgets-block-5 <?php echo esc_attr('pl-' . $seedone_footer_layout_gap / 2); ?>">
                            <?php dynamic_sidebar('sidebar-footer-5'); ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php

            if ('container' === $seedone_border_bottom) {
                echo wp_kses_post('<hr class="section-hr">');
            }
            ?>
        </div><!-- .container -->
        <?php
        if ('full' === $seedone_border_bottom) {
            echo wp_kses_post('<hr class="section-hr">');
        }
        ?>
</footer><!-- #footer -->