<?php

/**
 * The footer top section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//text
$seedone_footer_top_pre_heading = seedone_option('footer_top_pre_heading', '');
$seedone_footer_top_background_text = seedone_option('footer_top_background_text', '');
$seedone_footer_top_heading     = seedone_option('footer_top_heading', '');
$seedone_footer_top_description = seedone_option('footer_top_description', '');
$seedone_footer_top_shortcode   = seedone_option('footer_top_shortcode', '');

if (
	empty($seedone_footer_top_pre_heading)
	&&
	empty($seedone_footer_top_heading)
	&&
	empty($seedone_footer_top_description)
	&&
	empty($seedone_footer_top_shortcode)
) {
	return;
}

$seedone_fluid = seedone_option('footer_fluid') ? '-fluid' : '';

$seedone_footer_top_background = seedone_option('footer_top_background', '');
$seedone_extra_padding_top     = seedone_option('footer_top_extra_padding_top', '');
$seedone_extra_padding_bottom  = seedone_option('footer_top_extra_padding_bottom', '');

$seedone_border_top    = seedone_option('footer_top_border_top', '');
$seedone_border_bottom = seedone_option('footer_top_border_bottom', '');
$seedone_font_size     = seedone_option('footer_top_font_size', '');

$seedone_background_image = seedone_section_background_image_array('footer_top');
$seedone_absolute_image = seedone_option('footer_top_absolute_image');

//animation
//animate an__XXX
//footer_top_heading_animation
//footer_top_description_animation
//footer_top_button_first_animation
//footer_top_button_second_animation
//footer_top_shortcode_animation
$seedone_footer_top_pre_heading_animation   = seedone_option('footer_top_pre_heading_animation', '') ? 'animate an__' . seedone_option('footer_top_pre_heading_animation') : '';
$seedone_footer_top_heading_animation       = seedone_option('footer_top_heading_animation', '') ? 'animate an__' . seedone_option('footer_top_heading_animation') : '';
$seedone_footer_top_description_animation   = seedone_option('footer_top_description_animation', '') ? 'animate an__' . seedone_option('footer_top_description_animation') : '';
$seedone_footer_top_button_first_animation  = seedone_option('footer_top_button_first_animation', '') ? 'animate an__' . seedone_option('footer_top_button_first_animation') : '';
$seedone_footer_top_button_second_animation = seedone_option('footer_top_button_second_animation', '') ? 'animate an__' . seedone_option('footer_top_button_second_animation') : '';
$seedone_footer_top_shortcode_animation     = seedone_option('footer_top_shortcode_animation', '') ? 'animate an__' . seedone_option('footer_top_shortcode_animation') : '';

?>
<section id="footer-top" class="footer-top footer-top-2 text-center <?php echo esc_attr($seedone_footer_top_background . ' ' . $seedone_font_size . ' ' . $seedone_background_image['class']); ?>" <?php echo (!empty($seedone_background_image['url'])) ? 'style="background-image: url(' . esc_url($seedone_background_image['url']) . ');"' : ''; ?>>
	<?php
	if ('full' === $seedone_border_top) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
	<div class="container<?php echo esc_attr($seedone_fluid . ' ' . $seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
		<?php
		if ('container' === $seedone_border_top) {
			echo wp_kses_post('<hr class="section-hr">');
		}


		if (!empty($seedone_footer_top_pre_heading)) :
			$seedone_footer_top_pre_heading_mt = seedone_option('footer_top_pre_heading_mt', '');
			$seedone_footer_top_pre_heading_mb = seedone_option('footer_top_pre_heading_mb', '');
		?>
			<p class="footer_top-pre-heading <?php echo esc_attr($seedone_footer_top_pre_heading_animation . ' ' . $seedone_footer_top_pre_heading_mt . ' ' . $seedone_footer_top_pre_heading_mb); ?>">
				<?php echo wp_kses_post($seedone_footer_top_pre_heading); ?>
				<?php if (!empty($seedone_footer_top_background_text)) : ?>
					<span class="footer_top-background-text">
						<?php echo wp_kses_post($seedone_footer_top_background_text); ?>
					</span>
				<?php
				endif; //footer_top_background_text
				?>
			</p>
		<?php
		endif; //footer_top_pre_heading



		if (!empty($seedone_footer_top_heading)) :
			$seedone_footer_top_heading_mt = seedone_option('footer_top_heading_mt', '');
			$seedone_footer_top_heading_mb = seedone_option('footer_top_heading_mb', '');
		?>
			<h3 class="footer_top-heading <?php echo esc_attr($seedone_footer_top_heading_animation . ' ' . $seedone_footer_top_heading_mt . ' ' . $seedone_footer_top_heading_mb); ?>">
				<?php echo wp_kses_post($seedone_footer_top_heading); ?>
			</h3>
		<?php
		endif; //footer_top_heading

		if (!empty($seedone_footer_top_description)) :
			$seedone_footer_top_description_mt = seedone_option('footer_top_description_mt', '');
			$seedone_footer_top_description_mb = seedone_option('footer_top_description_mb', '');
		?>
			<div class="footer_top-description <?php echo esc_attr($seedone_footer_top_description_animation . ' ' . $seedone_footer_top_description_mt . ' ' . $seedone_footer_top_description_mb); ?>">
				<?php echo wp_kses_post($seedone_footer_top_description); ?>
			</div>
		<?php
		endif; //footer_top_description

		if (!empty($seedone_footer_top_shortcode)) :
			$seedone_footer_top_shortcode_mt = seedone_option('footer_top_shortcode_mt', '');
			$seedone_footer_top_shortcode_mb = seedone_option('footer_top_shortcode_mb', '');
		?>
			<div class="footer_top-shortcode <?php echo esc_attr($seedone_footer_top_shortcode_animation . ' ' . $seedone_footer_top_shortcode_mt . ' ' . $seedone_footer_top_shortcode_mb); ?>">
				<?php echo do_shortcode($seedone_footer_top_shortcode); ?>
			</div>
		<?php
		endif; //footer_top_shortcode

		if ('container' === $seedone_border_bottom) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>

	</div><!-- .container -->
	<?php
	if ('full' === $seedone_border_bottom) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
	<?php if (!empty($seedone_absolute_image)) { ?>
		<div class="footer_top_absolute_image">
			<img src="<?php echo esc_url($seedone_absolute_image); ?>" alt="<?php esc_attr_e('Image absolute', 'seedone'); ?>">
		</div>
	<?php } ?>
</section><!-- #footer -->