<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'title-only' ); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<footer class="entry-footer entry-footer-top"><?php seedone_entry_meta( true, true, true, true, true ); ?></footer>
		<!-- .entry-footer -->
	<?php if ( get_the_title() ) : ?>
	<header class="entry-header">
		<?php
		seedone_sticky_post_label();
		the_title( sprintf( '<h3 class="entry-title icon-inline" itemprop="headline">%s<a href="%s" rel="bookmark">', seedone_icon( 'file-document-outline', true ), esc_url( get_permalink() ) ), '</a></h3>' );
		?>
	</header><!-- .entry-header -->
	<?php endif; //get_the_title ?>
</article><!-- #post-<?php the_ID(); ?> -->
