<?php

/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 * @version 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$seedone_css_classes = seedone_get_layout_css_classes();

if (empty($seedone_css_classes['aside'])) {
	if (is_customize_preview()) {
		echo '<aside id="aside" class="d-none"></aside>';
	}
	return;
}
$seedone_sidebar_sticky       = seedone_option('main_sidebar_sticky', false);

$seedone_sidebar_margin_right = seedone_option('main_sidebar_margin_right', '');

$seedone_sidebar_sticky_class = !empty($seedone_sidebar_sticky) ? ' sticky' : '';
$seedone_font_size            = seedone_option('sidebar_font_size', '');
$seedone_sidebar_extra_class  = '';
if (is_page_template('page-templates/home.php') || is_front_page()) {
	if (is_active_sidebar('sidebar-home-after-columns')) {
		$seedone_sidebar_extra_class .= 'with-after-columns-sidebar';
	}
}
?>
<aside id="aside" itemtype="https://schema.org/WPSideBar" itemscope="itemscope" class="<?php echo esc_attr($seedone_css_classes['aside'] . ' ' . $seedone_font_size . ' ' . $seedone_sidebar_extra_class); ?> m-lg-<?php echo esc_attr($seedone_sidebar_margin_right) ?>">
	<div class="widgets-wrap<?php echo esc_attr($seedone_sidebar_sticky_class); ?>">

		<?php
		/**
		 * Fires at the top of aside column.
		 *
		 * @since Seedone 0.0.1
		 */
		do_action('seedone_action_top_of_aside_column');

		if (seedone_is_shop()) {
			dynamic_sidebar('shop');
		} else {
			if (is_page_template('page-templates/home.php') || is_front_page()) {
				if (is_active_sidebar('sidebar-home-main')) {
					dynamic_sidebar('sidebar-home-main');
				} else {
					dynamic_sidebar('sidebar-1');
				}
			} else {
				dynamic_sidebar('sidebar-1');
			}
		}

		/**
		 * Fires at the bottom of aside column.
		 *
		 * @since Seedone 0.0.1
		 */
		do_action('seedone_action_bottom_of_aside_column');

		?>

	</div><!-- .widgets-wrap -->
</aside><!-- .column-aside -->