<?php

/**
 * Theme static files
 *
 * @package Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

/**
 * Enqueue scripts and styles.
 */
//front end styles and scripts
if (!function_exists('seedone_enqueue_static')) :
	function seedone_enqueue_static()
	{

		$min = seedone_option('assets_min') ? 'min/' : '';

		//main theme css file
		wp_enqueue_style('seedone-style', SEEDONE_THEME_URI . '/assets/css/' . $min . 'style.css', array(), SEEDONE_THEME_VERSION);

		$seedone_colors_string = seedone_get_root_colors_inline_styles_string();
		if (!empty($seedone_colors_string)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					':root{' . $seedone_colors_string . '}',
					false
				)
			);
		endif;


		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'button[type="submit"]:not([name="apply_coupon"]):not(.wp-block-search__button):not(.widget_mc4wp_form_widget .mc4wp-form-fields button)::before{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',
					false
				)
			);
		endif;

		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'input[type="submit"]::before{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',
					false
				)
			);
		endif;

		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.button:not(.add_to_cart_button):not([name="apply_coupon"]):not(.product_type_grouped):not(.product_type_external)::before{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',
					false
				)
			);
		endif;

		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.premium-button::before{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',

					false
				)
			);
		endif;

		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.elementor-button::before{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',

					false
				)
			);
		endif;

		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.premium-banner-read-more::after{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',

					false
				)
			);
		endif;

		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.wp-block-button__link.header-button::before{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',

					false
				)
			);
		endif;

		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(

					'.premium-gallery-load-more-btn::before{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',
					false
				)
			);
		endif;

		$button_bg_hover_image = seedone_option('logo_btn_hover_image', '');
		if (!empty($button_bg_hover_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(

					'.ectbe-events-read-more::before{background-image:url(' . esc_url($button_bg_hover_image) . ') !important;}',
					false
				)
			);
		endif;

		$button_play_bg_image = seedone_option('blog_button_background_img', '');
		if (!empty($button_play_bg_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.post-thumbnail .svg-icon::before{background-image:url(' . esc_url($button_play_bg_image) . ');}',
					false
				)
			);
		endif;

		$button_play_bg_image = seedone_option('blog_button_background_img', '');
		if (!empty($button_play_bg_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.widget.widget_custom_posts .layout-slider .svg-icon.icon-video::before{background-image:url(' . esc_url($button_play_bg_image) . ');}',
					false
				)
			);
		endif;

		$button_play_bg_image = seedone_option('blog_button_background_img', '');
		if (!empty($button_play_bg_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.play-icon-custom .elementor-custom-embed-play i::before{background-image:url(' . esc_url($button_play_bg_image) . ');}',
					false
				)
			);
		endif;

		$blockquote_bg_image = seedone_option('blog_single_blockquote_image', '');
		if (!empty($blockquote_bg_image)) :
			wp_add_inline_style(
				'seedone-style',
				wp_kses(
					'.blockquote,
					.wp-block-quote::before{background-image:url(' . esc_url($blockquote_bg_image) . ');}',
					false
				)
			);
		endif;

		wp_enqueue_style('font-awesome', SEEDONE_THEME_URI . '/assets/css/' . $min . 'all.css', array(), SEEDONE_THEME_VERSION);
		wp_enqueue_style('icomoon', SEEDONE_THEME_URI . '/assets/css/' . $min . 'icomoon.css', array(), SEEDONE_THEME_VERSION);

		//Woo styles
		if (class_exists('WooCommerce')) {
			wp_enqueue_style('seedone-shop-style', SEEDONE_THEME_URI . '/assets/css/' . $min . 'shop.css', array(), SEEDONE_THEME_VERSION);
		}

		//custom Google fonts css file and inline styles if option is enabled
		// based on:
		// https://gist.github.com/kailoon/e2dc2a04a8bd5034682c
		// http://themeshaper.com/2014/08/13/how-to-add-google-fonts-to-wordpress-themes/
		$seedone_font_body     = json_decode(seedone_option('font_body', '{"font":"","variant": [],"subset":[]}'));
		$seedone_font_headings = json_decode(seedone_option('font_headings', '{"font":"","variant": [],"subset":[]}'));
		//TODO subsets can exists even if no font selected
		if (!empty($seedone_font_body->font) || !empty($seedone_font_headings->font)) {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			*/

			if ('off' !== esc_html_x('on', 'Google font: on or off', 'seedone')) {
				$seedone_body_subsets  = array();
				$seedone_font_body_font = '';
				if (!empty($seedone_font_body->font)) {
					$seedone_font_body_font = $seedone_font_body->font;
					if (!empty($seedone_font_body->variant)) {
						$seedone_font_body->font .= ':' . implode(',', $seedone_font_body->variant);
					}
					$seedone_body_subsets  = $seedone_font_body->subset;
				}

				$seedone_headings_subsets  = array();
				$seedone_font_headings_font = '';
				if (!empty($seedone_font_headings->font)) {
					$seedone_font_headings_font = $seedone_font_headings->font;
					if (!empty($seedone_font_headings->variant)) {
						$seedone_font_headings->font .= ':' . implode(',', $seedone_font_headings->variant);
					}
					$seedone_headings_subsets  = $seedone_font_headings->subset;
				}

				$seedone_fonts    = array(
					'body'     => $seedone_font_body->font,
					'headings' => $seedone_font_headings->font,
				);
				$seedone_subsets  = array(
					'body'     => implode(',', $seedone_body_subsets),
					'headings' => implode(',', $seedone_headings_subsets),
				);
				//'Montserrat|Bowlby One|Quattrocento Sans';
				$seedone_fonts_string    = implode('|', array_filter($seedone_fonts));
				$seedone_subsets_string  = implode(',', array_filter($seedone_subsets));

				$seedone_query_args = array(
					'family' => urlencode($seedone_fonts_string),
				);
				if (!empty($seedone_subsets_string)) {
					$seedone_query_args['subset'] = urlencode($seedone_subsets_string);
				}
				$seedone_query_args['display'] = 'swap';
				$seedone_font_url = add_query_arg(
					$seedone_query_args,
					'//fonts.googleapis.com/css'
				);

				//no need to provide anew version for Google fonts link
				wp_enqueue_style('seedone-google-fonts-style', $seedone_font_url, array(), '1.0.0');
				//printing header styles

				$seedone_body_style = (!empty($seedone_font_body_font)) ? 'body,.wp-block-calendar table caption{font-family:"' . $seedone_font_body_font . '" !important;}' : '';

				$seedone_secondary_selectors = array(
					'.title h1',
					'.footer_top-background-text',
					'.intro-pre-heading',
					'.slide-pre-heading',
					'.headline-bg',
					'.pre-heading-bg-text',
					'.footer_top-background-text',
					'h2.not_found .has-huge-font-size',
				);

				$seedone_headings_style = (!empty($seedone_font_headings_font)) ? join(',', $seedone_secondary_selectors) . '{font-family: "' . $seedone_font_headings_font . '" !important}' : '';

				wp_add_inline_style(
					'seedone-google-fonts-style',
					wp_kses(
						$seedone_body_style . $seedone_headings_style,
						false
					)
				);
			}
		}

		//admin-bar styles for front end
		if (is_admin_bar_showing()) {
			//Add Frontend admin styles
			wp_enqueue_style(
				'seedone-admin-bar-style',
				SEEDONE_THEME_URI . '/assets/css/admin-frontend.css',
				array(),
				SEEDONE_THEME_VERSION
			);
		}

		//always load masonry
		wp_enqueue_script('masonry', '', array('imagesloaded'), '', true);

		//photoswipe
		if (is_singular()) {
			wp_enqueue_style(
				'photoswipe',
				SEEDONE_THEME_URI . '/assets/vendor/photoswipe/photoswipe.css',
				array(),
				SEEDONE_THEME_VERSION
			);
			wp_enqueue_style(
				'photoswipe-skin',
				SEEDONE_THEME_URI . '/assets/vendor/photoswipe/default-skin/default-skin.css',
				array('photoswipe'),
				SEEDONE_THEME_VERSION
			);
			wp_enqueue_script('photoswipe', SEEDONE_THEME_URI . '/assets/vendor/photoswipe/photoswipe.min.js', array(), SEEDONE_THEME_VERSION, true);
			wp_enqueue_script('photoswipe-ui', SEEDONE_THEME_URI . '/assets/vendor/photoswipe/photoswipe-ui-default.js', array('photoswipe'), SEEDONE_THEME_VERSION, true);
		}

		//flexslider
		wp_enqueue_script('flexslider', SEEDONE_THEME_URI . '/assets/js/vendor/jquery.flexslider-min.js', array('jquery'), SEEDONE_THEME_VERSION, true);

		//glightbox
		wp_enqueue_style(
			'glightbox',
			SEEDONE_THEME_URI . '/assets/vendor/glightbox/glightbox.min.css',
			array(),
			SEEDONE_THEME_VERSION
		);

		wp_enqueue_script('glightbox', SEEDONE_THEME_URI . '/assets/vendor/glightbox/glightbox.min.js', array(), SEEDONE_THEME_VERSION, true);

		$min_js = !SEEDONE_DEV_MODE ? 'min/' : '';
		//main theme script
		wp_enqueue_script('seedone-init-script', SEEDONE_THEME_URI . '/assets/js/' . $min_js . 'init.js', array('jquery'), SEEDONE_THEME_VERSION, true);

		//animation scripts and styles
		if (seedone_option('animation_enabled', false)) :
			wp_enqueue_script('seedone-animation-script', SEEDONE_THEME_URI . '/assets/js/' . $min_js . 'animation.js', array(), SEEDONE_THEME_VERSION, true);
			wp_enqueue_style('seedone-animate', SEEDONE_THEME_URI . '/assets/css/' . $min . 'animate.css', array(), SEEDONE_THEME_VERSION);
		endif;

		//comments script
		if (is_singular() && comments_open() && get_option('thread_comments')) {
			wp_enqueue_script('comment-reply');
		}

		//move jQuery scripts to the footer if customizer option is active and if not user logged in
		if (seedone_option('jquery_to_footer', false) && !is_user_logged_in()) :
			wp_scripts()->add_data('jquery', 'group', 1);
			wp_scripts()->add_data('jquery-core', 'group', 1);
			wp_scripts()->add_data('jquery-migrate', 'group', 1);
		endif;

		//customizer preview
		if (is_customize_preview()) {
			wp_enqueue_script('seedone-customize-preview-script', SEEDONE_THEME_URI . '/assets/js/' . $min_js . 'customize-preview.js', array('jquery', 'customize-selective-refresh'), SEEDONE_THEME_VERSION, true);
		}
	}
endif;
add_action('wp_enqueue_scripts', 'seedone_enqueue_static');

//enqueue masonry for grid layout
if (!function_exists('seedone_enqueue_masonry')) :
	function seedone_enqueue_masonry()
	{
		wp_enqueue_script('masonry', '', array('imagesloaded'), '', true);
	}
endif;
//enqueue masonry for grid layout action
if (!function_exists('seedone_enqueue_masonry_action')) :
	function seedone_enqueue_masonry_action()
	{
		add_action('wp_enqueue_scripts', 'seedone_enqueue_masonry');
	}
endif;


//Gutenberg script
//https://developer.wordpress.org/block-editor/tutorials/javascript/loading-javascript/
if (!function_exists('seedone_action_enqueue_block_editor_assets')) :
	function seedone_action_enqueue_block_editor_assets($seedone_page)
	{

		$min = !SEEDONE_DEV_MODE ? 'min/' : '';

		$deps = array(
			'lodash',
			'wp-i18n',
			'wp-element',
			'wp-components',
			'wp-data',
			'wp-plugins',
			'wp-blocks',
			'wp-dom-ready',
		);
		//v 5.8 has block editor on widgets and throws error when 'edit post' scripts are loaded as a dependency
		$screen = function_exists('get_current_screen') ? get_current_screen() : false;
		if ($screen) {
			if ('widgets' !== $screen->id) {
				$deps[] = 'wp-edit-post';
				$deps[] = 'wp-editor';

				//animation scripts and styles
				if (seedone_option('animation_enabled', false) && empty(seedone_option('animation_disable_for_gutenberg', false))) :
					wp_enqueue_script(
						'gutenberg-animation',
						SEEDONE_THEME_URI . '/assets/js/' . $min . 'gutenberg-animation.js',
						$deps,
						SEEDONE_THEME_VERSION
					);
				endif;
			}
		}
		wp_enqueue_script(
			'gutenberg',
			SEEDONE_THEME_URI . '/assets/js/' . $min . 'gutenberg.js',
			$deps,
			SEEDONE_THEME_VERSION
		);
	}
endif;
add_action('enqueue_block_editor_assets', 'seedone_action_enqueue_block_editor_assets');


//login page styles
if (!function_exists('seedone_action_login_enqueue_static')) :
	function seedone_action_login_enqueue_static($seedone_page)
	{
		wp_enqueue_style(
			'seedone-login-page-style',
			SEEDONE_THEME_URI . '/assets/css/login-page.css',
			array(),
			SEEDONE_THEME_VERSION
		);
		$seedone_colors_string = seedone_get_root_colors_inline_styles_string();
		if (!empty($seedone_colors_string)) :
			wp_add_inline_style(
				'seedone-login-page-style',
				wp_kses(
					':root{' . $seedone_colors_string . '}',
					false
				)
			);
		endif;
	}
endif;
add_action('login_enqueue_scripts', 'seedone_action_login_enqueue_static');

//customizer panel
if (!function_exists('seedone_customizer_js')) :
	function seedone_customizer_js()
	{
		wp_enqueue_style(
			'seedone-customizer-style',
			SEEDONE_THEME_URI . '/assets/css/customizer.css',
			array(),
			SEEDONE_THEME_VERSION
		);
		$min = !SEEDONE_DEV_MODE ? 'min/' : '';
		wp_register_script(
			'seedone-customize-controls',
			SEEDONE_THEME_URI . '/assets/js/' . $min . 'customize-controls.js',
			array(),
			SEEDONE_THEME_VERSION,
			true
		);
		wp_localize_script('seedone-customize-controls', 'mwtGoogleFonts', seedone_get_google_fonts_array());

		//customizer redirect helpers
		$blog_url = get_post_type_archive_link('post');
		$post     = wp_get_recent_posts(
			array(
				'numberposts' => 1,
				'post_status' => 'publish',
			)
		);
		wp_reset_postdata();
		$post_url   = (!empty($post[0])) ? get_permalink($post[0]['ID']) : $blog_url;
		$search_url = home_url('/') . '?s=';
		$shop_url = esc_html(home_url('/'));
		$checkout_url = esc_html(home_url('/'));
		if (class_exists('WooCommerce')) {
			$shop_url = wc_get_page_permalink('shop');
			$checkout_url = wc_get_page_permalink('checkout');
		}
		wp_localize_script(
			'seedone-customize-controls',
			'seedoneCustomizerObject',
			array(
				'homeUrl'     => esc_url_raw(home_url()),
				'blogUrl'     => esc_url_raw($blog_url),
				'postUrl'     => esc_url_raw($post_url),
				'searchUrl'   => esc_url_raw($search_url),
				'shopUrl'     => esc_url_raw($shop_url),
				'checkoutUrl' => esc_url_raw($checkout_url),
				'themeUrl'    => esc_url_raw(SEEDONE_THEME_URI),
			)
		);

		wp_enqueue_script('seedone-customize-controls');

		wp_register_script(
			'vue-runtime',
			SEEDONE_THEME_URI . '/assets/js/vendor/vue.min.js',
			array(),
			SEEDONE_THEME_VERSION,
			true
		);
		wp_enqueue_script('vue-runtime');
	}
endif;
add_action('customize_controls_enqueue_scripts', 'seedone_customizer_js');

//admin styles
if (!function_exists('seedone_action_load_custom_wp_admin_style')) :
	function seedone_action_load_custom_wp_admin_style()
	{
		wp_register_style('seedone-custom-wp-admin-css', SEEDONE_THEME_URI . '/assets/css/admin-backend.css', false, SEEDONE_THEME_VERSION);
		wp_enqueue_style('seedone-custom-wp-admin-css');
		$seedone_colors_string = seedone_get_root_colors_inline_styles_string();
		if (!empty($seedone_colors_string)) :
			wp_add_inline_style(
				'seedone-custom-wp-admin-css',
				wp_kses(
					':root{' . $seedone_colors_string . '}',
					false
				)
			);
		endif;
	} //seedone_action_load_custom_wp_admin_style()
endif;
add_action('admin_enqueue_scripts', 'seedone_action_load_custom_wp_admin_style');

//comment_date
add_filter('get_comment_date', 'seedone_comment_date');
function seedone_comment_date($date)
{
	$date = date("F d, Y");
	return $date;
}

//demo content on remote hosting
/**
 * @param FW_Ext_Backups_Demo[] $demos
 *
 * @return FW_Ext_Backups_Demo[]
 */
if (!function_exists('seedone_filter_theme_fw_ext_backups_demos')) :

	function seedone_filter_theme_fw_ext_backups_demos($demos)
	{
		$secret_demo_id = SEEDONE_REMOTE_DEMO_ID;

		$demo_version_suffix = '-v' . SEEDONE_REMOTE_DEMO_VERSION; // '-v1.0.0' (Only for main demo)
		if (class_exists('FW_Ext_Backups_Demo')) :
			$demos_array = array(
				'seedone-microgreen-demo' => array(
					'title'        => esc_html__('Microgreen Demo', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-microgreen.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-microgreen/'),
					'plugins' => array(
						array(
							'name'     => esc_html__('WooCommerce Advanced Product Labels', 'seedone'),
							'slug'     => 'advanced-product-labels-for-woocommerce',
							'required' => true,
						),
						array(
							'name'     => esc_html__('Use Any Font', 'seedone'),
							'slug'     => 'use-any-font',
							'required' => true,
						),
					),
				),
				'seedone-demo' . $demo_version_suffix => array(
					'title'        => esc_html__('Seedone Demo', 'seedone'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/seedone/demo/screenshot.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone/'),
					'plugins' => array(),
				),
				'seedone-poultry-demo' => array(
					'title'        => esc_html__('Poultry Demo', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-poultry.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-poultry/'),
					'plugins' => array(
						array(
							'name'     => esc_html__('WooCommerce Advanced Product Labels', 'seedone'),
							'slug'     => 'advanced-product-labels-for-woocommerce',
							'required' => true,
						),
					),
				),
				'seedone-fish-farm-demo' => array(
					'title'        => esc_html__('Fish Farm Demo', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-fish-farm.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-fish-farm/'),
					'plugins' => array(
						array(
							'name'     => esc_html__('Use Any Font', 'seedone'),
							'slug'     => 'use-any-font',
							'required' => true,
						),
						array(
							'name'     => esc_html__('Social Icons Widget & Block', 'seedone'),
							'slug'     => 'social-icons-widget-by-wpzoom',
							'required' => true,
						),
					),
				),
				'seedone-agricultural-demo' => array(
					'title'        => esc_html__('Agricultural Demo', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-agricultural.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-agricultural/'),
					'plugins' => array(),
				),
				'seedone-cattle-calves-dairy-demo' => array(
					'title'        => esc_html__('Cattle Calves & Dairy Demo', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-cattle-calves-dairy.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-cattle-calves-dairy/'),
					'plugins' => array(
						array(
							'name'     => esc_html__('WooCommerce Advanced Product Labels', 'seedone'),
							'slug'     => 'advanced-product-labels-for-woocommerce',
							'required' => true,
						),
						array(
							'name'     => esc_html__('Use Any Font', 'seedone'),
							'slug'     => 'use-any-font',
							'required' => true,
						),
						array(
							'name'     => esc_html__('ShopLentor – WooCommerce Builder for Elementor & Gutenberg', 'seedone'),
							'slug'     => 'woolentor-addons',
							'required' => true,
						),
					),
				),
			);

			// You may request this demo id from this theme author to get a colorized demo content. See the author contacts information.
			$secret_demo_id = SEEDONE_REMOTE_DEMO_ID;

			// Demo Variants ( Colorized )
			if ($secret_demo_id) {
				$demos_array['seedone-microgreen-demo-colorized-' . $secret_demo_id] = array(
					'title' => esc_html__('Microgreen Demo (Colorized)', 'seedone'),
					'screenshot'    => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-microgreen.png'),
					'preview_link'  => esc_url('http://webdesign-finder.com/seedone-microgreen'),
					'plugins' => array(
						array(
							'name'     => esc_html__('WooCommerce Advanced Product Labels', 'seedone'),
							'slug'     => 'advanced-product-labels-for-woocommerce',
							'required' => true,
						),
						array(
							'name'     => esc_html__('Use Any Font', 'seedone'),
							'slug'     => 'use-any-font',
							'required' => true,
						),
					),
				);
				$demos_array['seedone-demo-colorized-' . $secret_demo_id . $demo_version_suffix] = array(
					'title' => esc_html__('Seedone Demo (Colorized)', 'seedone'),
					'screenshot' => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot.png'),
					'preview_link' => esc_url('http://webdesign-finder.com/seedone/'),
					'plugins' => array(),
				);
				$demos_array['seedone-poultry-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Poultry Demo', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-poultry.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-poultry/'),
					'plugins' => array(
						array(
							'name'     => esc_html__('WooCommerce Advanced Product Labels', 'seedone'),
							'slug'     => 'advanced-product-labels-for-woocommerce',
							'required' => true,
						),
					),
				);
				$demos_array['seedone-fish-farm-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Fish Farm Demo (Colorized)', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-fish-farm.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-fish-farm/'),
					'plugins' => array(
						array(
							'name'     => esc_html__('Use Any Font', 'seedone'),
							'slug'     => 'use-any-font',
							'required' => true,
						),
						array(
							'name'     => esc_html__('Social Icons Widget & Block', 'seedone'),
							'slug'     => 'social-icons-widget-by-wpzoom',
							'required' => true,
						),
					),
				);
				$demos_array['seedone-agricultural-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Agricultural Demo (Colorized)', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-agricultural.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-agricultural/'),
					'plugins' => array(),
				);
				$demos_array['seedone-cattle-calves-dairy-demo-colorized-' . $secret_demo_id] = array(
					'title'        => esc_html__('Cattle Calves & Dairy Demo (Colorized)', 'seedone'),
					'screenshot'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/screenshot-seedone-cattle-calves-dairy.png'),
					'preview_link' => esc_url('//webdesign-finder.com/seedone-cattle-calves-dairy/'),
					'plugins' => array(
						array(
							'name'     => esc_html__('WooCommerce Advanced Product Labels', 'seedone'),
							'slug'     => 'advanced-product-labels-for-woocommerce',
							'required' => true,
						),
						array(
							'name'     => esc_html__('Use Any Font', 'seedone'),
							'slug'     => 'use-any-font',
							'required' => true,
						),
						array(
							'name'     => esc_html__('ShopLentor – WooCommerce Builder for Elementor & Gutenberg', 'seedone'),
							'slug'     => 'woolentor-addons',
							'required' => true,
						),
					),
				);
			}

			$download_url = esc_url('http://webdesign-finder.com/remote-demo-content/seedone/demo/');

			foreach ($demos_array as $id => $data) {
				$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
					'url'     => $download_url,
					'file_id' => $id,
				));
				$demo->set_title($data['title']);
				$demo->set_screenshot($data['screenshot']);
				$demo->set_preview_link($data['preview_link']);
				if (method_exists($demo, 'set_plugins')) {
					$demo->set_plugins($data['plugins']);
				}

				$demos[$demo->get_id()] = $demo;

				unset($demo);
			}

			return $demos;

		endif; //class_exists
	} //seedone_filter_theme_fw_ext_backups_demos()
endif;
add_filter('fw:ext:backups-demo:demos', 'seedone_filter_theme_fw_ext_backups_demos');

//getting theme skin number

$skin = seedone_option('color_skin', '');
if (!empty($skin)) {
	wp_enqueue_style(
		'seedone-skin',
		SEEDONE_THEME_URI . '/assets/css/' . esc_attr($skin) . '.css',
		array(),
		SEEDONE_THEME_VERSION
	);
}
