<?php

/**
 * Theme setup function and sidebars registering
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}


if (!function_exists('seedone_setup')) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */

	function seedone_setup()
	{

		//remove_theme_support('widgets-block-editor');
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on this theme, use a find and replace
		 * to change 'seedone' to the name of your theme in all the template files.
		 */
		load_theme_textdomain('seedone', SEEDONE_THEME_PATH . '/languages');

		// Add default posts and comments RSS feed links to head.
		add_theme_support('automatic-feed-links');

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support('title-tag');

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support('post-thumbnails', array('post'));
		set_post_thumbnail_size(1530, 700, true);

		if (!isset($content_width)) {
			$content_width = 1170;
		}

		//image sizes - cropped
		add_image_size('seedone-square', 480, 480, true);
		add_image_size('seedone-default-post', 1000, 480, true);
		add_image_size('seedone-single-post', 1520, 760, true);
		add_image_size('seedone-square-half', 800, 400, true);
		add_image_size('seedone-square-big', 800, 600, true);

		//Post formats
		add_theme_support('post-formats', array('video', 'audio', 'image', 'gallery', 'quote'));

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption', 'script', 'style'));

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		$seedone_custom_header_logo = array(
			'height'      => 60,
			'width'       => 150,
			'flex-width'  => true,
			'flex-height' => true,
		);

		add_theme_support('custom-logo', $seedone_custom_header_logo);

		//Background image for header and title sections
		$seedone_custom_header_args = array(
			'width'       => 1920,
			'height'      => 800,
			'header-text' => false,
		);
		add_theme_support('custom-header', $seedone_custom_header_args);

		add_theme_support('custom-background');

		// Add theme support for selective refresh for widgets.
		add_theme_support('customize-selective-refresh-widgets');

		// Gutenberg block editor
		add_theme_support(
			'editor-color-palette',
			array(
				// colorLight
				// colorFont
				// colorFontMuted
				// colorBackground
				// colorBorder
				// colorDark
				// colorDarkMuted
				// colorMain
				// colorMain2
				array(
					'name'  => esc_html__('Light', 'seedone'),
					'slug'  => 'light',
					'color' => 'var(--colorLight)',
				),
				array(
					'name'  => esc_html__('Font', 'seedone'),
					'slug'  => 'font',
					'color' => 'var(--colorFont)',
				),
				array(
					'name'  => esc_html__('Muted', 'seedone'),
					'slug'  => 'font-muted',
					'color' => 'var(--colorFontMuted)',
				),
				array(
					'name'  => esc_html__('Background', 'seedone'),
					'slug'  => 'background',
					'color' => 'var(--colorBackground)',
				),
				array(
					'name'  => esc_html__('Border', 'seedone'),
					'slug'  => 'border',
					'color' => 'var(--colorBorder)',
				),
				array(
					'name'  => esc_html__('Dark', 'seedone'),
					'slug'  => 'dark',
					'color' => 'var(--colorDark)',
				),
				array(
					'name'  => esc_html__('Dark Muted', 'seedone'),
					'slug'  => 'dark-muted',
					'color' => 'var(--colorDarkMuted)',
				),
				array(
					'name'  => esc_html__('Accent', 'seedone'),
					'slug'  => 'main',
					'color' => 'var(--colorMain)',
				),
				array(
					'name'  => esc_html__('Accent 2', 'seedone'),
					'slug'  => 'main-2',
					'color' => 'var(--colorMain2)',
				),
			)
		);

		// Add support for Block Styles.
		// add_theme_support( 'wp-block-styles' );
		// 'wp-block-library-theme' - loads in the backend even if not defined here

		// Add support for full and wide align images.
		add_theme_support('align-wide');

		// Enqueue editor styles.
		add_theme_support('editor-styles');
		$min = get_theme_mod('assets_min') ? 'min/' : '';
		add_editor_style('assets/css/' . $min . 'editor-style.css');

		// Add support for responsive embedded content.
		// It will add JS file to the footer
		// add_theme_support( 'responsive-embeds' );

		//Yoast breadcrumbs support
		add_theme_support('yoast-seo-breadcrumbs');

		//WooCommerce
		add_theme_support('woocommerce');
		add_theme_support('wc-product-gallery-lightbox');
		add_theme_support('wc-product-gallery-slider');

		// This theme uses wp_nav_menu() in four locations.
		register_nav_menus(
			array(
				'topline'   => esc_html__('Topline Menu', 'seedone'),
				'primary'   => esc_html__('Main Menu', 'seedone'),
				'copyright' => esc_html__('Copyright Menu', 'seedone'),
			)
		);
	}
endif;
add_action('after_setup_theme', 'seedone_setup');


if (!function_exists('seedone_widgets_init')) :
	/**
	 * Register widget area.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
	 */
	function seedone_widgets_init()
	{

		register_sidebar(
			array(
				'name'          => esc_html__('Main', 'seedone'),
				'id'            => 'sidebar-1',
				'description'   => esc_html__('Add widgets here to appear in your sidebar.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__('Footer', 'seedone'),
				'id'            => 'sidebar-footer',
				'description'   => esc_html__('Add widgets here to appear in your footer.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="grid-item widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__('For Toggle Menu Side', 'seedone'),
				'id'            => 'sidebar-toggle-menu-side',
				'description'   => esc_html__('Add widgets here to appear in your header.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			)
		);

		$footer_layout = function_exists('seedone_option') ? seedone_option('footer') : '1';
		if ($footer_layout === '9') :
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 1', 'seedone'),
				'id'            => 'sidebar-footer-1',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="grid-item widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 2', 'seedone'),
				'id'            => 'sidebar-footer-2',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="grid-item widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 3', 'seedone'),
				'id'            => 'sidebar-footer-3',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="grid-item widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 4', 'seedone'),
				'id'            => 'sidebar-footer-4',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="grid-item widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
		endif;
		if ($footer_layout === '10') :
			register_sidebar(array(
				'name'          => esc_html__('Footer Block Top', 'seedone'),
				'id'            => 'sidebar-footer-top',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="grid-item widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 1', 'seedone'),
				'id'            => 'sidebar-footer-1',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 2', 'seedone'),
				'id'            => 'sidebar-footer-2',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 3', 'seedone'),
				'id'            => 'sidebar-footer-3',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 4', 'seedone'),
				'id'            => 'sidebar-footer-4',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
			register_sidebar(array(
				'name'          => esc_html__('Footer Block 5', 'seedone'),
				'id'            => 'sidebar-footer-5',
				'description'   => esc_html__('Appears in the footer section of the site.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			));
		endif;
		register_sidebar(
			array(
				'name'          => esc_html__('Home page above columns', 'seedone'),
				'id'            => 'sidebar-home-before-columns',
				'description'   => esc_html__('These widgets will appear on "Home" page above columns.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__('Home page above content', 'seedone'),
				'id'            => 'sidebar-home-before-content',
				'description'   => esc_html__('These widgets will appear on "Home" page above content', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__('Home page main sidebar', 'seedone'),
				'id'            => 'sidebar-home-main',
				'description'   => esc_html__('These widgets will appear on "Home" page in main sidebar.', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__('Home page below content', 'seedone'),
				'id'            => 'sidebar-home-after-content',
				'description'   => esc_html__('These widgets will appear on "Home" page below main content', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__('Home page below columns', 'seedone'),
				'id'            => 'sidebar-home-after-columns',
				'description'   => esc_html__('These widgets will appear on "Home" page below columns', 'seedone'),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title"><span>',
				'after_title'   => '</span></h3>',
			)
		);


		//WooCommerce sidebar
		if (class_exists('WooCommerce')) {
			register_sidebar(
				array(
					'name'          => esc_html__('Shop', 'seedone'),
					'id'            => 'shop',
					'description'   => esc_html__('This sidebar will appear on shop pages', 'seedone'),
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget'  => '</div>',
					'before_title'  => '<h3 class="widget-title"><span>',
					'after_title'   => '</span></h3>',
				)
			);
		}
	}
endif;
add_action('widgets_init', 'seedone_widgets_init');


//copy parent theme mods on first child theme activation
if (!function_exists('seedone_switch_theme_update_mods')) :
	function seedone_switch_theme_update_mods($seedone_new_theme)
	{

		if (is_child_theme()) {
			$seedone_new_theme_mods = get_theme_mods();

			//if is child theme and current theme mods are empty - set theme mods from parent theme
			if (empty($seedone_new_theme_mods) || 1 === count($seedone_new_theme_mods) || 2 === count($seedone_new_theme_mods)) {
				$seedone_mods = get_option('theme_mods_' . get_template());

				if (!empty($seedone_mods)) {
					foreach ((array) $seedone_mods as $seedone_mod => $seedone_mod_value) {
						// if ( 'sidebars_widgets' !== $seedone_mod )
						set_theme_mod($seedone_mod, $seedone_mod_value);
					}
				}
			}
		}
	}
endif;
add_action('after_switch_theme', 'seedone_switch_theme_update_mods');

// wrap two widgets in custom footer
add_filter('dynamic_sidebar_params', 'seedone_wrap_for_custom_footer');
function seedone_wrap_for_custom_footer($params)
{
	if (get_theme_mod('footer') == '8') {
		static $widget_counter;
		$total_widgets = wp_get_sidebars_widgets();
		$sidebar_widgets = count($total_widgets['sidebar-footer']);
		if ($sidebar_widgets > 4) {
			if ($params[0]['id'] == 'sidebar-footer') {

				if ($widget_counter == 2) {
					$params[0]['before_widget'] = '<div class="grid-item several-widgets">' . $params[0]['before_widget'];
				}
				if ($widget_counter == 3) {
					$params[0]['after_widget'] = '</div></div>';
				}
				$widget_counter++;
			}
		}
	}
	return $params;
}

// registration form
if (!function_exists('seedone_registration_form')) :
	function seedone_registration_form()
	{
?>
		<?php
		$user_login = '';
		$user_email = '';
		$user_password = '';
		$registration_redirect = !empty($_REQUEST['redirect_to']) ? $_REQUEST['redirect_to'] : '';
		$redirect_to = apply_filters('registration_redirect', $registration_redirect);
		?>

		<form name="registerform" id="registerform" action="<?php echo esc_url(site_url('wp-login.php?action=register', 'login_post')); ?>" method="post" novalidate="novalidate">
			<p>
				<input type="text" name="user_login" id="user_login_modal" placeholder="<?php esc_attr_e('Full name', 'seedone'); ?>" class="input" value="<?php echo esc_attr(wp_unslash($user_login)); ?>" size="20" autocapitalize="off" />
			</p>
			<p>
				<input type="email" name="user_email" id="user_email" placeholder="<?php esc_attr_e('Email address', 'seedone'); ?>" class="input" value="<?php echo esc_attr(wp_unslash($user_email)); ?>" size="25" />
			</p>
			<p>
				<input type="password" name="pwd" id="user_password" placeholder="<?php esc_attr_e('Password', 'seedone'); ?>" class="input" value="<?php echo esc_attr(wp_unslash($user_password)); ?>" size="25" />
			</p>
			<?php
			/**
			 * Fires following the 'Email' field in the user registration form.
			 *
			 * @since 2.1.0
			 */
			do_action('register_form');
			?>
			<br class="clear" />
			<input type="hidden" name="redirect_to" value="<?php echo esc_attr($redirect_to); ?>" />
			<p class="submit"><button type="submit" name="wp-submit" id="wp-submit-modal" class="button"><?php esc_html_e('Sign up', 'seedone'); ?></button></p>
		</form>
<?php
		return;
	}
endif; //function_exists
add_action('user_registration_form', 'seedone_registration_form');
