<?php

/**
 * Template HTML output filters
 *
 * @package Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//remove 'has-post-thumbnail' post_class if appropriate single post layout is selected
if (!function_exists('seedone_filter_post_class')) :
	function seedone_filter_post_class($seedone_classes)
	{
		if (is_single() && 'title-section-image' === seedone_option('blog_single_layout', '')) {
			$seedone_key = array_search('has-post-thumbnail', $seedone_classes, true);
			unset($seedone_classes[$seedone_key]);
		}

		return $seedone_classes;
	}
endif;
add_filter('post_class', 'seedone_filter_post_class');

// Wraps the title's each word in separate span
if (!function_exists('seedone_filter_widget_title')) :
	/**
	 * Wraps the title words in spans.
	 *
	 * @param string $seedone_title The string.
	 *
	 * @return string          The modified string.
	 */
	function seedone_filter_widget_title($seedone_title)
	{
		//RSS escaping HTML in title and break it

		if (empty($seedone_title)) {
			return;
		}

		if (stripos($seedone_title, 'rss') !== false) {
			return $seedone_title;
		}

		// Cut the title into words.
		$seedone_words = explode(' ', $seedone_title);

		$seedone_array = array();

		foreach ($seedone_words as $seedone_index => $seedone_word) {
			$seedone_counter = $seedone_index + 1;
			$seedone_array[] = '<span class="widget-title-word widget-title-word-' . $seedone_counter . '">' . $seedone_word . '</span>';
		}

		return implode(' ', $seedone_array);
	}
endif;
add_filter('widget_title', 'seedone_filter_widget_title', 999);

//Since 5.4 this do not needed?
//filter calendar widget to fix validation errors
if (!function_exists('seedone_filter_widget_calendar_html')) :
	function seedone_filter_widget_calendar_html($seedone_html)
	{
		//get tfoot
		$seedone_tfoot = preg_match('/<tfoot>(.|\n)*<\/tfoot>/', $seedone_html, $seedone_match);
		//remove tfoot from table
		$seedone_html = preg_replace('/<tfoot>(.|\n)*<\/tfoot>/', '', $seedone_html);
		//attach tfoot after tbody
		if (!empty($seedone_match[0])) {
			$seedone_html = str_replace('</tbody>', "</tbody>\n\t" . $seedone_match[0], $seedone_html);
		}

		return $seedone_html;
	} //seedone_filter_widget_calendar_html()
endif;
add_filter('get_calendar', 'seedone_filter_widget_calendar_html');

//wrapping in a span widgets categories and archives items count - but skip dropdowns
if (!function_exists('seedone_filter_add_span_to_arhcive_widget_count')) :
	function seedone_filter_add_span_to_arhcive_widget_count($seedone_links)
	{
		if (stristr($seedone_links, '<option')) {
			return $seedone_links;
		}

		//for woo categories widget
		$seedone_links = str_replace('<span class="count">(', '<span class="count"><span class="count-open">(</span>', $seedone_links);

		//for categories widget
		$seedone_links = str_replace('</a> (', '</a> <span class="count"><span class="count-open">(</span>', $seedone_links);
		//for archive widget
		$seedone_links = str_replace('&nbsp;(', ' <span class="count"><span class="count-open">(</span>', $seedone_links);
		$seedone_links = preg_replace('/([0-9]+)\)/', '$1<span class="count-close">)</span></span>', $seedone_links);

		//putting span before link for styling purpose
		$seedone_links = preg_replace('~(<a href=.*</a>) (<span class="count"><span class="count-open">\(</span>([0-9]*)<span class="count-close">\)</span></span>)~', '$2$1', $seedone_links);

		return $seedone_links;
	}
endif;
add_filter('wp_list_categories', 'seedone_filter_add_span_to_arhcive_widget_count');
add_filter('get_archives_link', 'seedone_filter_add_span_to_arhcive_widget_count');

//wrapping tag links in span
if (!function_exists('seedone_filter_add_spans_to_tag_links')) :
	function seedone_filter_add_spans_to_tag_links($seedone_html)
	{

		$seedone_html = str_replace('<a', '<span><a', $seedone_html);
		$seedone_html = str_replace('</a>', '</a></span>', $seedone_html);

		return $seedone_html;
	}
endif;
add_filter('wp_tag_cloud', 'seedone_filter_add_spans_to_tag_links');

//wrapping "category" word in title area in a span
if (!function_exists('seedone_filter_wrap_cat_title_before_colon_in_span')) :
	function seedone_filter_wrap_cat_title_before_colon_in_span($seedone_title)
	{
		$seedone_hide_tax_name_title = seedone_option('blog_hide_taxonomy_type_name', false);
		if (is_category()) {
			$seedone_hide_tax_name_title = true;
		}
		if (empty($seedone_hide_tax_name_title)) {
			return preg_replace('/^.*: /', '<span class="taxonomy-name-title">${0}</span>', $seedone_title);
		} else {
			return preg_replace('/^.*: /', '', $seedone_title);
		}
	}
endif;
add_filter('get_the_archive_title', 'seedone_filter_wrap_cat_title_before_colon_in_span');

// add icon to edit comment link
if (!function_exists('seedone_filter_edit_comment_link')) :
	function seedone_filter_edit_comment_link($edit_comment_html)
	{
		$edit_comment_html = str_replace('<span class="edit-link">', '<span class="edit-link"> ', $edit_comment_html);

		return $edit_comment_html;
	}
endif;
add_filter('edit_comment_link', 'seedone_filter_edit_comment_link');

// add 'data-hover' attribute to nav menu link
if (!function_exists('seedone_filter_menu_item_data_hover_attribute')) :
	function seedone_filter_menu_item_data_hover_attribute($atts, $item, $args, $depth)
	{
		$atts['data-hover'] = $item->title;
		return $atts;
	}
endif;
add_filter('nav_menu_link_attributes', 'seedone_filter_menu_item_data_hover_attribute', 4, 10);


// this function can be used to update views count on posts on wp_footer action
if (!function_exists('seedone_action_increment_post_views_count')) :
	function seedone_action_increment_post_views_count()
	{
		if (is_singular('post')) {
			$post_id = get_the_ID();
			$count   = (int) get_post_meta($post_id, 'seedone_views_count', true);
			$count++;
			update_post_meta($post_id, 'seedone_views_count', $count);
		}
	}
endif;

//add ALT text on post thumbnail if it is empty
if (!function_exists('seedone_filter_post_thumbnail_add_alt_text_if_empty')) :
	function seedone_filter_post_thumbnail_add_alt_text_if_empty($html, $post_id)
	{
		return str_replace('alt=""', 'alt="' . esc_attr(get_the_title($post_id)) . '"', $html);
	}
endif;
add_filter('post_thumbnail_html', 'seedone_filter_post_thumbnail_add_alt_text_if_empty', 10, 2);

//remove 'role="navigation"' from 'nav' pagination element
if (!function_exists('seedone_filter_navigation_markup_template')) :
	function seedone_filter_navigation_markup_template($html)
	{
		$html = str_replace('role="navigation" ', '', $html);
		return $html;
	}
endif;
add_filter('navigation_markup_template', 'seedone_filter_navigation_markup_template');

//remove menu-container class from nav_menu widget
if (!function_exists('seedone_filter_widget_nav_menu_args')) :
	function seedone_filter_widget_nav_menu_args($args)
	{
		$args = wp_parse_args(
			$args,
			array(
				'container' => false,
			)
		);
		return $args;
	}
endif;
add_filter('widget_nav_menu_args', 'seedone_filter_widget_nav_menu_args');

//add custom image size to Gutenberg dropdown
add_filter('image_size_names_choose', 'seedone_filter_image_size_names_choose');
if (!function_exists('seedone_filter_image_size_names_choose')) :
	function seedone_filter_image_size_names_choose($sizes)
	{
		return array_merge($sizes, array(
			'seedone-square' => esc_html__('Square', 'seedone'),
		));
	}
endif;


//gallery block filter
add_filter('render_block', 'seedone_filter_gallery_block_markup', 10, 3);
if (!function_exists('seedone_filter_gallery_block_markup')) :
	function seedone_filter_gallery_block_markup($block_content, $block)
	{

		if ('core/gallery' !== $block['blockName']) {
			return $block_content;
		}
		$output = $block_content;
		if (!empty($block['attrs']['ids'])) {
			$image_size = empty($block['attrs']['sizeSlug']) ? 'large' : $block['attrs']['sizeSlug'];
			foreach ($block['attrs']['ids'] as $id) {
				$image_data = wp_get_attachment_metadata($id);
				if (!empty($image_data)) {

					$output = str_replace('data-id="' . $id . '"', 'data-id="' . $id . '" data-width="' . $image_data['width'] . '" data-height="' . $image_data['height'] . '" ', $output);
				}
			}
		}

		return $output;
	}
endif;
