<?php

/**
 * The 404 page template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$seedone_background_image     = seedone_option('404_background_image', '');

$seedone_cover   = seedone_option('404_background_image_cover', '');
$seedone_fixed   = seedone_option('404_background_image_fixed', '');
$seedone_overlay = seedone_option('404_background_image_overlay', '');

$seedone_watermark = seedone_option('title_watermark_image', '');

if (!empty($seedone_cover)) {
	$seedone_cover = 'background-cover cover-center';
}

if (!empty($seedone_fixed)) {
	$seedone_fixed = ' background-fixed';
}

if (!empty($seedone_overlay)) {
	$seedone_overlay = ' background-overlay ' . $seedone_overlay;
}

get_header();

?>
<div id="main" class="main section-404 i <?php echo esc_attr($seedone_cover . ' ' . $seedone_fixed . ' ' . $seedone_overlay); ?>" <?php echo (!empty($seedone_background_image)) ? 'style="background-image: url(' . esc_url($seedone_background_image) . ');"' : ''; ?>>
	<div class="container pt-5 pb-5">
		<main>
			<div id="layout" class="text-center">
				<?php if (!empty($seedone_watermark)) { ?>
					<div class="round-text">
						<img src="<?php echo esc_url($seedone_watermark); ?>" alt="<?php esc_attr_e('Circular text', 'seedone'); ?>">
					</div>
				<?php
				}
				?>
				<h2 class="not_found mb-0 animate an__fadeInDown">
					<span class="has-huge-font-size"><?php esc_html_e('404', 'seedone'); ?></span>
				</h2>

				<h5 class=" animate an__fadeInDown">
					<?php esc_html_e('oops', 'seedone'); ?>
				</h5>

				<p class="animate an__fadeInLeft">
					<?php esc_html_e("We're sorry, but something went wrong", 'seedone'); ?>
				</p>


				<p class="mb-0 animate an__fadeInUp">
					<a href="<?php echo esc_url(home_url('/')); ?>" class="premium-button btn">
						<?php esc_html_e('Go to homepage', 'seedone'); ?>
					</a>
				</p>

			</div><!-- #layout -->
		</main>
	</div><!-- .container -->
</div><!-- #main -->
<?php
get_footer();
