var ub;

if (typeof Object['create'] != 'undefined') {
	/**
	 * create clean object
	 * autocomplete in console to show only defined methods, without other unnecesary methods from Object prototype
	 */
	ub = Object.create(null);
} else {
	ub = {};
}

/**
 * URI to framework directory
 */
ub.UB_URI = _ub_localized.UB_URI;

ub.SITE_URI = _ub_localized.SITE_URI;

ub.LOADER_URI = _ub_localized.LOADER_URI;

/**
 * Useful images
 */
ub.img = {
	loadingSpinner: ub.SITE_URI +'/wp-admin/images/spinner.gif',
	logoSvg: ub.LOADER_URI
};

/**
 * parseInt() alternative
 * Like intval() in php. Returns 0 on failure, not NaN
 * @param val
 */
ub.intval = function(val) {
	val = parseInt(val);

	return !isNaN(val) ? val : 0;
};


/**
 * Simple modal
 * Meant to display success/error messages
 * Can be called multiple times,all calls will be pushed to queue and displayed one-by-one
 *
 * Usage:
 *
 * // open modal with close button and wait for user to close it
 * ub.soleModal.show('unique-id', 'Hello World!');
 *
 * // open modal with close button but auto hide it after 3 seconds
 * ub.soleModal.show('unique-id', 'Hello World!', {autoHide: 3000});
 *
 * ub.soleModal.hide('unique-id');
 */
ub.soleModal = (function(){
	var inst = {
		queue: [
			/*
			{
				id: 'hello'
				html: 'Hello <b>World</b>!'
				autoHide: 0000 // auto hide timeout in ms
				allowClose: true // useful when you make an ajax and must force the user to wait until it will finish
				showCloseButton: true // false will hide the button, but the user will still be able to click on backdrop to close it
				width: 350
				height: 200
				hidePrevious: false // just replace the modal content or hide the previous modal and open it again with new content
				updateIfCurrent: false // if current open modal has the same id as modal requested to show, update it without reopening
				backdrop: null // true - light, false - dark
				afterOpenStart: function(){} // before open animation starts
				afterOpen: function(){}
				afterCloseStart: function(){} // before close animation starts
				afterClose: function(){}
			}
			*/
		],
		/** @type {Object|null} */
		current: null,
		animationTime: 300,
		$modal: null,
		backdropOpacity: 0.7, // must be the same as in .ub-modal style
		currentMethod: '',
		currentMethodTimeoutId: 0,
		pendingMethod: '',
		lazyInit: function(){
			if (this.$modal) {
				return false;
			}

			this.$modal = jQuery(
				'<div class="ub-modal ub-sole-modal" style="display:none;">'+
				'    <div class="media-modal wp-core-ui" style="width: 350px; height: 200px;">'+
				'        <div class="media-modal-content" style="min-height: 200px;">' +
				'            <button type="button" class="button-link media-modal-close"><span class="media-modal-icon"></span></button>'+
				'            <table width="100%" height="100%"><tbody><tr>'+
				'                <td valign="middle" class="ub-sole-modal-content ub-text-center"><!-- modal content --></td>'+
				'            </tr><tbody></table>'+
				'        </div>'+
				'    </div>'+
				'    <div class="media-modal-backdrop"></div>'+
				'</div>'
			);

			( this.$getCloseButton().add(this.$getBackdrop()) ).on('click', _.bind(function(){
				if (this.current && !this.current.allowClose) {
					// manual close not is allowed
					return;
				}

				this.hide();
			}, this));

			jQuery(document.body).append(this.$modal);

			return true;
		},
		$getBackdrop: function() {
			this.lazyInit();

			return this.$modal.find('.media-modal-backdrop:first');
		},
		$getCloseButton: function() {
			this.lazyInit();

			return this.$modal.find('.media-modal-close:first');
		},
		$getContent: function() {
			return this.$modal.find('.ub-sole-modal-content:first');
		},
		wrapWithTable: function ($modal) {
			var temporaryContent = $modal.find('.ub-sole-modal-content').html();

			$modal.find('.ub-sole-modal-content').remove();

			var htmlTemplate =
				'<tbody>' +
				'<tr>' +
				'<td valign="middle" class="ub-sole-modal-content ub-text-center">' +
				temporaryContent +
				'</td>' +
				'</tr>' +
				'</tbody>';

			var $table = jQuery('<table>', {
				html: htmlTemplate
			}).attr({width: '100%', height: '100%'});

			$modal.find('.media-modal-content').append($table);
		},
		unwrapWithTable: function ($modal) {
			var temporaryContent = $modal.find('.ub-sole-modal-content').html();

			$modal.find('.ub-sole-modal-content')
				.closest('table')
				.remove();

			$modal.find('.media-modal-content')
				.append(jQuery('<div>', {
					class: 'ub-sole-modal-content',
					html: temporaryContent
				}));
		},
		setContent: function(html) {
			this.lazyInit();

			this.$getContent().html(html || '&nbsp;');
		},
		runPendingMethod: function() {
			if (this.currentMethod) {
				return false;
			}

			if (!this.pendingMethod) {
				if (this.queue.length) {
					// there are messages to display
					this.pendingMethod = 'show';
				} else {
					return false;
				}
			}

			var pendingMethod = this.pendingMethod;

			this.pendingMethod = '';

			if (pendingMethod == 'hide') {
				this.hide();
				return true;
			} else if (pendingMethod == 'show') {
				this.show();
				return true;
			} else {
				console.warn('Unknown pending method:', pendingMethod);
				this.hide();
				return false;
			}
		},
		setSize: function(width, height) {
			var $size = this.$modal.find('> .media-modal');
			var $modal = this.$modal;
			$modal.addClass('ub-modal-opening');

			if (
				$size.height() != height
				||
				$size.width() != width
			) {
				$size.animate({
					'height': height +'px',
					'width': width +'px'
				}, this.animationTime);
			}

			setTimeout(function () {
				$modal.removeClass('ub-modal-opening');
			}, this.animationTime);

			$size = undefined;
		},
		/**
		 * Show modal
		 * Call without arguments to display next from queue
		 * @param {String} [id]
		 * @param {String} [html]
		 * @param {Object} [opts]
		 * @returns {Boolean}
		 */
		show: function (id, html, opts) {
			if (typeof id != 'undefined') {
				// make sure to remove this id from queue (if was added previously)
				this.queue = _.filter(this.queue, function (item) { return item.id != id; });

				{
					opts = jQuery.extend({
						autoHide: 0,
						allowClose: true,
						showCloseButton: true,
						width: 350,
						height: 200,
						hidePrevious: false,
						updateIfCurrent: false,
						wrapWithTable: true,
						backdrop: null,
						customClass: null,
						afterOpen: function(){},
						afterOpenStart: function(){},
						afterClose: function(){},
						afterCloseStart: function(){}
					}, opts || {});

					// hide close button if close is not allowed
					opts.showCloseButton = opts.showCloseButton && opts.allowClose;

					opts.id = id;
					opts.html = html;
				}

				this.queue.push(opts);

				return this.show();
			}

			if (this.currentMethod) {
				return false;
			}

			if (this.current) {
				if (
					this.queue.length
					&&
					this.queue[0].id === this.current.id
					&&
					this.queue[0].updateIfCurrent
				) {
					if (this.$modal && this.current.customClass !== null) {
						this.$modal.removeClass(this.current.customClass);
					}

					if (this.$modal && ! this.current.wrapWithTable) {
						this.wrapWithTable(this.$modal);
					}

					this.current = this.queue.shift();

					if (this.$modal && this.current.customClass !== null) {
						this.$modal.addClass(this.current.customClass);
					}

					this.setContent(this.current.html);

					if (this.$modal && ! this.current.wrapWithTable) {
						this.unwrapWithTable(this.$modal);
					}

					return true;
				} else {
					return false;
				}
			}

			if (this.current && this.$modal && this.current.customClass !== null) {
				this.$modal.removeClass(this.current.customClass);
			}

			if (this.current && this.$modal && ! this.current.wrapWithTable) {
				this.unwrapWithTable(this.$modal);
			}

			this.currentMethod = '';
			this.current = this.queue.shift();

			if (!this.current) {
				this.hide();
				return false;
			}

			this.currentMethod = 'show';

			this.setContent(this.current.html);

			this.$getCloseButton().css('display', this.current.showCloseButton ? '' : 'none');

			{
				this.$modal.removeClass('ub-modal-backdrop-light ub-modal-backdrop-dark');

				if (this.current.backdrop !== null) {
					this.$modal.addClass('ub-modal-backdrop-'+ (this.current.backdrop ? 'light' : 'dark'));
				}
			}

			this.$modal.removeClass('ub-modal-closing');
			this.$modal.addClass('ub-modal-open');

			if (this.$modal && this.current.customClass !== null) {
				this.$modal.addClass(this.current.customClass);
			}

			if (this.$modal && ! this.current.wrapWithTable) {
				this.unwrapWithTable(this.$modal);
			}

			this.$modal.css('display', '');

			this.setSize(this.current.width, this.current.height);

			this.current.afterOpenStart(this.$modal);
			this.currentMethodTimeoutId = setTimeout(_.bind(function() {
				this.current.afterOpen();

				this.currentMethod = '';

				if (this.runPendingMethod()) {
					return;
				}

				if (this.current.autoHide > 0) {
					this.currentMethod = 'auto-hide';
					this.currentMethodTimeoutId = setTimeout(_.bind(function () {
						this.currentMethod = '';
						this.hide();
					}, this), this.current.autoHide);
				}
			}, this), this.animationTime * 2);

			return true;
		},
		/**
		 * @param {String} [id]
		 * @returns {boolean}
		 */
		hide: function(id) {
			if (typeof id != 'undefined') {
				if (this.current && this.current.id == id) {
					// this id is currently displayed, hide it
				} else {
					// remove id from queue
					this.queue = _.filter(this.queue, function (item) {
						return item.id != id;
					});
					return true;
				}
			}

			if (this.currentMethod) {
				if (this.currentMethod == 'hide') {
					return false;
				} else if (this.currentMethod == 'auto-hide') {
					clearTimeout(this.currentMethodTimeoutId);
				} else {
					this.pendingMethod = 'hide';
					return true;
				}
			}

			this.currentMethod = '';

			if (!this.current) {
				// nothing to hide
				return this.runPendingMethod();
			}

			this.currentMethod = 'hide';

			if (this.queue.length && !this.queue[0].hidePrevious) {
				// replace content
				this.current.afterCloseStart(this.$modal);
				this.$getContent().fadeOut('fast', _.bind(function(){
					this.current.afterClose();

					if (this.$modal && this.current.customClass !== null) {
						this.$modal.removeClass(this.current.customClass);
					}

					if (this.$modal && ! this.current.wrapWithTable) {
						this.wrapWithTable(this.$modal);
					}

					this.currentMethod = '';
					this.current = null;
					this.show();
					this.$getContent().fadeIn('fast');
				}, this));

				return true;
			}

			this.$modal.addClass('ub-modal-closing');

			this.current.afterCloseStart(this.$modal);
			this.currentMethodTimeoutId = setTimeout(_.bind(function(){
				this.current.afterClose();

				this.currentMethod = '';

				this.$modal.css('display', 'none');

				this.$modal.removeClass('ub-modal-open');
				this.$modal.removeClass('ub-modal-closing');

				if (this.$modal && this.current.customClass !== null) {
					this.$modal.removeClass(this.current.customClass);
				}

				if (this.$modal && ! this.current.wrapWithTable) {
					this.wrapWithTable(this.$modal);
				}

				this.setContent('');

				this.current = null;

				this.runPendingMethod();
			}, this), this.animationTime);
		}
	};

	return {
		show: function(id, html, opts) {
			inst.show(id, html, opts);
		},
		hide: function(id){
			inst.hide(id);
		},
		/**
		 * Generate flash messages html for soleModal content
		 */
		renderFlashMessages: function (flashMessages) {
			var html = [],
				typeHtml = [],
				typeMessageClass = '',
				typeIconClass = '',
				typeTitle = '';

			jQuery.each(flashMessages, function(type, messages){
				typeHtml = [];

				switch (type) {
					case 'error':
						typeMessageClass = 'ub-text-danger';
						typeIconClass = 'dashicons dashicons-dismiss';
						typeTitle = _ub_localized.l10n.ah_sorry;
						break;
					case 'warning':
						typeMessageClass = 'ub-text-warning';
						typeIconClass = 'dashicons dashicons-no-alt';
						typeTitle = _ub_localized.l10n.ah_sorry;
						break;
					case 'success':
						typeMessageClass = 'ub-text-success';
						typeIconClass = 'dashicons dashicons-star-filled';
						typeTitle = _ub_localized.l10n.done;
						break;
					case 'info':
						typeMessageClass = 'ub-text-info';
						typeIconClass = 'dashicons dashicons-info';
						typeTitle = _ub_localized.l10n.done;
						break;
					default:
						typeMessageClass = typeIconClass = typeTitle = '';
				}

				jQuery.each(messages, function(messageId, message){
					if (!typeTitle.length) {
						return;
					}

					typeHtml.push(
						'<li>'+
						'<h2 class="'+ typeMessageClass +'"><span class="'+ typeIconClass +'"></span> '+ typeTitle +'</h2>'+
						'<p class="ub-text-muted"><em>'+ message +'</em></p>'+
						'</li>'
					);
				});

				if (typeHtml.length) {
					html.push(
						'<ul>'+ typeHtml.join('</ul><ul>') +'</ul>'
					);
				}
			});

			return html.join('');
		}
	};
})();

/**
 * Simple mechanism of getting confirmations from the user.
 *
 * Usage:
 *
 * var confirm = ub.soleConfirm.create();
 * confirm.result.then(function (data) {
 *   // SUCCESS!!
 * });
 *
 * confirm.result.fail(function (data) {
 *   // FAIL!!
 * });
 *
 * confirm.show();
 *
 * Note: confirm.result is a full-featured jQuery.Deferred object, you can also
 * use methods like always, done, jQuery.when with it.
 *
 * Warning:
 *   You confirm object will be garbage collected after the user will pick an
 *   option, that is, it will become null. You should create one more confirm
 *   afterwards, if you need it.
 *
 * TODO:
 *  1. Maybe pass unknown options to ub.soleModal itself.
 */
ub.soleConfirm = (function ($) {
	var hashMap = {};

	function create (opts) {
		var confirm = new Confirm(opts);
		hashMap[confirm.id] = confirm;
		return hashMap[confirm.id];
	}

	function Confirm (opts) {
		this.result = jQuery.Deferred();
		this.id = ub.randomMD5();

		this.opts = _.extend({
			severity: 'info', // warning | info
			message: null,
			backdrop: null,
			renderFunction: null,
			shouldResolvePromise: function (confirm, el, action) { return true; },
			okHTML: _ub_localized.l10n.ok,
			cancelHTML: _ub_localized.l10n.cancel,
			customClass: ''
		}, opts);
	}

	Confirm.prototype.destroy = function () {
		hashMap[this.id] = null;
		delete hashMap[this.id];
	}

	/**
	 * Attached listeners on this.result will be lost after this operation.
	 * You'll have to add them once again.
	 */
	Confirm.prototype.reset = function () {
		if (hashMap[this.id]) {
			throw "You can't reset till your promise is not resolved! Do a .destroy() if you don't need Confirm anymore!";
		}

		if (this.result.isRejected() || this.result.isResolved()) {
			this.result = jQuery.Deferred();
		}

		hashMap[this.id] = this;
	};

	Confirm.prototype.show = function () {
		this._checkIsSet();

		ub.soleModal.show(this.id, this._getHtml(), {
			wrapWithTable: false,
			showCloseButton: false,
			allowClose: false, // a confirm window can't be closed on click of it's backdrop
			backdrop: this.opts.backdrop,
			customClass: 'ub-sole-confirm-modal ub-sole-confirm-' + this.opts.severity + ' ' + this.opts.customClass,
			updateIfCurrent: true,

			afterOpenStart: _.bind(this._fireEvents, this),
			afterCloseStart: _.bind(this._teardownEvents, this),

			onFireEvents: jQuery.noop,
			onTeardownEvents: jQuery.noop
		});
	};

	Confirm.prototype.hide = function (reason) {
		this._checkIsSet();

		ub.soleModal.hide(this.id);
	};

	//////////////////

	Confirm.prototype._fireEvents = function ($modal) {
		$modal.attr('data-ub-sole-confirm-id', this.id);

		$modal.find('.ub-sole-confirm-button')
			.add(
				$modal.find('.media-modal-backdrop')
			)
			.on('click.ub-sole-confirm', _.bind(this._handleClose, this));

		if (this.opts.onFireEvents) {
			this.opts.onFireEvents(this, $modal[0]);
		}
	};

	Confirm.prototype._teardownEvents = function ($modal) {
		$modal.find('.ub-sole-confirm-button')
			.add(
				$modal.find('.media-modal-backdrop')
			)
			.off('click.ub-sole-confirm');

		if (this.opts.onTeardownEvents) {
			this.opts.onTeardownEvents(this, $modal[0]);
		}
	};

	Confirm.prototype._checkIsSet = function () {
		if (! hashMap[this.id]) {
			throw "You can't do operations on fullfilled Confirm! Do a .reset() first.";
		}
	};

	Confirm.prototype._handleClose = function (event) {
		event.preventDefault();

		var $el = $(event.target);

		if ($el.hasClass('media-modal-backdrop')) {

			// do not do any transformation on $el here by intent

		} else if (! $el.hasClass('ub-sole-confirm-button')) {
			$el = $el.closest('.ub-sole-confirm-button');
		}

		var action = $el.attr('data-ub-sole-confirm-action') || 'reject';
		var id = $el.closest('.ub-sole-modal').attr('data-ub-sole-confirm-id');
		var confirm = hashMap[id];

		if (confirm) {
			var modal_container = $el.closest('.ub-sole-modal')[0];

			if (action === 'reject') {
				confirm.result.reject({
					confirm: confirm,
					modal_container: modal_container
				});
			} else {
				var shouldHideAfterResolve = confirm.opts.shouldResolvePromise(
					confirm, modal_container
				);

				if (! shouldHideAfterResolve) {
					return;
				}

				// probably keep this syntax for another actions in future
				_.contains(['resolve'], action) &&
				confirm.result[action]({
					confirm: confirm,
					modal_container: $el.closest('.ub-sole-modal')[0]
				});

			}

			confirm.hide();

			confirm.destroy();
			confirm = null;
		}
	};

	Confirm.prototype._getHtml = function () {
		if (this.opts.renderFunction) {
			return this.opts.renderFunction(this);
		}

		var topHtml = '';

		var iconClass = 'dashicons-' + this.opts.severity;
		var icon = '<span class="dashicons ' + iconClass + '"></span>';
		var heading = '<h1>' + ub.capitalizeFirstLetter(this.opts.severity) + '</h1>';
		var message = this.opts.message ? '<p>' + this.opts.message + '</p>' : '';

		topHtml = icon + heading + message;

		var cancelButton = $('<button>', {
			html: this.opts.cancelHTML
		}).attr({
			'data-ub-sole-confirm-action': 'reject',
			type: 'button',
		}).addClass('ub-sole-confirm-button button');

		var okButton = $('<button>', {
			html: this.opts.okHTML
		}).attr({
			'data-ub-sole-confirm-action': 'resolve',
			type: 'button',
		}).addClass('ub-sole-confirm-button button button-primary');

		return topHtml + selfHtml(cancelButton) + selfHtml(okButton);

		function selfHtml (el) { return $('<div>').append(el).html(); }
	};

	return {
		create: create
	};
})(jQuery);


/**
 * ub.loading
 * Show/Hide loading on the page
 *
 * Usage:
 * - ub.loading.show('unique-id');
 * - ub.loading.hide('unique-id');
 */
(function($){
	var inst = {
		$el: null,
		queue: [],
		current: null,
		timeoutId: 0,
		pendingHide: false,
		$getEl: function(){
			if (this.$el === null) { // lazy init
				this.$el = $(
					'<div id="ub-loading" style="display: none;">'+
					'<table width="100%" height="100%"><tbody><tr><td valign="middle" align="center">'+
					'<img src="'+ ub.img.logoSvg +'"'+
					' width="30"'+
					' class="ub-animation-rotate-reverse-180"'+
					' alt="Loading"' +
					' onerror="this.onerror=null; this.src=\''+ ub.UB_URI +'/static/img/logo-100.png\';"'+
					' />'+
					'</td></tr></tbody></table>'+
					'</div>'
				);

				$(document.body).prepend(this.$el);
			}

			return this.$el;
		},
		removeFromQueue: function(id) {
			this.queue = _.filter(this.queue, function (item) {
				return item.id != id;
			});
		},
		show: function(id, opts) {
			if (typeof id != 'undefined') {
				this.removeFromQueue(id);

				{
					opts = jQuery.extend({
						autoClose: 30000
					}, opts || {});

					opts.id = id;

					/**
					 * @type {string} pending|opening|open|closing
					 */
					opts.state = 'pending';
				}

				this.queue.push(opts);

				return this.show();
			}

			if (this.current) {
				return false;
			}

			if (this.current && this.current.customClass !== null) {
				this.$modal.removeClass(this.current.customClass);
			}

			if (this.$modal && ! this.current.wrapWithTable) {
				this.wrapWithTable(this.$modal);
			}

			this.current = this.queue.shift();

			if (!this.current) {
				return false;
			}

			this.current.state = 'opening';

			{
				clearTimeout(this.timeoutId);

				this.timeoutId = setTimeout(_.bind(function(){
					if (
						!this.current
						||
						this.current.state != 'opening'
					) {
						return;
					}

					this.current.state = 'open';

					this.$getEl().removeClass('opening closing closed').addClass('open');

					if (this.current.autoClose) {
						clearTimeout(this.timeoutId);

						this.timeoutId = setTimeout(_.bind(function(){
							this.hide();
						}, this), this.current.autoClose);
					}

					if (this.pendingHide) {
						this.pendingHide = false;
						this.hide();
					}
				}, this), 300);
			}

			this.$getEl().removeClass('open closing closed').addClass('opening').show();

			return true;
		},
		hide: function(id) {
			if (typeof id != 'undefined') {
				if (
					this.current
					&&
					this.current.id == id
				) {
					// the script below will handle this
				} else {
					this.removeFromQueue(id);
					return true;
				}
			}

			if (!this.current) {
				return false;
			}

			var forceClose = false;

			if (this.current.state == 'opening') {
				if (this.current.id == id) {
					/**
					 * If the currently opening loading was requested to hide
					 * hide it immediately, do not wait full open.
					 * Maybe the script that started the loading was executed so quickly
					 * so the user don't event need to see the loading.
					 */
					// do nothing here, just allow the close script below to be executed
					forceClose = true;
				} else {
					this.pendingHide = true;
					return true;
				}
			} else {
				if (this.current.state != 'open') {
					return false;
				}
			}

			this.current.state = 'closing';

			{
				clearTimeout(this.timeoutId);

				this.timeoutId = setTimeout(_.bind(function () {
					if (
						!this.current
						||
						this.current.state != 'closing'
					) {
						return;
					}

					this.current.state = 'closed';

					this.$getEl().hide().removeClass('opening open closing').addClass('closed');

					if (this.$modal && this.current.customClass !== null) {
						this.$modal.removeClass(this.current.customClass);
					}

					if (this.$modal && ! this.current.wrapWithTable) {
						this.wrapWithTable(this.$modal);
					}

					this.current = null;

					this.show();
				}, this), 300);
			}

			if (forceClose) {
				this.$getEl().fadeOut('fast', _.bind(function(){
					this.$getEl().removeClass('force-closing').addClass('closed').removeAttr('style');
				}, this));

				this.$getEl().addClass('force-closing');
			}

			this.$getEl().removeClass('closed').addClass('closing');
		}
	};

	ub.loading = {
		show: function(id, opts) {
			/**
			 * Compatibility with old version of ub.loading.show()
			 * which didn't had the (id,opts) parameters
			 */
			if (typeof id == 'undefined') {
				id = 'main';
			}

			return inst.show(id, opts);
		},
		hide: function(id) {
			/**
			 * Compatibility with old version of ub.loading.hide()
			 * which didn't had the (id) parameter
			 */
			if (typeof id == 'undefined') {
				id = 'main';
			}

			return inst.hide(id);
		}
	};
})(jQuery);


/**
 * Listen and trigger custom events to communicate between javascript components
 */
var ubEvents = new (function(){
	var _events = {};
	var currentIndentation = 1;
	var debug = false;

	this.countAll = function (topic) {
		return _events[topic];
	}

	/**
	 * Make log helper public
	 *
	 * @param {String} [message]
	 * @param {Object} [data]
	 */
	this.log = log;

	/**
	 * Enable/Disable Debug
	 * @param {Boolean} enabled
	 */
	this.debug = function(enabled) {
		debug = Boolean(enabled);

		return this;
	};

	/**
	 * Add event listener
	 *
	 * @param event {String | Object}
	 *   Can be a:
	 *     - single event: 'event1'
	 *     - space separated event list: 'event1 event2 event2'
	 *     - an object: {event1: function () {}, event2: function () {}}
	 *
	 * @param callback {Function}
	 */
	this.on = function(topicStringOrObject, listener) {
		objectMap(
			splitTopicStringOrObject(topicStringOrObject, listener),
			function (eventName, listener) {
				(_events[eventName] || (_events[eventName] = [])).push(
					listener
				);

				debug && log('✚ ' + eventName);
			}
		);

		return this;
	};

	/**
	 * Same as .on(), but callback will executed only once
	 */
	this.one = function(topicStringOrObject, listener) {
		objectMap(
			splitTopicStringOrObject(topicStringOrObject, listener),
			function (eventName, listener) {
				(_events[eventName] || (_events[eventName] = [])).push(
					once(listener)
				);

				debug && log('✚ [' + eventName +']');
			}
		);

		return this;

		// https://github.com/jashkenas/underscore/blob/8fc7032295d60aff3620ef85d4aa6549a55688a0/underscore.js#L946
		function once(func) {
			var memo;

			var times = 2;

			return function() {
				if (--times > 0) {
					memo = func.apply(this, arguments);
				}

				if (times <= 1) func = null;

				return memo;
			};
		};
	};

	/**
	 * In order to remove one single listener you should give as an argument
	 * the same callback function. If you want to remove *all* listeners from
	 * a particular event you should not pass the second argument.
	 *
	 * @param topicStringOrObject {String | Object}
	 * @param listener {Function | false}
	 */
	this.off = function(topicStringOrObject, listener) {
		objectMap(
			splitTopicStringOrObject(topicStringOrObject, listener),
			function (eventName, listener) {
				if (_events[eventName]) {
					if (listener) {
						_events[eventName].splice(
							_events[eventName].indexOf(listener) >>> 0,
							1
						);
					} else {
						_events[eventName] = [];
					}

					debug && log('✖ ' + eventName);
				}
			}
		);

		return this;
	};

	/**
	 * Trigger an event. In case you provide multiple events via space-separated
	 * string or an object of events it will execute listeners for each event
	 * separatedly. You can use the "all" event to trigger all events.
	 *
	 * @param topicStringOrObject {String | Object}
	 * @param data {Object}
	 */
	this.trigger = function(eventName, data) {
		objectMap(
			splitTopicStringOrObject(eventName),
			function (eventName) {
				log('╭─ '+ eventName, data);

				changeIndentation(+1);

				try {
					// TODO: REFACTOR THAT!!!!!!!!!
					// Maybe this is an occasion for using 'all' event???
					if (eventName === 'fw:options:init') {
						ub.options.startListeningToEvents(
							data.$elements || document.body
						)
					}

					(_events[eventName] || []).map(dispatchSingleEvent);
					(_events['all'] || []).map(dispatchSingleEvent);
				} catch (e) {
					console.log(
						"%c [Events] Exception raised. Please contact support in https://github.com/ThemeFuse/Unyson/issues/new. Don't forget to attach this stack trace to the issue.",
						"color: red; font-weight: bold;"
					);

					if (typeof console !== 'undefined') {
						console.error(e)
					} else {
						throw e;
					}
				}

				changeIndentation(-1);

				log('╰─ '+ eventName, data);

				function dispatchSingleEvent (listenerDescriptor) {
					if (! listenerDescriptor) return;

					listenerDescriptor.call(
						window,
						data
					);
				}
			}
		);

		return this;

		function changeIndentation(increment) {
			if (typeof increment != 'undefined') {
				currentIndentation += (increment > 0 ? +1 : -1);
			}

			if (currentIndentation < 0) {
				currentIndentation = 0;
			}
		}
	};

	/**
	 * Check if an event has listeners
	 * @param {String} [event]
	 * @return {Boolean}
	 */
	this.hasListeners = function(eventName) {
		if (! _events) {
			return false;
		}

		return (_events[eventName] || []).length > 0;
	};

	/**
	 * Probably split string into general purpose object representation for
	 * event names and listeners. This function leaves objects un-modified.
	 *
	 * @param topicStringOrObject {String | Object}
	 * @param listener {Function | false}
	 *
	 * @returns {Object} {
	 *    eventname: listener,
	 *    otherevent: listener
	 * }
	 */
	function splitTopicStringOrObject (topicStringOrObject, listener) {
		if (typeof topicStringOrObject !== 'string') {
			return topicStringOrObject;
		}

		var arrayOfEvents = topicStringOrObject.replace(
			/\s\s+/g, ' '
		).trim().split(' ');

		var len = arrayOfEvents.length;

		var listenerDescriptor = Object.create(null);

		for (var i = 0; i < len; i++) {
			listenerDescriptor[arrayOfEvents[i]] = listener;
		}

		return listenerDescriptor;
	}

	/**
	 * returns a new object with the predicate applied to each value
	 * objectMap({a: 3, b: 5, c: 9}, (key, value) => value + 1); // {a: 4, b: 6, c: 10}
	 * objectMap({a: 3, b: 5, c: 9}, (key, value) => key); // {a: 'a', b: 'b', c: 'c'}
	 * objectMap({a: 3, b: 5, c: 9}, (key, value) => key + value); // {a: 'a3', b: 'b5', c: 'c9'}
	 *
	 * https://github.com/angus-c/just/tree/master/packages/object-map
	 */
	function objectMap(obj, predicate) {
		var result = {};
		var keys = Object.keys(obj);
		var len = keys.length;

		for (var i = 0; i < len; i++) {
			var key = keys[i];
			result[key] = predicate(key, obj[key]);
		}

		return result;
	}

	function log(message, data) {
		if (! debug) {
			return;
		}

		if (typeof data != 'undefined') {
			console.log('[Event] ' + getIndentation() + message, '─', data);
		} else {
			console.log('[Event] ' + getIndentation() + message);
		}

		function getIndentation() {
			return new Array(currentIndentation).join('│ ');
		}
	}
})();


/**
 * Check current status
 */
jQuery(function ($) {
	var inst = {
		localized: _ub_ext_backups_demo,
		getEventName: function(name) {
			return 'fw:ext:backups-demo:status:'+ name;
		},
		timeoutId: 0,
		timeoutTime: 3000,
		/**
		 * 0 - (false) not busy
		 * 1 - (true) busy
		 * 2 - (true) busy and a pending ajax
		 */
		isBusy: 0,
		doAjax: function() {
			if (this.isBusy) {
				this.isBusy = 2;
				return false;
			}

			clearTimeout(this.timeoutId);

			ubEvents.trigger(this.getEventName('updating'));

			$.ajax({
					url: ajaxurl,
					type: 'POST',
					dataType: 'json',
					data: {
						action: this.localized.ajax_action.status
					}
				})
				.done(_.bind(function(r){
					if (r.success) {
						ubEvents.trigger(this.getEventName('update'), r.data);
					} else {
						ubEvents.trigger(this.getEventName('update-fail'));
					}
				}, this))
				.fail(_.bind(function(jqXHR, textStatus, errorThrown){
					console.error('Ajax error', jqXHR, textStatus, errorThrown);
					ubEvents.trigger(this.getEventName('update-fail'));
				}, this))
				.always(_.bind(function(data_jqXHR, textStatus, jqXHR_errorThrown){
					ubEvents.trigger(this.getEventName('updated'));

					if (this.isBusy === 2) {
						this.isBusy = 0;
						this.doAjax();
					} else {
						this.isBusy = 0;
					}

					this.timeoutId = setTimeout(_.bind(this.doAjax, this), this.timeoutTime);
				}, this));

			return true;
		},
		onUpdate: function(data) {
			this.timeoutTime = data.is_busy ? 3000 : 10000;
		},
		init: function(){
			this.init = function(){};

			ubEvents.on(this.getEventName('do-update'), _.bind(function(){ this.doAjax(); }, this));
			ubEvents.on(this.getEventName('update'), _.bind(function(data){ this.onUpdate(data); }, this));

			this.doAjax();
		}
	};

	// let other scripts to listen events
	setTimeout(function(){ inst.init(); }, 100);
});

/**
 * Current status
 */
jQuery(function($){
	var inst = {
		failCount: 0,
		ubSoleModalId: 'ub-ext-backups-demo-status',
		onUpdating: function(){},
		onUpdate: function(data) {
			if (data.is_busy) {
				ub.soleModal.show(
					this.ubSoleModalId,
					data.html,
					{
						allowClose: false,
						updateIfCurrent: true
					}
				);
			} else {
				ub.soleModal.hide(this.ubSoleModalId);
			}

			this.failCount = 0;
		},
		onUpdateFail: function() {
			if (this.failCount > 3) {
				ub.soleModal.show(
					this.ubSoleModalId,
					'<span class="ub-text-danger dashicons dashicons-warning"></span>',
					{
						allowClose: false,
						updateIfCurrent: true
					}
				);
			}
			++this.failCount;
		},
		onUpdated: function() {},
		init: function(){
			ubEvents.on({
				'fw:ext:backups-demo:status:updating': _.bind(this.onUpdating, this),
				'fw:ext:backups-demo:status:update': _.bind(this.onUpdate, this),
				'fw:ext:backups-demo:status:update-fail': _.bind(this.onUpdateFail, this),
				'fw:ext:backups-demo:status:updated': _.bind(this.onUpdated, this)
			});
		}
	};

	inst.init();
});

/**
 * Install button
 */
jQuery(function($) {
	var inst = {
		localized: _ub_ext_backups_demo,
		isBusy: false,
		ubLoadingId: 'ub-ext-backups-demo-install',
		init: function(){
			ubEvents.on('fw:ext:backups-demo:status:update', function(data){
				{
					$('#ub-ext-backups-demo-list .ub-ext-backups-demo-item').removeClass('active');

					if (data.active_demo.id) {
						$('#demo-'+ data.active_demo.id).addClass('active');
					}
				}

				if (data.active_demo.result) {
					if (data.active_demo.result === true) {
						ub.soleModal.hide(inst.ubLoadingId);

						setTimeout(function(){
							$(document.body).fadeOut();
						}, 500); // after modal hide animation end

						setTimeout(function(){
							window.location.assign(data.home_url);
						}, 1000); // after all animations end
					} else {
						ub.soleModal.show(
							inst.ubLoadingId,
							'<h3 class="ub-text-danger">'+ data.active_demo.result +'</h3>'
						);
					}
				}
			});

			$('#ub-ext-backups-demo-list').on('click', '[data-install]', function(){
				if (inst.isBusy) {
					console.log('Install is busy');
					return;
				}

				var $this = $(this),
					demoId = $this.attr('data-install'),
					confirm_message = $this.attr('data-confirm');

				if (confirm_message) {
					if (!confirm(confirm_message)) {
						return;
					}
				}

				inst.isBusy = true;
				ub.loading.show(inst.ubLoadingId);

				$.ajax({
					url: ajaxurl,
					data: {
						action: inst.localized.ajax_action.install,
						id: demoId
					},
					type: 'POST',
					dataType: 'json'
				})
					.done(function(r){
						if (r.success) {
							ubEvents.trigger('fw:ext:backups-demo:status:do-update');
						} else {
							ub.soleModal.show(
								'ub-ext-backups-demo-install-error',
								((r.data && r.data.length) ? r.data[0].message : '')
							);
						}
					})
					.fail(function(jqXHR, textStatus, errorThrown){
						ub.soleModal.show(
							'ub-ext-backups-demo-install-error',
							'<h2>Ajax error</h2>'+ '<p>'+ String(errorThrown) +'</p>'
						);
					})
					.always(function(data_jqXHR, textStatus, jqXHR_errorThrown){
						inst.isBusy = false;
						ub.loading.hide(inst.ubLoadingId);
					});
			});
		}
	};

	inst.init();
});

/**
 * "Cancel" functionality
 */
jQuery(function($){
	var inst = {
		localized: _ub_ext_backups_demo,
		isBusy: false,
		ubLoadingId: 'ub-ext-backups-demo-install-cancel',
		doCancel: function(){
			if (this.isBusy) {
				return;
			} else {
				if (!confirm(this.localized.l10n.abort_confirm)) {
					return;
				}

				this.isBusy = true;
			}

			inst.isBusy = true;
			ub.loading.show(inst.ubLoadingId);

			$.ajax({
					url: ajaxurl,
					data: {
						action: inst.localized.ajax_action.cancel
					},
					type: 'POST',
					dataType: 'json'
				})
				.done(function(r){
					if (r.success) {
						ubEvents.trigger('fw:ext:backups-demo:status:do-update');
					} else {
						console.warn('Cancel failed');
					}
				})
				.fail(function(jqXHR, textStatus, errorThrown){
					ub.soleModal.show(
						'ub-ext-backups-demo-install-error',
						'<h2>Ajax error</h2>'+ '<p>'+ String(errorThrown) +'</p>'
					);
				})
				.always(function(data_jqXHR, textStatus, jqXHR_errorThrown){
					inst.isBusy = false;
					ub.loading.hide(inst.ubLoadingId);
				});
		},
		init: function(){
			var that = this;

			ubEvents.on('fw:ext:backups-demo:cancel', function(){
				that.doCancel();
			});
		}
	};

	inst.init();
});

/**
 * If loopback request failed, execute steps via ajax
 * @since 2.0.5
 */
jQuery(function($){
	if (typeof ub_ext_backups_loopback_failed == 'undefined') {
		return;
	}

	var inst = {
		running: false,
		isBusy: false,
		onUpdate: function(data) {
			this.running = data.is_busy;
			this.executeNextStep(data.ajax_steps.token, data.ajax_steps.active_tasks_hash);
		},
		executeNextStep: function(token, activeTasksHash){
			if (!this.running || this.isBusy) {
				return false;
			}

			this.isBusy = true;

			$.ajax({
					url: ajaxurl,
					data: {
						action: 'fw:ext:backups:continue-pending-task',
						token: token,
						active_tasks_hash: activeTasksHash
					},
					type: 'POST',
					dataType: 'json'
				})
				.done(function(r){ console.log(r);
					if (r.success) {
						ubEvents.trigger('fw:ext:backups-demo:status:do-update');
					} else {
						console.error('Ajax execution failed');
						// execution will try to continue on next (auto) update
					}
				})
				.fail(_.bind(function(jqXHR, textStatus, errorThrown){
					console.error('Ajax error: '+ String(errorThrown));
				}, this))
				.always(_.bind(function(data_jqXHR, textStatus, jqXHR_errorThrown){
					this.isBusy = false;
				}, this));
		},
		init: function(){
			ubEvents.on('fw:ext:backups-demo:status:update', _.bind(this.onUpdate, this));
		}
	};

	inst.init();
});

//plugins
(function ($) {
	$(window).on("load", function (e) {
		if( $('.ub_ext_backups_loopback_failed_true').length ) {
			window.ub_ext_backups_loopback_failed = true;
		}
		var state = {
			current: '',
			plugins: {
				install: [],
				activate: []
			},
			demo: '',
		};
		var $containers = $('.ub-ext-backups-demo-item');
		//processing IMPORT button click
		$containers.each( function() {
			var $container = $(this);
			if($container.find('.demo-required-plugins-wrap').length) {
				$container.find('.theme-actions .button-primary').attr('disabled', 'disabled');
			}


			//processing INSTALL PLUGINS button click
			$container.on('click', '.demo-required-plugins-install-plugins-button', function (e) {
				console.log('clicked  demo plugins');
				var $button = $(this);
				$button.attr('disabled','disabled');
				state.current = '';
				state.plugins.install = $button.data('toinstall').split(',');
				state.plugins.activate = $button.data('toactivate').split(',');
				state.demo = $button.data('todemo');
				state.plugins.install.map(function (val,index,array) {
					$container.find('span.demo-required-plugin-'+val).text(unyson_demo_plugins.text_installing);
					$button.next().css({visibility: 'visible'});
					$.post(
						ajaxurl,
						{
							action: 'ub_install_and_activate_plugins',
							wpnonce: unyson_demo_plugins.wpnonce,
							'plugins_activate[]': state.plugins.activate,
							'plugins_install[]': state.plugins.install,
							demo: state.demo,
							slug: state.plugins.install[index]
						},
						//success function - installing plugins via TGM
						function (res) {
							$.post(
								res.url,
								res,
							).done(function () {
								$container.find('span.demo-required-plugin-'+val).text(unyson_demo_plugins.text_activating);
								state.plugins.activate.push(val);
								state.plugins.install.splice (state.plugins.install.indexOf(val), 1);
								//activate plugins here
								if(0===state.plugins.install.length) {
									$.post(
										ajaxurl,
										{
											action: 'ub_install_and_activate_plugins',
											wpnonce: unyson_demo_plugins.wpnonce,
											'plugins_activate[]': state.plugins.activate,
											'plugins_install[]': state.plugins.install,
											demo: state.demo,
											slug: state.plugins.activate
										},
										//success function - activating plugins via TGM - all in bulk action
										function (res) {
											$.post(
												res.url,
												res,
											).done(function () {
												$container.find('span[class*="demo-required-plugin-"]').text(unyson_demo_plugins.text_done);
												//end of activate plugins here
												$button.next().css({visibility: 'hidden'});
												$container.find('.theme-actions .button-primary').removeAttr('disabled');
											}).fail(function(data) {
												console.log(data);
												$button.closest('.demo-required-plugins-button-wrap').find('.install-required-plugins-error').remove();
												$button.before('<div class="install-required-plugins-error">' + unyson_demo_plugins.text_fail_tgm + '<br></div>');
											});
										}
									).fail(
										function (data) {
											console.log(data);
											$button.closest('.demo-required-plugins-button-wrap').find('.install-required-plugins-error').remove();
											$button.before('<div class="install-required-plugins-error">' + unyson_demo_plugins.text_fail + '<br></div>');
										}
									);
								}
							}).fail(function(data) {
								console.log(data);
								$button.closest('.demo-required-plugins-button-wrap').find('.install-required-plugins-error').remove();
								$button.before('<div class="install-required-plugins-error">' + unyson_demo_plugins.text_fail_tgm + '<br></div>');
							});
						}
					).fail(
						function (data) {
							console.log(data);
							$button.closest('.demo-required-plugins-button-wrap').find('.install-required-plugins-error').remove();
							$button.before('<div class="install-required-plugins-error">' + unyson_demo_plugins.text_fail + '<br></div>');
						}
					);
				});
			});

		});
	});
})(jQuery);