<?php
/**
 * Widget Posts view file
 *
 * @package Seedone
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$mwt_center_class = ( ! empty( $mwt_text_center ) ) ? ' text-center' : '';

echo wp_kses_post( str_replace( 'class="', 'class="widget-fullwidth posts-side ', $mwt_args['before_widget'] ) );
echo '<div class="posts-side ' . esc_attr( 'layout-' . $mwt_layout . ' ' . $mwt_css_class . $mwt_center_class ) . '">';
if ( $mwt_title ) {
	echo wp_kses_post( $mwt_args['before_title'] . $mwt_title . $mwt_args['after_title'] );
}
if ( $mwt_sub_title ) {
	echo '<p class="sub-title">' . wp_kses_post( $mwt_sub_title ) . '</p><!-- .sub-title-->';
}
if ( ! empty( $mwt_cat_name ) && ! empty( $mwt_show_cat ) ) {
	echo '<h4 class="widget-posts-category-name"><span>' . wp_kses_post( $mwt_cat_name ) . '</span></h4>';
}
?>
	<div class="posts-side-wrap">
		<?php
		while ( $mwt_r->have_posts() ) :
			$mwt_r->the_post();
			$mwt_id             = get_the_ID();
			$mwt_post_title     = get_the_title( $mwt_id );
			$mwt_post_thumbnail = get_the_post_thumbnail( $mwt_id, 'thumbnail' );
			$mwt_title          = ( ! empty( $mwt_post_title ) ) ? $mwt_post_title : esc_html__( '(no title)', 'mwt-widgets' );
			?>
			<div class="posts-side-item <?php echo ( ! empty( $mwt_post_thumbnail ) ) ? 'has-post-thumbnail side-item' : 'no-post-thumbnail'; ?>">
				<?php if ( ! empty( $mwt_post_thumbnail ) ) : ?>
					<a class="posts-list-thumbnail" href="<?php the_permalink( $mwt_id ); ?>">
						<?php
						echo get_the_post_thumbnail( $mwt_id, 'large' );
						seedone_post_format_icon( get_post_format( $mwt_id ) );
						?>
					</a>
				<?php endif; ?>
				<div class="item-content">
					<div class="entry-header">
						<h5 class="mb-1">
							<a href="<?php the_permalink( $mwt_id ); ?>"><?php echo wp_kses_post( $mwt_title ); ?></a>
						</h5>
					</div>
					<?php if ( $mwt_show_date ) : ?>
						<footer class="entry-footer">
							<span class="icon-inline post-date">
								<?php seedone_icon( 'calendar' ); ?>
								<span><?php echo get_the_date( '', $mwt_id ); ?></span>
							</span>
						</footer>
						<?php
					endif; //$mwt_show_date
					the_excerpt();
					?>
				</div>
			</div><!-- .posts-side-item  -->
			<?php
		endwhile;
		wp_reset_postdata();
		if ( ! empty( $mwt_read_all ) ) :
			?>
			<span class="read-all-link">
				<a href="<?php echo esc_url( $mwt_read_all_url ); ?>">
					<?php echo esc_html( $mwt_read_all ); ?>
				</a>
			</span>
		<?php endif; //$mwt_read_all ?>
	</div><!-- .posts-side-wrap -->
	</div><!-- .post-side -->
<?php
echo wp_kses_post( $mwt_args['after_widget'] );
