<?php
/**
 * Widget Posts view file
 *
 * @package Seedone
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$mwt_center_class = ( ! empty( $mwt_text_center ) ) ? ' text-center' : '';

echo wp_kses_post( str_replace( 'class="', 'class="widget-fullwidth posts-featured ', $mwt_args['before_widget'] ) );
echo '<div class="posts-featured ' . esc_attr( $mwt_css_class . ' layout-' . $mwt_layout . ' layout-gap-' . $mwt_gap . ' ' . $mwt_center_class ) . '">';
if ( $mwt_title ) {
	echo wp_kses_post( $mwt_args['before_title'] . $mwt_title . $mwt_args['after_title'] );
}
if ( $mwt_sub_title ) {
	echo '<p class="sub-title">' . wp_kses_post( $mwt_sub_title ) . '</p><!-- .sub-title-->';
}
if ( ! empty( $mwt_cat_name ) && ! empty( $mwt_show_cat ) ) {
	echo '<h4 class="widget-posts-category-name"><span>' . wp_kses_post( $mwt_cat_name ) . '</span></h4>';
}
?>
	<div class="d-grid grid-2-cols layout-2-cols-loop">
	<?php
	foreach ( $mwt_r->posts as $mwt_index => $mwt_post ) :
		$mwt_post_title     = get_the_title( $mwt_post->ID );
		$mwt_post_thumbnail = get_the_post_thumbnail( $mwt_post->ID, 'thumbnail' );
		$mwt_title          = ( ! empty( $mwt_post_title ) ) ? $mwt_post_title : esc_html__( '(no title)', 'mwt-widgets' );
		?>
			<div class="post-grid-item <?php echo ( ! empty( $mwt_post_thumbnail ) ) ? 'has-post-thumbnail content-absolute' : 'no-post-thumbnail'; ?> item-<?php echo esc_attr( $mwt_index ); ?>">
				<?php if ( ! empty( $mwt_post_thumbnail ) ) : ?>

					<a class="posts-list-thumbnail" href="<?php the_permalink( $mwt_post->ID ); ?>">
						<?php
						echo get_the_post_thumbnail( $mwt_post->ID, 'seedone-square' );
						seedone_post_format_icon( get_post_format( $mwt_post->ID ) );
						?>
					</a>
				<?php endif; ?>
				<div class="overlap-content">
					<h6 class="post-title">
						<a href="<?php the_permalink( $mwt_post->ID ); ?>"><?php echo wp_kses_post( $mwt_title ); ?></a>
					</h6>
					<?php if ( $mwt_show_date ) : ?>
						<footer class="entry-footer">
							<span class="icon-inline post-date">
								<?php seedone_icon( 'calendar' ); ?>
								<span><?php echo get_the_date( '', $mwt_post->ID ); ?></span>
							</span>
						</footer>
					<?php endif; ?>
				</div><!-- .overlap-content -->
			</div><!-- .item-* -->
		<?php endforeach; ?>
	</div><!-- .d-grid -->
	<?php if ( ! empty( $mwt_read_all ) ) : ?>
	<span class="read-all-link">
		<a href="<?php echo esc_url( $mwt_read_all_url ); ?>">
			<?php echo esc_html( $mwt_read_all ); ?>
		</a>
	</span>
	<?php endif; //$mwt_read_all ?>
	</div><!-- .posts-featured -->
<?php
echo wp_kses_post( $mwt_args['after_widget'] );
