<?php
/**
 * Widget Theme meta view file
 *
 * @package Seedone
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// if our theme is not active - return
if ( ! function_exists( 'seedone_get_theme_meta' ) ) {
	return;
}

//meta
$mwt_meta = seedone_get_theme_meta();

$mwt_center_class = ( ! empty( $mwt_text_center ) ) ? ' text-center' : '';

echo wp_kses_post( $mwt_args['before_widget'] );
echo '<div class="widget-theme-meta-default ' . esc_attr( $mwt_css_class . $mwt_center_class ) . '">';
if ( $mwt_title ) {
	echo wp_kses_post( $mwt_args['before_title'] . $mwt_title . $mwt_args['after_title'] );
}
if ( $mwt_image_uri ) {
	echo '<div class="theme-meta-img wp-block-image"><img src="' . esc_url( $mwt_image_uri ) . '" alt="' . esc_attr( $mwt_title ) . '"></div>';
}
if ( $mwt_sub_title ) {
	echo '<p class="sub-title">' . wp_kses_post( seedone_get_copyright_text( $mwt_sub_title ) ) . '</p><!-- .sub-title-->';
}

if (
! empty( $mwt_meta )
) :
	?>
	<div class="theme-meta">
	<?php
		if ( ! empty( $mwt_meta['address'] ) && ! empty( $mwt_show_address ) ) :
	?>
	<span class="icon-inline">
		<?php seedone_icon( 'map-marker-outline' ); ?>
			<span>
				<?php if ( ! empty( $mwt_meta['address_label'] ) ) : ?>
					<strong><?php echo wp_kses_post( $mwt_meta['address_label'] ); ?></strong>
				<?php endif; ?>
				<span><?php echo wp_kses_post( $mwt_meta['address'] ); ?></span>
			</span>
		</span>
		<?php
		endif; //address
		if ( ! empty( $mwt_meta['phone'] ) && ! empty( $mwt_show_phone ) ) : ?>
			<span class="icon-inline">
			<?php seedone_icon( 'phone-outline' ); ?>
				<span>
					<?php if ( ! empty( $mwt_meta['phone_label'] ) ) : ?>
						<strong><?php echo wp_kses_post( $mwt_meta['phone_label'] ); ?></strong>
					<?php endif; ?>
					<span><?php echo wp_kses_post( $mwt_meta['phone'] ); ?></span>
				</span>
			</span>
			<?php
		endif; //phone
		if ( ! empty( $mwt_meta['email'] ) && ! empty( $mwt_show_email ) ) :
			?>
			<span class="icon-inline">
			<?php seedone_icon( 'email-outline' ); ?>
				<span>
					<?php if ( ! empty( $mwt_meta['email_label'] ) ) : ?>
						<strong><?php echo wp_kses_post( $mwt_meta['email_label'] ); ?></strong>
					<?php endif; ?>
					<a href="mailto:<?php echo esc_attr( $mwt_meta['email'] ); ?>"><?php echo wp_kses_post( $mwt_meta['email'] ); ?></a>
				</span>
			</span>
			<?php
		endif; //email
		if ( ! empty( $mwt_meta['opening_hours'] ) && ! empty( $mwt_show_opening_hours ) ) :
			?>
			<span class="icon-inline">
			<?php seedone_icon( 'clock-outline' ); ?>
				<span>
					<?php if ( ! empty( $mwt_meta['opening_hours_label'] ) ) : ?>
						<strong><?php echo wp_kses_post( $mwt_meta['opening_hours_label'] ); ?></strong>
					<?php endif; ?>
					<span><?php echo wp_kses_post( $mwt_meta['opening_hours'] ); ?></span>
				</span>
			</span>
			<?php
		endif; //opening_hours
		?>
	</div><!-- .theme-meta -->
	<?php
endif; //! empty meta
if ( ! empty( $mwt_show_social_links ) && function_exists( 'seedone_social_links' ) ) :
	?>
	<?php seedone_social_links(); ?>
<?php endif; //social_links ?>
	</div><!-- .widget-theme-meta-default -->
<?php
echo wp_kses_post( $mwt_args['after_widget'] );
