<?php
/*
Plugin Name: MWT Widgets
Description: Additional extended custom widgets for theme
Version:     1.0.0
Author:      MWTemplates
Author URI:  https://themeforest.net/user/mwtemplates
License:     GPLv2 or later
Text Domain: mwt-widgets
Domain Path: /languages
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'MWT_WIDGETS_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'MWT_WIDGETS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

//check - is current theme is our theme.
if ( 'seedone' !== get_template() ) :
	//put functions and styles from theme here if our theme is not active
	require_once MWT_WIDGETS_PLUGIN_PATH . '/functions.php';
endif;

//custom widgets
require_once MWT_WIDGETS_PLUGIN_PATH . '/widgets/posts/class-mwt-widget-theme-posts.php';
require_once MWT_WIDGETS_PLUGIN_PATH . '/widgets/meta/class-mwt-widget-theme-meta.php';
require_once MWT_WIDGETS_PLUGIN_PATH . '/widgets/category/class-mwt-widget-theme-category.php';
require_once MWT_WIDGETS_PLUGIN_PATH . '/widgets/spacer/class-mwt-widget-theme-spacer.php';
require_once MWT_WIDGETS_PLUGIN_PATH . '/addons.php';

add_action( 'plugins_loaded', 'mwt_widgets_load_plugin_textdomain' );
if ( ! function_exists( 'mwt_widgets_load_plugin_textdomain' ) ) :
    /**
     * Load plugin textdomain.
     */
    function mwt_widgets_load_plugin_textdomain() {
        load_plugin_textdomain( 'mwt-widgets', false, '/mwt-widgets/languages' );
    }
endif;