<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/*
 * Views
 */

if (!function_exists('seedone_set_post_views')) :
    /**
     * Counter incrementor
     *
     * @param int $postID ID of the post.
     */
    function seedone_set_post_views($postID)
    {
        $count_key = 'seedone_post_views_count';
        $count     = get_post_meta($postID, $count_key, true);
        if ($count == '') {
            $count = 0;
            delete_post_meta($postID, $count_key);
            add_post_meta($postID, $count_key, '1');
        } else {
            //this fires twice for some unknown reason so we increase count by one half
            $count = $count + 0.5;
            update_post_meta($postID, $count_key, $count);
        }
    } //seedone_set_post_views()
endif;

if (!function_exists('seedone_action_track_post_views')) :
    /**
     * Post views tracker
     *
     * @param int $post_id ID of the post.
     */
    function seedone_action_track_post_views($post_id = '')
    {
        if (!is_singular('post')) {
            return;
        }
        if (empty($post_id)) {
            global $post;
            $post_id = $post->ID;
        }
        seedone_set_post_views($post_id);
    } //seedone_action_track_post_views()
endif;
add_action('shutdown', 'seedone_action_track_post_views');

if (!function_exists('seedone_get_post_views')) :
    /**
     * Get counter value
     *
     * @param int $postID ID of the post.
     */
    function seedone_get_post_views($post_id)
    {
        $count_key = 'seedone_post_views_count';
        $count     = get_post_meta($post_id, $count_key, true);
        if ($count == '') {
            delete_post_meta($post_id, $count_key);
            add_post_meta($post_id, $count_key, '0');

            return "0";
        }

        return number_format($count, 0, ".", ",");
    } //seedone_action_track_post_views()
endif;

if (!function_exists('seedone_filter_post_column_views')) :
    //Function that Adds a 'Views' Column to your Posts tab in WordPress Dashboard.
    function seedone_filter_post_column_views($newcolumn)
    {
        //Retrieves the translated string, if translation exists, and assign it to the 'default' array.
        $newcolumn['post_views'] = esc_html__('Views', 'seedone');

        return $newcolumn;
    } //seedone_filter_post_column_views()
endif;

if (!function_exists('seedone_action_post_custom_column_views')) :
    //Function that Populates the 'Views' Column with the number of views count.
    function seedone_action_post_custom_column_views($column_name, $id)
    {

        if ($column_name === 'post_views') {
            // Display the Post View Count of the current post.
            // get_the_ID() - Returns the numeric ID of the current post.
            echo seedone_get_post_views(get_the_ID());
        }
    }
endif;
//Hooks a function to a specific filter action.
//applied to the list of columns to print on the manage posts screen.
add_filter('manage_posts_columns', 'seedone_filter_post_column_views');

//Hooks a function to a specific action.
//allows you to add custom columns to the list post/custom post type pages.
//'10' default: specify the function's priority.
//and '2' is the number of the functions' arguments.
add_action('manage_posts_custom_column', 'seedone_action_post_custom_column_views', 10, 2);


if (!function_exists('seedone_show_post_views_count')) :
    function seedone_show_post_views_count()
    {

        $id     = get_the_ID();
        $number = seedone_get_post_views($id);
        $html   = '';

        if (!$number) {
            $html = '<span class="item-views-count">0</span> <span class="ml-1 item-views-word">' . esc_html__('Views', 'seedone') . '</span>';
        }

        if ($number == 1) {
            $html = '<span class="item-views-count">1</span> <span class="ml-1 item-views-word">' . esc_html__('View', 'seedone') . '</span>';
        }

        if ($number > 1) {
            $html = '<span class="item-views-count">' . $number . '</span> <span class="ml-1 item-views-word">' . esc_html__('Views', 'seedone') . '</span>';
        }

        echo wp_kses_post($html);
    } //seedone_show_post_views_count()
endif;

/*
 *  share buttons
 */
if (!function_exists('seedone_share_this')) :
    /**
     * Share article through social networks.
     * bool $only_buttons
     */
    function seedone_share_this($only_buttons = false)
    {

        $share_buttons                      = array();
        $share_buttons['share_facebook']    = '<a href="https://www.facebook.com/share.php?u=' . esc_url(get_permalink()) . '" class="dropdown-item fa fa-facebook-f" target="_blank"></a>';
        $share_buttons['share_twitter']     = '<a href="https://twitter.com/intent/tweet?url=' . esc_url(get_permalink()) . '" class="dropdown-item ico-x-twitter" target="_blank"></a>';
        $share_buttons['share_telegram']    = '<a href="https://telegram.me/share/url?url=' . esc_url(get_permalink()) . '" class="dropdown-item fa fa-paper-plane" target="_blank"></a>';
        $share_buttons['share_pinterest']   = '<a href="https://pinterest.com/pin/create/bookmarklet/?url=' . esc_url(get_permalink()) . '" class="dropdown-item fa fa-pinterest" target="_blank"></a>';
        $share_buttons['share_linkedin']    = '<a href="https://www.linkedin.com/shareArticle?url=' . esc_url(get_permalink()) . '" class="dropdown-item fa fa-linkedin" target="_blank"></a>';

        if (is_singular()) {
            $blog_share_facebook  = seedone_option('blog_single_share_facebook', true);
            $blog_share_twitter  = seedone_option('blog_single_share_twitter', true);
            $blog_share_telegram  = seedone_option('blog_single_share_telegram', true);
            $blog_share_pinterest  = seedone_option('blog_single_share_pinterest', true);
            $blog_share_linkedin  = seedone_option('blog_single_share_linkedin', true);
        } else {
            $blog_share_facebook  = seedone_option('blog_share_facebook', true);
            $blog_share_twitter  = seedone_option('blog_share_twitter', true);
            $blog_share_telegram  = seedone_option('blog_share_telegram', true);
            $blog_share_pinterest  = seedone_option('blog_share_pinterest', true);
            $blog_share_linkedin  = seedone_option('blog_share_linkedin', true);
        }

        if (!$blog_share_facebook) {
            unset($share_buttons['share_facebook']);
        }
        if (!$blog_share_twitter) {
            unset($share_buttons['share_twitter']);
        }
        if (!$blog_share_telegram) {
            unset($share_buttons['share_telegram']);
        }
        if (!$blog_share_pinterest) {
            unset($share_buttons['share_pinterest']);
        }
        if (!$blog_share_linkedin) {
            unset($share_buttons['share_linkedin']);
        }


        if (!empty($share_buttons)) :
            $id = uniqid();
?>
            <div class="share_buttons">
                <div class="dropdown">
                    <label for="<?php echo esc_attr($id) ?>"><?php seedone_icon('vector'); ?></label>
                    <input type="checkbox" id="<?php echo esc_attr($id) ?>">
                    <ul class="dropdown-list">
                        <?php
                        foreach ($share_buttons as $share_button) :
                            echo '<li>';
                            echo wp_kses_post($share_button);
                            echo '</li>';
                        endforeach;
                        ?>
                    </ul>
                </div>
            </div><!-- eof .share_buttons -->
<?php
        endif; // share_buttons
    } //seedone_share_this()
endif; //function_exists