<?php

namespace MasterAddons\Modules\DynamicTags\Tags;

use Elementor\Core\DynamicTags\Tag;
use Elementor\Modules\DynamicTags\Module as TagsModule;

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

class JLTMA_Author_Meta extends Tag
{

	public function get_name()
	{
		return 'jltma-author-meta';
	}

	public function get_title()
	{
		return esc_html__('MA Author Meta', 'master-addons' );
	}

	public function get_group()
	{
		return 'author';
	}

	public function get_categories()
	{
		return [TagsModule::TEXT_CATEGORY];
	}

	public function get_panel_template_setting_key()
	{
		return 'key';
	}

	public function render()
	{
		$key = $this->get_settings('key');
		if (empty($key)) {
			return;
		}

		$value = get_the_author_meta($key);

		echo wp_kses_post($value);
	}

	protected function register_controls()
	{
		$this->add_control(
			'key',
			[
				'label' => esc_html__('Meta Key', 'master-addons' ),
			]
		);
	}
}
