import { MoveableManagerInterface, ClippableProps, ControlPose } from "../../types";
export declare const CLIP_DIRECTIONS: readonly [readonly [0, -1, "n"], readonly [1, 0, "e"]];
export declare const CLIP_RECT_DIRECTIONS: readonly [readonly [-1, -1, "nw"], readonly [0, -1, "n"], readonly [1, -1, "ne"], readonly [1, 0, "e"], readonly [1, 1, "se"], readonly [0, 1, "s"], readonly [-1, 1, "sw"], readonly [-1, 0, "w"]];
export declare function getClipStyles(moveable: MoveableManagerInterface<ClippableProps>, clipPath: ReturnType<typeof getClipPath>, poses: number[][]): string[] | undefined;
export declare function getRectPoses(top: number, right: number, bottom: number, left: number): ControlPose[];
export declare function getControlSize(controlPoses: ControlPose[]): number[];
export declare function getClipPath(target: HTMLElement | SVGElement | undefined | null, width: number, height: number, defaultClip?: string, customClip?: string): {
    readonly type: "polygon";
    readonly clipText: string;
    readonly poses: ControlPose[];
    readonly splitter: string;
    readonly left: number;
    readonly right: number;
    readonly top: number;
    readonly bottom: number;
    readonly radiusX?: undefined;
    readonly radiusY?: undefined;
    readonly radius?: undefined;
    readonly values?: undefined;
} | {
    readonly type: "circle" | "ellipse";
    readonly clipText: string;
    readonly radiusX: number;
    readonly radiusY: number;
    readonly left: number;
    readonly top: number;
    readonly right: number;
    readonly bottom: number;
    readonly poses: ControlPose[];
    readonly splitter: string;
    readonly radius?: undefined;
    readonly values?: undefined;
} | {
    readonly type: "inset";
    readonly clipText: string;
    readonly poses: ControlPose[];
    readonly top: number;
    readonly left: number;
    readonly right: number;
    readonly bottom: number;
    readonly radius: string[];
    readonly splitter: string;
    readonly radiusX?: undefined;
    readonly radiusY?: undefined;
    readonly values?: undefined;
} | {
    readonly type: "rect";
    readonly clipText: string;
    readonly poses: ControlPose[];
    readonly top: number;
    readonly right: number;
    readonly bottom: number;
    readonly left: number;
    readonly values: string[];
    readonly splitter: string;
    readonly radiusX?: undefined;
    readonly radiusY?: undefined;
    readonly radius?: undefined;
} | undefined;
