"use client";
import {
  createHovercardStore
} from "../__chunks/JTLIIJ4U.js";
import "../__chunks/ME2CUF3F.js";
import "../__chunks/FZZ2AVHF.js";
import "../__chunks/RCQ5P4YE.js";
import {
  createStore
} from "../__chunks/BCALMBPZ.js";
import {
  defaultValue
} from "../__chunks/PBFD2E7P.js";
import {
  __spreadProps,
  __spreadValues
} from "../__chunks/3YLGPPWQ.js";

// src/tooltip/tooltip-store.ts
function createTooltipStore(props = {}) {
  var _a;
  if (process.env.NODE_ENV !== "production") {
    if (props.type === "label") {
      console.warn(
        "The `type` option on the tooltip store is deprecated.",
        "Render a visually hidden label or use the `aria-label` or `aria-labelledby` attributes on the anchor element instead.",
        "See https://ariakit.org/components/tooltip#tooltip-anchors-must-have-accessible-names"
      );
    }
  }
  const syncState = (_a = props.store) == null ? void 0 : _a.getState();
  const hovercard = createHovercardStore(__spreadProps(__spreadValues({}, props), {
    placement: defaultValue(
      props.placement,
      syncState == null ? void 0 : syncState.placement,
      "top"
    ),
    hideTimeout: defaultValue(props.hideTimeout, syncState == null ? void 0 : syncState.hideTimeout, 0)
  }));
  const initialState = __spreadProps(__spreadValues({}, hovercard.getState()), {
    type: defaultValue(props.type, syncState == null ? void 0 : syncState.type, "description"),
    skipTimeout: defaultValue(props.skipTimeout, syncState == null ? void 0 : syncState.skipTimeout, 300)
  });
  const tooltip = createStore(initialState, hovercard, props.store);
  return __spreadValues(__spreadValues({}, hovercard), tooltip);
}
export {
  createTooltipStore
};
