<?php

/**
 * The title section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$seedone_show_title       = seedone_option('title_show_title', '');
$seedone_show_breadcrumbs = seedone_breadcrumbs_enabled();
$seedone_show_search      = seedone_option('title_show_search', '');

$seedone_title_background     = seedone_option('title_background', '');
$seedone_extra_padding_top    = seedone_option('title_extra_padding_top', '');
$seedone_extra_padding_bottom = seedone_option('title_extra_padding_bottom', '');
$seedone_border_top           = seedone_option('title_border_top', '');
$seedone_border_bottom        = seedone_option('title_border_bottom', '');
$seedone_font_size            = seedone_option('title_font_size', '');
$seedone_background_image     = seedone_section_background_image_array('title');

?>
<section id="title" class="title title-1 <?php echo esc_attr($seedone_title_background . ' ' . $seedone_font_size . ' ' . $seedone_background_image['class']); ?>" <?php echo (!empty($seedone_background_image['url'])) ? 'style="background-image: url(' . esc_url($seedone_background_image['url']) . ');"' : ''; ?>>
	<?php
	if ('full' === $seedone_border_top) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
	<div class="container <?php echo esc_attr($seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
		<?php
		if ('container' === $seedone_border_top) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		if (!empty($seedone_show_title)) {
		?>
			<h1 itemprop="headline"><?php get_template_part('template-parts/title/title-text'); ?></h1>
		<?php
		} //show_title
		if (!empty($seedone_show_breadcrumbs)) {
			seedone_breadcrumbs();
		}
		if (!empty($seedone_show_search)) {
			get_search_form();
		}
		if ('container' === $seedone_border_bottom) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>
	</div><!-- .container -->
	<?php
	if ('full' === $seedone_border_bottom) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
</section><!-- #title -->