<?php
/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
//meta
$seedone_meta = seedone_get_theme_meta();

$seedone_fluid = seedone_option('topline_fluid') ? '-fluid' : '';
$seedone_topline_background = seedone_option('topline_background', '');
$seedone_font_size = seedone_option('topline_font_size', '');
?>
<div id="topline" class="topline <?php echo esc_attr($seedone_topline_background . ' ' . $seedone_font_size); ?>">
    <div class="container<?php echo esc_attr($seedone_fluid); ?>">
        <?php if (!empty($seedone_meta)) : ?>
            <div id="topline_dropdown" class="dropdown">
                <button id="topline_dropdown_toggle" class="nav-btn type-dots"
                        aria-controls="topline_dropdown"
                        aria-expanded="false"
                        aria-label="<?php esc_attr_e('Topline Info Toggler', 'seedone'); ?>"
                >
                    <span></span>
                </button>

                <span class="dropdown-menu dropdown-menu-md site-meta">
                <?php if (!empty($seedone_meta['address'])) :
                    ?>
                    <span class="icon-inline">
					<?php seedone_icon('map-marker-outline'); ?>
						<span>
							<?php if (!empty($seedone_meta['address_label'])) : ?>
                                <strong><?php echo wp_kses_post($seedone_meta['address_label']); ?></strong>
                            <?php endif; ?>
							<span><?php echo wp_kses_post($seedone_meta['address']); ?></span>
						</span>
					</span>
                <?php
                endif; //address
                if (!empty($seedone_meta['email'])) :
                    ?>
                    <span class="icon-inline">
					<?php seedone_icon('email-outline'); ?>
						<span>
							<?php if (!empty($seedone_meta['email_label'])) : ?>
                                <strong><?php echo wp_kses_post($seedone_meta['email_label']); ?></strong>
                            <?php endif; ?>
							<a href="mailto:<?php echo esc_attr($seedone_meta['email']); ?>"><?php echo wp_kses_post($seedone_meta['email']); ?></a>
						</span>
					</span>
                <?php
                endif; //email
                if (!empty($seedone_meta['phone'])) : ?>
                    <span class="icon-inline">
					<?php seedone_icon('phone-outline'); ?>
						<span>
							<?php if (!empty($seedone_meta['phone_label'])) : ?>
                                <strong><?php echo wp_kses_post($seedone_meta['phone_label']); ?></strong>
                            <?php endif; ?>
							<span><?php echo wp_kses_post($seedone_meta['phone']); ?></span>
						</span>
					</span>
                <?php
                endif; //phone
                if (!empty($seedone_meta['opening_hours'])) :
                    ?>
                    <span class="icon-inline">
					<?php seedone_icon('clock-outline'); ?>
						<span>
							<?php if (!empty($seedone_meta['opening_hours_label'])) : ?>
                                <strong><?php echo wp_kses_post($seedone_meta['opening_hours_label']); ?></strong>
                            <?php endif; ?>
							<span><?php echo wp_kses_post($seedone_meta['opening_hours']); ?></span>
						</span>
					</span>
                <?php endif; //opening_hours ?>
				</span><!-- .site-meta -->
            </div><!-- #topline_dropdown -->
        <?php

        endif; //! empty meta?>
        <div class="header-login">
            <button class="hidden-xs"
                    id="login_toggle"
                    aria-controls="login_dropdown"
                    aria-expanded="false"
                    aria-label="<?php esc_attr_e( 'login', 'seedone' ); ?>"
            >
                <?php
                seedone_icon( 'log-in' );
                echo esc_html__('Log in', 'seedone')
                ?>
            </button>
        </div><!-- .header-search -->
        <?php if ( class_exists('YITH_WCWL') && is_user_logged_in() ) : ?>
        <span class="pr-2 px-xl-3">
            <i class="fa fa-heart-o pr-05"></i>
            <a href="<?php echo esc_url( home_url('/wishlist/view/') ); ?>"><?php echo esc_html__('Wishlist', 'seedone') ?></a>
        </span>
        <?php endif;

        seedone_social_links();

        ?>
    </div><!-- .container -->
</div><!-- #topline -->
