<?php

/**
 * The slider wrap template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.2
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
//TODO move style to separate CSS file!

//watermark
$seedone_watermark = seedone_option('slider_watermark_image', '');

$args = !empty($args) ? $args : array();
$slide_number = !empty($args['slide_number']) ? $args['slide_number'] : '1';

$image         = seedone_option('slide_' . $slide_number . '_image');
$pre_heading   = seedone_option('slide_' . $slide_number . '_pre_heading');
$heading       = seedone_option('slide_' . $slide_number . '_heading');
$description   = seedone_option('slide_' . $slide_number . '_description');
$button_1_text = seedone_option('slide_' . $slide_number . '_button_1_text');
$button_2_text = seedone_option('slide_' . $slide_number . '_button_2_text');

if (
	$image
	||
	$pre_heading
	||
	$heading
	||
	$description
	||
	$button_1_text
	||
	$button_2_text
) :
?>
	<div class="page_slider intro_slider">
		<div class="flexslider">
			<ul class="slides">
				<?php
				get_template_part('template-parts/header/slider/slide', '', array('slide_number' => '1'));
				get_template_part('template-parts/header/slider/slide', '', array('slide_number' => '2'));
				get_template_part('template-parts/header/slider/slide', '', array('slide_number' => '3'));
				?>
			</ul>
			<?php if (!empty($seedone_watermark)) { ?>
				<div class="round-text">
					<img src="<?php echo esc_url($seedone_watermark); ?>" alt="<?php esc_attr_e('Circular text', 'seedone'); ?>">
				</div>
			<?php } ?>
		</div><!-- .flexslider -->

	</div>
	<!--. page_slider -->
<?php endif; ?>