<?php

/**
 * The slide template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.2
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
$args = !empty($args) ? $args : array();
$slide_number = !empty($args['slide_number']) ? $args['slide_number'] : '1';

$image         = seedone_option('slide_' . $slide_number . '_image');
$pre_heading   = seedone_option('slide_' . $slide_number . '_pre_heading');
$heading       = seedone_option('slide_' . $slide_number . '_heading');
$description   = seedone_option('slide_' . $slide_number . '_description');
$button_1_text = seedone_option('slide_' . $slide_number . '_button_1_text');
$button_1_url  = seedone_option('slide_' . $slide_number . '_button_1_url');
$button_2_text = seedone_option('slide_' . $slide_number . '_button_2_text');
$button_2_url  = seedone_option('slide_' . $slide_number . '_button_2_url');
$align         = seedone_option('slide_' . $slide_number . '_align');

$slider_custom_class = seedone_option('slider_custom_class');
$slide_custom_class = seedone_option('slide_' . $slide_number . '_custom_class');

if (
	$image
	||
	$pre_heading
	||
	$heading
	||
	$description
	||
	$button_1_text
	||
	$button_2_text
) :
?>
	<li class="slide-number-<?php echo esc_attr($slide_number) . ' ' . esc_html($slider_custom_class) . ' ' . esc_html($slide_custom_class) ?>">
		<?php

		if ($image) {
			echo '<img src="' . esc_url($image) . '" alt="' . esc_attr($heading) . '">';
		}
		if (
			$pre_heading
			||
			$heading
			||
			$description
			||
			$button_1_text
			||
			$button_2_text
		) :
			echo '<div class="container slider-content intro_layers ' . esc_attr($align) . '">';
			if ($pre_heading) {
				echo '<h4 class="slide-pre-heading">' . wp_kses_post($pre_heading) .
					'<span class="slide-pre-heading-duplicate d-none">' . wp_kses_post($pre_heading) . '</span></h4>';
			}

			if ($heading) {
				echo '<h2 class="slide-heading">' . wp_kses_post($heading) .
					'<span class="slide-heading-duplicate d-none">' . wp_kses_post($pre_heading) . '</span></h2>';
			}

			if ($description) {
				echo '<div class="slide-description">' . wp_kses_post($description) . '</div>';
			}

			if ($button_1_text || $button_2_text) {
				echo '<div class="slider-buttons-wrap">';
				if ($button_1_text) {
					echo '<a class="button wp-block-button__link" href="' . esc_url($button_1_url) . '">' . esc_html($button_1_text) . '</a> ';
				}
				if ($button_2_text) {
					echo ' <a class="button wp-block-button__link" href="' . esc_url($button_2_url) . '">' . esc_html($button_2_text) . '</a>';
				}
				echo '</div>';
			}

			echo '</div><!-- .slider-content -->';
		endif;

		?>
	</li>
<?php endif;
