<?php

/**
 * The intro section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$seedone_intro_layout      = seedone_option('intro_layout', '');
$seedone_intro_fullscreen  = seedone_option('intro_fullscreen', '');
$seedone_intro_heading     = seedone_option('intro_heading', '');
$seedone_intro_description = seedone_option('intro_description', '');
$seedone_intro_shortcode   = seedone_option('intro_shortcode', '');

$seedone_extra_padding_top    = seedone_option('intro_extra_padding_top', '');
$seedone_extra_padding_bottom = seedone_option('intro_extra_padding_bottom', '');
$seedone_intro_background     = seedone_option('intro_background', '');
$seedone_intro_alignment      = seedone_option('intro_alignment', '');
$seedone_font_size            = seedone_option('intro_font_size', '');
$seedone_background_image     = seedone_section_background_image_array('intro');

$seedone_intro_background_image_scale_class = seedone_option('intro_background_image_scale', '') ? 'image-scale' : '';

//buttons
$seedone_intro_button_text_first  = seedone_option('intro_button_text_first', '');
$seedone_intro_button_url_first   = seedone_option('intro_button_url_first', '');
$seedone_intro_button_text_second = seedone_option('intro_button_text_second', '');
$seedone_intro_button_url_second  = seedone_option('intro_button_url_second', '');

//animation
$seedone_intro_image_animation = seedone_option('intro_image_animation', '') ? 'animate an__' . seedone_option('intro_image_animation') : '';

//watermark
$seedone_watermark = seedone_option('title_watermark_image', '');

$intro_custom_class = seedone_option('intro_custom_class', '');
//not showing intro if no content specified
if (
	empty($seedone_intro_heading)
	&&
	empty($seedone_intro_description)
	&&
	empty($seedone_intro_shortcode)
	&&
	empty($seedone_intro_button_text_first)
	&&
	empty($seedone_intro_button_text_second)
	&&
	empty($seedone_background_image['url'])
) {
	return;
}
//if fullscreen - adding class to font size
if (!empty($seedone_intro_fullscreen)) {
	$seedone_font_size .= ' screen';
}

//default layout is background image
switch ($seedone_intro_layout):
		//side image layout
	case 'image-left':
	case 'image-right':
?>
		<section id="intro" class="intro intro-section layout-gap-30 <?php echo esc_attr($intro_custom_class . ' ' . $seedone_font_size . ' ' . $seedone_intro_background . ' ' . $seedone_intro_alignment . ' ' . $seedone_intro_layout . ' ' . $seedone_intro_background_image_scale_class); ?>">
			<?php
			if (seedone_option('intro_social_links')) {
				seedone_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
				<div class="d-grid grid-2-cols">
					<div class="column">
						<?php if (!empty($seedone_background_image['url'])) : ?>
							<div class="img-wrap">
								<img src="<?php echo esc_url($seedone_background_image['url']); ?>" alt="<?php echo esc_attr($seedone_intro_heading); ?>" class="intro-image <?php echo esc_attr($seedone_intro_image_animation); ?>">
							</div>
						<?php endif; ?>
					</div>
					<div class="column intro-section-text">
						<?php
						get_template_part('template-parts/header/intro-text');
						?>
					</div><!-- .column -->
				</div><!-- .d-grid -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;

	case 'image-top':
	?>
		<section id="intro" class="intro intro-section <?php echo esc_attr($intro_custom_class . ' ' . $seedone_font_size . ' ' . $seedone_intro_background . ' ' . $seedone_intro_alignment . ' ' . $seedone_intro_layout); ?>">
			<?php
			if (seedone_option('intro_social_links')) {
				seedone_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
				<div class="column">
					<?php if (!empty($seedone_background_image['url'])) : ?>
						<img src="<?php echo esc_url($seedone_background_image['url']); ?>" alt="<?php echo esc_attr($seedone_intro_heading); ?>" class="intro-image <?php echo esc_attr($seedone_intro_image_animation); ?>">
					<?php endif; ?>
				</div>
				<div class="column intro-section-text">
					<?php
					get_template_part('template-parts/header/intro-text');
					?>
				</div><!-- .column -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;
	case 'image-bottom':
	?>
		<section id="intro" class="intro intro-section <?php echo esc_attr($intro_custom_class . ' ' . $seedone_font_size . ' ' . $seedone_intro_background . ' ' . $seedone_intro_alignment . ' ' . $seedone_intro_layout); ?>">
			<?php
			if (seedone_option('intro_social_links')) {
				seedone_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
				<div class="column intro-section-text">
					<?php
					get_template_part('template-parts/header/intro-text');
					?>
				</div><!-- .column -->
				<div class="column">
					<?php if (!empty($seedone_background_image['url'])) : ?>
						<img src="<?php echo esc_url($seedone_background_image['url']); ?>" alt="<?php echo esc_attr($seedone_intro_heading); ?>" class="intro-image <?php echo esc_attr($seedone_intro_image_animation); ?>">
					<?php endif; ?>
				</div><!-- .column -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;
		//background image
	default:
	?>
		<section id="intro" class="intro section-intro <?php echo esc_attr($intro_custom_class . ' ' . $seedone_font_size . ' ' . $seedone_intro_background . ' ' . $seedone_intro_alignment . ' ' . $seedone_background_image['class']); ?>" <?php echo (!empty($seedone_background_image['url'])) ? 'style="background-image: url(' . esc_url($seedone_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (seedone_option('intro_social_links')) {
				seedone_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
				<?php
				get_template_part('template-parts/header/intro-text');
				?>
			</div><!-- .container -->
			<?php if (!empty($seedone_watermark)) { ?>
				<div class="round-text">
					<img src="<?php echo esc_url($seedone_watermark); ?>" alt="<?php esc_attr_e('Circular text', 'seedone'); ?>">
				</div>
			<?php } ?>
		</section><!-- #intro -->
<?php
endswitch;//$seedone_intro_layout
