<?php

/**
 * The intro section text template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//text
$seedone_intro_pre_heading = seedone_option('intro_pre_heading', '');
$seedone_intro_heading     = seedone_option('intro_heading', '');
$seedone_intro_description = seedone_option('intro_description', '');
$seedone_intro_shortcode   = seedone_option('intro_shortcode', '');

//buttons
$seedone_intro_button_text_first  = seedone_option('intro_button_text_first', '');
$seedone_intro_button_url_first   = seedone_option('intro_button_url_first', '');
$seedone_intro_button_text_second = seedone_option('intro_button_text_second', '');
$seedone_intro_button_url_second  = seedone_option('intro_button_url_second', '');

//animation
//animate an__XXX
//intro_heading_animation
//intro_description_animation
//intro_button_first_animation
//intro_button_second_animation
//intro_shortcode_animation
$seedone_intro_pre_heading_animation   = seedone_option('intro_pre_heading_animation', '') ? 'animate an__' . seedone_option('intro_pre_heading_animation') : '';
$seedone_intro_heading_animation       = seedone_option('intro_heading_animation', '') ? 'animate an__' . seedone_option('intro_heading_animation') : '';
$seedone_intro_description_animation   = seedone_option('intro_description_animation', '') ? 'animate an__' . seedone_option('intro_description_animation') : '';
$seedone_intro_button_first_animation  = seedone_option('intro_button_first_animation', '') ? 'animate an__' . seedone_option('intro_button_first_animation') : '';
$seedone_intro_button_second_animation = seedone_option('intro_button_second_animation', '') ? 'animate an__' . seedone_option('intro_button_second_animation') : '';
$seedone_intro_shortcode_animation     = seedone_option('intro_shortcode_animation', '') ? 'animate an__' . seedone_option('intro_shortcode_animation') : '';


//not showing intro if no content specified
if (
	empty($seedone_intro_pre_heading)
	&&
	empty($seedone_intro_heading)
	&&
	empty($seedone_intro_description)
	&&
	empty($seedone_intro_shortcode)
	&&
	empty($seedone_intro_button_text_first)
	&&
	empty($seedone_intro_button_text_second)
) {
	return;
}

if (seedone_option('intro_social_links')) {
	seedone_social_links('intro-social-links');
}

if (!empty($seedone_intro_pre_heading)) :
	$seedone_intro_pre_heading_mt = seedone_option('intro_pre_heading_mt', '');
	$seedone_intro_pre_heading_mb = seedone_option('intro_pre_heading_mb', '');
	$seedone_intro_pre_heading_custom_class = seedone_option('intro_pre_heading_custom_class', '');
?>
	<h2 class="intro-pre-heading <?php echo esc_attr($seedone_intro_pre_heading_custom_class . ' ' . $seedone_intro_pre_heading_animation . ' ' . $seedone_intro_pre_heading_mt . ' ' . $seedone_intro_pre_heading_mb); ?>">
		<?php echo wp_kses_post($seedone_intro_pre_heading); ?>
		<span class="intro-pre-heading-duplicate d-none">
			<?php echo wp_kses_post($seedone_intro_pre_heading); ?>
		</span>
	</h2>
<?php
endif; //intro_heading

if (!empty($seedone_intro_heading)) :
	$seedone_intro_heading_mt = seedone_option('intro_heading_mt', '');
	$seedone_intro_heading_mb = seedone_option('intro_heading_mb', '');
?>
	<h1 class="intro-heading <?php echo esc_attr($seedone_intro_heading_animation . ' ' . $seedone_intro_heading_mt . ' ' . $seedone_intro_heading_mb); ?>">
		<?php echo wp_kses_post($seedone_intro_heading); ?>
		<span class="intro-heading-duplicate d-none">
			<?php echo wp_kses_post($seedone_intro_heading); ?>
		</span>
	</h1>

<?php
endif; //intro_heading

if (!empty($seedone_intro_description)) :
	$seedone_intro_description_mt = seedone_option('intro_description_mt', '');
	$seedone_intro_description_mb = seedone_option('intro_description_mb', '');
?>
	<div class="intro-description <?php echo esc_attr($seedone_intro_description_animation . ' ' . $seedone_intro_description_mt . ' ' . $seedone_intro_description_mb); ?>">
		<?php echo wp_kses_post($seedone_intro_description); ?>
	</div>
<?php
endif; //intro_description

if (!empty($seedone_intro_button_text_first) || !empty($seedone_intro_button_text_second)) :
	$seedone_intro_buttons_mt = seedone_option('intro_buttons_mt', '');
	$seedone_intro_buttons_mb = seedone_option('intro_buttons_mb', '');
?>
	<div class="intro-buttons <?php echo esc_attr($seedone_intro_buttons_mt . ' ' . $seedone_intro_buttons_mb); ?>">
		<?php if (!empty($seedone_intro_button_text_first)) : ?>
			<a class="button wp-block-button__link <?php echo esc_attr($seedone_intro_button_first_animation); ?>" href="<?php echo esc_url($seedone_intro_button_url_first); ?>"><?php echo esc_html($seedone_intro_button_text_first); ?></a>
		<?php endif; //intro_button_text_first 
		?>
		<?php if (!empty($seedone_intro_button_text_second)) : ?>
			<a class="button wp-block-button__link <?php echo esc_attr($seedone_intro_button_second_animation); ?>" href="<?php echo esc_url($seedone_intro_button_url_second); ?>"><?php echo esc_html($seedone_intro_button_text_second); ?></a>
		<?php endif; //intro_button_text_second 
		?>
	</div>
<?php
endif; //intro_heading
if (!empty($seedone_intro_shortcode)) :
	$seedone_intro_shortcode_mt = seedone_option('intro_shortcode_mt', '');
	$seedone_intro_shortcode_mb = seedone_option('intro_shortcode_mb', '');
?>
	<div class="intro-shortcode <?php echo esc_attr($seedone_intro_shortcode_animation . ' ' . $seedone_intro_shortcode_mt . ' ' . $seedone_intro_shortcode_mb); ?>">
		<?php echo do_shortcode($seedone_intro_shortcode); ?>
	</div>
<?php
endif; //intro_shortcode
