<?php

/**
 * The header top template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//wrapper for topline, header and title
echo '<div id="top-wrap">';

$seedone_intro_position = seedone_option('intro_position', '');
//intro section on front page after header
if (seedone_is_front_page() && 'before' === $seedone_intro_position) :

	get_template_part('template-parts/header/intro');

endif;

$seedone_header_image_url = get_header_image();
if (!empty($seedone_header_image_url)) :
	$seedone_background_image = seedone_section_background_image_array('header_image', true);
?>
	<div id="header-image" class="i <?php echo esc_attr($seedone_background_image['class']); ?>" style="background-image: url('<?php echo esc_url($seedone_background_image['url']); ?> ');">
	<?php
endif; //header_image_url

$seedone_header_absolute = seedone_option('header_absolute', '');
if (!empty($seedone_header_absolute)) :
	?>
		<div class="header-absolute-wrap">
			<div class="header-absolute-content">
			<?php
		endif; //$seedone_header_absolute

		//topline header section
		get_template_part('template-parts/header/topline/topline', seedone_template_part('topline', ''));
		//header section
		get_template_part('template-parts/header/header', seedone_template_part('header', '1'));

		if (!empty($seedone_header_absolute)) :
			?>
			</div><!-- .header-absolute-content -->
			<?php
			//title section not on front page
			if (seedone_is_title_section_is_shown()) :
				get_template_part('template-parts/title/title', seedone_template_part('title', '1'));
			//front page text
			else :
				//TODO homepage fullwidth image
				$seedone_display_header_text = display_header_text();
				if (!empty($seedone_display_header_text)) :
			?>
					<h1 class="site-title">
						<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
							<?php echo wp_kses_post(get_bloginfo('name', 'display')); ?>
						</a>
					</h1>
					<?php
					$seedone_description = get_bloginfo('description', 'display');

					if ($seedone_description || is_customize_preview()) :
					?>
						<p class="site-description"><?php echo wp_kses_post($seedone_description); ?></p>
			<?php
					endif; //description
				endif; //display_header_text
			endif; //seedone_is_front_page
			?>
		</div><!-- .header-absolute-wrap -->
		<?php
		else :
			//title section not on front page
			if (seedone_is_title_section_is_shown() || is_404()) :
				get_template_part('template-parts/title/title', seedone_template_part('title', '1'));
			//front page text
			else :
				//TODO homepage fullwidth image
				$seedone_display_header_text = display_header_text();
				if (!empty($seedone_display_header_text)) :
		?>
				<h1 class="site-title">
					<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
						<?php echo wp_kses_post(get_bloginfo('name', 'display')); ?>
					</a>
				</h1>
				<?php
					$seedone_description = get_bloginfo('description', 'display');

					if ($seedone_description || is_customize_preview()) :
				?>
					<p class="site-description"><?php echo wp_kses_post($seedone_description); ?></p>
		<?php
					endif; //description
				endif; //display_header_text
			endif; //seedone_is_front_page
		endif; //$seedone_header_absolute

		/**
		 * Fires after the header.
		 *
		 * @since WBPlank 0.0.1
		 */
		do_action('seedone_action_after_header');

		//intro section on front page after header
		if (seedone_is_front_page() && 'after' === $seedone_intro_position) :
			get_template_part('template-parts/header/intro');
		endif;

		//homepage slider
		if (seedone_is_front_page()) {
			get_template_part('template-parts/header/slider/slider');
		}

		if (!empty($seedone_header_image_url)) :
		?>
	</div>
	<!--#header-image-->
<?php
		endif; //$seedone_header_image_url

		echo '</div><!--#top-wrap-->';
