<?php
/**
 * The header search template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$seedone_search = seedone_option( 'header_search', '' );

if ( empty( $seedone_search ) ) {
	return;
}

switch ( $seedone_search ) :
	case 'button':
		?>
		<div class="header-search">
			<button id="search_toggle"
					aria-controls="search_dropdown"
					aria-expanded="false"
					aria-label="<?php esc_attr_e( 'Search Dropdown Toggler', 'seedone' ); ?>"
			>
				<?php
				seedone_icon( 'magnify' );
				?>
			</button>
		</div><!-- .header-search -->
		<?php
		break;

	//form
	default:
		?>
		<div class="header-search">
			<?php get_search_form(); ?>
		</div><!-- .header-search -->
		<?php
endswitch;
