<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
//options
$seedone_fluid             = seedone_option('header_fluid') ? '-fluid' : '';
$seedone_transparent       = seedone_option('header_transparent') ? 'transparent' : '';
$seedone_absolute          = seedone_option('header_absolute') ? 'absolute' : '';
$seedone_header_top_tall   = seedone_option('header_top_tall') ? 'header-tall' : '';
$seedone_sticky            = seedone_option('header_sticky');
$seedone_search            = seedone_option('header_search');
$seedone_button_url        = seedone_option('header_button_url');
$seedone_button_text       = seedone_option('header_button_text');
$seedone_header_background = seedone_option('header_background', '');
$seedone_font_size         = seedone_option('header_font_size', '');

$seedone_border_top    = seedone_option('header_border_top', '');
$seedone_border_bottom = seedone_option('header_border_bottom', '');

//meta
$seedone_phone = seedone_option('meta_phone');
$seedone_email = seedone_option('meta_email');
$seedone_hours = seedone_option('meta_opening_hours');

$seedone_toggler_side_in_header = seedone_option('header_toggler_menu_side', true);
$seedone_toggler_main_in_header = seedone_option('header_toggler_menu_main', true);

$seedone_header_align_main_menu = seedone_option('header_align_main_menu', '');
$seedone_header_has_menu_class  = has_nav_menu('primary') ? 'has-menu' : 'no-menu';

if (!empty($seedone_sticky)) :
?>
	<div id="header-affix-wrap" class="header-wrap <?php echo esc_attr($seedone_header_background . ' ' . $seedone_transparent . ' ' . $seedone_absolute); ?>">
	<?php endif; //$seedone_sticky 
	?>
	<header id="header" class="header header-1 <?php echo esc_attr($seedone_header_background . ' ' . $seedone_font_size . ' ' . $seedone_header_align_main_menu . ' ' . $seedone_sticky . ' ' . $seedone_transparent . ' ' . $seedone_absolute . ' ' . $seedone_header_top_tall . ' ' . $seedone_header_has_menu_class); ?>">
		<?php
		if ('full' === $seedone_border_top) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>
		<?php
		if ('container' === $seedone_border_top) {
			echo wp_kses_post('<hr class="section-hr container">');
		}
		?>
		<div class="container<?php echo esc_attr($seedone_fluid); ?>">
			<?php if (!empty($seedone_toggler_side_in_header) && (has_nav_menu('side') || is_active_sidebar('sidebar-side'))) : ?>
				<button id="nav_side_toggle" class="nav-btn" aria-controls="nav_side" aria-expanded="false" aria-label="<?php esc_attr_e('Side Menu Toggler', 'seedone'); ?>">
					<span></span>
				</button>
			<?php
			endif; //toggler_side_in_header

			get_template_part('template-parts/header/logo/logo', seedone_template_part('logo', '1'));

			?>
			<div id="overlay"></div>
			<?php
			if (has_nav_menu('primary')) :
			?>
				<nav id="nav_top" class="top-nav" aria-label="<?php esc_attr_e('Top Menu', 'seedone'); ?>">
					<?php
					if (has_nav_menu('primary')) :
						$seedone_menu_css_class = seedone_get_menu_class_based_on_top_items_count('primary');
						wp_nav_menu(
							array(
								'theme_location' => 'primary',
								'menu_class'     => 'top-menu ' . $seedone_menu_css_class,
								'container'      => false,
							)
						);
					endif; //has_nav_menu
					if (empty($seedone_toggler_main_in_header)) :
					?>
						<button id="nav_toggle" class="nav-btn" aria-controls="nav_top" aria-expanded="false" aria-label="<?php esc_attr_e('Top Menu Toggler', 'seedone'); ?>">
							<span></span>
						</button>
					<?php
					//echo closing button if main button is inside header section
					else :
					?>
						<button id="nav_close" class="nav-btn" aria-controls="nav_top" aria-expanded="true" aria-label="<?php esc_attr_e('Top Menu Close', 'seedone'); ?>">
							<span></span>
						</button>
					<?php endif; //toggler_main_in_header 
					?>
				</nav><!-- .top-nav -->
			<?php
			endif; //has_nav_menu 
			?>
			<div class="meta-wrap">
				<?php
				if (!empty($seedone_phone)) :
					echo '<div class="header-meta">';
					if (!empty($seedone_phone)) :
				?>
						<span class="icon-inline">
							<?php seedone_icon('phone-outline'); ?>
							<span><?php echo wp_kses_post($seedone_phone); ?></span>
						</span>
					<?php
					endif;
					echo '</div><!--.header-meta-->';
				endif; //meta_phone
				if ('button' === $seedone_search) : ?>
					<div class="search-social-wrap d-flex">
					<?php else : ?>
						<div class="search-social-wrap flex-column">
						<?php
					endif; //button
					if (!empty($seedone_search)) :
						get_template_part('template-parts/header/header-search');
					endif;
						?>
						</div>
						<?php
						if (class_exists('WooCommerce')) :
							get_template_part('template-parts/header/cart-dropdown');
						endif; //woocommerce
						?>
					</div><!-- .meta-wrap -->
					<?php
					if (!empty($seedone_toggler_main_in_header) && has_nav_menu('primary')) :
					?>
						<button id="nav_toggle" class="nav-btn" aria-controls="nav_top" aria-expanded="false" aria-label="<?php esc_attr_e('Top Menu Toggler', 'seedone'); ?>">
							<span></span>
						</button>
					<?php endif; //toggler_main_in_header 
					?>

			</div><!-- .container -->
			<?php
			if ('container' === $seedone_border_bottom) {
				echo wp_kses_post('<hr class="section-hr container">');
			}
			if ('full' === $seedone_border_bottom) {
				echo wp_kses_post('<hr class="section-hr">');
			}
			?>
	</header><!-- #header -->
	<?php if (!empty($seedone_sticky)) : ?>
	</div>
	<!--#header-affix-wrap-->
<?php endif; //$seedone_sticky 
?>