<?php

/**
 * The copyright section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$seedone_fluid = seedone_option('copyright_fluid') ? '-fluid' : '';

$seedone_text = seedone_option('copyright_text', '');
if (empty($seedone_text)) {
	$seedone_text = get_bloginfo('name', 'display');
}

$seedone_copyright_background = seedone_option('copyright_background', '');
$seedone_extra_padding_top    = seedone_option('copyright_extra_padding_top');
$seedone_extra_padding_bottom = seedone_option('copyright_extra_padding_bottom');
$seedone_font_size            = seedone_option('copyright_font_size', '');

$seedone_background_image = seedone_section_background_image_array('copyright');

$seedone_background_image_copyright = (!empty(seedone_option('404_background_image_copyright'))) ? true : false;
$seedone_404_background_image     = seedone_option('404_background_image', '');
?>
<?php
if (!empty($seedone_background_image_copyright) && is_404()) : ?>
	<div id="copyright" class="copyright copyright-1 copyright-404 background-cover cover-center background-fixed <?php echo esc_attr($seedone_copyright_background . ' ' . $seedone_font_size); ?>" <?php echo (!empty($seedone_404_background_image)) ? 'style="background-image: url(' . esc_url($seedone_404_background_image) . ');"' : ''; ?>>
	<?php
else :
	?>
		<div id="copyright" class="copyright <?php echo esc_attr($seedone_copyright_background . ' ' . $seedone_font_size . ' ' . $seedone_background_image['class']); ?>" <?php echo (!empty($seedone_background_image['url'])) ? 'style="background-image: url(' . esc_url($seedone_background_image['url']) . ');"' : ''; ?>>
		<?php endif; ?>
		<div class="container<?php echo esc_attr($seedone_fluid . ' ' . $seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
			<div class="cols-2">

				<div class="copyright-text">
					<?php echo wp_kses_post(seedone_get_copyright_text($seedone_text)); ?>
				</div>
				<?php

				seedone_social_links();

				?>
			</div><!-- .cols-2 -->
		</div><!-- .container -->

		</div><!-- #copyright -->