<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	seedone_sticky_post_label();
	seedone_post_thumbnail('seedone-default-post');
	?>
	<div class="item-content bg-lightgrey">
		<div class="entry-footer entry-footer-top">
			<?php seedone_entry_meta(true, true, true, false, true, true); ?>
		</div>
		<?php if (get_the_title()) : ?>
			<header class="entry-header">
				<?php
				the_title(sprintf('<h3 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
				?>
			</header><!-- .entry-header -->
		<?php endif; //get_the_title 
		?>

		<div class="entry-content" itemprop="text">
			<?php
			$seedone_show_full_text = seedone_option('blog_show_full_text', false);

			if (empty($seedone_show_full_text)) :
				the_excerpt();

			else :
				the_content(
					seedone_read_more_inside_link_markup()
				);

			endif; // show_full_text

			wp_link_pages(
				seedone_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->


		<?php
		if (function_exists('seedone_share_this')) {
			seedone_share_this();
		}
		?>


		<footer class="entry-footer  entry-footer-bottom meta-tags"><?php seedone_entry_meta(false, false, false, true, false, false); ?></footer>
		<!-- .entry-footer -->

	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->