<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$seedone_layouts           = seedone_get_feed_layout_options( true );
$seedone_gaps              = seedone_get_feed_layout_gap_options( true );
$seedone_sidebar_positions = seedone_get_sidebar_position_options( true );

//options for categories
//returning array of fields
return array(
	'layout'           => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Layout', 'seedone' ),
		'description' => esc_html__( 'Category layout', 'seedone' ),
		'default'     => '',
		'choices'     => $seedone_layouts,
	),
	'gap'              => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Items gap (for grid layouts)', 'seedone' ),
		'description' => esc_html__( 'Gap between elements in pixels', 'seedone' ),
		'default'     => '',
		'choices'     => $seedone_gaps,
	),
	'sidebar_position' => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Sidebar position', 'seedone' ),
		'description' => esc_html__( 'Sidebar position for category', 'seedone' ),
		'default'     => '',
		'choices'     => $seedone_sidebar_positions,
	),
);
