<?php

/**
 * WooCommerce support
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//Woo min required version is 3.6

//header products counter ajax refresh
add_filter('woocommerce_add_to_cart_fragments', 'seedone_filter_woocommerce_cart_count_fragments', 10, 1);
if (!function_exists('seedone_filter_woocommerce_cart_count_fragments')) :
	function seedone_filter_woocommerce_cart_count_fragments($fragments)
	{
		$fragments['span.cart-count'] = '<span class="cart-count">';
		if (!empty(WC()->cart->get_cart_contents_count())) {
			$fragments['span.cart-count'] .= WC()->cart->get_cart_contents_count();
		}
		$fragments['span.cart-count'] .= '</span>';
		return $fragments;
	}
endif;

//removing wrapper 'main' and 'div' elements - templates/global and adding our custom with class .woo
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

add_action('woocommerce_before_main_content', 'seedone_action_woocommerce_output_content_wrapper', 10);
if (!function_exists('seedone_action_woocommerce_output_content_wrapper')) :
	function seedone_action_woocommerce_output_content_wrapper()
	{
		echo '<div class="woo">';
	}
endif;
add_action('woocommerce_after_main_content', 'seedone_action_woocommerce_output_content_wrapper_end', 10);
if (!function_exists('seedone_action_woocommerce_output_content_wrapper_end')) :
	function seedone_action_woocommerce_output_content_wrapper_end()
	{
		echo '</div><!--.woo-->';
	}
endif;


//removing default WooCommerce sidebar - we have our sidebar
remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

//removing default breadcrumbs - we have our breadcrumbs
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

//removing page title if it is showing in the title section (to prevent duplication)
$seedone_title = seedone_option('title_show_title', '');
if (!empty($seedone_title)) {
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
	add_filter('woocommerce_show_page_title', '__return_false');
}

/////////////////
//Products Loop//
/////////////////

//wrap products counter and filter dropdown to div on products archive
add_action('woocommerce_before_shop_loop', 'seedone_action_woocommerce_before_shop_loop_open_wrap_div', 15);
if (!function_exists('seedone_action_woocommerce_before_shop_loop_open_wrap_div')) :
	function seedone_action_woocommerce_before_shop_loop_open_wrap_div()
	{
		echo '<div class="row clear woo-count-filter-wrap">';
	}
endif;
add_action('woocommerce_before_shop_loop', 'seedone_action_woocommerce_before_shop_loop_close_wrap_div', 35);
if (!function_exists('seedone_action_woocommerce_before_shop_loop_close_wrap_div')) :
	function seedone_action_woocommerce_before_shop_loop_close_wrap_div()
	{
		echo '</div><!--.woo-count-filter-wrap-->';
	}
endif; //seedone_action_woocommerce_before_shop_loop_close_wrap_div

//wrap product and category loop item into div
add_action('woocommerce_before_subcategory', 'seedone_action_woocommerce_before_shop_loop_item_open_wrap_div', 5);
add_action('woocommerce_before_shop_loop_item', 'seedone_action_woocommerce_before_shop_loop_item_open_wrap_div', 5);
if (!function_exists('seedone_action_woocommerce_before_shop_loop_item_open_wrap_div')) :
	function seedone_action_woocommerce_before_shop_loop_item_open_wrap_div()
	{
		echo '<div class="product-loop-item">';
		echo '<div class="product-thumbnail-wrap">';
	}
endif; //seedone_action_woocommerce_before_shop_loop_item_open_wrap_div
add_action('woocommerce_after_subcategory', 'seedone_action_woocommerce_after_shop_loop_item_close_wrap_div', 15);
add_action('woocommerce_after_shop_loop_item', 'seedone_action_woocommerce_after_shop_loop_item_close_wrap_div', 15);
if (!function_exists('seedone_action_woocommerce_after_shop_loop_item_close_wrap_div')) :
	function seedone_action_woocommerce_after_shop_loop_item_close_wrap_div()
	{
		echo '</div><!--.product-text-wrap-->';
		echo '</div><!--.product-loop-item-->';
	}
endif;

add_action('woocommerce_after_shop_loop_item', 'seedone_action_woocommerce_after_shop_loop_item_product_short_description', 7);
if (!function_exists('seedone_action_woocommerce_after_shop_loop_item_product_short_description')) :
	function seedone_action_woocommerce_after_shop_loop_item_product_short_description()
	{
		global $product;
		echo '<div class="product-short-description">';
		echo wp_kses_post($product->get_short_description());
		echo '</div><!-- .product-short-description -->';
	}
endif;

//quick view button
if (class_exists('YITH_WCQV_Frontend')) :
	remove_action('woocommerce_after_shop_loop_item', array(YITH_WCQV_Frontend::get_instance(), 'yith_add_quick_view_button'), 15);
	remove_action('yith_wcwl_table_after_product_name', array(YITH_WCQV_Frontend::get_instance(), 'yith_add_quick_view_button'), 15, 0);

	add_filter('yith_add_quick_view_button_html', 'seedone_filter_yith_add_quick_view_button_html');
	if (!function_exists('seedone_filter_yith_add_quick_view_button_html')) :
		function seedone_filter_yith_add_quick_view_button_html($html)
		{
			return str_replace('class="button ', 'class="', $html);
		}
	endif;
endif;

//closing product link after image
add_action('woocommerce_before_shop_loop_item_title', 'seedone_action_woocommerce_template_loop_close_link_and_div_after_thumbnail', 11);
if (!function_exists('seedone_action_woocommerce_template_loop_close_link_and_div_after_thumbnail')) :
	function seedone_action_woocommerce_template_loop_close_link_and_div_after_thumbnail()
	{
		echo '</a>';
		$show_link        = seedone_option('product_show_thumbnail_link', '');
		$show_add_to_cart = seedone_option('product_show_thumbnail_add_to_cart', '');
		$show_whishlist   = defined('YITH_WCWL');
		$show_quick_view  = class_exists('YITH_WCQV_Frontend');
		if ($show_link || $show_add_to_cart || $show_whishlist) :
			echo '<div class="product-buttons-wrap">';
			if ($show_link) {
				echo '<a class="view_product" href="' . esc_url(get_the_permalink()) . '"></a>';
			}
			if ($show_quick_view) {
				echo do_shortcode('[yith_quick_view]');
			}
			//YITH WooCommerce Wishlist
			if ($show_whishlist && is_user_logged_in()) {
				echo do_shortcode('[yith_wcwl_add_to_wishlist]');
			}
			if ($show_add_to_cart) {
				woocommerce_template_loop_add_to_cart();
			}
			echo '</div><!-- .product-buttons-wrap -->';
		endif; //buttons
		echo '</div><!-- .product-thumbnail-wrap -->';
		//add to cart button options
		$hide_btn  = seedone_option('product_simple_add_to_cart_hide_button', '') ? 'hide-btn' : '';
		//additional product info options
		$show_cat  = seedone_option('product_show_category', '') ? 'show-cat' : '';
		$show_desc = seedone_option('product_show_short_description', '') ? 'show-desc' : '';
		echo '<div class="product-text-wrap ' . esc_attr($hide_btn . ' ' . $show_cat . ' ' . $show_desc) . '">';
	}
endif; //seedone_woocommerce_template_loop_close_link_and_div_after_thumbnail

//putting link to product in the product title heading
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
add_action('woocommerce_shop_loop_item_title', 'seedone_action_woocommerce_template_loop_product_title', 10);
if (!function_exists('seedone_action_woocommerce_template_loop_product_title')) :
	function seedone_action_woocommerce_template_loop_product_title()
	{
		echo '<h2 class="woocommerce-loop-product__title">';
		woocommerce_template_loop_product_link_open();
		the_title();
		woocommerce_template_loop_product_link_close();
		echo '</h2>';
	}
endif;

remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);

//closing category link after image
add_action('woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_link_close', 9);
remove_action('woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10);
//putting link to category in the product category title heading
add_action('woocommerce_shop_loop_subcategory_title', 'seedone_action_woocommerce_template_loop_category_title', 10);
if (!function_exists('seedone_action_woocommerce_template_loop_category_title')) :
	function seedone_action_woocommerce_template_loop_category_title($category)
	{
		echo '</div><!-- .product-thumbnail-wrap -->';
		echo '<div class="product-text-wrap">';
		echo '<h2 class="woocommerce-loop-category__title">';
		woocommerce_template_loop_category_link_open($category);
		echo esc_html($category->name);
		if ($category->count > 0) {
			echo wp_kses(
				apply_filters(
					'seedone_woocommerce_subcategory_count_html',
					' <mark class="count">(' . esc_html($category->count) . ')</mark>',
					$category
				),
				array(
					'mark' => array(
						'class' => array(),
					),
				)
			);
		}
		woocommerce_template_loop_category_link_close();
		echo '</h2>';
	}
endif;

//add categories to loop
add_action('woocommerce_shop_loop_item_title', 'seedone_action_woocommerce_shop_loop_item_title_open_wrap', 5);
if (!function_exists('seedone_action_woocommerce_shop_loop_item_title_open_wrap')) :
	function seedone_action_woocommerce_shop_loop_item_title_open_wrap()
	{
		echo '<div class="product-title-cat-wrap">';
	}
endif;
add_action('woocommerce_shop_loop_item_title', 'seedone_action_woocommerce_shop_loop_item_title', 20);
if (!function_exists('seedone_action_woocommerce_shop_loop_item_title')) :
	function seedone_action_woocommerce_shop_loop_item_title()
	{
		global $product;
		echo wp_kses_post(wc_get_product_category_list($product->get_id(), ', ', '<span class="posted_in">', '</span>'));
		echo '</div><!-- .product-title-cat-wrap -->';
	}
endif;

//remove closing A tag from the end of product and category loop item - we have our own earlier
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action('woocommerce_after_subcategory', 'woocommerce_template_loop_category_link_close', 10);

//add rating wrap and reviews count inside it
add_action('woocommerce_after_shop_loop_item_title', 'seedone_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count', 10);
if (!function_exists('seedone_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count')) :
	function seedone_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count()
	{
		if (!wc_review_ratings_enabled()) {
			return;
		}
		/*
		 * You can use following to display rating instead of option from customizer
		global $product;
		$review_count = $product->get_review_count();
		$css_class    = $review_count ? 'visible' : 'hidden';
		*/
		$css_class = seedone_option('product_show_rating', '') ? 'visible' : 'hidden';
		echo '<div class="product-rating-wrap ' . esc_attr($css_class) . '">';
	}
endif; //seedone_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count
add_action('woocommerce_after_shop_loop_item_title', 'seedone_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count_close', 11);
if (!function_exists('seedone_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count_close')) :
	function seedone_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count_close()
	{
		if (!wc_review_ratings_enabled()) {
			return;
		}
		woocommerce_template_loop_rating();

		if (comments_open()) :
			global $product;
			$review_count = $product->get_review_count();
			$css_class_reviews = seedone_option('product_show__review_count', '') ? 'visible' : 'hidden';
			$link         = apply_filters('seedone_woocommerce_loop_product_link', get_the_permalink(), $product);

?>
			<a href="<?php echo esc_url($link); ?>#reviews" class="product-review-link <?php echo esc_attr($css_class_reviews) ?>" rel="nofollow">
				<?php
				printf(
					esc_html(
						/* translators: 1: number of comments */
						_n(
							'%s review',
							'%s reviews',
							esc_html($review_count),
							'seedone'
						)
					),
					'<span class="count">' . esc_html($review_count) . '</span>'
				);
				?>
			</a>
<?php
		endif; //comments_open
		echo '</div><!-- .product-rating-wrap -->';
	}
endif; //seedone_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count

//change woo pagination
add_action('woocommerce_after_shop_loop', 'seedone_action_woocommerce_after_shop_loop', 9);
if (!function_exists('seedone_action_woocommerce_after_shop_loop')) :
	function seedone_action_woocommerce_after_shop_loop()
	{
		echo '<div class="nav-links">';
	}
endif;
//change woo pagination
add_action('woocommerce_after_shop_loop', 'seedone_action_woocommerce_after_shop_loop_end', 1);
if (!function_exists('seedone_action_woocommerce_after_shop_loop_end')) :
	function seedone_action_woocommerce_after_shop_loop_end()
	{
		echo '</div><!--.nav-links -->';
	}
endif;
//change woo pagination
add_filter('woocommerce_pagination_args', 'seedone_filter_woocommerce_pagination_args');
if (!function_exists('seedone_filter_woocommerce_pagination_args')) :
	function seedone_filter_woocommerce_pagination_args($args)
	{
		$args['type'] = 'plain';
		$args         = wp_parse_args(seedone_get_the_posts_pagination_atts(), $args);
		return $args;
	}
endif;
// view
add_action('woocommerce_before_shop_loop', 'upqode_action_before_shop_loop_wrap_form_close', 40);
if (!function_exists('upqode_action_before_shop_loop_wrap_form_close')) :
	function upqode_action_before_shop_loop_wrap_form_close()
	{
		echo '<a href="#" id="toggle_shop_view" class=""></a>';
	}
endif;

//add autocomplete none for search form
add_filter('get_product_search_form', 'seedone_filter_woocommerce_get_product_search_form');
if (!function_exists('seedone_filter_woocommerce_get_product_search_form')) :
	function seedone_filter_woocommerce_get_product_search_form($form_html)
	{
		$form_html = str_replace('<form', '<form autocomplete="off"', $form_html);
		$form_html = str_replace('class="woocommerce-product-search"', 'class="woocommerce-product-search search-form"', $form_html);
		$form_html = str_replace('class="woocommerce-product-search"', 'class="woocommerce-product-search search-form"', $form_html);
		$form_html = str_replace('<button type="submit"', '<button type="submit" class="search-submit"', $form_html);
		$form_html = str_replace('</button>', seedone_icon('magnify', true) . '</button>', $form_html);
		return $form_html;
	}
endif;

////////////////////
//cart page layout//
////////////////////
add_action('woocommerce_before_cart', 'seedone_action_woocommerce_before_cart');
if (!function_exists('seedone_action_woocommerce_before_cart')) :
	function seedone_action_woocommerce_before_cart()
	{
		echo '<div class ="cart-cols">';
	}
endif;

add_action('woocommerce_after_cart', 'seedone_action_woocommerce_after_cart');
if (!function_exists('seedone_action_woocommerce_after_cart')) :
	function seedone_action_woocommerce_after_cart()
	{
		echo '</div><!-- .cart-cols.cols-2 -->';
	}
endif;

//////////
//Blocks//
//////////

//add autocomplete none for search form
add_filter('woocommerce_blocks_product_grid_item_html', 'seedone_filter_woocommerce_blocks_product_grid_item_html', 10, 2);
if (!function_exists('seedone_filter_woocommerce_blocks_product_grid_item_html')) :
	function seedone_filter_woocommerce_blocks_product_grid_item_html($html, $data)
	{
		return "<li class=\"product wc-block-grid__product\">
				<div class=\"product-loop-item\">
					<div class=\"product-thumbnail-wrap\">
						<a href=\"{$data->permalink}\" class=\"wc-block-grid__product-link\">
							{$data->image}
						</a>
					</div>
					<div class=\"product-text-wrap\">
						<a href=\"{$data->permalink}\" class=\"wc-block-grid__product-link\">
							{$data->title}
						</a>
						{$data->badge}
						{$data->price}
						{$data->rating}
						{$data->button}
					</div>
				</div>
			</li>";
	}
endif;

/*
add .products to block UL
uncomment, if needed
add_filter( 'the_content', 'seedone_filter_woocommerce_the_content' );
*/
if (!function_exists('seedone_filter_woocommerce_the_content')) :
	function seedone_filter_woocommerce_the_content($html)
	{
		return str_replace('ul class="wc-block-grid__products"', 'ul class="products wc-block-grid__products"', $html);
	}
endif;

//add class to checkout button
remove_action('woocommerce_widget_shopping_cart_buttons', 'woocommerce_widget_shopping_cart_proceed_to_checkout', 20);
add_action('woocommerce_widget_shopping_cart_buttons', 'seedone_action_woocommerce_widget_shopping_cart_proceed_to_checkout', 20);
if (!function_exists('seedone_action_woocommerce_widget_shopping_cart_proceed_to_checkout')) :
	function seedone_action_woocommerce_widget_shopping_cart_proceed_to_checkout()
	{
		echo '<a href="' . esc_url(wc_get_checkout_url()) . '" class="button alt checkout wc-forward">' . esc_html__('Checkout', 'seedone') . '</a>';
	}
endif;

//add spans to filter widget braces
add_filter('woocommerce_layered_nav_count', 'seedone_filter_woocommerce_layered_nav_count', 10, 2);
if (!function_exists('seedone_filter_woocommerce_layered_nav_count')) :
	function seedone_filter_woocommerce_layered_nav_count($html, $count)
	{
		return '<span class="count"><span class="count-open">(</span>' . absint($count) . '<span class="count-close">)</span></span>';
	}
endif;

//add sidebar position option for product and shop
add_filter('seedone_customizer_options', 'seedone_filter_seedone_customizer_options');
if (!function_exists('seedone_filter_seedone_customizer_options')) :
	function seedone_filter_seedone_customizer_options($options)
	{
		//sections
		$options['section_seedone_woocommerce_layout'] = array(
			'type'        => 'section',
			'panel'       => 'woocommerce',
			'label'       => esc_html__('Seedone Shop Layout', 'seedone'),
			'description' => esc_html__('These options let you manage sidebar positions on the shop and product pages.', 'seedone'),
		);

		$options['section_seedone_woocommerce_products'] = array(
			'type'        => 'section',
			'panel'       => 'woocommerce',
			'label'       => esc_html__('Seedone Products List', 'seedone'),
			'description' => esc_html__('These options let you manage your products list display.', 'seedone'),
		);

		//options
		//sidebars
		$options['shop_sidebar_position'] = array(
			'type'        => 'radio',
			'section'     => 'section_seedone_woocommerce_layout',
			'default'     => seedone_option('shop_sidebar_position', 'right'),
			'label'       => esc_html__('Shop sidebar position', 'seedone'),
			'description' => esc_html__('This option let you manage sidebar position on the shop page.', 'seedone'),
			'choices'     => seedone_get_sidebar_position_options(),
		);

		$options['product_sidebar_position'] = array(
			'type'        => 'radio',
			'section'     => 'section_seedone_woocommerce_layout',
			'default'     => seedone_option('product_sidebar_position', 'right'),
			'label'       => esc_html__('Product sidebar position', 'seedone'),
			'description' => esc_html__('This option let you manage sidebar position on product pages.', 'seedone'),
			'choices'     => seedone_get_sidebar_position_options(),
		);

		$options['header_cart_dropdown'] = array(
			'type'        => 'checkbox',
			'section'     => 'section_seedone_woocommerce_layout',
			'default'     => seedone_option('header_cart_dropdown', ''),
			'label'       => esc_html__('Show Cart Dropdown in Header', 'seedone'),
			'description' => esc_html__('Show cart icon in header with product count in shopping cart if added.', 'seedone'),
		);

		//products list
		//button options
		$options['product_simple_add_to_cart_hide_button'] = array(
			'type'    => 'checkbox',
			'section' => 'section_seedone_woocommerce_products',
			'default' => seedone_option('product_simple_add_to_cart_hide_button', ''),
			'label'   => esc_html__('Hide product "Add to Cart" button', 'seedone'),
		);

		//products additional info options
		$options['product_show_rating'] = array(
			'type'    => 'checkbox',
			'section' => 'section_seedone_woocommerce_products',
			'default' => seedone_option('product_show_rating', ''),
			'label'   => esc_html__('Show rating', 'seedone'),
		);

		$options['product_show__review_count'] = array(
			'type'    => 'checkbox',
			'section' => 'section_seedone_woocommerce_products',
			'default' => seedone_option('product_show_review_count', ''),
			'label'   => esc_html__('Show review count (if "Show rating" is selected)', 'seedone'),
		);

		$options['product_show_category'] = array(
			'type'    => 'checkbox',
			'section' => 'section_seedone_woocommerce_products',
			'default' => seedone_option('product_show_category', ''),
			'label'   => esc_html__('Show products categories', 'seedone'),
		);

		$options['product_show_short_description'] = array(
			'type'    => 'checkbox',
			'section' => 'section_seedone_woocommerce_products',
			'default' => seedone_option('product_show_short_description', ''),
			'label'   => esc_html__('Show product short description', 'seedone'),
		);

		$options['product_show_thumbnail_add_to_cart'] = array(
			'type'    => 'checkbox',
			'section' => 'section_seedone_woocommerce_products',
			'default' => seedone_option('product_show_thumbnail_add_to_cart', ''),
			'label'   => esc_html__('Show "Add to Cart" button over thumbnail', 'seedone'),
		);

		$options['product_show_thumbnail_link'] = array(
			'type'    => 'checkbox',
			'section' => 'section_seedone_woocommerce_products',
			'default' => seedone_option('product_show_thumbnail_link', ''),
			'label'   => esc_html__('Show "Go to Product" button over thumbnail', 'seedone'),
		);

		return $options;
	}
endif;


//change image thumbnails size
add_filter('woocommerce_get_image_size_gallery_thumbnail', 'seedone_change_image_size_gallery_thumbnail');
if (!function_exists('seedone_change_image_size_gallery_thumbnail')) :
	function seedone_change_image_size_gallery_thumbnail($size)
	{
		return array(
			'width' => 300,
			'height' => 300,
			'crop' => 0,
		);
	}
endif;

add_action('woocommerce_before_single_product_summary', 'seedone_action_echo_div_columns_before_single_product_summary', 9);
if (!function_exists('seedone_action_echo_div_columns_before_single_product_summary')) :
	function seedone_action_echo_div_columns_before_single_product_summary()
	{
		echo '<div class="product-wrap position-relative">';
	}
endif;

add_action('woocommerce_before_single_product_summary', 'seedone_action_echo_div_close_first_column_before_single_product_summary', 21);
if (!function_exists('seedone_action_echo_div_close_first_column_before_single_product_summary')) :
	function seedone_action_echo_div_close_first_column_before_single_product_summary()
	{
		echo '</div><!-- eof .col-sm- with single product images -->';
	}
endif;

add_filter('woocommerce_loop_add_to_cart_link', 'before_after_btn', 10, 3);
function before_after_btn($add_to_cart_html, $product, $args)
{
	$before = '<div class="product-buttons-wrap">';
	$after = '</div>';
	return $before . $add_to_cart_html . $after;
}

//cart_page
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
remove_action('woocommerce_cart_collaterals', 'woocommerce_cart_totals');

add_action('woocommerce_after_cart', 'woocommerce_cart_totals', 10);
add_action('woocommerce_after_cart', 'woocommerce_cross_sell_display');

//checkout
add_action('woocommerce_checkout_before_customer_details', 'seedone_action_echo_div_checkout_before_customer_details');
if (!function_exists('seedone_action_echo_div_checkout_before_customer_details')) :
	function seedone_action_echo_div_checkout_before_customer_details()
	{
		echo '<div class="flex_wrap">';
	}
endif;

add_action('woocommerce_checkout_before_order_review_heading', 'seedone_action_echo_div_checkout_before_order_review_heading');
if (!function_exists('seedone_action_echo_div_checkout_before_order_review_heading')) :
	function seedone_action_echo_div_checkout_before_order_review_heading()
	{
		echo '<div class="order_wrap">';
	}
endif;

add_action('woocommerce_checkout_after_order_review', 'seedone_action_echo_div_checkout_after_order_review');
if (!function_exists('seedone_action_echo_div_checkout_after_order_review')) :
	function seedone_action_echo_div_checkout_after_order_review()
	{
		echo '</div> </div>';
	}
endif;

//additional information
add_filter('gettext', 'change_some_woocommerce_strings', 10, 3);
function change_some_woocommerce_strings($custom_text, $original_text, $domain)
{
	if (is_checkout() && $original_text === 'Additional information') {
		$custom_text = 'Ship to a different address?';
	}

	return $custom_text;
}


add_filter('woocommerce_checkout_fields', 'change_order_notes_placeholder');
function change_order_notes_placeholder($fields)
{
	$fields['order']['order_comments']['placeholder'] = 'Order notes (optional)';

	return $fields;
}
