<?php

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Seedone for publication on ThemeForest
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */

require_once SEEDONE_THEME_PATH . '/inc/tgm-plugin-activation/class-tgm-plugin-activation.php';

//required plugins arrays - default and additional for different demos
if (!function_exists('seedone_get_required_plugins_array')) :
	function seedone_get_required_plugins_array($seedone_index = 'default', $seedone_all = false, $seedone_all_flat = false)
	{
		$seedone_required_plugins_array = array(
			//Following plugins are required for all demo contents:
			'default' => array(
				array(
					'name'     => esc_html__('Theme Widgets', 'seedone'),
					'slug'     => 'mwt-widgets',
					'source'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/plugins/mwt-widgets.zip'),
					'required' => true,
					'version'  => '0.0.1',
				),
				array(
					'name'     => esc_html__('Seedone Options for Theme', 'seedone'),
					'slug'     => 'seedone-options-for-theme',
					'source'   => esc_url('http://webdesign-finder.com/remote-demo-content/seedone/plugins/mwt-fields.zip'),
					'required' => true,
					'version'  => '0.0.1',
				),
				array(
					'name'     => esc_html__('Unyson Backup', 'seedone'),
					'slug'     => 'unyson-backup',
					'source'   => esc_url('http://webdesign-finder.com/remote-demo-content/common-plugins-original/unyson-backup.zip'),
					'required' => true,
				),
				array(
					'name'             => esc_html__('MailChimp', 'seedone'),
					'slug'             => 'mailchimp-for-wp',
					'required'         => true,
				),
				array(
					'name' => esc_html__('Reusable Blocks Extended', 'seedone'),
					'slug' => 'reusable-blocks-extended',
				),
				array(
					'name'        => esc_html__('WordPress SEO by Yoast', 'seedone'),
					'slug'        => 'wordpress-seo',
					'is_callable' => 'wpseo_init',
				),
				array(
					'name'     => esc_html__('Envato Market', 'seedone'),
					'slug'     => 'envato-market',
					'required' => true, // please do not turn to false!
					'source'   => esc_url('https://envato.github.io/wp-envato-market/dist/envato-market.zip'),
				),
				array(
					'name' => esc_html__('WooCommerce', 'seedone'),
					'slug' => 'woocommerce',
				),
				array(
					'name'             => esc_html__('WooCommerce Product Price Custom Text (Before & After Text) and Discount', 'seedone'),
					'slug'             => 'elex-product-price-custom-text-before-after-text-and-discount-for-woocommerce',
					'required'         => false,
				),
				array(
					'name'     => esc_html__('YITH WooCommerce Quick View', 'seedone'),
					'slug'     => 'yith-woocommerce-quick-view',
					'required' => false,
				),
				array(
					'name'     => esc_html__('YITH WooCommerce Badge Management', 'seedone'),
					'slug'     => 'yith-woocommerce-badges-management',
					'required' => false,
				),
				array(
					'name'             => esc_html__('Widget CSS Classes', 'seedone'),
					'slug'             => 'widget-css-classes',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('Contact Form 7', 'seedone'),
					'slug'             => 'contact-form-7',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('Elementor', 'seedone'),
					'slug'             => 'elementor',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('Master Addons for Elementor', 'seedone'),
					'slug'             => 'master-addons',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('Premium Addons for Elementor', 'seedone'),
					'slug'             => 'premium-addons-for-elementor',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('Checkout Field Editor for WooCommerce', 'seedone'),
					'slug'             => 'woo-checkout-field-editor-pro',
					'required'         => true,
				),
			),
			'shop'    => array(
				array(
					'name' => esc_html__('WooCommerce', 'seedone'),
					'slug' => 'woocommerce',
				),
				array(
					'name'             => esc_html__('WooCommerce Advanced Product Labels', 'seedone'),
					'slug'             => 'woocommerce-advanced-product-labels',
					'required'         => false,
				),
				array(
					'name'     => esc_html__('YITH WooCommerce Quick View', 'seedone'),
					'slug'     => 'yith-woocommerce-quick-view',
					'required' => false,
				),
			),
		);
		if (!empty($seedone_all_flat)) {
			$seedone_required_plugins_array_all = array();
			foreach ($seedone_required_plugins_array as $key => $plugins) {
				foreach ($plugins as $plugin) {
					$seedone_required_plugins_array_all[$plugin['slug']] = $plugin;
				}
			}
			return $seedone_required_plugins_array_all;
		} elseif (!empty($seedone_all)) {
			return $seedone_required_plugins_array;
		} else {
			return $seedone_required_plugins_array[$seedone_index];
		}
	}
endif; //seedone_get_required_plugins_array

add_action('tgmpa_register', 'seedone_register_required_plugins');
if (!function_exists('seedone_register_required_plugins')) :
	/**
	 * Register the required plugins for this theme.
	 *
	 * The variables passed to the `tgmpa()` function should be:
	 * - an array of plugin arrays;
	 * - optionally a configuration array.
	 * If you are not changing anything in the configuration array, you can remove the array and remove the
	 * variable from the function call: `tgmpa( $seedone_plugins );`.
	 * In that case, the TGMPA default settings will be used.
	 *
	 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
	 */
	function seedone_register_required_plugins()
	{
		/*
		* Array of plugin arrays. Required keys are name and slug.
		* If the source is NOT from the .org repo, then source is also required.
		*/
		//we need this to install different plugins for different demos
		if (!empty($_POST['seedone_all_plugins'])) {
			$seedone_plugins = seedone_get_required_plugins_array('', false, true);
		} else {
			$seedone_plugins = seedone_get_required_plugins_array();
		}
		tgmpa(
			$seedone_plugins,
			array(
				'domain'       => 'seedone',
				'dismissable'  => true,
				'is_automatic' => false,
			)
		);
	}
endif;

//demo content installing
//disable branding
add_filter('pt-ocdi/disable_pt_branding', '__return_true');

if (!function_exists('seedone_ocdi_get_required_demo_plugins')) :
	function seedone_ocdi_get_required_demo_plugins($seedone_demo_number = 'default')
	{
		//get TGMPA instance
		//$seedone_tgmpa = $GLOBALS['tgmpa'];
		$seedone_tgmpa = call_user_func(array(get_class($GLOBALS['tgmpa']), 'get_instance'));

		//get all plugins - different plugins for different demo as keys
		$seedone_plugins = seedone_get_required_plugins_array('', true);

		$seedone_plugins_to_install_and_activate = array(
			'all'      => array(), // Meaning: all plugins which still have open actions.
			'install'  => array(),
			'update'   => array(),
			'activate' => array(),
		);

		if (empty($seedone_plugins[$seedone_demo_number])) {
			return $seedone_plugins_to_install_and_activate;
		}

		//registering all plugins if they are not in the default stack
		foreach ($seedone_plugins[$seedone_demo_number] as $seedone_plugin) {
			$seedone_tgmpa->register($seedone_plugin);
		}

		foreach ($seedone_plugins[$seedone_demo_number] as $seedone_plugin) {
			if (!$seedone_tgmpa->can_plugin_activate($seedone_plugin['slug']) && $seedone_tgmpa->is_plugin_installed($seedone_plugin['slug']) && false === $seedone_tgmpa->does_plugin_have_update($seedone_plugin['slug'])) {
				//following will cause theme check error - is_plugin_active
				// if ( $seedone_tgmpa->is_plugin_active( $seedone_plugin['slug'] ) && false === $seedone_tgmpa->does_plugin_have_update( $seedone_plugin['slug'] ) ) {
				// No need to display plugins if they are installed, up-to-date and active.
				continue;
			}
			if (!$seedone_tgmpa->is_plugin_installed($seedone_plugin['slug'])) {
				$seedone_plugins_to_install_and_activate['install'][$seedone_plugin['slug']] = $seedone_plugin;
			} else {
				if (false !== $seedone_tgmpa->does_plugin_have_update($seedone_plugin['slug'])) {
					$seedone_plugins_to_install_and_activate['update'][$seedone_plugin['slug']] = $seedone_plugin;
				}

				if ($seedone_tgmpa->can_plugin_activate($seedone_plugin['slug'])) {
					$seedone_plugins_to_install_and_activate['activate'][$seedone_plugin['slug']] = $seedone_plugin;
				}
			}
		}

		return $seedone_plugins_to_install_and_activate;
	}
endif; //seedone_ocdi_get_required_demo_plugins

if (!function_exists('seedone_ocdi_get_demo_install_notice_html')) :
	function seedone_ocdi_get_demo_install_notice_html($seedone_demo_number = 0)
	{
		$seedone_plugins       = seedone_ocdi_get_required_demo_plugins($seedone_demo_number);
		$seedone_notice_html   = '';
		$seedone_data_install  = array();
		$seedone_data_activate = array();
		if (!empty($seedone_plugins['install']) || !empty($seedone_plugins['activate'])) {
			$seedone_notice_html .= '<div class="seedone-ocdi-required-plugins"><strong>' . esc_html__('Required plugins:', 'seedone') . '</strong></div>';
			foreach ($seedone_plugins['install'] as $seedone_plugin) {
				if (empty($seedone_plugin['name'])) {
					continue;
				}
				$seedone_notice_html   .= '<div class="seedone-ocdi-plugin-install">' . esc_html($seedone_plugin['name']) . ' - <span class="seedone-ocdi-' . esc_attr($seedone_plugin['slug']) . '">' . esc_html__('Install', 'seedone') . '</span></div>';
				$seedone_data_install[] = $seedone_plugin['slug'];
			}
			foreach ($seedone_plugins['activate'] as $seedone_plugin) {
				if (empty($seedone_plugin['name'])) {
					continue;
				}
				$seedone_notice_html    .= '<div class="seedone-ocdi-plugin-activate">' . esc_html($seedone_plugin['name']) . ' - <span class="seedone-ocdi-' . esc_attr($seedone_plugin['slug']) . '">' . esc_html__('Activate', 'seedone') . '</span></div>';
				$seedone_data_activate[] = $seedone_plugin['slug'];
			}
			$seedone_notice_html .= '<br><div class="seedone-ocdi-button-wrap"><button class="seedone-ocdi-install-plugins-button button button-primary"' .
				' data-install="' . esc_attr(join(',', $seedone_data_install)) . '"' .
				' data-activate="' . esc_attr(join(',', $seedone_data_activate)) . '"' .
				' data-demo="' . esc_attr($seedone_demo_number) . '">' .
				esc_html__('Install and Activate plugins', 'seedone') .
				'</button><span class="spinner"></span></div>';
		}

		return $seedone_notice_html;
	}
endif; //seedone_ocdi_get_demo_install_notice_html

// http://proteusthemes.github.io/one-click-demo-import/#basic-import-setup
if (!function_exists('seedone_ocdi_import_files')) :
	function seedone_ocdi_import_files()
	{
		return array(
			array(
				'import_file_name'             => esc_html__('Default', 'seedone'),
				'local_import_file'            => SEEDONE_THEME_PATH . '/assets/demo-content/default/demo-content.xml',
				'local_import_widget_file'     => SEEDONE_THEME_PATH . '/assets/demo-content/default/widgets.wie',
				'local_import_customizer_file' => SEEDONE_THEME_PATH . '/assets/demo-content/default/customizer.dat',
				'import_preview_image_url'     => SEEDONE_THEME_URI . '/screenshot.jpg',
				'import_notice'                => seedone_ocdi_get_demo_install_notice_html('default'),
				'preview_url'                  => '//demo.seedone-wordpress-theme.com/blog/',
			),
		);
	}
endif;
//demo content only on demo page or only when ajax happens - for not load and not displayed ALL required plugins by all demos
if ((!empty($_GET['page']) && ('pt-one-click-demo-import' === $_GET['page'] || 'one-click-demo-import' === $_GET['page'])) || wp_doing_ajax()) {
	add_filter('pt-ocdi/import_files', 'seedone_ocdi_import_files');
}

//setting cropped default image sizes
if (!function_exists('seedone_ocdi_before_content_import')) :
	function seedone_ocdi_before_content_import($selected_import)
	{
		update_option('medium_crop', '1');
		update_option('large_crop', '1');
	}
endif;
add_action('pt-ocdi/before_content_import', 'seedone_ocdi_before_content_import');

//setting menus, main and blog pages and special cats after demo import
if (!function_exists('seedone_ocdi_after_import_setup')) :
	function seedone_ocdi_after_import_setup($selected_import)
	{

		//different operations depending on different demos
		//https://github.com/awesomemotive/one-click-demo-import#how-to-handle-different-after-import-setups-depending-on-which-predefined-import-was-selected

		// Assign menus to their locations.
		$seedone_menus        = array(
			'topline'   => 'footer_menu_1',
			'primary'   => 'main_menu',
			/*
			side menu will be placed with widget, not with the menu
			'side'      => 'Side Menu',
			*/
			'copyright' => 'footer_menu_1',
		);
		$seedone_menus_to_set = array();
		foreach ($seedone_menus as $seedone_position => $seedone_name) {
			$seedone_menu = get_term_by('name', $seedone_name, 'nav_menu');
			if (!empty($seedone_menu)) {
				$seedone_menus_to_set[$seedone_position] = $seedone_menu->term_id;
			}
		}
		if (!empty($seedone_menus_to_set)) {
			set_theme_mod('nav_menu_locations', $seedone_menus_to_set);
		}

		//set reusable block with inline subscribe form as a theme mod
		$inline_subscribe_block = get_page_by_title('Inline Subscribe', OBJECT, 'wp_block');
		if (!empty($inline_subscribe_block)) {
			set_theme_mod('footer_top_shortcode', '[reblex id="' . $inline_subscribe_block->ID . '"]');
		}

		//set default items count for feed
		update_option('posts_per_page', '12');

		//hide Hello World post
		$seedone_hello_world_post = get_page_by_path('hello-world', OBJECT, 'post');
		if (!empty($seedone_hello_world_post)) {
			$seedone_hello_world_post->post_status = 'draft';
			wp_update_post($seedone_hello_world_post);
		}

		//set page as front page for demo with a static homepage
		// Assign front page and posts page (blog page).
		$seedone_front_page_id = get_page_by_title('Home');
		$seedone_blog_page_id  = get_page_by_title('Blog');

		update_option('show_on_front', 'page');
		update_option('page_on_front', $seedone_front_page_id->ID);
		update_option('page_for_posts', $seedone_blog_page_id->ID);

		//set shop page as front page for shop demo content
		//		if ( 'Shop' === $selected_import['import_file_name'] ) {
		// Assign front page - Shop, and posts page (blog page).
		$seedone_front_page_id = get_page_by_title('Home');
		$seedone_blog_page_id  = get_page_by_title('Blog');
		// Other Woo pages
		$seedone_cart_page_id     = get_page_by_title('Cart');
		$seedone_checkout_page_id = get_page_by_title('Checkout');
		$seedone_account_page_id  = get_page_by_title('My account');

		update_option('show_on_front', 'page');
		update_option('page_on_front', $seedone_front_page_id->ID);
		update_option('page_for_posts', $seedone_blog_page_id->ID);

		//Woo
		update_option('woocommerce_cart_page_id', $seedone_cart_page_id->ID);
		update_option('woocommerce_checkout_page_id', $seedone_checkout_page_id->ID);
		update_option('woocommerce_myaccount_page_id', $seedone_account_page_id->ID);
		//customizer
		update_option('woocommerce_catalog_columns', '3');

		//set home page link in menus in demos where home page is a post archive
		if ('Blog' === $selected_import['import_file_name']) {
			$menu_items = wp_get_nav_menu_items('Main Menu');
			if (!empty($menu_items)) {
				foreach ($menu_items as $menu_item_post_object) {
					if ('Home' === $menu_item_post_object->post_title) {
						update_post_meta($menu_item_post_object->ID, '_menu_item_url', get_site_url());
						break;
					}
				}
			}
			$menu_items = wp_get_nav_menu_items('Side Menu');
			if (!empty($menu_items)) {
				foreach ($menu_items as $menu_item_post_object) {
					if ('Home' === $menu_item_post_object->post_title) {
						$menu_item_post_object->url = get_site_url();
						update_post_meta($menu_item_post_object->ID, '_menu_item_url', get_site_url());
						break;
					}
				}
			}
		}
		//set permalinks structure
		{
			global $wp_rewrite;

			//Write the rule
			$wp_rewrite->set_permalink_structure('/%postname%/');

			//Set the option
			update_option("rewrite_rules", FALSE);

			//Flush the rules and tell it to write htaccess
			$wp_rewrite->flush_rules(true);
		}

		//change hardcoded URLs in pages, reusable blocks and nav menus
		$find = 'http://webdesign-finder.com/seedone';
		$replace = get_site_url();
		$query = new WP_Query(
			array(
				'post_type' => 'wp_block',
				'posts_per_page' => -1,
			)
		);
		foreach ($query->posts as $post) :
			$post->guid = str_replace($find, $replace, $post->guid);
			$post->post_content = str_replace($find, $replace, $post->post_content);
			wp_update_post($post);
		endforeach;

		$query = new WP_Query(
			array(
				'post_type' => 'page',
				'posts_per_page' => -1,
			)
		);
		foreach ($query->posts as $post) :
			$post->guid = str_replace($find, $replace, $post->guid);
			$post->post_content = str_replace($find, $replace, $post->post_content);
			wp_update_post($post);
		endforeach;
	}
endif; //seedone_ocdi_after_import_setup
add_action('pt-ocdi/after_import', 'seedone_ocdi_after_import_setup');

//load plugins install script
if (!function_exists('seedone_ocdi_admin_enqueue_scripts')) :
	function seedone_ocdi_admin_enqueue_scripts($hook)
	{
		if ('appearance_page_pt-one-click-demo-import' === $hook || 'appearance_page_one-click-demo-import' === $hook) {
			$min = !SEEDONE_DEV_MODE ? 'min/' : '';
			wp_enqueue_script('seedone-ocdi-plugins-install-script', SEEDONE_THEME_URI . '/assets/js/' . $min . 'ocdi.js', array('jquery'), SEEDONE_THEME_VERSION, true);
			wp_localize_script(
				'seedone-ocdi-plugins-install-script',
				'seedone_ocdi',
				array(
					'tgm_plugin_nonce' => array(
						'update'  => wp_create_nonce('tgmpa-update'),
						'install' => wp_create_nonce('tgmpa-install'),
					),
					'tgm_bulk_url'     => admin_url('themes.php?page=tgmpa-install-plugins'),
					'ajaxurl'          => admin_url('admin-ajax.php'),
					'wpnonce'          => wp_create_nonce('seedone_ocdi_nonce'),
					'text_done'        => esc_html__('Done', 'seedone'),
					'text_installing'  => esc_html__('Installing...', 'seedone'),
					'text_activating'  => esc_html__('Activating...', 'seedone'),
					'text_fail'        => esc_html__('Ajax error', 'seedone'),
					'text_fail_tgm'    => esc_html__('TGMPA Ajax error', 'seedone'),
				)
			);
		}
	}
endif; //seedone_ocdi_admin_enqueue_scripts
add_action('admin_enqueue_scripts', 'seedone_ocdi_admin_enqueue_scripts');

//process ajax call to install plugins
add_action('wp_ajax_seedone_install_and_activate_plugins', 'seedone_wp_ajax_install_and_activate_plugins');
if (!function_exists('seedone_wp_ajax_install_and_activate_plugins')) :
	function seedone_wp_ajax_install_and_activate_plugins()
	{
		if (!check_ajax_referer('seedone_ocdi_nonce', 'wpnonce')) {
			wp_send_json_error(
				array(
					'error'   => 1,
					'message' => esc_html__('Forbidden', 'seedone'),
				)
			);
		}
		if (empty($_POST['slug']) || (empty($_POST['plugins_activate']) && empty($_POST['plugins_install']))) {
			wp_send_json_error(
				array(
					'error'   => 1,
					'message' => esc_html__('No Plugins to Process', 'seedone'),
				)
			);
		}

		$plugins = array();
		// send back some json we use to hit up TGM
		if (isset($_POST['plugins_activate'])) {
			$plugins['activate'] = array_map('sanitize_title', $_POST['plugins_activate']);
		} else {
			$plugins['activate'] = array();
		}
		if (isset($_POST['plugins_install'])) {
			$plugins['install'] = array_map('sanitize_title', $_POST['plugins_install']);
		} else {
			$plugins['install'] = array();
		}
		// what are we doing with this plugin?
		//activating - is default
		$json = array(
			'url'             => admin_url('themes.php?page=tgmpa-install-plugins'),
			'plugin'          => array_filter($plugins['activate']),
			'tgmpa-page'      => 'tgmpa-install-plugins',
			'plugin_status'   => 'all',
			'_wpnonce'        => wp_create_nonce('bulk-plugins'),
			'action'          => 'tgmpa-bulk-activate',
			'action2'         => -1,
			'message'         => esc_html__('Activating Plugin...', 'seedone'),
			//load all plugins, not only default
			'seedone_all_plugins' => 1,
		);
		//every plugin to install is separate call
		//override activation here
		foreach ($plugins['install'] as $slug) {
			if ($slug === $_POST['slug']) {
				$json = array(
					'url'             => admin_url('themes.php?page=tgmpa-install-plugins'),
					'plugin'          => array($slug),
					'tgmpa-page'      => 'tgmpa-install-plugins',
					'plugin_status'   => 'all',
					'_wpnonce'        => wp_create_nonce('bulk-plugins'),
					'action'          => 'tgmpa-bulk-install',
					'action2'         => -1,
					'message'         => esc_html__('Installing Plugin...', 'seedone'),
					//load all plugins, not only default
					'seedone_all_plugins' => 1,
				);
				break;
			}
		}

		if ($json) {
			$json['hash'] = md5(serialize($json)); // used for checking if duplicates happen, move to next plugin
			wp_send_json($json);
		} else {
			wp_send_json(
				array(
					'done'    => 1,
					'message' => esc_html__('Success', 'seedone'),
				)
			);
		}
		wp_die();
	}
endif; //seedone_wp_ajax_install_and_activate_plugins
