<?php

/**
 * Template helpers fucntions
 *
 * @package Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

if (!function_exists('seedone_get_body_schema_itemtype')) :

	/**
	 * Get itemtype value for body tag
	 *
	 * @since 0.0.1
	 */
	function seedone_get_body_schema_itemtype()
	{

		//Get default itemtype
		$seedone_itemtype = (is_page()) ? 'WebPage' : 'Blog';

		//Change itemtype if is search page
		if (is_search()) {
			$seedone_itemtype = 'SearchResultsPage';
		}

		return $seedone_itemtype;
	}
endif;

//get theme template part
if (!function_exists('seedone_template_part')) :
	function seedone_template_part($seedone_template_part_name, $seedone_default_value = '1')
	{
		$seedone_return = seedone_option($seedone_template_part_name, $seedone_default_value);

		//for demo
		if (!empty($_GET[$seedone_template_part_name])) {
			$seedone_return = absint($_GET[$seedone_template_part_name]);
		}

		return $seedone_return;
	}
endif;

//get proper CSS classes for #main section based on page template
if (!function_exists('seedone_get_page_main_section_css_classes')) :
	function seedone_get_page_main_section_css_classes()
	{
		$return = 'width-inherit';
		if (is_page_template('page-templates/no-sidebar-720.php')) {
			$return = 'container-720';
		}
		if (is_page_template('page-templates/no-sidebar-960.php')) {
			$return = 'container-960';
		}
		if (is_page_template('page-templates/no-sidebar-1170.php')) {
			$return = 'container-1170';
		}

		return $return;
	}
endif;

//get proper CSS classes for main column, aside column and body
if (!function_exists('seedone_get_layout_css_classes')) :
	function seedone_get_layout_css_classes()
	{

		//default - sidebar
		$seedone_return = array(
			'body'  => 'with-sidebar',
			'main'  => 'column-main',
			'aside' => 'column-aside',
		);

		//check for shop
		if (function_exists('is_woocommerce') && is_woocommerce()) :
			if (is_product()) {
				$seedone_shop_sidebar_position_option = seedone_option('product_sidebar_position', 'right');
			}
			if (is_shop() || is_product_taxonomy()) {
				$seedone_shop_sidebar_position_option = seedone_option('shop_sidebar_position', 'right');
			}
			//if empty sidebar or disabled in customizer - removing aside
			if (!is_active_sidebar('shop') || 'no' === $seedone_shop_sidebar_position_option) {
				$seedone_return['body']  = 'no-sidebar';
				$seedone_return['aside'] = false;

				return $seedone_return;
			} //is_active_sidebar( 'shop' )
			//left sidebar
			if ('left' === $seedone_shop_sidebar_position_option) {
				$seedone_return['body'] .= ' sidebar-left';

				return $seedone_return;
				//default - right sidebar
			} else {
				return $seedone_return;
			}
		endif; //is_woocommerce()

		//if category has meta - overriding default customizer option option
		if (is_category()) {
			$seedone_sidebar_position_option = seedone_get_category_sidebar_position();
		} else {
			if (!is_single()) {
				$seedone_sidebar_position_option = seedone_option('blog_sidebar_position', 'right');
			} else {
				$seedone_sidebar_position_option = seedone_option('blog_single_sidebar_position', 'right');
			}
		} //is_category

		if (!is_page_template('page-templates/home.php')) {
			$sidebar = 'sidebar-1';
			if (is_front_page() && is_active_sidebar('sidebar-home-main')) {
				$sidebar = 'sidebar-home-main';
			}
			//if empty sidebar - removing aside
			if (!is_active_sidebar($sidebar)) {
				$seedone_return['body']  = 'no-sidebar';
				$seedone_return['aside'] = false;

				return $seedone_return;
			} //sidebar-1
		} else {
			//if empty sidebar on home.php page template - removing aside
			if (!is_active_sidebar('sidebar-home-main')) {
				$seedone_return['body']  = 'no-sidebar';
				$seedone_return['aside'] = false;

				return $seedone_return;
			} //sidebar-nome-main
		} //! is_page_template( 'page-templates/home.php'

		//various cases with sidebar
		//single post without sidebars
		if (is_single()) {

			//no sidebar for posts layouts
			if (
				is_page_template('page-templates/post-full-width-no-meta-no-thumbnail.php')
				||
				is_page_template('page-templates/post-full-width-no-meta.php')
				||
				is_page_template('page-templates/post-full-width.php')
			) {
				$seedone_return['body']  = 'no-sidebar';
				$seedone_return['aside'] = false;

				return $seedone_return;
			}
		} //is_single

		//pages
		if (is_page()) :

			//no sidebar
			if (
				is_page_template('page-templates/full-width.php')
				||
				is_page_template('page-templates/empty-page.php')
				||
				is_page_template('page-templates/empty-page-container.php')
				||
				is_page_template('page-templates/no-sidebar-720.php')
				||
				is_page_template('page-templates/no-sidebar-960.php')
				||
				is_page_template('page-templates/no-sidebar-1170.php')
				||
				is_page_template('page-templates/no-sidebar-no-title.php')
				||
				is_page_template('page-templates/no-sidebar-no-padding.php')
				||
				!is_page_template()
			) {
				$seedone_return['body']  = 'no-sidebar';
				$seedone_return['aside'] = false;

				return $seedone_return;
			}

			//left sidebar for page
			if (
				is_page_template('page-templates/sidebar-left.php')
				||
				('left' === $seedone_sidebar_position_option)
			) {
				$seedone_return['body'] .= ' sidebar-left';

				return $seedone_return;
			}

		//right sidebar is default
		endif; // is_page

		//if no sidebar option - removing aside
		if ('no' === $seedone_sidebar_position_option && !(is_page_template('page-templates/home.php'))) {
			$seedone_return['body']  = 'no-sidebar';
			$seedone_return['aside'] = false;

			return $seedone_return;
		}

		//left sidebar
		if ('left' === $seedone_sidebar_position_option) {
			$seedone_return['body'] .= ' sidebar-left';
		}

		return $seedone_return;
	}
endif;

//get category layout based on category meta with global blog option as fallback
if (!function_exists('seedone_get_category_layout')) :
	function seedone_get_category_layout()
	{
		$seedone_layout = '';

		$seedone_queried_object = get_queried_object();
		$seedone_term_id        = $seedone_queried_object->term_id;

		//if layout is overriden for category in admin panel
		$seedone_term_metas_layout = get_term_meta($seedone_term_id, 'layout', true);
		if (!empty($seedone_term_metas_layout)) {
			$seedone_layout = $seedone_term_metas_layout;
		}

		//if category layout not specified - getting default layout
		if (empty($seedone_layout)) {
			$seedone_layout = seedone_option('blog_layout', '') ? seedone_option('blog_layout', '') : 'default';
		}

		return $seedone_layout;
	}
endif;

//get category layout gap based on category meta with global blog option as fallback
if (!function_exists('seedone_get_category_layout_gap')) :
	function seedone_get_category_layout_gap()
	{
		$seedone_layout_gap = '';

		$seedone_queried_object = get_queried_object();
		$seedone_term_id        = $seedone_queried_object->term_id;

		//if layout is overriden for category in admin panel
		$seedone_term_metas_layout = get_term_meta($seedone_term_id, 'gap', true);
		if (!empty($seedone_term_metas_layout)) {
			$seedone_layout_gap = $seedone_term_metas_layout;
		}

		//if category layout not specified - getting default layout
		if (empty($seedone_layout_gap)) {
			$seedone_layout_gap = seedone_option('blog_layout_gap', '') ? seedone_option('blog_layout_gap', '') : '';
		}

		return $seedone_layout_gap;
	}
endif;

//get feed shot_title
if (!function_exists('seedone_get_feed_shot_title')) :
	function seedone_get_feed_shot_title()
	{
		if (is_category()) {
			$seedone_show_title = !seedone_option('title_show_title', '');
		} else {
			$seedone_show_title = !seedone_option('title_show_title', '') && !is_front_page();
		}

		return $seedone_show_title;
	}
endif;

//get feed layout
if (!function_exists('seedone_get_feed_layout')) :
	function seedone_get_feed_layout()
	{
		if (is_category()) {
			$seedone_layout = seedone_get_category_layout();
		} else {
			$seedone_layout = seedone_option('blog_layout', '') ? seedone_option('blog_layout', '') : 'default';
		}

		//override option for demo purposes
		if (isset($_GET['blog_layout'])) {
			$seedone_layout_id = absint($_GET['blog_layout']);
			$seedone_layouts   = array_keys(seedone_get_feed_layout_options());
			$seedone_layout    = !empty($seedone_layouts[$seedone_layout_id]) ? $seedone_layouts[$seedone_layout_id] : $seedone_layout;
		}

		return $seedone_layout;
	}
endif;

//get feed gap
if (!function_exists('seedone_get_feed_gap')) :
	function seedone_get_feed_gap()
	{
		if (is_category()) {
			$seedone_layout_gap = seedone_get_category_layout_gap();
		} else {
			$seedone_layout_gap = seedone_option('blog_layout_gap', '') ? seedone_option('blog_layout_gap', '') : '';
		}

		//override option for demo purposes
		if (isset($_GET['blog_layout_gap'])) {
			$seedone_layout_gap_id = absint($_GET['blog_layout_gap']);
			$seedone_layout_gaps   = array_keys(seedone_get_feed_layout_gap_options());
			$seedone_layout_gap    = !empty($seedone_layout_gaps[$seedone_layout_gap_id]) ? $seedone_layout_gaps[$seedone_layout_gap_id] : $seedone_layout_gap;
		}

		return $seedone_layout_gap;
	}
endif;

//get category sidebar_position based on category meta with global blog option as fallback
if (!function_exists('seedone_get_category_sidebar_position')) :
	function seedone_get_category_sidebar_position()
	{
		$seedone_sidebar_position = '';

		$seedone_queried_object = get_queried_object();
		$seedone_term_id        = $seedone_queried_object->term_id;

		//term metas from category options has higher priority than customizer option for special categories
		$seedone_term_metas = get_term_meta($seedone_term_id, 'sidebar_position', true);
		if (!empty($seedone_term_metas)) {
			$seedone_sidebar_position = $seedone_term_metas;
		}

		//if category sidebar_position not specified - getting default sidebar_position
		if (empty($seedone_sidebar_position)) {
			$seedone_sidebar_position = seedone_option('blog_sidebar_position', '') ? seedone_option('blog_sidebar_position', '') : 'right';
		}

		return $seedone_sidebar_position;
	}
endif;

//get single post layout based on blog post option
if (!function_exists('seedone_get_post_layout')) :
	function seedone_get_post_layout()
	{

		$seedone_layout = seedone_option('blog_single_layout', '') ? seedone_option('blog_single_layout', '') : 'default';

		//override option for demo purposes
		if (isset($_GET['blog_single_layout'])) {
			$seedone_layout_id = absint($_GET['blog_single_layout']);
			$seedone_layouts   = array_keys(seedone_get_post_layout_options());
			$seedone_layout    = !empty($seedone_layouts[$seedone_layout_id]) ? $seedone_layouts[$seedone_layout_id] : $seedone_layout;
		}

		return $seedone_layout;
	}
endif;

if (!function_exists('seedone_body_classes')) :
	/**
	 * Adds custom classes to the array of body classes.
	 *
	 * @param array $seedone_classes Classes for the body element.
	 *
	 * @return array
	 */
	function seedone_body_classes($seedone_classes)
	{
		//header-empty
		if (is_page_template('page-templates/empty-page.php')) {
			$seedone_classes[] = 'header-empty';
		}

		//header sticky
		if (has_nav_menu('side') || is_active_sidebar('sidebar-side')) {
			$seedone_classes[] = 'has-side-nav';
			$seedone_classes[] = seedone_option('side_nav_position', '') ? 'side-nav-right' : 'side-nav-left';
			$seedone_classes[] = seedone_option('side_nav_sticked', '') ? 'side-nav-sticked' : '';
			$seedone_classes[] = seedone_option('side_nav_header_overlap', '') ? 'side-nav-header-overlap' : '';
		}

		// Adds a class of hfeed to non-singular pages.
		if (!is_singular()) {
			$seedone_classes[] = 'hfeed';
		} else {
			//add 'singular' class for single post or page or any other post type
			$seedone_classes[] = 'singular';
		}

		//Adds a sidebar classes
		$seedone_css_classes = seedone_get_layout_css_classes();

		$seedone_classes[] = $seedone_css_classes['body'];

		//Add icons in meta classes
		//single post
		if (is_singular()) {

			$seedone_hide_meta_icons = seedone_option('blog_single_hide_meta_icons', false);

			//blog loop
		} else {

			$seedone_hide_meta_icons = seedone_option('blog_hide_meta_icons', false);
		}
		if ($seedone_hide_meta_icons) {
			$seedone_classes[] = 'meta-icons-hidden';
		}

		//container width
		$seedone_container_width      = seedone_option('main_container_width', '1170');
		$seedone_container_post_width = seedone_option('blog_single_container_width', '');
		$seedone_container_blog_width = seedone_option('blog_container_width', '');
		if (is_singular('post') && !empty($seedone_container_post_width)) {
			$seedone_container_width = $seedone_container_post_width;
		}
		if ((is_home() || is_category() || is_tag() || is_date() || is_author()) && !empty($seedone_container_blog_width)) {
			$seedone_container_width = $seedone_container_blog_width;
		}
		if ('1520' === $seedone_container_width) {
			$seedone_classes[] = 'container-1520';
		}
		if ('1170' === $seedone_container_width) {
			$seedone_classes[] = 'container-1170';
		}
		if ('960' === $seedone_container_width) {
			$seedone_classes[] = 'container-960';
		}
		if ('720' === $seedone_container_width) {
			$seedone_classes[] = 'container-720';
		}

		//meta icons color class
		$seedone_meta_icons_color = seedone_option('color_meta_icons', '');
		if ($seedone_meta_icons_color) {
			$seedone_classes[] = esc_attr($seedone_meta_icons_color);
		}

		//shop class
		if (class_exists('WooCommerce')) {
			$seedone_classes[] = 'woo';
		}

		//header class
		if ('always-sticky' === seedone_option('header_sticky', '')) {
			$seedone_classes[] = 'header-sticky';
		}

		//animation enabled
		$seedone_animation = seedone_option('animation_enabled', '');
		if (!empty($seedone_animation)) {
			$seedone_classes[] = 'animation-enabled';
		}

		//title section enabled
		$seedone_title = seedone_is_title_section_is_shown();
		if (empty($seedone_title)) {
			$seedone_classes[] = 'title-hidden';
		}

		return $seedone_classes;
	}
endif;
add_filter('body_class', 'seedone_body_classes');

//markup for animated page elements
if (!function_exists('seedone_animated_elements_markup')) :
	function seedone_animated_elements_markup()
	{
		$seedone_animation = seedone_option('animation_enabled', '');
		if (empty($seedone_animation)) {
			return;
		}

		//get animations array from customizer. Keys - selectors
		$seedone_animations = array(
			'.column-aside .widget'            => seedone_option('animation_sidebar_widgets', ''),
			'.footer-widgets .widget'          => seedone_option('animation_footer_widgets', ''),
			'.hfeed article.post'              => seedone_option('animation_feed_posts', ''),
			'.hfeed .post .post-thumbnail img' => seedone_option('animation_feed_posts_thumbnail', ''),
		);

		$seedone_animations = array_filter($seedone_animations);
		if (!empty($seedone_animations)) :
?>
			data-animate='<?php echo esc_attr(str_replace('&quot;', '"', json_encode($seedone_animations))); ?>'
		<?php
		endif;
	}
endif;

//markup for sticky post label
if (!function_exists('seedone_sticky_post_label')) :
	function seedone_sticky_post_label()
	{
		if (is_sticky() && is_home() && !is_paged()) :
		?>
			<span class="icon-inline sticky-post">
				<?php seedone_icon('pin'); ?>
				<span><?php echo esc_html_x('Featured', 'post', 'seedone'); ?></span>
			</span><!-- .sticky-post -->
			<?php
		endif; //is_sticky()
	}
endif;

//arguments for link pages
if (!function_exists('seedone_get_wp_link_pages_atts')) :
	function seedone_get_wp_link_pages_atts()
	{
		return apply_filters(
			'seedone_link_pages_atts',
			array(
				'before'      => '<div class="page-links"><span class="screen-reader-text">' . esc_html__('Pages: ', 'seedone') . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
			)
		);
	}
endif;

//arguments for link pages
if (!function_exists('seedone_get_the_posts_pagination_atts')) :
	function seedone_get_the_posts_pagination_atts()
	{
		return array(
			'mid_size'  => 5,
			'prev_text' => '<span class="screen-reader-text">' . esc_html__('Previous page', 'seedone') . '</span><span class="icon-inline">' . seedone_icon('chevron-left', true) . '</span>',
			'next_text' => '<span class="screen-reader-text">' . esc_html__('Next page', 'seedone') . '</span><span class="icon-inline">' . seedone_icon('chevron-right', true) . '</span>',
		);
	}
endif;

//get top level menu items count
if (!function_exists('seedone_get_menu_top_level_items_count')) :
	function seedone_get_menu_top_level_items_count($seedone_menu_name)
	{

		$seedone_locations   = get_nav_menu_locations();
		$seedone_menu_id     = $seedone_locations[$seedone_menu_name];
		$seedone_menu_object = wp_get_nav_menu_object($seedone_menu_id);
		if (empty($seedone_menu_object)) {
			return '-1';
		}

		$seedone_menu_items       = wp_get_nav_menu_items($seedone_menu_object->term_id);
		$seedone_menu_items_count = 0;

		foreach ((array) $seedone_menu_items as $seedone_key => $seedone_menu_item) {
			if ('0' === $seedone_menu_item->menu_item_parent) {
				$seedone_menu_items_count++;
			}
		}

		return $seedone_menu_items_count;
	}
endif;

//get menu class depending on menu top level items count
if (!function_exists('seedone_get_menu_class_based_on_top_items_count')) :
	function seedone_get_menu_class_based_on_top_items_count($seedone_menu_name)
	{

		$seedone_menu_items_count = seedone_get_menu_top_level_items_count($seedone_menu_name);
		if ('-1' === $seedone_menu_items_count) {
			return 'menu-empty';
		}

		$seedone_css_class = 'menu-low-items';

		if ($seedone_menu_items_count > 6) {
			$seedone_css_class = 'menu-many-items';
		}

		return $seedone_css_class;
	}
endif;


//print svg icon
if (!function_exists('seedone_icon')) :
	function seedone_icon($seedone_name, $seedone_return = false, $seedone_container_css_class = 'svg-icon')
	{
		//in the future we'll add option for this
		$seedone_icons_pack = 'google';

		if ($seedone_return) {
			ob_start();
		}

		echo '<span class="' . esc_attr($seedone_container_css_class) . ' icon-' . esc_attr($seedone_name) . '">';
		get_template_part('/template-parts/svg/' . $seedone_icons_pack . '/' . $seedone_name);
		echo '</span>';

		if ($seedone_return) {
			return ob_get_clean();
		}
	}
endif;

//print social link
if (!function_exists('seedone_social_link')) :
	function seedone_social_link($seedone_name, $seedone_url)
	{
		echo '<a href="' . esc_url($seedone_url) . '" target="_blank" class="social-icon border-icon rounded-icon social-icon-' . esc_attr($seedone_name) . '">';
		seedone_icon($seedone_name);
		echo '</a>';
	}
endif;

//meta
//get meta array
if (!function_exists('seedone_get_theme_meta')) :
	function seedone_get_theme_meta($seedone_meta_names = array())
	{
		/*
		customizer options with meta are:
			'meta_email'
			'meta_email_label'
			'meta_phone'
			'meta_phone_label'
			'meta_address'
			'meta_address_label'
			'meta_opening_hours'
			'meta_opening_hours_label'
		*/

		//if no names specified - using all meta
		if (empty($seedone_meta_names)) :
			$seedone_meta_names = array(
				'email',
				'phone',
				'address',
				'opening_hours',
			);
		endif;

		$seedone_theme_meta = array();

		//meta values
		foreach ($seedone_meta_names as $seedone_meta_name) {
			$seedone_value = seedone_option('meta_' . $seedone_meta_name);
			if (!empty($seedone_value)) {
				$seedone_theme_meta[$seedone_meta_name] = $seedone_value;
			}
		}

		//labels for meta if it is not empty
		if (!empty($seedone_theme_meta)) {
			foreach ($seedone_theme_meta as $seedone_meta_name => $seedone_meta_value) {
				$seedone_label = seedone_option('meta_' . $seedone_meta_name . '_label');
				if (!empty($seedone_label)) {
					$seedone_theme_meta[$seedone_meta_name . '_label'] = $seedone_label;
				}
			}
		}

		return $seedone_theme_meta;
	}
endif;

//print all social links based on theme_meta from Customizzer
if (!function_exists('seedone_social_links')) :
	function seedone_social_links($wrapper_class = '')
	{

		$seedone_facebook  = seedone_option('meta_facebook');
		$seedone_twitter   = seedone_option('meta_twitter');
		$seedone_youtube   = seedone_option('meta_youtube');
		$seedone_instagram = seedone_option('meta_instagram');
		$seedone_pinterest = seedone_option('meta_pinterest');
		$seedone_linkedin  = seedone_option('meta_linkedin');
		$seedone_github    = seedone_option('meta_github');

		if (
			!empty($seedone_facebook)
			||
			!empty($seedone_twitter)
			||
			!empty($seedone_youtube)
			||
			!empty($seedone_instagram)
			||
			!empty($seedone_pinterest)
			||
			!empty($seedone_linkedin)
			||
			!empty($seedone_github)
		) :

			if ($wrapper_class) {
				echo '<div class="' . esc_attr($wrapper_class) . '">';
			}
			echo '<span class="social-links">';

			if (!empty($seedone_facebook)) :
				seedone_social_link('facebook', $seedone_facebook);
			endif;

			if (!empty($seedone_twitter)) :
				seedone_social_link('twitter', $seedone_twitter);
			endif;

			if (!empty($seedone_youtube)) :
				seedone_social_link('youtube', $seedone_youtube);
			endif;

			if (!empty($seedone_instagram)) :
				seedone_social_link('instagram', $seedone_instagram);
			endif;

			if (!empty($seedone_pinterest)) :
				seedone_social_link('pinterest', $seedone_pinterest);
			endif;

			if (!empty($seedone_linkedin)) :
				seedone_social_link('linkedin', $seedone_linkedin);
			endif;

			if (!empty($seedone_github)) :
				seedone_social_link('github-circle', $seedone_github);
			endif;

			echo '</span><!--.social-links-->';
			if ($wrapper_class) {
				echo '</div><!--' . esc_html($wrapper_class) . '-->';
			}

		endif;
	}
endif;

if (!function_exists('seedone_has_post_thumbnail')) :
	/**
	 * Check if has post thumbnail and thumbnail file exists
	 */
	function seedone_has_post_thumbnail($seedone_id = false)
	{
		if (empty($seedone_id)) {
			$seedone_id = get_the_ID();
		}

		return !(post_password_required($seedone_id)
			||
			is_attachment()
			||
			!has_post_thumbnail($seedone_id)
			||
			!file_exists(get_attached_file(get_post_thumbnail_id($seedone_id))));
	}
endif;

if (!function_exists('seedone_post_thumbnail')) :
	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function seedone_post_thumbnail($seedone_size = 'post-thumbnail', $seedone_css_class = '', $show_categories = false)
	{

		if (
			!seedone_has_post_thumbnail()
		) {
			return;
		}

		//detect video
		$oembed_url = false;
		$oembed_post_thumbnail = false;
		//only video post format
		if ('video' === get_post_format()) {
			$oembed_post_thumbnail = true;
		}

		if ($oembed_post_thumbnail) {
			$post_content = get_the_content();
			//get oEmbed URL
			$reg = preg_match('|^\s*(https?://[^\s"]+)\s*$|im', $post_content, $matches);

			$oembed_url = !empty($reg) ? trim($matches[0]) : false;
			//if no youtube, trying to find self hosted

			$first_self_hosted = '';
			$embeds = array();
			if (empty($oembed_url)) {
				$post_content = apply_filters('the_content', $post_content);
				$embeds = get_media_embedded_in_content($post_content);
			}
		}

		if (is_singular()) :
			if (($oembed_url || !empty($embeds[0]))) :
				//if youtube
				if ($oembed_url) :
					add_filter('the_content', function ($content) use ($oembed_url) {
						//remove embed
						$content = str_replace($oembed_url, '', $content);
						//hide embed wrapper
						$pos = strpos($content, 'class="wp-block-embed');
						if ($pos !== false) {
							$content = substr_replace($content, 'class="d-none wp-block-embed', $pos, strlen('class="wp-block-embed'));
						}
						return $content;
						//1 - to run early
					}, 1);
			?>
					<figure class="wp-block-embed wp-embed-aspect-16-9 post-thumbnail mb-0">
						<div class="wp-block-embed__wrapper" itemprop="video" itemscope="itemscope" itemtype="https://schema.org/VideoObject">
							<?php

							echo wp_oembed_get($oembed_url);

							$thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');

							if ($thumbnail_url) :
							?>
								<meta itemprop="thumbnailUrl" content="<?php echo esc_url($thumbnail_url); ?>">
							<?php
							endif; //thumbnail_url
							?>
							<meta itemprop="uploadDate" content="<?php echo esc_attr(the_time(get_option('date_format'))); ?>">
							<meta itemprop="contentUrl" content="<?php echo esc_url($oembed_url); ?>">
							<?php
							the_title('<h3 class="d-none" itemprop="name">', '</h3>');
							?>
							<p class="d-none" itemprop="description">
								<?php echo wp_kses(get_the_excerpt(), false); ?>
							</p>
						</div>
					</figure><!-- .post-thumbnail -->
				<?php
				//self hosted
				else :
					$embed = (!empty($embeds[0])) ? $embeds[0] : false;
					$url = preg_match('`src="(.*)"`', $embed, $founds);
					$hosted_video_url = !empty($founds['1']) ? $founds['1'] : '';
					add_filter('the_content', function ($content) use ($embed) {
						//remove embed
						$content = str_replace($embed, '', $content);
						//hide embed wrapper
						$pos = strpos($content, 'class="wp-block-video');
						if ($pos !== false) {
							$content = substr_replace($content, 'class="d-none wp-block-video', $pos, strlen('class="wp-block-embed'));
						}
						return $content;
						//1 - to run early
					}, 1);
				?>
					<figure class="post-thumbnail mb-0">
						<div class="wp-block-video" itemprop="video" itemscope="itemscope" itemtype="https://schema.org/VideoObject">
							<?php
							echo wp_kses_post($embed);
							$thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
							if ($thumbnail_url) :
							?>
								<meta itemprop="thumbnailUrl" content="<?php echo esc_url($thumbnail_url); ?>">
							<?php
							endif; //thumbnail_url
							?>
							<meta itemprop="uploadDate" content="<?php echo esc_attr(the_time(get_option('date_format'))); ?>">
							<meta itemprop="contentUrl" content="<?php echo esc_url($hosted_video_url); ?>">
							<?php
							the_title('<h3 class="d-none" itemprop="name">', '</h3>');
							?>
							<p class="d-none" itemprop="description">
								<?php echo wp_kses(get_the_excerpt(), false); ?>
							</p>
						</div>
					</figure><!-- .post-thumbnail -->
				<?php
				endif; //$oembed_url
			//not video
			else :
				?>
				<figure class="<?php echo esc_attr('post-thumbnail ' . $seedone_css_class); ?>">
					<?php
					if ($show_categories) {
						seedone_entry_meta(false, false, true, false, false);
					}
					the_post_thumbnail(
						$seedone_size,
						array(
							'itemprop' => 'image',
							'alt'      => get_the_title(),
						)
					);
					?>
				</figure><!-- .post-thumbnail -->
			<?php
			//oembed
			endif;
		//not is_singular
		//archive
		else :

			//detecting gallery
			$is_gallery = false;
			$gallery_css_class = '';
			if ('gallery' === get_post_format()) {
				$galleries_images = get_post_galleries_images();
				//gutenberg block parse
				if (empty($galleries_images)) {
					global $post;
					if (has_block('gallery', $post->post_content)) {
						$post_blocks = parse_blocks($post->post_content);
						foreach ($post_blocks as $block) {
							if ('core/gallery' === $block['blockName']) {
								$src_array = array();
								foreach ($block['attrs']['ids'] as $id) {
									$src_array[] = wp_get_attachment_image_url($id, 'seedone-default-post');
								}
								$galleries_images[] = $src_array;
								break;
							}
						}
					}
				}

				$galleries_images_count = count($galleries_images);
				if ($galleries_images_count) {
					$is_gallery = true;
					$gallery_css_class = 'item-media-gallery';
				}
			} //gallery post format

			?>
			<div class="post-thumbnail-wrap">
				<?php
				if ($show_categories) {
					seedone_entry_meta(false, false, true, false, false);
				}
				?>
				<figure class="<?php echo esc_attr('post-thumbnail ' . $seedone_css_class); ?>">
					<a href="<?php

								if (empty($oembed_url)) {
									the_permalink();
								} else {
									echo esc_url($oembed_url);
								}

								?>">
						<?php

						if (empty($is_gallery)) {


							the_post_thumbnail(
								$seedone_size,
								array(
									'itemprop' => 'image',
									'alt'      => get_the_title(),
								)
							);
						} else {
							//gallery

							echo '<div class="flexslider"><ul class="slides">';

							//adding featured image as a first element in carousel

							//featured image url
							$post_featured_image_src = wp_get_attachment_image_url(get_post_thumbnail_id(), 'seedone-default-post');

							if ($post_featured_image_src) : ?>
								<li><img src="<?php echo esc_url($post_featured_image_src); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
								</li>
								<?php endif;
							$count = 1;
							foreach ($galleries_images as $gallerie) :
								foreach ($gallerie as $src) :
									//showing only 3 images from gallery
									if ($count > 3) {
										break 2;
									}
								?>
									<li><img src="<?php echo esc_url($src); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
									</li>
						<?php
									$count++;
								endforeach;
							endforeach;
							echo '</ul></div><!--.flexslider-->';
						}
						seedone_post_format_icon(get_post_format());
						?>
					</a>
				</figure>
			</div>
			<!-- post-thumbnail-wrap -->
		<?php
		endif; // End is_singular().
	}
endif; //seedone_post_thumbnail

//print post format icon
if (!function_exists('seedone_post_format_icon')) :
	function seedone_post_format_icon($seedone_post_format = '')
	{
		// 'video', 'audio', 'image', 'gallery', 'quote'
		switch ($seedone_post_format):
			case 'video':
				seedone_icon('video');
				break;
			case 'audio':
				seedone_icon('volume-high');
				break;
			case 'image':
				seedone_icon('image');
				break;
				/*case 'gallery':
				seedone_icon('camera');
				break;*/
			case 'quote':
				seedone_icon('format-quote-close');
				break;

			default:
		endswitch;
	}
endif;


if (!function_exists('seedone_the_author')) :
	/*
		** Prints author HTML with with link on author archive.
		 */
	function seedone_the_author()
	{

		//options
		//single post
		if (is_singular()) {

			$seedone_show_author   = seedone_option('blog_single_show_author', true);
			$seedone_author_avatar = seedone_option('blog_single_show_author_avatar', '');
			$seedone_author_word   = seedone_option('blog_single_before_author_word', '');
			$seedone_show_icons    = !seedone_option('blog_single_hide_meta_icons', false);

			//blog loop
		} else {

			$seedone_show_author   = seedone_option('blog_show_author', true);
			$seedone_author_avatar = seedone_option('blog_show_author_avatar', '');
			$seedone_author_word   = seedone_option('blog_before_author_word', '');
			$seedone_show_icons    = !seedone_option('blog_hide_meta_icons', false);
		}

		if (!empty($seedone_show_author)) :
			//author-wrapper
			if (!empty($seedone_author_avatar)) :
				echo '<span class="author-avatar">';
				$seedone_author_id        = get_the_author_meta('ID');
				$seedone_custom_image_url = get_the_author_meta('custom_profile_image', $seedone_author_id);
				if (!empty($seedone_custom_image_url)) {
					echo '<img src="' . esc_url($seedone_custom_image_url) . '" alt="' . esc_attr(get_the_author_meta('display_name', $seedone_author_id)) . '">';
				} else {
					echo get_avatar($seedone_author_id, 100);
				}
				echo '</span><!-- .author-avatar-->';
			endif; //$seedone_author_avatar
		?>
			<span class="entry-author-wrap icon-inline">
				<?php
				//icon
				if (!empty($seedone_show_icons)) {
					seedone_icon('user');
				}

				//word
				if (!empty($seedone_author_word)) :
				?>
					<span class="entry-author-word meta-word">
						<?php echo esc_html($seedone_author_word); ?>
					</span>
					<!--.entry-author-word-->
				<?php
				endif;
				//value
				?>
				<span class="vcard author" itemtype="https://schema.org/Person" itemscope="itemscope" itemprop="author">
					<?php
					the_author_posts_link();
					?>
				</span><!-- .author -->
			</span>
			<!--.entry-author-wrap-->
			<!-- publisher -->
			<div class="hidden" itemprop="publisher" itemtype="http://schema.org/Organization" itemscope="itemscope">
				<span itemprop="name"><?php the_author(); ?></span>
				<?php
				$seedone_custom_logo = seedone_option('custom_logo');
				if (!empty($seedone_custom_logo)) :
				?>
					<span itemprop="logo" itemscope="itemscope" itemtype="https://schema.org/ImageObject">
						<?php
						$seedone_custom_logo_metadata = !empty($seedone_custom_logo) ? wp_get_attachment_metadata($seedone_custom_logo) : array(
							'width'  => '0',
							'height' => '0',
						);
						echo wp_get_attachment_image($seedone_custom_logo, 'full');
						?>
						<meta itemprop="url" content="<?php echo esc_url(home_url('/')); ?>" />
						<meta itemprop="width" content="<?php echo esc_attr($seedone_custom_logo_metadata['width']); ?>" />
						<meta itemprop="height" content="<?php echo esc_attr($seedone_custom_logo_metadata['height']); ?>" />
					</span>
				<?php endif; //custom_logo 
				?>
			</div>
			<!-- publisher -->
		<?php
		endif; //author
	}
endif; //seedone_the_author

add_filter('the_author_posts_link', 'seedone_the_author_link_itemprop');
if (!function_exists('seedone_the_author_link_itemprop')) :
	/**
	 * Add 'itemprop' attribute to the author link.
	 */
	function seedone_the_author_link_itemprop($seedone_link)
	{
		$seedone_link = str_replace('rel="author">', 'rel="author" itemprop="url"><span itemprop="name">', $seedone_link);
		$seedone_link = str_replace('</a>', '</span></a>', $seedone_link);

		return $seedone_link;
	}
endif;

if (!function_exists('seedone_the_date')) :
	/**
	 * Prints date HTML with the post link on blog.
	 */
	function seedone_the_date()
	{

		//options
		//single post
		if (is_singular()) {

			$seedone_show_date  = seedone_option('blog_single_show_date', true);
			$seedone_date_word  = seedone_option('blog_single_before_date_word', '');
			$seedone_show_icons = !seedone_option('blog_single_hide_meta_icons', false);

			//blog loop
		} else {

			$seedone_show_date  = seedone_option('blog_show_date', true);
			$seedone_date_word  = seedone_option('blog_before_date_word', '');
			$seedone_show_icons = !seedone_option('blog_hide_meta_icons', false);
		}

		if (!empty($seedone_show_date)) :
			//date-wrapper
		?>
			<span class="entry-date-wrap icon-inline">
				<?php

				//icon
				if (!empty($seedone_show_icons)) {
					seedone_icon('clock-outline');
				}

				//word
				if (!empty($seedone_date_word)) :
				?>
					<span class="date-word meta-word">
						<?php echo esc_html($seedone_date_word); ?>
					</span>
					<!--.date-word-->
				<?php
				endif;
				//value
				//link date to post on archive
				if (!is_singular()) :
				?>
					<a href="<?php echo esc_url(get_permalink()); ?>" rel="bookmark" itemprop="mainEntityOfPage">
					<?php endif; //is_singular 
					?>
					<span itemprop="datePublished"><?php the_time(get_option('date_format')); ?></span>
					<span class="hidden" itemprop="dateModified"><?php the_modified_time(get_option('date_format')); ?></span>
					<?php if (!is_singular()) : ?>
					</a>
				<?php endif; //is_singular 
				?>
			</span>
			<!--.entry-date-wrap-->
			<?php
		endif; //date
	}
endif; //seedone_the_date

if (!function_exists('seedone_the_categories')) :
	/**
	 * Prints categories HTML for the current post.
	 */

	function seedone_the_categories()
	{

		//options
		//single post
		if (is_singular()) {

			$seedone_show_categories = seedone_option('blog_single_show_categories', true);
			$seedone_categories_word = seedone_option('blog_single_before_categories_word', '');
			$seedone_show_icons      = !seedone_option('blog_single_hide_meta_icons', false);

			//blog loop
		} else {

			$seedone_show_categories = seedone_option('blog_show_categories', true);
			$seedone_categories_word = seedone_option('blog_before_categories_word', '');
			$seedone_show_icons      = !seedone_option('blog_hide_meta_icons', false);
		}

		if (!empty($seedone_show_categories)) :
			$seedone_c = wp_get_post_categories(get_the_ID());

			//only if categories exists
			if (!empty($seedone_c)) :

				//categories-wrapper
			?>
				<span class="entry-categories-wrap icon-inline">
					<?php

					//icon
					if (!empty($seedone_show_icons)) {
						seedone_icon('folder-outline');
					}

					//word
					if (!empty($seedone_categories_word)) :
					?>
						<span class="categories-word meta-word">
							<?php echo esc_html($seedone_categories_word); ?>
						</span>
						<!--.categories-word-->
					<?php
					endif;

					//value
					?>
					<span class="categories-list">
						<?php
						echo wp_kses_post(get_the_category_list('<span class="entry-categories-separator"> </span>'));
						?>
					</span>
					<!--.categories-list-->
				</span>
				<!--.entry-categories-wrap-->
			<?php
			endif; //$seedone_c
		endif; //categories
	}
endif; //seedone_the_categories

if (!function_exists('seedone_the_tags')) :
	/**
	 * Prints tags HTML for the current post.
	 */
	function seedone_the_tags()
	{

		//options
		//single post
		if (is_singular()) {

			$seedone_show_tags  = seedone_option('blog_single_show_tags', true);
			$seedone_tags_word  = seedone_option('blog_single_before_tags_word', '');
			$seedone_show_icons = !seedone_option('blog_single_hide_meta_icons', false);

			//blog loop
		} else {

			$seedone_show_tags  = seedone_option('blog_show_tags', true);
			$seedone_tags_word  = seedone_option('blog_before_tags_word', '');
			$seedone_show_icons = !seedone_option('blog_hide_meta_icons', false);
		}

		if (!empty($seedone_show_tags)) :

			$seedone_t = wp_get_post_tags(get_the_ID());

			//only if tags exists
			if (!empty($seedone_t)) :

				//tags-wrapper
			?>
				<span class="entry-tags-wrap icon-inline">
					<?php

					//icon
					if (!empty($seedone_show_icons)) {
						seedone_icon('tag');
					}

					//word
					if (!empty($seedone_tags_word)) :
					?>
						<span class="tags-word meta-word">
							<?php echo esc_html($seedone_tags_word); ?>
						</span>
						<!--.tags-word-->
					<?php
					endif; //tags_word

					//value
					?>
					<span class="tags-list">
						<?php
						echo wp_kses_post(get_the_tag_list('<span class="entry-tags">', '<span class="entry-tags-separator"> </span>', '</span>'));
						?>
					</span>
					<!--.tags-list-->
				</span>
				<!--.entry-tags-wrap-->
				<?php
			endif; //$seedone_t
		endif; //tags
	}
endif; //seedone_the_tags

if (!function_exists('seedone_comment_count')) :
	/**
	 * Prints HTML with the comment count for the current post.
	 */
	function seedone_comment_count()
	{

		//options
		//single post
		if (is_singular()) {

			$seedone_show_comments = seedone_option('blog_single_show_comments_link', 'number');
			$seedone_show_icons    = !seedone_option('blog_single_hide_meta_icons', false);

			//blog loop
		} else {

			$seedone_show_comments = seedone_option('blog_show_comments_link', 'number');
			$seedone_show_icons    = !seedone_option('blog_hide_meta_icons', false);
		}

		if (!post_password_required() && (comments_open() || get_comments_number()) && $seedone_show_comments) :
			switch ($seedone_show_comments):
				case 'number':
				?>
					<span class="comments-link icon-inline">
						<?php
						if (!empty($seedone_show_icons)) {
							seedone_icon('comment-outline');
						}
						$comments_count = get_comments_number();
						comments_popup_link($comments_count, $comments_count, $comments_count);
						?>
					</span><!-- .comments-link -->
				<?php
					break;
					//text
				default:
				?>
					<span class="comments-link icon-inline">
						<?php

						if (!empty($seedone_show_icons)) {
							seedone_icon('comment-outline');
						}
						?>

						<?php

						comments_popup_link(
							sprintf(
								wp_kses(
									/* translators: %s: Name of current post. Only visible to screen readers. */
									__(' Leave a comment<span class="screen-reader-text"> on %s</span>', 'seedone'),
									array(
										'span' => array(
											'class' => array(),
										),
									)
								),
								get_the_title()
							)
						);
						?>
					</span><!-- .comments-link -->
			<?php
			endswitch;
		endif; //show_comments
	}
endif;

if (!function_exists('seedone_the_view')) :
	/**
	 * Prints date HTML with the post link on blog.
	 */
	function seedone_the_view()
	{

		//options
		//single post
		if (is_singular()) {

			$blog_show_views  = seedone_option('blog_single_show_views', true);
			$blog_before_views_word  = seedone_option('blog_single_before_views_word', '');
			$seedone_show_icons = !seedone_option('blog_single_hide_meta_icons', false);

			//blog loop
		} else {

			$blog_show_views  = seedone_option('blog_show_views', true);
			$blog_before_views_word  = seedone_option('blog_before_views_word', '');
			$seedone_show_icons = !seedone_option('blog_hide_meta_icons', false);
		}

		if (!empty($blog_show_views) && function_exists('seedone_show_post_views_count')) :
			//date-wrapper
			?>
			<span class="entry-view-wrap icon-inline">
				<?php

				//icon
				if (!empty($seedone_show_icons)) {
					seedone_icon('eye');
				}

				//word
				if (!empty($blog_before_views_word)) :
				?>
					<span class="date-word meta-word">
						<?php echo esc_html($blog_before_views_word); ?>
					</span>
					<!--.date-word-->
			<?php
				endif;
				seedone_show_post_views_count();
				echo '</span>';
			endif; //date
		}
	endif; //seedone_the_date

	if (!function_exists('seedone_entry_meta')) :
		/**
		 * Prints HTML with the comment count for the current post.
		 */

		function seedone_entry_meta($seedone_show_author = true, $seedone_show_date = true, $seedone_show_categories = true, $seedone_show_tags = true, $seedone_show_comments = true, $seedone_the_view = true)
		{

			if (!empty($seedone_show_author)) :
				seedone_the_author();
			endif; //author

			if (!empty($seedone_the_view)) :
				seedone_the_view();
			endif; //tags

			if (!empty($seedone_show_comments)) :
				seedone_comment_count();
			endif; //comments

			if (!empty($seedone_show_date)) :
				seedone_the_date();
			endif; //date

			if (!empty($seedone_show_categories)) :
				seedone_the_categories();
			endif; //categories

			if (!empty($seedone_show_tags)) :
				seedone_the_tags();
			endif; //tags

		}
	endif;


	if (!function_exists('seedone_post_nav')) :
		/**
		 * Display navigation to next/previous post when applicable.
		 */
		function seedone_post_nav()
		{

			$seedone_blog_single_post_nav = seedone_option('blog_single_post_nav', '');

			if (empty($seedone_blog_single_post_nav)) {
				return;
			}

			// Don't print empty markup if there's nowhere to navigate.
			$seedone_previous = (is_attachment()) ? get_post(get_post()->post_parent) : get_adjacent_post(false, '', true);
			$seedone_next     = get_adjacent_post(false, '', false);

			if (!$seedone_next && !$seedone_previous) {
				return;
			}

			$seedone_word_prev = seedone_option('blog_single_post_nav_word_prev', esc_html__('Prev', 'seedone'));
			$seedone_word_next = seedone_option('blog_single_post_nav_word_next', esc_html__('Next', 'seedone'));
			?>
			<nav class="post-nav post-nav-layout-<?php echo esc_attr($seedone_blog_single_post_nav); ?>">
				<?php

				if (is_attachment() && 'attachment' === $seedone_previous->post_type) {
					return;
				}

				if ($seedone_previous && has_post_thumbnail($seedone_previous->ID)) {
					$seedone_prevthumb = wp_get_attachment_image_src(get_post_thumbnail_id($seedone_previous->ID), 'post-thumbnail');
					if ($seedone_prevthumb) {
						$seedone_prevthumb_sm         = wp_get_attachment_image_src(get_post_thumbnail_id($seedone_previous->ID), 'thumbnail');
						$seedone_prev_thumbnail_style = ' style="background-image: url(' . esc_url($seedone_prevthumb[0]) . '); "';
						$seedone_prev_thumbnail_class = 'has-image background-cover background-overlay';
						$seedone_prev_thumbnail_img   = '<span class="post-nav-thumb"><img src="' . esc_url($seedone_prevthumb_sm[0]) . '" alt="' . $seedone_previous->post_title . '"></span>';
					} else {
						$seedone_prev_thumbnail_style = '';
						$seedone_prev_thumbnail_class = 'no-image';
						$seedone_prev_thumbnail_img   = '';
					}
				} else {
					$seedone_prev_thumbnail_style = '';
					$seedone_prev_thumbnail_class = 'no-image';
					$seedone_prev_thumbnail_img   = '';
				}

				if ($seedone_next && has_post_thumbnail($seedone_next->ID)) {
					$seedone_nextthumb = wp_get_attachment_image_src(get_post_thumbnail_id($seedone_next->ID), 'post-thumbnail');
					if ($seedone_nextthumb) {
						$seedone_nextthumb_sm         = wp_get_attachment_image_src(get_post_thumbnail_id($seedone_next->ID), 'thumbnail');
						$seedone_next_thumbnail_style = ' style="background-image: url(' . esc_url($seedone_nextthumb[0]) . '); "';
						$seedone_next_thumbnail_class = 'has-image background-cover background-overlay';
						$seedone_next_thumbnail_img   = '<span class="post-nav-thumb"><img src="' . esc_url($seedone_nextthumb_sm[0]) . '" alt="' . $seedone_next->post_title . '"></span>';
					} else {
						$seedone_next_thumbnail_style = '';
						$seedone_next_thumbnail_class = 'no-image';
						$seedone_next_thumbnail_img   = '';
					}
				} else {
					$seedone_next_thumbnail_style = '';
					$seedone_next_thumbnail_class = 'no-image';
					$seedone_next_thumbnail_img   = '';
				}

				//layouts
				switch ($seedone_blog_single_post_nav):
					case 'bg':
						echo '<div>';
						previous_post_link(
							'%link',
							'<div class="post-nav-item bg-item prev-item ' . esc_attr($seedone_prev_thumbnail_class) . '"' . $seedone_prev_thumbnail_style . '>
							<span class="post-nav-arrow">' . seedone_icon('chevron-left', true) . '</span>
							<span class="post-nav-words-wrap">
								<span class="post-nav-word">' . esc_html($seedone_word_prev) . '</span>
								<span class="post-nav-title">%title</span>
							</span>
						</div>',
							false,
							''
						);
						echo '</div>';

						echo '<div>';
						next_post_link(
							'%link',
							'<div class="post-nav-item bg-item next-item ' . esc_attr($seedone_next_thumbnail_class) . '"' . $seedone_next_thumbnail_style . '>
							<span class="post-nav-words-wrap">
								<span class="post-nav-word">' . esc_html($seedone_word_next) . '</span>
								<span class="post-nav-title">%title</span>
							</span>
							<span class="post-nav-arrow">' . seedone_icon('chevron-right', true) . '</span>
						</div>',
							false,
							''
						);
						echo '</div>';
						break;
					case 'thumbnail':
						echo '<div>';
						previous_post_link(
							'%link',
							'<div class="post-nav-item prev-item">
							<span class="post-nav-arrow">' . seedone_icon('chevron-left', true) . '</span>
							' . $seedone_prev_thumbnail_img . '
							<span class="post-nav-words-wrap">
								<span class="post-nav-word">' . esc_html($seedone_word_prev) . '</span>
								<span class="post-nav-title">%title</span>
							</span>
						</div>',
							false,
							''
						);
						echo '</div>';

						echo '<div>';
						next_post_link(
							'%link',
							'<div class="post-nav-item next-item">
							<span class="post-nav-words-wrap">
								<span class="post-nav-word">' . esc_html($seedone_word_next) . '</span> 
								<span class="post-nav-title">%title</span>
							</span>
							' . $seedone_next_thumbnail_img . '
							<span class="post-nav-arrow">' . seedone_icon('chevron-right', true) . '</span>
						</div>',
							false,
							''
						);
						echo '</div>';
						break;
						//title
					default:
						echo '<div>';
						previous_post_link(
							'%link',
							'<div class="post-nav-item prev-item">
							<span class="post-nav-arrow">' . seedone_icon('chevron-left', true) . '</span>
							<span class="post-nav-words-wrap">
								<span class="post-nav-word">' . esc_html($seedone_word_prev) . '</span>
								<span class="post-nav-title">%title</span>
							</span>
						</div>',
							false,
							''
						);
						echo '</div>';

						echo '<div>';
						next_post_link(
							'%link',
							'<div class="post-nav-item next-item">
							<span class="post-nav-words-wrap">
								<span class="post-nav-word">' . esc_html($seedone_word_next) . '</span> 
								<span class="post-nav-title">%title</span>
							</span>
							<span class="post-nav-arrow">' . seedone_icon('chevron-right', true) . '</span>
						</div>',
							false,
							''
						);
						echo '</div>';
				endswitch;

				?>
			</nav><!-- .navigation -->
			<?php
		} //seedone_post_nav
	endif;


	if (!function_exists('seedone_section_background_image_array')) :
		/**
		 * Get array of section attributes to display background image.
		 */
		function seedone_section_background_image_array($seedone_section, $seedone_empty_image = false)
		{

			//processing title section background for simple single post 'title-section-image' layout
			if (is_single() && 'title' === $seedone_section) :
				if (seedone_get_post_layout() === 'title-section-image') :
					//if has post thumbnail
					if (!post_password_required() && !is_attachment() && has_post_thumbnail()) {
						return array(
							'url'   => get_the_post_thumbnail_url(get_the_ID(), 'full'),
							'class' => 'i post-thumbnail-background background-cover cover-center background-fixed background-overlay overlay-dark',
						);
					}
				endif;
			endif; //is_single

			//for page with feature image - override default header_image
			if ('header_image' === $seedone_section) {
				$seedone_image = get_header_image();
				//for page with feature image - override default image
				if (is_page()) {
					if (has_post_thumbnail()) {
						$seedone_image = get_the_post_thumbnail_url();
					}
				}
			} else {
				$seedone_image = seedone_option($seedone_section . '_background_image', '');
				// override title background if page featured image is set
				if ('title' === $seedone_section && $seedone_image) {
					//for page with feature image - override default image
					if (is_page()) {
						if (has_post_thumbnail()) {
							$seedone_image = get_the_post_thumbnail_url();
						}
					}
				}
			}

			$seedone_return = array(
				'url'   => $seedone_image,
				'class' => '',
			);

			if (empty($seedone_image) && empty($seedone_empty_image)) {
				return $seedone_return;
			}

			$seedone_cover   = seedone_option($seedone_section . '_background_image_cover', '');
			$seedone_fixed   = seedone_option($seedone_section . '_background_image_fixed', '');
			$seedone_overlay = seedone_option($seedone_section . '_background_image_overlay', '');

			if (!empty($seedone_cover)) {
				$seedone_return['class'] .= 'background-cover cover-center';
			}

			if (!empty($seedone_fixed)) {
				$seedone_return['class'] .= ' background-fixed';
			}

			if (!empty($seedone_overlay)) {
				$seedone_return['class'] .= ' background-overlay ' . $seedone_overlay;
			}

			return $seedone_return;
		}
	endif;

	/////////////
	//Read More//
	/////////////

	// Read more markup inside link for excertp and the_content
	if (!function_exists('seedone_read_more_inside_link_markup')) :
		function seedone_read_more_inside_link_markup($seedone_read_more_text = '')
		{

			if (empty($seedone_read_more_text)) {
				$seedone_read_more_text = seedone_option('blog_read_more_text', '');
			}

			if (empty($seedone_read_more_text)) {
				return '';
			}

			return sprintf(
				wp_kses(
					$seedone_read_more_text . '<span class="screen-reader-text"> "%s"</span>',
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			);
		}
	endif;

	//generated excerpt ending...
	if (!function_exists('seedone_excerpt_more')) :
		function seedone_excerpt_more($seedone_more)
		{
			return '<span class="more-dots">...</span>';
		}
	endif;
	add_filter('excerpt_more', 'seedone_excerpt_more', 21);

	//read more for excerpt
	if (!function_exists('seedone_read_more_markup_excerpt')) :
		function seedone_read_more_markup_excerpt()
		{
			global $post;
			$seedone_markup = ' <span class="more-tag"><a class="more-link" href="' .
				esc_url(get_permalink($post->ID)) . '">' .
				seedone_read_more_inside_link_markup() .
				'</a></span><!-- .more-tag -->';

			return $seedone_markup;
		}
	endif;

	//putting read more text inside excerpt if text is not empty
	if (!function_exists('seedone_read_more_in_excerpt')) :
		function seedone_read_more_in_excerpt($seedone_excerpt)
		{

			$seedone_read_more_text = seedone_option('blog_read_more_text', '');

			if (empty($seedone_read_more_text)) {
				return $seedone_excerpt;
			}

			$seedone_excerpt = str_replace('</p>', seedone_read_more_markup_excerpt($seedone_read_more_text) . '</p>', $seedone_excerpt);

			return $seedone_excerpt;
		}
	endif;
	add_filter('the_excerpt', 'seedone_read_more_in_excerpt', 21);

	//Filter the except length
	if (!function_exists('seedone_excerpt_custom_length')) :
		function seedone_excerpt_custom_length($seedone_length)
		{

			return absint(seedone_option('blog_excerpt_length', 40));
		}
	endif;
	add_filter('excerpt_length', 'seedone_excerpt_custom_length', 999);

	//home page intro teasers
	if (!function_exists('seedone_get_intro_teasers')) :
		function seedone_get_intro_teasers()
		{

			$seedone_teasers = array();

			for ($seedone_i = 1; $seedone_i < 5; $seedone_i++) {
				/*
			reeatable options:
				intro_teaser_image_
				intro_teaser_title_
				intro_teaser_text_
				intro_teaser_link_
				intro_teaser_button_text_
			*/
				$seedone_teasers[$seedone_i] = array_filter(
					array(
						'image'  => seedone_option('intro_teaser_image_' . $seedone_i, ''),
						'title'  => seedone_option('intro_teaser_title_' . $seedone_i, ''),
						'text'   => seedone_option('intro_teaser_text_' . $seedone_i, ''),
						'link'   => seedone_option('intro_teaser_link_' . $seedone_i, ''),
						'button' => seedone_option('intro_teaser_button_text_' . $seedone_i, ''),
					)
				);
			}

			return array_filter($seedone_teasers);
		}
	endif;

	//related posts
	if (!function_exists('seedone_related_posts')) :
		function seedone_related_posts($seedone_id)
		{

			$seedone_layout = seedone_option('blog_single_related_posts', '');
			if (empty($seedone_layout)) {
				return;
			}
			$seedone_tags   = wp_get_post_tags($seedone_id, array('fields' => 'ids'));
			if (!empty($seedone_tags)) :
				//list
				//list-thumbnails
				//grid
				//num of posts
				$seedone_posts_number = absint(seedone_option('blog_single_related_posts_number', 3));
				if (empty($seedone_posts_number)) {
					$seedone_posts_number = 3;
				}

				$seedone_args  = array(
					'tag__in'        => $seedone_tags,
					'post__not_in'   => array($seedone_id),
					'posts_per_page' => $seedone_posts_number,
				);
				$seedone_query = new WP_Query($seedone_args);
				if ($seedone_query->have_posts()) :
					$seedone_related_title = seedone_option('blog_single_related_posts_title', esc_html__('Related Posts', 'seedone'));
			?>
					<div class="related-posts">
						<?php if (!empty($seedone_related_title)) : ?>
							<h5 class="related-posts-heading"><?php esc_html_e('Related Posts', 'seedone'); ?></h5>
							<?php
						endif; //related_title
						switch ($seedone_layout):
							case 'grid':
								switch ($seedone_posts_number):
									case 3:
										$seedone_wrapper_class = 'layout-cols-3';
										break;
									case 4:
										$seedone_wrapper_class = 'layout-cols-4';
										break;
									default:
										$seedone_wrapper_class = '';
								endswitch;
								if ($seedone_query->post_count < 3) {
									$seedone_wrapper_class = 'layout-cols-' . $seedone_query->post_count;
								}
							?>
								<div class="layout-gap-50">
									<div class="grid-wrapper <?php echo esc_attr($seedone_wrapper_class); ?>">
										<?php
										while ($seedone_query->have_posts()) :
											$seedone_query->the_post();
										?>
											<div class=grid-item>
												<article <?php post_class(); ?>>
													<?php if (has_post_thumbnail()) : ?>
														<figure class="post-thumbnail">
															<a href="<?php the_permalink(); ?>">
																<?php the_post_thumbnail('seedone-square'); ?>
															</a>
														</figure>
													<?php endif; ?>
													<div class="item-content">
														<footer class="entry-footer"><?php seedone_entry_meta(false, true, true, false, false); ?></footer>
														<h5>
															<a rel="bookmark" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
														</h5>
													</div>
												</article>
											</div>
										<?php endwhile; ?>
									</div><!-- .grid-wrapper -->
								</div><!-- .layout-gap-* -->
							<?php
								break;

							case 'list-thumbnails':
							?>
								<ul class="posts-list">
									<?php
									while ($seedone_query->have_posts()) :
										$seedone_query->the_post();
									?>
										<li>
											<?php if (has_post_thumbnail()) : ?>
												<a class="posts-list-thumbnail" href="<?php the_permalink(); ?>">
													<?php the_post_thumbnail('thumbnail'); ?>
												</a>
											<?php endif; ?>
											<div class="item-content">
												<h3 class="post-title">
													<a rel="bookmark" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
												</h3>
												<span class="icon-inline post-date">
													<?php seedone_icon('calendar'); ?>
													<span><?php echo get_the_date('', get_the_ID()); ?></span>
												</span>
											</div>
										</li>
									<?php endwhile; ?>
								</ul>
							<?php
								break;

							default:
							?>
								<ul>
									<?php
									while ($seedone_query->have_posts()) :
										$seedone_query->the_post();
									?>
										<li>
											<h6>
												<a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a>
											</h6>
										</li>
									<?php endwhile; ?>
								</ul>
						<?php
						endswitch; //layout
						?>
					</div><!-- .related-posts -->
	<?php
				endif; //have_posts
				wp_reset_postdata();
			endif; //tags
		}
	endif;

	//get any widget HTML markup
	if (!function_exists('seedone_get_the_widget')) :
		function seedone_get_the_widget($seedone_widget_class, $seedone_instance = array())
		{

			if (!class_exists($seedone_widget_class)) {
				return '';
			}
			//same as in inc/setup.php file
			$seedone_args = array(
				'before_title' => '<h3 class="widget-title"><span>',
				'after_title'  => '</span></h3>',
			);

			ob_start();

			the_widget($seedone_widget_class, $seedone_instance, $seedone_args);

			return ob_get_clean();
		}
	endif;

	//count widgets in sidebar
	if (!function_exists('seedone_get_sidebar_widgets_count')) :
		function seedone_get_sidebar_widgets_count($sidebar_id)
		{
			$widgets = get_option('sidebars_widgets');

			return count($widgets[$sidebar_id]);
		}
	endif;

	//detect shop - handy for sidebar and breadcrumbs
	if (!function_exists('seedone_is_shop')) :
		function seedone_is_shop()
		{
			$seedone_return = false;
			if (function_exists('is_woocommerce')) {
				if (is_woocommerce() || is_cart() || is_checkout() || is_account_page()) {
					$seedone_return = true;
				}
			}
			if (function_exists('yith_wcwl_is_wishlist_page')) {
				if (yith_wcwl_is_wishlist_page()) {
					$seedone_return = true;
				}
			}

			return $seedone_return;
		}
	endif;

	//echo breadcrumbs markup
	if (!function_exists('seedone_breadcrumbs')) :
		function seedone_breadcrumbs()
		{
			$seedone_args              = array(
				'before' => '<nav class="breadcrumbs">',
				'after'  => '</nav>',
			);
			$seedone_seo_options       = get_option('wpseo_titles');
			$seedone_args['delimiter'] = !empty($seedone_seo_options['breadcrumbs-sep']) ? $seedone_seo_options['breadcrumbs-sep'] : '/';
			if (seedone_is_shop()) :
				woocommerce_breadcrumb(
					array(
						'wrap_before' => $seedone_args['before'] . '<span>',
						'wrap_after'  => '</span>' . $seedone_args['after'],
						'before'      => '<span class="breadcrumbs_item">',
						'after'       => '</span>',
						'delimiter'   => ' ' . $seedone_args['delimiter'] . ' ',
					)
				);
			elseif (function_exists('yoast_breadcrumb')) :
				yoast_breadcrumb('<nav class="breadcrumbs">', '</nav>');
			elseif (function_exists('rank_math_the_breadcrumbs')) :
				$args = array(
					'delimiter'   => '&nbsp;&#47;&nbsp;',
					'wrap_before' => '<nav class="breadcrumbs">',
					'wrap_after'  => '</nav>',
					'before'      => '',
					'after'       => '',
				);
				rank_math_the_breadcrumbs($args);
			endif;
		}
	endif;

	//check if breadcrumbs are enabled and plugins to show them are active
	if (!function_exists('seedone_breadcrumbs_enabled')) :
		function seedone_breadcrumbs_enabled()
		{
			$seedone_return = seedone_option('title_show_breadcrumbs', true);
			if (seedone_is_shop() && $seedone_return) {
				return $seedone_return;
			} elseif (function_exists('yoast_breadcrumb') && $seedone_return) {
				return $seedone_return;
			} elseif (function_exists('rank_math_the_breadcrumbs') && $seedone_return) {
				return $seedone_return;
			} else {
				return false;
			}
		}
	endif;

	//copyright text - year
	if (!function_exists('seedone_get_copyright_text')) :
		function seedone_get_copyright_text($seedone_text = '')
		{
			$seedone_text = str_replace('[year]', '<span class="copyright-year">' . date('Y') . '</span>', $seedone_text);
			return $seedone_text;
		}
	endif;

	//detect is_front_page and not is paged
	if (!function_exists('seedone_is_front_page')) :
		function seedone_is_front_page()
		{
			return is_front_page();
		}
	endif;

	//detect for displaying title section
	if (!function_exists('seedone_is_title_section_is_shown')) :
		function seedone_is_title_section_is_shown()
		{
			if (is_page_template('page-templates/no-sidebar-no-title.php')) {
				return false;
			}
			$seedone_show_title       = seedone_option('title_show_title', '');
			$seedone_show_search      = seedone_option('title_show_search', '');
			$seedone_show_breadcrumbs = seedone_breadcrumbs_enabled();
			$seedone_is_front_page    = seedone_is_front_page();

			if (!empty($seedone_is_front_page) && empty($seedone_show_search)) {
				return false;
			}

			if (empty($seedone_show_title) && empty($seedone_show_breadcrumbs) && empty($seedone_show_search)) {
				return false;
			} else {
				return true;
			}
		}
	endif;
