<?php

/**
 * Theme options
 *
 * @package Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//default values for customizer or other theme options
if (!function_exists('seedone_get_default_options_array')) :
    function seedone_get_default_options_array()
    {

        //fonts choises:
        // Open Sans
        // Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese
        // Roboto
        // Lato
        // Raleway
        // Montserrat
        // PT Sans
        // Source Sans Pro
        // Oswald
        // Lora
        // Work Sans

        return array(
            'demo_number' => '',
            'colorLight' => '#ffffff',
            'colorFont' => '#919191',
            'colorFontMuted' => '#666666',
            'colorBackground' => '#f7f7f7',
            'colorBorder' => '#e0e3e6',
            'colorDark' => '#31342b',
            'colorDarkMuted' => '#000000',
            'colorMain' => '#d4ec70',
            'colorMain2' => '#e46b2d',
            'colorMain3' => '#fcd200',
            'colorMain4' => '#8ccc67',
            'color_meta_icons' => 'meta-icons-main',
            'slide_1_image' => '',
            'slide_1_pre_heading' => '',
            'slide_1_heading' => '',
            'slide_1_description' => '',
            'slide_1_button_1_text' => '',
            'slide_1_button_1_url' => '',
            'slide_1_button_2_text' => '',
            'slide_1_button_2_url' => '',
            'slide_1_align' => 'text-center',
            'slide_1_custom_class' => '',
            'slide_2_image' => '',
            'slide_2_pre_heading' => '',
            'slide_2_heading' => '',
            'slide_2_description' => '',
            'slide_2_button_1_text' => '',
            'slide_2_button_1_url' => '',
            'slide_2_button_2_text' => '',
            'slide_2_button_2_url' => '',
            'slide_2_align' => 'text-center',
            'slide_2_custom_class' => '',
            'slide_3_image' => '',
            'slide_3_pre_heading' => '',
            'slide_3_heading' => '',
            'slide_3_description' => '',
            'slide_3_button_1_text' => '',
            'slide_3_button_1_url' => '',
            'slide_3_button_2_text' => '',
            'slide_3_button_2_url' => '',
            'slide_3_align' => 'text-center',
            'slide_3_custom_class' => '',
            'slider_custom_class' => '',
            'slider_watermark_image' => '',
            'intro_block_heading' => '',
            'intro_position' => '',
            'intro_layout' => '',
            'intro_fullscreen' => '',
            'intro_background' => '',
            'intro_background_image' => '',
            'intro_background_image_scale' => '',
            'intro_image_animation' => '',
            'intro_background_image_cover' => '',
            'intro_background_image_fixed' => '',
            'intro_background_image_overlay' => '',
            'intro_pre_heading' => '',
            'intro_pre_heading_custom_class' => '',
            'intro_pre_heading_mt' => '',
            'intro_pre_heading_mb' => '',
            'intro_pre_heading_animation' => 'fadeInUp',
            'intro_heading' => '',
            'intro_heading_mt' => '',
            'intro_heading_mb' => '',
            'intro_heading_animation' => 'fadeInUp',
            'intro_description' => '',
            'intro_description_mt' => '',
            'intro_description_mb' => '',
            'intro_description_animation' => '',
            'intro_button_text_first' => '',
            'intro_button_url_first' => '',
            'intro_button_first_animation' => 'fadeInUp',
            'intro_button_text_second' => '',
            'intro_button_url_second' => '',
            'intro_button_second_animation' => 'fadeInUp',
            'intro_buttons_mt' => '',
            'intro_buttons_mb' => '',
            'intro_shortcode' => '',
            'intro_shortcode_mt' => '',
            'intro_shortcode_mb' => '',
            'intro_shortcode_animation' => '',
            'intro_alignment' => 'text-center',
            'intro_extra_padding_top' => '',
            'intro_extra_padding_bottom' => '',
            'intro_social_links' => '',
            'intro_font_size' => '',
            'intro_custom_class' => '',
            'logo' => '1',
            'logo_text_primary' => '',
            'logo_text_secondary' => 'Seedone',
            'header_top_tall' => '1',
            'logo_background' => '',
            'logo_padding_horizontal' => '',
            'logo_btn_hover_image' => SEEDONE_THEME_URI . '/assets/img/leaf-btn.png',
            'preset' => '',
            'main_container_width' => '1520',
            'blog_container_width' => '',
            'blog_single_container_width' => '',
            'preloader' => '',
            'box_fade_in' => '',
            'totop' => '1',
            'assets_min' => '',
            'jquery_to_footer' => '',
            'meta_email' => 'seedone@test.com',
            'meta_email_label' => '',
            'meta_phone' => '',
            'meta_phone_label' => '',
            'meta_address' => 'Sydney',
            'meta_address_label' => '',
            'meta_opening_hours' => '',
            'meta_opening_hours_label' => '',
            'meta_facebook' => '#',
            'meta_twitter' => '#',
            'meta_youtube' => '#',
            'meta_instagram' => '#',
            'meta_pinterest' => '',
            'meta_linkedin' => '',
            'meta_github' => '',
            'header_image_background_image_cover' => '1',
            'header_image_background_image_fixed' => '1',
            'header_image_background_image_overlay' => '',
            'header' => '1',
            'header_fluid' => '',
            'header_background' => 'i',
            'header_toplogo_background' => 'i',
            'header_align_main_menu' => 'menu-center',
            'header_toggler_menu_main' => '1',
            'header_absolute' => '',
            'header_transparent' => '',
            'header_border_top' => '',
            'header_border_bottom' => 'full',
            'header_font_size' => '',
            'header_sticky' => 'always-sticky',
            'header_search' => '',
            'header_button_text' => '',
            'header_button_url' => '',
            'header_topline_options_heading' => '',
            'topline' => '',
            'topline_fluid' => '',
            'topline_background' => 'l m',
            'meta_topline_text' => '',
            'topline_font_size' => 'fs-16',
            'header_logo_background' => '',
            'title' => '3',
            'title_show_title' => '1',
            'title_show_breadcrumbs' => '1',
            'title_show_search' => '',
            'title_watermark_image' => '',
            'title_background' => 'i',
            'title_border_top' => '',
            'title_border_bottom' => '',
            'title_extra_padding_top' => 'pt-5',
            'title_extra_padding_bottom' => 'pb-8',
            'title_font_size' => 'fs-16',
            'title_hide_taxonomy_name' => '1',
            'title_background_image' => '',
            'title_background_image_cover' => '1',
            'title_background_image_fixed' => '1',
            'title_background_image_overlay' => '',
            'title_custom_class' => '',
            'main_sidebar_width' => '30',
            'main_gap_width' => '',
            'main_sidebar_margin_right' => '80',
            'main_sidebar_sticky' => '1',
            'main_extra_padding_top' => 'pt-10',
            'main_extra_padding_bottom' => 'pb-8',
            'main_font_size' => 'fs-18',
            'sidebar_font_size' => '',
            '404_background_image' => '',
            '404_background_image_cover' => '1',
            '404_background_image_fixed' => '',
            '404_background_image_overlay' => '',
            'footer_top' => '2',
            'footer_top_fluid' => '1',
            'footer_top_pre_heading' => '',
            'footer_top_pre_heading_mt' => 'mt-1',
            'footer_top_pre_heading_mb' => '',
            'footer_top_pre_heading_animation' => '',
            'footer_top_background_text' => '',
            'footer_top_heading' => '',
            'footer_top_heading_mt' => '',
            'footer_top_heading_mb' => 'mb-0',
            'footer_top_heading_animation' => '',
            'footer_top_description' => '',
            'footer_top_description_mt' => '',
            'footer_top_description_mb' => '',
            'footer_top_description_animation' => '',
            'footer_top_shortcode' => '',
            'footer_top_shortcode_mt' => '',
            'footer_top_shortcode_mb' => 'mb-0',
            'footer_top_shortcode_animation' => '',
            'footer_top_background' => 'l',
            'footer_top_border_top' => '',
            'footer_top_border_bottom' => '',
            'footer_top_extra_padding_top' => 'pt-10',
            'footer_top_extra_padding_bottom' => 'pb-9',
            'footer_top_font_size' => '',
            'footer_top_background_image' => '',
            'footer_top_background_image_cover' => '1',
            'footer_top_background_image_fixed' => '',
            'footer_top_background_image_overlay' => '',
            'footer_top_absolute_image' => '',
            'footer' => '1',
            'footer_layout_gap' => '40',
            'footer_fluid' => '',
            'footer_background' => 'i',
            'footer_border_top' => 'full',
            'footer_border_bottom' => 'full',
            'footer_extra_padding_top' => 'pt-10',
            'footer_extra_padding_bottom' => '',
            'footer_font_size' => '',
            'footer_background_image' => '',
            'footer_background_image_cover' => '1',
            'footer_background_image_fixed' => '1',
            'footer_background_image_overlay' => '',
            'copyright' => '1',
            'copyright_text' => 'Copyright © [year] All Rights Reserved',
            'copyright_fluid' => '',
            'copyright_background' => 'i',
            'copyright_extra_padding_top' => '',
            'copyright_extra_padding_bottom' => '',
            'copyright_font_size' => '',
            'copyright_background_image' => '',
            'copyright_background_image_cover' => '',
            'copyright_background_image_fixed' => '',
            'copyright_background_image_overlay' => '',
            'font_body_heading' => '',
            'font_body' => '{"font":"DM Sans","variant":["regular","500","700"],"subset":["latin"]}',
            'font_headings_heading' => '',
            'font_headings' => '{"font":"Kristi","variant":["regular"],"subset":["latin"]}',
            'blog_layout' => '',
            'blog_layout_gap' => '',
            'blog_sidebar_position' => 'left',
            'blog_page_name' => 'Blog sidebar',
            'blog_show_full_text' => '',
            'blog_excerpt_length' => '20',
            'blog_read_more_text' => '',
            'blog_hide_taxonomy_type_name' => '1',
            'blog_meta_options_heading' => '',
            'blog_hide_meta_icons' => '',
            'blog_show_author' => '1',
            'blog_show_author_avatar' => '1',
            'blog_before_author_word' => '',
            'blog_show_date' => '1',
            'blog_before_date_word' => '',
            'blog_show_categories' => '',
            'blog_before_categories_word' => '',
            'blog_show_tags' => '',
            'blog_before_tags_word' => '',
            'blog_show_views' => '',
            'blog_before_views_word' => '',
            'blog_show_comments_link' => 'text',
            'blog_share_options_heading' => '',
            'blog_share_facebook' => '',
            'blog_share_twitter' => '',
            'blog_share_telegram' => '',
            'blog_share_pinterest' => '',
            'blog_share_linkedin' => '',
            'blog_button_background_img' => '',
            'blog_single_layout' => '',
            'blog_single_sidebar_position' => 'left',
            'blog_single_show_author_bio' => '1',
            'blog_single_author_bio_about_word' => 'Author',
            'blog_single_post_nav_heading' => '',
            'blog_single_post_nav' => 'bg',
            'blog_single_post_nav_word_prev' => 'Previous post',
            'blog_single_post_nav_word_next' => 'Next post',
            'blog_single_related_posts_heading' => '',
            'blog_single_related_posts' => 'list',
            'blog_single_related_posts_title' => '',
            'blog_single_related_posts_number' => '3',
            'blog_single_meta_options_heading' => '',
            'blog_single_hide_meta_icons' => '',
            'blog_single_show_author' => '',
            'blog_single_show_author_avatar' => '',
            'blog_single_before_author_word' => '',
            'blog_single_show_date' => '',
            'blog_single_before_date_word' => '',
            'blog_single_show_categories' => '',
            'blog_single_before_categories_word' => '',
            'blog_single_show_tags' => '1',
            'blog_single_before_tags_word' => '',
            'blog_single_show_views' => '',
            'blog_single_before_views_word' => '',
            'blog_single_show_comments_link' => '',
            'blog_single_comments_title_reply' => '',
            'blog_single_share_options_heading' => '',
            'blog_single_share_facebook' => '',
            'blog_single_share_twitter' => '',
            'blog_single_share_telegram' => '',
            'blog_single_share_pinterest' => '',
            'blog_single_share_linkedin' => '',
            'blog_single_blockquote_image' => '',
            'animation_enabled' => '1',
            'animation_sidebar_widgets' => '',
            'animation_footer_widgets' => '',
            'animation_feed_posts' => 'zoomIn',
            'animation_feed_posts_thumbnail' => '',
            'shop_sidebar_position' => 'left',
            'product_sidebar_position' => 'no',
            'header_cart_dropdown' => '1',
            'product_simple_add_to_cart_hide_button' => '',
            'product_show_rating' => '',
            'product_show__review_count' => '',
            'product_show_category' => '',
            'product_show_short_description' => '',
            'product_show_thumbnail_add_to_cart' => '',
            'product_show_thumbnail_link' => '',
        );
    }
endif;

//get theme option from default or from customizer
if (!function_exists('seedone_option')) :
    function seedone_option($seedone_option_name, $seedone_default_value = '')
    {
        //get theme defaults
        $seedone_defaults = seedone_get_default_options_array();

        //lowest priority is basic default value from theme defaults
        $seedone_return = (!empty($seedone_defaults[$seedone_option_name])) ? $seedone_defaults[$seedone_option_name] : $seedone_default_value;

        unset($seedone_defaults);

        //theme_mods are higher - if not empty - overriding value from theme default
        $seedone_return = get_theme_mod($seedone_option_name, $seedone_return);

        if (isset($_GET[$seedone_option_name])) {
            $seedone_return = sanitize_text_field($_GET[$seedone_option_name]);
        }

        return $seedone_return;
    }
endif;

//layout options array. Used global in customizer and for categories
if (!function_exists('seedone_get_feed_layout_options')) :
    function seedone_get_feed_layout_options($seedone_category = false)
    {
        if (empty($seedone_category)) {
            $seedone_first_element = esc_html__('Default - top featured image', 'seedone');
        } else {
            $seedone_first_element = esc_html__('Inherit from Customizer settings', 'seedone');
        }

        $seedone_return = apply_filters(
            'seedone_feed_layout_options',
            array(
                ''                                => $seedone_first_element,
                'cols 2'                          => esc_html__('Grid - 2 columns', 'seedone'),
                'cols 3'                          => esc_html__('Grid - 3 columns', 'seedone'),
                'cols 4'                          => esc_html__('Grid - 4 columns', 'seedone'),
            )
        );

        return $seedone_return;
    }
endif;

//gap options array. Used global in customizer and for categories
if (!function_exists('seedone_get_feed_layout_gap_options')) :
    function seedone_get_feed_layout_gap_options($seedone_category = false)
    {
        if (empty($seedone_category)) {
            $seedone_first_element = esc_html__('Default - none', 'seedone');
        } else {
            $seedone_first_element = esc_html__('Inherit from Customizer settings', 'seedone');
        }

        $seedone_return = apply_filters(
            'seedone_feed_layout_gap_options',
            array(
                ''   => $seedone_first_element,
                '1'  => esc_html__('1px', 'seedone'),
                '2'  => esc_html__('2px', 'seedone'),
                '3'  => esc_html__('3px', 'seedone'),
                '4'  => esc_html__('4px', 'seedone'),
                '5'  => esc_html__('5px', 'seedone'),
                '10' => esc_html__('10px', 'seedone'),
                '15' => esc_html__('15px', 'seedone'),
                '20' => esc_html__('20px', 'seedone'),
                '30' => esc_html__('30px', 'seedone'),
                '40' => esc_html__('40px', 'seedone'),
                '50' => esc_html__('50px', 'seedone'),
                '60' => esc_html__('60px', 'seedone'),
            )
        );

        return $seedone_return;
    }
endif;


//layout options array. Used global in customizer and for single posts
if (!function_exists('seedone_get_post_layout_options')) :
    function seedone_get_post_layout_options($seedone_category = false)
    {
        if (empty($seedone_category)) {
            $seedone_first_element = esc_html__('Default - top featured image', 'seedone');
        } else {
            $seedone_first_element = esc_html__('Inherit from Customizer settings', 'seedone');
        }

        $seedone_return = apply_filters(
            'seedone_post_layout_options',
            array(
                ''                    => $seedone_first_element,
                'wide-image'          => esc_html__('Wide featured image', 'seedone'),
                'meta-top'            => esc_html__('Post meta above featured image', 'seedone'),
                'meta-image'          => esc_html__('Post meta on featured image', 'seedone'),
                'meta-side'           => esc_html__('Side post meta', 'seedone'),
                'bottom-meta'         => esc_html__('Bottom post meta', 'seedone'),
                'title-section-image' => esc_html__('Title section featured image', 'seedone'),
            )
        );

        return $seedone_return;
    }
endif;


//sidebar options array. Used global in customizer and for categories
if (!function_exists('seedone_get_sidebar_position_options')) :
    function seedone_get_sidebar_position_options($seedone_category = false)
    {
        if (empty($seedone_category)) {
            $seedone_first_element = esc_html__('Default', 'seedone');
        } else {
            $seedone_first_element = esc_html__('Inherit from Customizer settings', 'seedone');
        }

        $seedone_return = array(
            'right' => esc_html__('Right sidebar', 'seedone'),
            'left'  => esc_html__('Left sidebar', 'seedone'),
            'no'    => esc_html__('No sidebar', 'seedone'),
        );

        if ($seedone_category) {
            $seedone_return = array($seedone_first_element) + $seedone_return;
        }

        return $seedone_return;
    }
endif;

//animation options array.
if (!function_exists('seedone_get_animation_options')) :
    function seedone_get_animation_options()
    {

        $seedone_return = array(
            ''             => esc_html__('None', 'seedone'),
            'bounce'       => esc_html__('bounce', 'seedone'),
            'flash'        => esc_html__('flash', 'seedone'),
            'pulse'        => esc_html__('pulse', 'seedone'),
            'rubberBand'   => esc_html__('rubberBand', 'seedone'),
            'shake'        => esc_html__('shake', 'seedone'),
            'headShake'    => esc_html__('headShake', 'seedone'),
            'swing'        => esc_html__('swing', 'seedone'),
            'tada'         => esc_html__('tada', 'seedone'),
            'wobble'       => esc_html__('wobble', 'seedone'),
            'jello'        => esc_html__('jello', 'seedone'),
            'heartBeat'    => esc_html__('heartBeat', 'seedone'),
            'bounceIn'     => esc_html__('bounceIn', 'seedone'),
            'fadeIn'       => esc_html__('fadeIn', 'seedone'),
            'fadeInDown'   => esc_html__('fadeInDown', 'seedone'),
            'fadeInLeft'   => esc_html__('fadeInLeft', 'seedone'),
            'fadeInRight'  => esc_html__('fadeInRight', 'seedone'),
            'fadeInUp'     => esc_html__('fadeInUp', 'seedone'),
            'flip'         => esc_html__('flip', 'seedone'),
            'flipInX'      => esc_html__('flipInX', 'seedone'),
            'flipInY'      => esc_html__('flipInY', 'seedone'),
            'lightSpeedIn' => esc_html__('lightSpeedIn', 'seedone'),
            'jackInTheBox' => esc_html__('jackInTheBox', 'seedone'),
            'zoomIn'       => esc_html__('zoomIn', 'seedone'),
        );

        return $seedone_return;
    }
endif;

//get :root colors inline styles string
if (!function_exists('seedone_get_root_colors_inline_styles_string')) :
    function seedone_get_root_colors_inline_styles_string()
    {
        //colors
        $seedone_colors_string = '';
        // colorLight
        // colorFont
        // colorFontMuted
        // colorBackground
        // colorBorder
        // colorDark
        // colorDarkMuted
        // colorMain
        // colorMain2
        // colorMain3
        // colorMain4
        $seedone_colors_string .= seedone_option('colorLight', '') ? '--colorLight:' . sanitize_hex_color(seedone_option('colorLight', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorFont', '') ? '--colorFont:' . sanitize_hex_color(seedone_option('colorFont', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorFontMuted', '') ? '--colorFontMuted:' . sanitize_hex_color(seedone_option('colorFontMuted', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorBackground', '') ? '--colorBackground:' . sanitize_hex_color(seedone_option('colorBackground', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorBorder', '') ? '--colorBorder:' . sanitize_hex_color(seedone_option('colorBorder', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorDark', '') ? '--colorDark:' . sanitize_hex_color(seedone_option('colorDark', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorDarkMuted', '') ? '--colorDarkMuted:' . sanitize_hex_color(seedone_option('colorDarkMuted', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorMain', '') ? '--colorMain:' . sanitize_hex_color(seedone_option('colorMain', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorMain2', '') ? '--colorMain2:' . sanitize_hex_color(seedone_option('colorMain2', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorMain3', '') ? '--colorMain3:' . sanitize_hex_color(seedone_option('colorMain3', '')) . ';' : '';
        $seedone_colors_string .= seedone_option('colorMain4', '') ? '--colorMain4:' . sanitize_hex_color(seedone_option('colorMain4', '')) . ';' : '';

        $fontBody       = '';
        $fontHeadings   = '';

        $seedone_font_body     = json_decode(seedone_option('font_body', '{"font":"","variant": [],"subset":[]}'));
        $seedone_font_headings = json_decode(seedone_option('font_headings', '{"font":"","variant": [],"subset":[]}'));

        $seedone_font_body_font = '';
        if (!empty($seedone_font_body->font)) {
            $seedone_font_body_font = $seedone_font_body->font;
        }
        $fontBody = "--fontBody: \"{$seedone_font_body_font}\" !important;";

        $seedone_font_headings_font = '';
        if (!empty($seedone_font_headings->font)) {
            $seedone_font_headings_font = $seedone_font_headings->font;
        }
        $fontHeadings = "--fontHeadings: \"{$seedone_font_headings_font}\" !important;";

        $seedone_colors_string .= $fontBody;
        $seedone_colors_string .= $fontHeadings;

        return $seedone_colors_string;
    }
endif;
