<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

require_once SEEDONE_THEME_PATH . '/inc/customizer/class-mwt-block-heading-control.php';
require_once SEEDONE_THEME_PATH . '/inc/customizer/class-mwt-dropdown-category-control.php';
require_once SEEDONE_THEME_PATH . '/inc/customizer/class-mwt-google-font-control.php';
require_once SEEDONE_THEME_PATH . '/inc/customizer/class-mwt-hidden-customize-control.php';
require_once SEEDONE_THEME_PATH . '/inc/customizer/class-mwt-customizer.php';
require_once SEEDONE_THEME_PATH . '/inc/customizer/customizer-helpers.php';
require_once SEEDONE_THEME_PATH . '/inc/customizer/customizer-woocommerce.php';


//cutsomizer theme settings
if (!function_exists('seedone_customizer_settings_array')) :
	function seedone_customizer_settings_array()
	{
		return apply_filters(
			'seedone_customizer_options',
			//panels -> sections -> settings
			array(
				//////////////////////
				//registering panels//
				//////////////////////
				'panel_slider'                           => array(
					'type'            => 'panel',
					'label'           => esc_html__('Homepage Slider', 'seedone'),
					'description'     => esc_html__('Slider that will appear on the home page', 'seedone'),
					'priority'        => 130,
					'active_callback' => '',
				),
				'panel_theme'                           => array(
					'type'            => 'panel',
					'label'           => esc_html__('Theme options', 'seedone'),
					'description'     => esc_html__('Theme specific options', 'seedone'),
					'priority'        => 130,
					'active_callback' => '',
				),
				////////////////////////
				//registering sections//
				////////////////////////

				/*
				make sure that you have appropriate panel registered above
				otherwise do not pass 'panel' key
				*/

				//global settings preset. It will change multiple options over 'Theme options' panel
				'section_slide_1'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_slider',
					'label'       => esc_html__('Homepage Slide 1', 'seedone'),
					'description' => esc_html__('First homepage slide', 'seedone'),
					'priority'    => 100,
				),
				'section_slide_2'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_slider',
					'label'       => esc_html__('Homepage Slide 2', 'seedone'),
					'description' => esc_html__('Second homepage slide', 'seedone'),
					'priority'    => 100,
				),
				'section_slide_3'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_slider',
					'label'       => esc_html__('Homepage Slide 3', 'seedone'),
					'description' => esc_html__('Third homepage slide', 'seedone'),
					'priority'    => 100,
				),
				'section_slider_settings'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_slider',
					'label'       => esc_html__('Global Slider Settings', 'seedone'),
					'description' => esc_html__('Global slider settings', 'seedone'),
					'priority'    => 100,
				),
				'section_layout'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Theme Layout', 'seedone'),
					'description' => esc_html__('Site layout options', 'seedone'),
					'priority'    => 100,
				),
				'section_meta'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Theme Meta', 'seedone'),
					'description' => esc_html__('Email, phone, address etc. Appears in various template parts depending from choosen sections layout', 'seedone'),
					'priority'    => 100,
				),

				//template parts layout sections
				'section_header'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Header Section', 'seedone'),
					'description' => esc_html__('Choose header options', 'seedone'),
					'priority'    => 100,
				),
				'section_title'                         => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Title Section', 'seedone'),
					'description' => esc_html__('Choose title options. Yoast SEO plugin required for breadcrumbs', 'seedone'),
					'priority'    => 100,
				),
				'section_main'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Main Section', 'seedone'),
					'description' => esc_html__('Choose main section options', 'seedone'),
					'priority'    => 100,
				),
				'section_404'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('404 Section', 'seedone'),
					'description' => esc_html__('Choose 404 section options', 'seedone'),
					'priority'    => 100,
				),
				'section_footer_top'                    => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Top Footer Section', 'seedone'),
					'description' => esc_html__('Choose top footer section options', 'seedone'),
					'priority'    => 100,
				),
				'section_footer'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Footer Section', 'seedone'),
					'description' => esc_html__('Choose footer options', 'seedone'),
					'priority'    => 100,
				),
				'section_copyright'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Copyright Section', 'seedone'),
					'description' => esc_html__('Choose copyright options', 'seedone'),
					'priority'    => 100,
				),
				'section_blog'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Blog', 'seedone'),
					'description' => esc_html__('Blog display options', 'seedone'),
					'priority'    => 100,
				),
				'section_blog_post'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Single Post', 'seedone'),
					'description' => esc_html__('Single post display options', 'seedone'),
					'priority'    => 100,
				),
				'section_fonts'                         => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Fonts', 'seedone'),
					'description' => esc_html__('Choose Google fonts', 'seedone'),
					'priority'    => 100,
				),
				'section_special_categories'            => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Services, Portfolio, Team', 'seedone'),
					'description' => esc_html__('Choose separate categories for displaying Services, Portfolio, Team. They will be removed from regular blog displaying', 'seedone'),
					'priority'    => 100,
				),
				'section_animation'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Animation', 'seedone'),
					'description' => esc_html__('You can select elements that you want to animate on your page', 'seedone'),
					'priority'    => 100,
				),

				///////////////////////
				//registering options//
				///////////////////////
				/*
				make sure that you have registered appropriate section above
				or used default sections as 'section' key's value:
					'title_tagline' - Site Title & Tagline
					'colors' - Colors
					'header_image' - Header Image
					'background_image' - Background Image
					'nav' - Navigation
					'static_front_page' - Static Front Page
				*/
				/*
				available types:
					'checkbox'
					'color'
					'dropdown-pages'
					'file'
					'image'
					'radio'
					'select'
					'text'
					'textarea'
					'url'
					'dropdown-category' - our custom dropdown
					'block-heading' - our custom block heading
					'hidden-option' - our custom hidden option
				make sure that you have provide an array with 'choices' key for 'select' and 'radio':
					'choices' => array(
						'choice_1' => esc_html__( 'Choice 1', 'seedone' ),
						...
					)
				*/

				//////////////////////
				//Hidden Demo Number//
				//////////////////////
				'demo_number'                           => array(
					'type'    => 'hidden-option',
					'section' => 'section_presets',
					'default' => seedone_option('demo_number', ''),
				),

				//////////
				//colors//
				//////////
				//see _variables.scss
				//see options.php for defaults
				// colorLight
				// colorFont
				// colorFontMuted
				// colorBackground
				// colorBorder
				// colorDark
				// colorDarkMuted
				// colorMain
				// colorMain2
				// colorMain3
				// colorMain4
				'colorLight'                            => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Light color', 'seedone'),
					'default'     => seedone_option('colorLight', '#ffffff'),
					'description' => esc_html__('Using as a background for light sections and as a font color in inversed sections.', 'seedone'),
				),
				'colorFont'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Font color', 'seedone'),
					'default'     => seedone_option('colorFont', '#555555'),
					'description' => esc_html__('Using as a font color.', 'seedone'),
				),
				'colorFontMuted'                        => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Font muted color', 'seedone'),
					'default'     => seedone_option('colorFontMuted', '#666666'),
					'description' => esc_html__('Using as a font muted color.', 'seedone'),
				),
				'colorBackground'                       => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Light grey background color', 'seedone'),
					'default'     => seedone_option('colorBackground', '#f7f7f7'),
					'description' => esc_html__('Using as a light grey background.', 'seedone'),
				),
				'colorBorder'                           => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Grey border color', 'seedone'),
					'default'     => seedone_option('colorBorder', '#e1e1e1'),
					'description' => esc_html__('Using as a border color.', 'seedone'),
				),
				'colorDark'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark color', 'seedone'),
					'default'     => seedone_option('colorDark', '#444444'),
					'description' => esc_html__('Using as a links color for light sections and as a background for inversed sections.', 'seedone'),
				),
				'colorDarkMuted'                        => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Darker color', 'seedone'),
					'default'     => seedone_option('colorDarkMuted', '#222222'),
					'description' => esc_html__('Using as headings color and a background for darker inversed sections.', 'seedone'),
				),
				'colorMain'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Main accent color #1', 'seedone'),
					'default'     => seedone_option('colorMain', '#fa6755'),
					'description' => esc_html__('Using as a main accent color.', 'seedone'),
				),
				'colorMain2'                            => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Main accent color #2', 'seedone'),
					'default'     => seedone_option('colorMain2', '#a3d6d7'),
					'description' => esc_html__('Using as a main accent second color.', 'seedone'),
				),
				'colorMain3'                            => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Main accent color #3', 'seedone'),
					'default'     => seedone_option('colorMain3', '#d8d8b6'),
					'description' => esc_html__('Using as a main accent third color.', 'seedone'),
				),
				'colorMain4'                            => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Main accent color #4', 'seedone'),
					'default'     => seedone_option('colorMain4', '#ffcc8d'),
					'description' => esc_html__('Using as a main accent fourth color.', 'seedone'),
				),
				'color_meta_icons'                      => array(
					'type'    => 'select',
					'section' => 'colors',
					'label'   => esc_html__('Color for icons in post meta', 'seedone'),
					'default' => seedone_option('color_meta_icons', ''),
					'choices' => array(
						''                      => esc_html__('Default', 'seedone'),
						'meta-icons-main'       => esc_html__('Accent color', 'seedone'),
						'meta-icons-main2'      => esc_html__('Accent color 2', 'seedone'),
						'meta-icons-border'     => esc_html__('Borders color', 'seedone'),
						'meta-icons-dark'       => esc_html__('Dark color', 'seedone'),
						'meta-icons-dark-muted' => esc_html__('Darker color', 'seedone'),
					),
				),
				'color_skin' => array(
					'type'    => 'select',
					'section' => 'colors',
					'value'   => '',
					'label'   => esc_html__('Choose theme skin', 'seedone'),
					'description'    => esc_html__('Select one of predefined skins', 'seedone'),
					'choices' => array(
						''  => esc_html__('No skin', 'seedone'),
						'skin1' => esc_html__('First skin', 'seedone'),
						'skin2' => esc_html__('Second skin', 'seedone'),
						'skin3' => esc_html__('Third skin', 'seedone'),
						'skin4' => esc_html__('Fourth skin', 'seedone'),
						'skin5' => esc_html__('Fifth  skin', 'seedone'),
						'skin6' => esc_html__('Sixth skin', 'seedone'),
					),
				),

				///////////////////////////
				//homepage slider section//
				///////////////////////////

				//first slide
				'slide_1_image'                => array(
					'type'    => 'image',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Slide 1 Image', 'seedone'),
					'default' => seedone_option('slide_1_image', ''),
				),
				'slide_1_pre_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Slide 1 Pre Heading', 'seedone'),
					'default' => seedone_option('slide_1_pre_heading', ''),
				),
				'slide_1_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Slide 1 Heading', 'seedone'),
					'default' => seedone_option('slide_1_heading', ''),
				),
				'slide_1_description'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Slide 1 Description', 'seedone'),
					'default' => seedone_option('slide_1_description', ''),
				),
				'slide_1_button_1_text'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Slide 1 Primary Button Text', 'seedone'),
					'default' => seedone_option('slide_1_button_1_text', ''),
				),
				'slide_1_button_1_url'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Slide 1 Primary Button URL', 'seedone'),
					'default' => seedone_option('slide_1_button_1_url', ''),
				),
				'slide_1_button_2_text'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Slide 1 Secondary Button Text', 'seedone'),
					'default' => seedone_option('slide_1_button_2_text', ''),
				),
				'slide_1_button_2_url'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Slide 1 Secondary Button URL', 'seedone'),
					'default' => seedone_option('slide_1_button_2_url', ''),
				),
				'slide_1_align'                      => array(
					'type'    => 'select',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Text Alignment', 'seedone'),
					'default' => seedone_option('slide_1_align', ''),
					'choices' => array(
						''       => esc_html__('Default', 'seedone'),
						'text-center' => esc_html__('Center', 'seedone'),
						'text-right'  => esc_html__('Right', 'seedone'),
					),
				),
				'slide_1_custom_class'               => array(
					'type'    => 'text',
					'section' => 'section_slide_1',
					'label'   => esc_html__('Add custom class', 'seedone'),
					'default' => seedone_option('slide_1_custom_class', ''),
				),

				//second slide
				'slide_2_image'                => array(
					'type'    => 'image',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Slide 2 Image', 'seedone'),
					'default' => seedone_option('slide_2_image', ''),
				),
				'slide_2_pre_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Slide 2 Pre Heading', 'seedone'),
					'default' => seedone_option('slide_2_pre_heading', ''),
				),
				'slide_2_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Slide 2 Heading', 'seedone'),
					'default' => seedone_option('slide_2_heading', ''),
				),
				'slide_2_description'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Slide 2 Description', 'seedone'),
					'default' => seedone_option('slide_2_description', ''),
				),
				'slide_2_button_1_text'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Slide 2 Primary Button Text', 'seedone'),
					'default' => seedone_option('slide_2_button_2_text', ''),
				),
				'slide_2_button_1_url'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Slide 2 Primary Button URL', 'seedone'),
					'default' => seedone_option('slide_2_button_2_url', ''),
				),
				'slide_2_button_2_text'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Slide 2 Secondary Button Text', 'seedone'),
					'default' => seedone_option('slide_2_button_2_text', ''),
				),
				'slide_2_button_2_url'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Slide 1 Secondary Button URL', 'seedone'),
					'default' => seedone_option('slide_1_button_2_url', ''),
				),
				'slide_2_align'                      => array(
					'type'    => 'select',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Text Alignment', 'seedone'),
					'default' => seedone_option('slide_2_align', ''),
					'choices' => array(
						''       => esc_html__('Default', 'seedone'),
						'text-center' => esc_html__('Center', 'seedone'),
						'text-right'  => esc_html__('Right', 'seedone'),
					),
				),
				'slide_2_custom_class'               => array(
					'type'    => 'text',
					'section' => 'section_slide_2',
					'label'   => esc_html__('Add custom class', 'seedone'),
					'default' => seedone_option('slide_2_custom_class', ''),
				),

				//third slide
				'slide_3_image'                => array(
					'type'    => 'image',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Slide 3 Image', 'seedone'),
					'default' => seedone_option('slide_3_image', ''),
				),
				'slide_3_pre_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Slide 3 Pre Heading', 'seedone'),
					'default' => seedone_option('slide_3_pre_heading', ''),
				),
				'slide_3_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Slide 3 Heading', 'seedone'),
					'default' => seedone_option('slide_3_heading', ''),
				),
				'slide_3_description'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Slide 3 Description', 'seedone'),
					'default' => seedone_option('slide_3_description', ''),
				),
				'slide_3_button_1_text'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Slide 3 Primary Button Text', 'seedone'),
					'default' => seedone_option('slide_3_button_3_text', ''),
				),
				'slide_3_button_1_url'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Slide 3 Primary Button URL', 'seedone'),
					'default' => seedone_option('slide_3_button_3_url', ''),
				),
				'slide_3_button_2_text'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Slide 3 Secondary Button Text', 'seedone'),
					'default' => seedone_option('slide_3_button_3_text', ''),
				),
				'slide_3_button_2_url'                         => array(
					'type'    => 'text',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Slide 1 Secondary Button URL', 'seedone'),
					'default' => seedone_option('slide_1_button_3_url', ''),
				),
				'slide_3_align'                      => array(
					'type'    => 'select',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Text Alignment', 'seedone'),
					'default' => seedone_option('slide_3_align', ''),
					'choices' => array(
						''       => esc_html__('Default', 'seedone'),
						'text-center' => esc_html__('Center', 'seedone'),
						'text-right'  => esc_html__('Right', 'seedone'),
					),
				),
				'slide_3_custom_class'               => array(
					'type'    => 'text',
					'section' => 'section_slide_3',
					'label'   => esc_html__('Add custom class', 'seedone'),
					'default' => seedone_option('slide_3_custom_class', ''),
				),
				//global slider settings
				'slider_custom_class'               => array(
					'type'    => 'text',
					'section' => 'section_slider_settings',
					'label'   => esc_html__('Add custom class', 'seedone'),
					'default' => seedone_option('slider_custom_class', ''),
				),
				'slider_watermark_image'                => array(
					'type'    => 'image',
					'section' => 'section_slider_settings',
					'label'   => esc_html__('Watermark Image', 'seedone'),
					'default' => seedone_option('slider_watermark_image', ''),
				),


				//////////////////////////
				//homepage intro section//
				//////////////////////////

				// static_front_page
				'intro_block_heading'                   => array(
					'type'        => 'block-heading',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Intro Section', 'seedone'),
					'description' => esc_html__('Set your settings for homepage intro section. Leave blank if not needed.', 'seedone'),
				),
				'intro_position'                        => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Position', 'seedone'),
					'default' => seedone_option('intro_position', ''),
					'choices' => array(
						''       => esc_html__('Hidden', 'seedone'),
						'before' => esc_html__('Before header', 'seedone'),
						'after'  => esc_html__('After header', 'seedone'),
					),
				),
				'intro_layout'                          => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Layout', 'seedone'),
					'default' => seedone_option('intro_layout', ''),
					'choices' => array(
						''             => esc_html__('Background image', 'seedone'),
						'image-left'   => esc_html__('Left side image', 'seedone'),
						'image-right'  => esc_html__('Right side image', 'seedone'),
						'image-top'    => esc_html__('Top image', 'seedone'),
						'image-bottom' => esc_html__('Bottom image', 'seedone'),
					),
				),
				'intro_fullscreen'                      => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Full Screen Intro Height', 'seedone'),
					'default' => seedone_option('intro_fullscreen', false),
				),
				'intro_background'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Background', 'seedone'),
					'default' => seedone_option('intro_background', ''),
					'choices' => seedone_customizer_backgrounds_array(),
				),
				'intro_background_image'                => array(
					'type'    => 'image',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Image', 'seedone'),
					'default' => seedone_option('intro_background_image', ''),
				),
				'intro_background_image_scale' => array(
					'type'        => 'checkbox',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Make image bigger on large screen', 'seedone'),
					'description' => esc_html__('Scale image for large screens', 'seedone'),
					'default'     => seedone_option('intro_background_image_scale', false),
				),
				'intro_image_animation'                 => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro image', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('intro_image_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'intro_background_image_cover'          => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Cover background image', 'seedone'),
					'default' => seedone_option('intro_background_image_cover', false),
				),
				'intro_background_image_fixed'          => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Fixed background image', 'seedone'),
					'default' => seedone_option('intro_background_image_fixed', false),
				),
				'intro_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Overlay for background image', 'seedone'),
					'default' => seedone_option('intro_background_image_overlay', ''),
					'choices' => seedone_customizer_background_overlay_array(),
				),
				'intro_pre_heading'                         => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Pre Heading text', 'seedone'),
					'default' => seedone_option('intro_pre_heading', ''),
				),
				'intro_pre_heading_custom_class'               => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Pre Heading custom class', 'seedone'),
					'default' => seedone_option('intro_pre_heading_custom_class', ''),
				),
				'intro_pre_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Pre Heading top margin', 'seedone'),
					'default' => seedone_option('intro_pre_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_pre_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Pre Heading bottom margin', 'seedone'),
					'default' => seedone_option('intro_pre_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_pre_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for pre intro heading', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('intro_pre_heading_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'intro_heading'                         => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Heading text', 'seedone'),
					'default' => seedone_option('intro_heading', ''),
				),
				'intro_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Heading top margin', 'seedone'),
					'default' => seedone_option('intro_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Heading bottom margin', 'seedone'),
					'default' => seedone_option('intro_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro heading', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('intro_heading_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'intro_description'                     => array(
					'type'    => 'textarea',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section description text', 'seedone'),
					'default' => seedone_option('intro_description', ''),
				),
				'intro_description_mt'                  => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Description top margin', 'seedone'),
					'default' => seedone_option('intro_description_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_description_mb'                  => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Description bottom margin', 'seedone'),
					'default' => seedone_option('intro_description_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_description_animation'           => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro description text', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('intro_description_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'intro_button_text_first'               => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Primary Action Button Text', 'seedone'),
					'default' => seedone_option('intro_button_text_first', ''),
				),
				'intro_button_url_first'                => array(
					'type'    => 'url',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Primary Action Button URL', 'seedone'),
					'default' => seedone_option('intro_button_url_first', ''),
				),
				'intro_button_first_animation'          => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for first intro button', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('intro_button_first_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'intro_button_text_second'              => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Secondary Action Button Text', 'seedone'),
					'default' => seedone_option('intro_button_text_second', ''),
				),
				'intro_button_url_second'               => array(
					'type'    => 'url',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Secondary Action Button URL', 'seedone'),
					'default' => seedone_option('intro_button_url_second', ''),
				),
				'intro_button_second_animation'         => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for second intro button', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('intro_button_second_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'intro_buttons_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Buttons top margin', 'seedone'),
					'default' => seedone_option('intro_buttons_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_buttons_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Buttons bottom margin', 'seedone'),
					'default' => seedone_option('intro_buttons_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_shortcode'                       => array(
					'type'        => 'text',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Intro Section Shortcode', 'seedone'),
					'description' => esc_html__('You can put shortcode here. It will appear below Intro description', 'seedone'),
					'default'     => seedone_option('intro_shortcode', ''),
				),
				'intro_shortcode_mt'                    => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Shortcode top margin', 'seedone'),
					'default' => seedone_option('intro_shortcode_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_shortcode_mb'                    => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Shortcode bottom margin', 'seedone'),
					'default' => seedone_option('intro_shortcode_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_shortcode_animation'             => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro shortcode', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('intro_shortcode_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'intro_alignment'                       => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Text Alignment', 'seedone'),
					'default' => seedone_option('intro_alignment', 'text-left'),
					'choices' => array(
						'text-left'   => esc_html__('Left', 'seedone'),
						'text-center' => esc_html__('Centered', 'seedone'),
						'text-right'  => esc_html__('Right', 'seedone'),
					),
				),
				'intro_extra_padding_top'               => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section top padding', 'seedone'),
					'default' => seedone_option('intro_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pt-0'  => esc_html__('0', 'seedone'),
						'pt-1'  => esc_html__('1em', 'seedone'),
						'pt-2'  => esc_html__('2em', 'seedone'),
						'pt-3'  => esc_html__('3em', 'seedone'),
						'pt-4'  => esc_html__('4em', 'seedone'),
						'pt-5'  => esc_html__('5em', 'seedone'),
						'pt-6'  => esc_html__('6em', 'seedone'),
						'pt-7'  => esc_html__('7em', 'seedone'),
						'pt-8'  => esc_html__('8em', 'seedone'),
						'pt-9'  => esc_html__('9em', 'seedone'),
						'pt-10' => esc_html__('10em', 'seedone'),
					),
				),
				'intro_extra_padding_bottom'            => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section bottom padding', 'seedone'),
					'default' => seedone_option('intro_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pb-0'  => esc_html__('0', 'seedone'),
						'pb-1'  => esc_html__('1em', 'seedone'),
						'pb-2'  => esc_html__('2em', 'seedone'),
						'pb-3'  => esc_html__('3em', 'seedone'),
						'pb-4'  => esc_html__('4em', 'seedone'),
						'pb-5'  => esc_html__('5em', 'seedone'),
						'pb-6'  => esc_html__('6em', 'seedone'),
						'pb-7'  => esc_html__('7em', 'seedone'),
						'pb-8'  => esc_html__('8em', 'seedone'),
						'pb-9'  => esc_html__('9em', 'seedone'),
						'pb-10' => esc_html__('10em', 'seedone'),
					),
				),
				'intro_social_links'                    => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Show social links if they set', 'seedone'),
					'default' => seedone_option('intro_social_links', false),
				),
				'intro_font_size'                       => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section font size', 'seedone'),
					'default' => seedone_option('intro_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),
				'intro_custom_class'               => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Add custom class', 'seedone'),
					'default' => seedone_option('intro_custom_class', ''),
				),

				////////
				//logo//
				////////

				//to existing 'title_tagline' section
				'logo'                                  => array(
					'type'    => 'select',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Layout', 'seedone'),
					'default' => seedone_option('logo', ''),
					'choices' => array(
						'1' => esc_html__('Left image and right text', 'seedone'),
						'2' => esc_html__('Top image and bottom text', 'seedone'),
						'3' => esc_html__('Image between text', 'seedone'),
					),
				),
				'logo_text_primary'                     => array(
					'type'    => 'text',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Primary Text', 'seedone'),
					'default' => seedone_option('logo_text_primary', ''),
				),
				'logo_text_secondary'                   => array(
					'type'    => 'text',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Secondary Text', 'seedone'),
					'default' => seedone_option('logo_text_secondary', ''),
				),
				'header_top_tall'                       => array(
					'type'        => 'checkbox',
					'section'     => 'title_tagline',
					'label'       => esc_html__('Logo additional vertical padding', 'seedone'),
					'description' => esc_html__('Will make header taller in top position', 'seedone'),
					'default'     => seedone_option('header_top_tall', false),
				),
				'logo_background'                       => array(
					'type'    => 'select',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Background', 'seedone'),
					'default' => seedone_option('logo_background', ''),
					'choices' => seedone_customizer_backgrounds_array(),
				),
				'logo_padding_horizontal'               => array(
					'type'        => 'checkbox',
					'section'     => 'title_tagline',
					'label'       => esc_html__('Logo additional horizontal padding', 'seedone'),
					'description' => esc_html__('This will add an extra horizontal padding for logo', 'seedone'),
					'default'     => seedone_option('logo_padding_horizontal', false),
				),
				'logo_btn_hover_image'                => array(
					'type'    => 'image',
					'section' => 'title_tagline',
					'label'   => esc_html__('Button Hover Image', 'seedone'),
					'default' => seedone_option('logo_btn_hover_image', ''),
				),

				//////////
				//layout//
				//////////
				'preset'                                => array(
					'type'    => 'select',
					'section' => 'section_presets',
					'label'   => esc_html__('Select global preset of Theme options', 'seedone'),
					'default' => seedone_option('preset', ''),
					'choices' => array(
						''  => esc_html__('No preset', 'seedone'),
						'1' => esc_html__('First preset', 'seedone'),
						'2' => esc_html__('Second preset', 'seedone'),
					),
				),
				'main_container_width'                  => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Global container max width', 'seedone'),
					'default' => seedone_option('main_container_width', '1170'),
					'choices' => array(
						'1520' => esc_html__('1520px', 'seedone'),
						'1170' => esc_html__('1170px', 'seedone'),
						'960'  => esc_html__('960px', 'seedone'),
						'720'  => esc_html__('720px', 'seedone'),
					),
				),
				'blog_container_width'                  => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Archive container max width', 'seedone'),
					'default' => seedone_option('blog_container_width', ''),
					'choices' => array(
						''     => esc_html__('Inherit from Global', 'seedone'),
						'1520' => esc_html__('1520px', 'seedone'),
						'1170' => esc_html__('1170px', 'seedone'),
						'960'  => esc_html__('960px', 'seedone'),
						'720'  => esc_html__('720px', 'seedone'),
					),
				),
				'blog_single_container_width'           => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Single post container max width', 'seedone'),
					'default' => seedone_option('blog_single_container_width', ''),
					'choices' => array(
						''     => esc_html__('Inherit from Global', 'seedone'),
						'1520' => esc_html__('1520px', 'seedone'),
						'1170' => esc_html__('1170px', 'seedone'),
						'960'  => esc_html__('960px', 'seedone'),
						'720'  => esc_html__('720px', 'seedone'),
					),
				),
				'preloader'                             => array(
					'type'     => 'select',
					'section'  => 'section_layout',
					'label'    => esc_html__('Page preloader', 'seedone'),
					'default'  => seedone_option('preloader', ''),
					'priority' => 200,
					'choices'  => array(
						''       => esc_html__('No preloader', 'seedone'),
						'cover'  => esc_html__('Cover page preloader', 'seedone'),
						'corner' => esc_html__('Corner page preloader', 'seedone'),
					),
				),
				'box_fade_in'                           => array(
					'type'     => 'checkbox',
					'section'  => 'section_layout',
					'label'    => esc_html__('Fade in page on load', 'seedone'),
					'default'  => seedone_option('box_fade_in', ''),
					'priority' => 200,
				),
				'totop'                                 => array(
					'type'     => 'checkbox',
					'section'  => 'section_layout',
					'label'    => esc_html__('Enable page \'to top\' button', 'seedone'),
					'default'  => seedone_option('totop', ''),
					'priority' => 200,
				),
				'assets_min'                            => array(
					'type'        => 'checkbox',
					'section'     => 'section_layout',
					'label'       => esc_html__('Use minified version of CSS files', 'seedone'),
					'description' => esc_html__('You can use compressed versions of your static files for best performance', 'seedone'),
					'default'     => seedone_option('assets_min', ''),
					'priority'    => 200,
				),
				'jquery_to_footer'                      => array(
					'type'        => 'checkbox',
					'section'     => 'section_layout',
					'label'       => esc_html__('Put jQuery script to footer for guest users', 'seedone'),
					'description' => esc_html__('If some plugins requires jQuery, it will be loaded in the footer section', 'seedone'),
					'default'     => seedone_option('jquery_to_footer', ''),
					'priority'    => 200,
				),

				////////
				//meta//
				////////
				'meta_email'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Email', 'seedone'),
					'default' => seedone_option('meta_email', ''),
				),
				'meta_email_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Email label', 'seedone'),
					'default' => seedone_option('meta_email_label', ''),
				),
				'meta_phone'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Phone', 'seedone'),
					'default' => seedone_option('meta_phone', ''),
				),
				'meta_phone_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Phone label', 'seedone'),
					'default' => seedone_option('meta_phone_label', ''),
				),
				'meta_address'                          => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Address', 'seedone'),
					'default' => seedone_option('meta_address', ''),
				),
				'meta_address_label'                    => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Address label', 'seedone'),
					'default' => seedone_option('meta_address_label', ''),
				),
				'meta_opening_hours'                    => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Opening hours', 'seedone'),
					'default' => seedone_option('meta_opening_hours', ''),
				),
				'meta_opening_hours_label'              => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Opening hours label', 'seedone'),
					'default' => seedone_option('meta_opening_hours_label', ''),
				),
				//social links
				'meta_facebook'                         => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Facebook URL', 'seedone'),
					'default' => seedone_option('meta_facebook', ''),
				),
				'meta_twitter'                          => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Twitter URL', 'seedone'),
					'default' => seedone_option('meta_twitter', ''),
				),
				'meta_youtube'                          => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('YouTube URL', 'seedone'),
					'default' => seedone_option('meta_youtube', ''),
				),
				'meta_instagram'                        => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Instagram URL', 'seedone'),
					'default' => seedone_option('meta_instagram', ''),
				),
				'meta_pinterest'                        => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Pinterest URL', 'seedone'),
					'default' => seedone_option('meta_pinterest', ''),
				),
				'meta_linkedin'                         => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('LinkedIn URL', 'seedone'),
					'default' => seedone_option('meta_linkedin', ''),
				),
				'meta_github'                           => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('GitHub URL', 'seedone'),
					'default' => seedone_option('meta_github', ''),
				),

				//////////
				//header//
				//////////

				//header image options
				//section 'header_image'
				'header_image_background_image_cover'   => array(
					'type'    => 'checkbox',
					'section' => 'header_image',
					'label'   => esc_html__('Cover background image', 'seedone'),
					'default' => seedone_option('header_image_background_image_cover', false),
				),
				'header_image_background_image_fixed'   => array(
					'type'    => 'checkbox',
					'section' => 'header_image',
					'label'   => esc_html__('Fixed background image', 'seedone'),
					'default' => seedone_option('header_image_background_image_fixed', false),
				),
				'header_image_background_image_overlay' => array(
					'type'    => 'select',
					'section' => 'header_image',
					'label'   => esc_html__('Overlay for background image', 'seedone'),
					'default' => seedone_option('header_image_background_image_overlay', ''),
					'choices' => seedone_customizer_background_overlay_array(),
				),

				//header
				'header'                                => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Layout', 'seedone'),
					'default' => seedone_option('header', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'seedone'),
						'1' => esc_html__('Left logo center menu and meta', 'seedone'),
						'2' => esc_html__('Top centered logo and bottom menu', 'seedone'),
						'3' => esc_html__('Left logo center menu and meta (sticky)', 'seedone'),
						'4' => esc_html__('Left logo, right menu and meta', 'seedone'),
						'6' => esc_html__('Left logo, center menu, bottom menu and sidebar', 'seedone'),
					),
				),
				'header_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Full Width Header', 'seedone'),
					'default' => seedone_option('header_fluid', true),
				),
				'header_background'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Background', 'seedone'),
					'default' => seedone_option('header_background', 'l'),
					'choices' => seedone_customizer_backgrounds_array(true),
				),
				'header_toplogo_background'             => array(
					'type'        => 'select',
					'section'     => 'section_header',
					'label'       => esc_html__('Header Logo Section Background', 'seedone'),
					'default'     => seedone_option('header_toplogo_background', 'l'),
					'description' => esc_html__('Background for top logo section, if header layout contains it', 'seedone'),
					'choices'     => seedone_customizer_backgrounds_array(true),
				),
				'header_align_main_menu'                => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Align main menu', 'seedone'),
					'default' => seedone_option('header_align_main_menu', true),
					'choices' => array(
						''            => esc_html__('Default', 'seedone'),
						'menu-right'  => esc_html__('Right', 'seedone'),
						'menu-center' => esc_html__('Center', 'seedone'),
					),
				),
				// TODO why commented out?
				'header_toggler_menu_main'              => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Put main menu mobile toggler in header', 'seedone'),
					'default' => seedone_option('header_toggler_menu_main', true),
				),
				'header_absolute'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Position absolute header', 'seedone'),
					'default' => seedone_option('header_absolute', false),
				),
				'header_transparent'                    => array(
					'type'        => 'checkbox',
					'section'     => 'section_header',
					'label'       => esc_html__('Remove background color', 'seedone'),
					'description' => esc_html__('Make header transparent', 'seedone'),
					'default'     => seedone_option('header_transparent', false),
				),
				'header_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Top border', 'seedone'),
					'default' => seedone_option('header_border_top', ''),
					'choices' => seedone_customizer_borders_array(),
				),
				'header_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Bottom border', 'seedone'),
					'default' => seedone_option('header_border_bottom', ''),
					'choices' => seedone_customizer_borders_array(),
				),
				'header_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header section font size', 'seedone'),
					'default' => seedone_option('header_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),
				'header_sticky'                         => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Sticky Header', 'seedone'),
					'default' => seedone_option('header_sticky', false),
					'choices' => array(
						''                 => esc_html__('Disabled', 'seedone'),
						'always-sticky'    => esc_html__('Always visible', 'seedone'),
						'scrolltop-sticky' => esc_html__('Visible on scrolling to top', 'seedone'),
					),
				),
				'header_search'                         => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Show Search in Header', 'seedone'),
					'description' => esc_html__('If header layout contains it', 'seedone'),
					'default' => seedone_option('header_search', ''),
					'choices' => array(
						''       => esc_html__('Disabled', 'seedone'),
						'button' => esc_html__('Search Modal button', 'seedone'),
						'form'   => esc_html__('Search Form', 'seedone'),
					),
				),
				'header_button_text'                    => array(
					'type'    => 'text',
					'section' => 'section_header',
					'label'   => esc_html__('Header Action Button Text', 'seedone'),
					'description' => esc_html__('If header layout contains it', 'seedone'),
					'default' => seedone_option('header_button_text', ''),
				),
				'header_button_url'                     => array(
					'type'    => 'url',
					'section' => 'section_header',
					'label'   => esc_html__('Header Action Button URL', 'seedone'),
					'default' => seedone_option('header_button_url', ''),
				),
				//topline in header
				//heading
				'header_topline_options_heading'        => array(
					'type'        => 'block-heading',
					'section'     => 'section_header',
					'label'       => esc_html__('Header topline options', 'seedone'),
					'description' => esc_html__('You need to fill theme meta options to show them in header topline.', 'seedone'),
				),
				'topline'                               => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Topline Layout', 'seedone'),
					'default' => seedone_option('topline', ''),
					'choices' => array(
						''  => esc_html__('Disabled', 'seedone'),
						'1' => esc_html__('Left meta and right social links', 'seedone'),
						'2' => esc_html__('Left menu and right social links', 'seedone'),
						'3' => esc_html__('Left social links and right menu', 'seedone'),
						'4' => esc_html__('Left custom text and right social links', 'seedone'),

					),
				),
				'topline_fluid'                         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Full Width Header Topline', 'seedone'),
					'default' => seedone_option('topline_fluid', true),
				),
				'topline_background'                    => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Topline Background', 'seedone'),
					'default' => seedone_option('topline_background', 'l'),
					'choices' => seedone_customizer_backgrounds_array(true),
				),
				'meta_topline_text'                     => array(
					'type'        => 'textarea',
					'section'     => 'section_header',
					'label'       => esc_html__('Topline custom text', 'seedone'),
					'description' => esc_html__('Appears on different topline layouts', 'seedone'),
					'default'     => seedone_option('meta_topline_text', ''),
				),
				'topline_font_size'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Topline section font size', 'seedone'),
					'default' => seedone_option('topline_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),

				'header_logo_background'                      => array(
					'type'    => 'image',
					'section' => 'section_header',
					'label'   => esc_html__('Logo modal Background image', 'seedone'),
					'default' => seedone_option('header_logo_background', ''),
				),

				/////////
				//title//
				/////////
				'title'                                 => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title Layout', 'seedone'),
					'default' => seedone_option('title', '1'),
					'choices' => array(
						'1' => esc_html__('Title above breadcrumbs', 'seedone'),
						'2' => esc_html__('Title inline with breadcrumbs', 'seedone'),
						'3' => esc_html__('Title above breadcrumbs centered', 'seedone'),
						'4' => esc_html__('Title above breadcrumbs centered alt', 'seedone'),
						'5' => esc_html__('Title above breadcrumbs centered (full width)', 'seedone'),

					),
				),
				'title_show_title'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Show title in title section instead of content area', 'seedone'),
					'default' => seedone_option('title_show_title', ''),
				),
				'title_show_breadcrumbs'                => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Show breadcrumbs (Yoast SEO or Rank Math plugins required)', 'seedone'),
					'default' => seedone_option('title_show_breadcrumbs', true),
				),
				'title_show_search'                     => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Show search form', 'seedone'),
					'default' => seedone_option('title_show_search', false),
				),

				'title_watermark_image'                => array(
					'type'    => 'image',
					'section' => 'section_title',
					'label'   => esc_html__('Watermark Image', 'seedone'),
					'default' => seedone_option('title_watermark_image', ''),
				),

				'title_background'                      => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title Background', 'seedone'),
					'default' => seedone_option('title_background', ''),
					'choices' => seedone_customizer_backgrounds_array(),
				),
				'title_border_top'                      => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Top border', 'seedone'),
					'default' => seedone_option('title_border_top', ''),
					'choices' => seedone_customizer_borders_array(),
				),
				'title_border_bottom'                   => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Bottom border', 'seedone'),
					'default' => seedone_option('title_border_bottom', ''),
					'choices' => seedone_customizer_borders_array(),
				),
				'title_extra_padding_top'               => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Top padding', 'seedone'),
					'default' => seedone_option('title_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pt-0'  => esc_html__('0', 'seedone'),
						'pt-1'  => esc_html__('1em', 'seedone'),
						'pt-2'  => esc_html__('2em', 'seedone'),
						'pt-3'  => esc_html__('3em', 'seedone'),
						'pt-4'  => esc_html__('4em', 'seedone'),
						'pt-5'  => esc_html__('5em', 'seedone'),
						'pt-6'  => esc_html__('6em', 'seedone'),
						'pt-7'  => esc_html__('7em', 'seedone'),
						'pt-8'  => esc_html__('8em', 'seedone'),
						'pt-9'  => esc_html__('9em', 'seedone'),
						'pt-10' => esc_html__('10em', 'seedone'),
					),
				),
				'title_extra_padding_bottom'            => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Bottom padding', 'seedone'),
					'default' => seedone_option('title_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pb-0'  => esc_html__('0', 'seedone'),
						'pb-1'  => esc_html__('1em', 'seedone'),
						'pb-2'  => esc_html__('2em', 'seedone'),
						'pb-3'  => esc_html__('3em', 'seedone'),
						'pb-4'  => esc_html__('4em', 'seedone'),
						'pb-5'  => esc_html__('5em', 'seedone'),
						'pb-6'  => esc_html__('6em', 'seedone'),
						'pb-7'  => esc_html__('7em', 'seedone'),
						'pb-8'  => esc_html__('8em', 'seedone'),
						'pb-9'  => esc_html__('9em', 'seedone'),
						'pb-10' => esc_html__('10em', 'seedone'),
					),
				),
				'title_font_size'                       => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title section font size', 'seedone'),
					'default' => seedone_option('title_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),
				'title_hide_taxonomy_name'              => array(
					'type'        => 'checkbox',
					'section'     => 'section_title',
					'label'       => esc_html__('Hide taxonomy name', 'seedone'),
					'description' => esc_html__('You can hide a taxonomy name on taxonomy archives page', 'seedone'),
					'default'     => seedone_option('title_hide_taxonomy_name', false),
				),
				'title_background_image'                => array(
					'type'    => 'image',
					'section' => 'section_title',
					'label'   => esc_html__('Title Section Background Image', 'seedone'),
					'default' => seedone_option('title_background_image', ''),
				),
				'title_background_image_cover'          => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Cover background image', 'seedone'),
					'default' => seedone_option('title_background_image_cover', false),
				),
				'title_background_image_fixed'          => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Fixed background image', 'seedone'),
					'default' => seedone_option('title_background_image_fixed', false),
				),
				'title_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Overlay for background image', 'seedone'),
					'default' => seedone_option('title_background_image_overlay', ''),
					'choices' => seedone_customizer_background_overlay_array(),
				),
				'title_custom_class'               => array(
					'type'    => 'text',
					'section' => 'section_title',
					'label'   => esc_html__('Add custom class', 'seedone'),
					'default' => seedone_option('title_custom_class', ''),
				),

				////////////////
				//main section//
				////////////////
				'main_sidebar_width'                    => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar width on big screens', 'seedone'),
					'default' => seedone_option('main_sidebar_width', ''),
					'choices' => array(
						'33' => esc_html__('Default - 1/3 - 33%', 'seedone'),
						'25' => esc_html__('1/4 - 25%', 'seedone'),
						'30' => esc_html__('30% - 70%', 'seedone'),
					),
				),
				'main_gap_width'                        => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar gap width', 'seedone'),
					'default' => seedone_option('main_gap_width', ''),
					'choices' => array(
						''  => esc_html__('Default', 'seedone'),
						'1' => esc_html__('1em', 'seedone'),
						'2' => esc_html__('2em', 'seedone'),
						'3' => esc_html__('3em', 'seedone'),
						'4' => esc_html__('4em', 'seedone'),
					),
				),
				'main_sidebar_margin_right'                        => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar margin', 'seedone'),
					'default' => seedone_option('main_sidebar_margin_right', ''),
					'choices' => array(
						''  => esc_html__('Default', 'seedone'),
						'10' => esc_html__('10px', 'seedone'),
						'15' => esc_html__('15px', 'seedone'),
						'20' => esc_html__('20px', 'seedone'),
						'30' => esc_html__('30px', 'seedone'),
						'40' => esc_html__('40px', 'seedone'),
						'60' => esc_html__('60px', 'seedone'),
						'80' => esc_html__('80px', 'seedone'),
					),
				),
				'main_sidebar_sticky'                   => array(
					'type'    => 'checkbox',
					'section' => 'section_main',
					'label'   => esc_html__('Sticky sidebar', 'seedone'),
					'default' => seedone_option('main_sidebar_sticky', false),
				),
				'main_extra_padding_top'                => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Top padding', 'seedone'),
					'default' => seedone_option('main_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pt-0'  => esc_html__('0', 'seedone'),
						'pt-1'  => esc_html__('1em', 'seedone'),
						'pt-2'  => esc_html__('2em', 'seedone'),
						'pt-3'  => esc_html__('3em', 'seedone'),
						'pt-4'  => esc_html__('4em', 'seedone'),
						'pt-5'  => esc_html__('5em', 'seedone'),
						'pt-6'  => esc_html__('6em', 'seedone'),
						'pt-7'  => esc_html__('7em', 'seedone'),
						'pt-8'  => esc_html__('8em', 'seedone'),
						'pt-9'  => esc_html__('9em', 'seedone'),
						'pt-10' => esc_html__('10em', 'seedone'),
					),
				),
				'main_extra_padding_bottom'             => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Bottom padding', 'seedone'),
					'default' => seedone_option('main_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pb-0'  => esc_html__('0', 'seedone'),
						'pb-1'  => esc_html__('1em', 'seedone'),
						'pb-2'  => esc_html__('2em', 'seedone'),
						'pb-3'  => esc_html__('3em', 'seedone'),
						'pb-4'  => esc_html__('4em', 'seedone'),
						'pb-5'  => esc_html__('5em', 'seedone'),
						'pb-6'  => esc_html__('6em', 'seedone'),
						'pb-7'  => esc_html__('7em', 'seedone'),
						'pb-8'  => esc_html__('8em', 'seedone'),
						'pb-9'  => esc_html__('9em', 'seedone'),
						'pb-10' => esc_html__('10em', 'seedone'),
					),
				),
				'main_font_size'                        => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Main section font size', 'seedone'),
					'default' => seedone_option('main_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),
				'sidebar_font_size'                     => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar font size', 'seedone'),
					'default' => seedone_option('sidebar_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),
				///////
				//404//
				///////
				'404_background_image'                => array(
					'type'    => 'image',
					'section' => 'section_404',
					'label'   => esc_html__('404 Page Background Image', 'seedone'),
					'default' => seedone_option('404_background_image', ''),
				),
				'404_background_image_cover'          => array(
					'type'    => 'checkbox',
					'section' => 'section_404',
					'label'   => esc_html__('Cover background image', 'seedone'),
					'default' => seedone_option('404_background_image_cover', false),
				),
				'404_background_image_fixed'          => array(
					'type'    => 'checkbox',
					'section' => 'section_404',
					'label'   => esc_html__('Fixed background image', 'seedone'),
					'default' => seedone_option('404_background_image_fixed', false),
				),
				'404_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('Overlay for background image', 'seedone'),
					'default' => seedone_option('404_background_image_overlay', ''),
					'choices' => seedone_customizer_background_overlay_array(),
				),
				'404_background_image_copyright'          => array(
					'type'    => 'checkbox',
					'section' => 'section_404',
					'label'   => esc_html__('Apply background image to entire page', 'seedone'),
					'description' => esc_html__('Background image must be fixed to work correctly', 'seedone'),
					'default' => seedone_option('404_background_image_copyright', false),
				),
				//////////////
				//footer_top//
				//////////////
				'footer_top'                                => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Layout', 'seedone'),
					'default' => seedone_option('footer_top', ''),
					'choices' => array(
						''  => esc_html__('Disabled', 'seedone'),
						'1' => esc_html__('Single column', 'seedone'),
						'2' => esc_html__('Single column centered', 'seedone'),
						'3' => esc_html__('Two columns', 'seedone'),
					),
				),
				'footer_top_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Full Width Section', 'seedone'),
					'default' => seedone_option('footer_top_fluid', false),
				),
				'footer_top_pre_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Pre Heading text', 'seedone'),
					'default' => seedone_option('footer_top_pre_heading', ''),
				),
				'footer_top_pre_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Pre Heading top margin', 'seedone'),
					'default' => seedone_option('footer_top_pre_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_pre_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Pre Heading bottom margin', 'seedone'),
					'default' => seedone_option('footer_top_pre_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_pre_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for pre heading', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('footer_top_pre_heading_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'footer_top_background_text'                         => array(
					'type'    => 'text',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background text', 'seedone'),
					'default' => seedone_option('footer_top_background_text', ''),
				),
				'footer_top_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading text', 'seedone'),
					'default' => seedone_option('footer_top_heading', ''),
				),
				'footer_top_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading top margin', 'seedone'),
					'default' => seedone_option('footer_top_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading bottom margin', 'seedone'),
					'default' => seedone_option('footer_top_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for footer_top heading', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('footer_top_heading_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'footer_top_description'                     => array(
					'type'    => 'textarea',
					'section' => 'section_footer_top',
					'label'   => esc_html__('description text', 'seedone'),
					'default' => seedone_option('footer_top_description', ''),
				),
				'footer_top_description_mt'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Description top margin', 'seedone'),
					'default' => seedone_option('footer_top_description_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_description_mb'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Description bottom margin', 'seedone'),
					'default' => seedone_option('footer_top_description_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_description_animation'           => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for footer_top description text', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('footer_top_description_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'footer_top_shortcode'                       => array(
					'type'        => 'text',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Shortcode', 'seedone'),
					'description' => esc_html__('You can put shortcode here. It will appear below description', 'seedone'),
					'default'     => seedone_option('footer_top_shortcode', ''),
				),
				'footer_top_shortcode_mt'                    => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Shortcode top margin', 'seedone'),
					'default' => seedone_option('footer_top_shortcode_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_shortcode_mb'                    => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Shortcode bottom margin', 'seedone'),
					'default' => seedone_option('footer_top_shortcode_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_shortcode_animation'             => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for shortcode', 'seedone'),
					'description' => esc_html__('Animation should be enabled', 'seedone'),
					'default'     => seedone_option('footer_top_shortcode_animation', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'footer_top_background'                     => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background', 'seedone'),
					'default' => seedone_option('footer_top_background', ''),
					'choices' => seedone_customizer_backgrounds_array(),
				),
				'footer_top_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top border', 'seedone'),
					'default' => seedone_option('footer_top_border_top', ''),
					'choices' => seedone_customizer_borders_array(),
				),
				'footer_top_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Bottom border', 'seedone'),
					'default' => seedone_option('footer_top_border_bottom', ''),
					'choices' => seedone_customizer_borders_array(),
				),
				'footer_top_extra_padding_top'              => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top padding', 'seedone'),
					'default' => seedone_option('footer_top_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pt-0'  => esc_html__('0', 'seedone'),
						'pt-1'  => esc_html__('1em', 'seedone'),
						'pt-2'  => esc_html__('2em', 'seedone'),
						'pt-3'  => esc_html__('3em', 'seedone'),
						'pt-4'  => esc_html__('4em', 'seedone'),
						'pt-5'  => esc_html__('5em', 'seedone'),
						'pt-6'  => esc_html__('6em', 'seedone'),
						'pt-7'  => esc_html__('7em', 'seedone'),
						'pt-8'  => esc_html__('8em', 'seedone'),
						'pt-9'  => esc_html__('9em', 'seedone'),
						'pt-10' => esc_html__('10em', 'seedone'),
					),
				),
				'footer_top_extra_padding_bottom'           => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Bottom padding', 'seedone'),
					'default' => seedone_option('footer_top_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pb-0'  => esc_html__('0', 'seedone'),
						'pb-1'  => esc_html__('1em', 'seedone'),
						'pb-2'  => esc_html__('2em', 'seedone'),
						'pb-3'  => esc_html__('3em', 'seedone'),
						'pb-4'  => esc_html__('4em', 'seedone'),
						'pb-5'  => esc_html__('5em', 'seedone'),
						'pb-6'  => esc_html__('6em', 'seedone'),
						'pb-7'  => esc_html__('7em', 'seedone'),
						'pb-8'  => esc_html__('8em', 'seedone'),
						'pb-9'  => esc_html__('9em', 'seedone'),
						'pb-10' => esc_html__('10em', 'seedone'),
					),
				),
				'footer_top_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Font Size', 'seedone'),
					'default' => seedone_option('footer_top_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),
				'footer_top_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background Image', 'seedone'),
					'default' => seedone_option('footer_top_background_image', ''),
				),
				'footer_top_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Cover background image', 'seedone'),
					'default' => seedone_option('footer_top_background_image_cover', false),
				),
				'footer_top_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Fixed background image', 'seedone'),
					'default' => seedone_option('footer_top_background_image_fixed', false),
				),
				'footer_top_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Overlay for background image', 'seedone'),
					'default' => seedone_option('footer_top_background_image_overlay', ''),
					'choices' => seedone_customizer_background_overlay_array(),
				),
				'footer_top_absolute_image'                => array(
					'type'    => 'image',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Image Absolute', 'seedone'),
					'default' => seedone_option('footer_top_absolute_image', ''),
				),

				//////////
				//footer//
				//////////
				'footer'                                => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Layout', 'seedone'),
					'default' => seedone_option('footer', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'seedone'),
						'1' => esc_html__('Equal columns', 'seedone'),
						'2' => esc_html__('First one half column', 'seedone'),
						'3' => esc_html__('Second one half column', 'seedone'),
						'4' => esc_html__('Full Width', 'seedone'),
						'5' => esc_html__('Full Width centered', 'seedone'),
						'6' => esc_html__('Full Width centered narrow', 'seedone'),
						'7' => esc_html__('Second and third narrow columns', 'seedone'),
						'8' => esc_html__('Four columns', 'seedone'),
						'9' => esc_html__('Poultry footer', 'seedone'),
						'10' => esc_html__('Microgreen footer', 'seedone'),
					),
				),
				'footer_layout_gap'                     => array(
					'type'        => 'select',
					'section'     => 'section_footer',
					'label'       => esc_html__('Footer widgets gap', 'seedone'),
					'description' => esc_html__('Used only for multiple columns layouts', 'seedone'),
					'default'     => seedone_option('footer_layout_gap', ''),
					'choices'     => seedone_get_feed_layout_gap_options(),
				),
				'footer_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Full Width Footer', 'seedone'),
					'default' => seedone_option('footer_fluid', false),
				),
				'footer_background'                     => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Background', 'seedone'),
					'default' => seedone_option('footer_background', ''),
					'choices' => seedone_customizer_backgrounds_array(),
				),
				'footer_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Top border', 'seedone'),
					'default' => seedone_option('footer_border_top', ''),
					'choices' => seedone_customizer_borders_array(),
				),
				'footer_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Bottom border', 'seedone'),
					'default' => seedone_option('footer_border_bottom', ''),
					'choices' => seedone_customizer_borders_array(),
				),
				'footer_extra_padding_top'              => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Top padding', 'seedone'),
					'default' => seedone_option('footer_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pt-0'  => esc_html__('0', 'seedone'),
						'pt-1'  => esc_html__('1em', 'seedone'),
						'pt-2'  => esc_html__('2em', 'seedone'),
						'pt-3'  => esc_html__('3em', 'seedone'),
						'pt-4'  => esc_html__('4em', 'seedone'),
						'pt-5'  => esc_html__('5em', 'seedone'),
						'pt-6'  => esc_html__('6em', 'seedone'),
						'pt-7'  => esc_html__('7em', 'seedone'),
						'pt-8'  => esc_html__('8em', 'seedone'),
						'pt-9'  => esc_html__('9em', 'seedone'),
						'pt-10' => esc_html__('10em', 'seedone'),
					),
				),
				'footer_extra_padding_bottom'           => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Bottom padding', 'seedone'),
					'default' => seedone_option('footer_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pb-0'  => esc_html__('0', 'seedone'),
						'pb-1'  => esc_html__('1em', 'seedone'),
						'pb-2'  => esc_html__('2em', 'seedone'),
						'pb-3'  => esc_html__('3em', 'seedone'),
						'pb-4'  => esc_html__('4em', 'seedone'),
						'pb-5'  => esc_html__('5em', 'seedone'),
						'pb-6'  => esc_html__('6em', 'seedone'),
						'pb-7'  => esc_html__('7em', 'seedone'),
						'pb-8'  => esc_html__('8em', 'seedone'),
						'pb-9'  => esc_html__('9em', 'seedone'),
						'pb-10' => esc_html__('10em', 'seedone'),
					),
				),
				'footer_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Section Font Size', 'seedone'),
					'default' => seedone_option('footer_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),
				'footer_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Section Background Image', 'seedone'),
					'default' => seedone_option('footer_background_image', ''),
				),
				'footer_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Cover background image', 'seedone'),
					'default' => seedone_option('footer_background_image_cover', false),
				),
				'footer_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Fixed background image', 'seedone'),
					'default' => seedone_option('footer_background_image_fixed', false),
				),
				'footer_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Overlay for background image', 'seedone'),
					'default' => seedone_option('footer_background_image_overlay', ''),
					'choices' => seedone_customizer_background_overlay_array(),
				),
				'footer_custom_class'               => array(
					'type'    => 'text',
					'section' => 'section_footer',
					'label'   => esc_html__('Add custom class', 'seedone'),
					'default' => seedone_option('footer_custom_class', ''),
				),

				/////////////
				//copyright//
				/////////////
				'copyright'                             => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Layout', 'seedone'),
					'default' => seedone_option('copyright', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'seedone'),
						'1' => esc_html__('Only copyright (centered)', 'seedone'),
						'2' => esc_html__('Only copyright (left aligned)', 'seedone'),
						'3' => esc_html__('Left copyright and right menu', 'seedone'),
						'4' => esc_html__('Left copyright and right social icons', 'seedone'),
						'5' => esc_html__('Left copyright, menu and right social icons', 'seedone'),
						'6' => esc_html__('Left logo image, copyright and right social icons', 'seedone'),
					),
				),
				'copyright_text'                        => array(
					'type'        => 'textarea',
					'section'     => 'section_copyright',
					'label'       => esc_html__('Copyright text', 'seedone'),
					'description' => esc_html__('Site name will be displayed, if leave empty', 'seedone'),
					'default'     => seedone_option('copyright_text', ''),
				),
				'copyright_fluid'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Full Width copyright', 'seedone'),
					'default' => seedone_option('copyright_fluid', true),
				),
				'copyright_background'                  => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Background', 'seedone'),
					'default' => seedone_option('copyright_background', ''),
					'choices' => seedone_customizer_backgrounds_array(),
				),
				'copyright_extra_padding_top'           => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Top padding', 'seedone'),
					'default' => seedone_option('copyright_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pt-0'  => esc_html__('0', 'seedone'),
						'pt-1'  => esc_html__('1em', 'seedone'),
						'pt-2'  => esc_html__('2em', 'seedone'),
						'pt-3'  => esc_html__('3em', 'seedone'),
						'pt-4'  => esc_html__('4em', 'seedone'),
						'pt-5'  => esc_html__('5em', 'seedone'),
						'pt-6'  => esc_html__('6em', 'seedone'),
						'pt-7'  => esc_html__('7em', 'seedone'),
						'pt-8'  => esc_html__('8em', 'seedone'),
						'pt-9'  => esc_html__('9em', 'seedone'),
						'pt-10' => esc_html__('10em', 'seedone'),
					),
				),
				'copyright_extra_padding_bottom'        => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Bottom padding', 'seedone'),
					'default' => seedone_option('copyright_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'seedone'),
						'pb-0'  => esc_html__('0', 'seedone'),
						'pb-1'  => esc_html__('1em', 'seedone'),
						'pb-2'  => esc_html__('2em', 'seedone'),
						'pb-3'  => esc_html__('3em', 'seedone'),
						'pb-4'  => esc_html__('4em', 'seedone'),
						'pb-5'  => esc_html__('5em', 'seedone'),
						'pb-6'  => esc_html__('6em', 'seedone'),
						'pb-7'  => esc_html__('7em', 'seedone'),
						'pb-8'  => esc_html__('8em', 'seedone'),
						'pb-9'  => esc_html__('9em', 'seedone'),
						'pb-10' => esc_html__('10em', 'seedone'),
					),
				),
				'copyright_font_size'                   => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright section font size', 'seedone'),
					'default' => seedone_option('copyright_font_size', ''),
					'choices' => seedone_customizer_font_size_array(),
				),
				'copyright_background_image'            => array(
					'type'    => 'image',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Section Background Image', 'seedone'),
					'default' => seedone_option('copyright_background_image', ''),
				),
				'copyright_background_image_cover'      => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Cover background image', 'seedone'),
					'default' => seedone_option('copyright_background_image_cover', false),
				),
				'copyright_background_image_fixed'      => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Fixed background image', 'seedone'),
					'default' => seedone_option('copyright_background_image_fixed', false),
				),
				'copyright_background_image_overlay'    => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Overlay for background image', 'seedone'),
					'default' => seedone_option('footer_background_image_overlay', ''),
					'choices' => seedone_customizer_background_overlay_array(),
				),
				'copyright_logo_image'                => array(
					'type'    => 'image',
					'section' => 'section_copyright',
					'label'   => esc_html__('Logo Image', 'seedone'),
					'description' => esc_html__('If copyright layout contains it', 'seedone'),
					'default' => seedone_option('copyright_logo_image', ''),
				),

				/////////
				//fonts//
				/////////
				'font_body_heading'                     => array(
					'type'        => 'block-heading',
					'section'     => 'section_fonts',
					'label'       => esc_html__('Body font options', 'seedone'),
					'description' => esc_html__('You can use CMD (CTRL) key for select multiple variants and subsets.', 'seedone'),
				),
				'font_body'                             => array(
					'type'    => 'google-font',
					'section' => 'section_fonts',
					'label'   => esc_html__('Body Custom Font', 'seedone'),
					'default' => seedone_option('font_body', '{"font":"","variant": [],"subset":[]}'),
				),
				'font_headings_heading'                 => array(
					'type'        => 'block-heading',
					'section'     => 'section_fonts',
					'label'       => esc_html__('Secondary font options', 'seedone'),
					'description' => esc_html__('Used for header, title, headings and buttons. You can use CMD (CTRL) key for select multiple variants and subsets.', 'seedone'),
				),
				'font_headings'                         => array(
					'type'    => 'google-font',
					'section' => 'section_fonts',
					'label'   => esc_html__('Secondary Custom Font', 'seedone'),
					'default' => seedone_option('font_headings', '{"font":"","variant": [],"subset":[]}'),
				),

				////////
				//blog//
				////////
				'blog_layout'                           => array(
					'type'    => 'select',
					'section' => 'section_blog',
					'label'   => esc_html__('Blog feed layout', 'seedone'),
					'default' => seedone_option('blog_layout', ''),
					'choices' => seedone_get_feed_layout_options(),
				),
				'blog_layout_gap'                       => array(
					'type'        => 'select',
					'section'     => 'section_blog',
					'label'       => esc_html__('Blog feed layout gap', 'seedone'),
					'description' => esc_html__('Used only for grid and masonry layouts', 'seedone'),
					'default'     => seedone_option('blog_layout_gap', ''),
					'choices'     => seedone_get_feed_layout_gap_options(),
				),
				'blog_sidebar_position'                 => array(
					'type'        => 'radio',
					'section'     => 'section_blog',
					'label'       => esc_html__('Blog sidebar position', 'seedone'),
					'description' => esc_html__('Can be overriden for certain category on category edit page', 'seedone'),
					'default'     => seedone_option('blog_sidebar_position', 'right'),
					'choices'     => seedone_get_sidebar_position_options(),
				),
				'blog_page_name'                        => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Blog page name. Default: \'Blog\'', 'seedone'),
					'default' => seedone_option('blog_page_name', esc_html__('Blog', 'seedone')),
				),
				'blog_show_full_text'                   => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show full text instead of excerpt', 'seedone'),
					'default' => seedone_option('blog_show_full_text', false),
				),
				'blog_excerpt_length'                   => array(
					'type'        => 'number',
					'section'     => 'section_blog',
					'label'       => esc_html__('Custom excerpt length', 'seedone'),
					'description' => esc_html__('Words amount', 'seedone'),
					'default'     => seedone_option('blog_excerpt_length', 40),
				),
				'blog_read_more_text'                   => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('\'Read More\' text. Leave blank to hide', 'seedone'),
					'default' => seedone_option('blog_read_more_text', ''),
				),
				'blog_hide_taxonomy_type_name'          => array(
					'type'        => 'checkbox',
					'section'     => 'section_blog',
					'label'       => esc_html__('Hide taxonomy type name in title section', 'seedone'),
					'default'     => seedone_option('blog_hide_taxonomy_type_name', false),
					'description' => esc_html__('You can hide taxonomy name (ex. \'Tag:\') word if you want.', 'seedone'),
				),
				'blog_meta_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog',
					'label'       => esc_html__('Post meta options', 'seedone'),
					'description' => esc_html__('Select what post meta you want to show in blog feed. Not all layouts will show post meta even if it is checked.', 'seedone'),
				),
				'blog_hide_meta_icons'                  => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Hide icons in the post meta', 'seedone'),
					'default' => seedone_option('blog_hide_meta_icons', false),
				),
				'blog_show_author'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show author', 'seedone'),
					'default' => seedone_option('blog_show_author', true),
				),
				'blog_show_author_avatar'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show author avatar', 'seedone'),
					'default' => seedone_option('blog_show_author_avatar', false),
				),
				'blog_before_author_word'               => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before author', 'seedone'),
					'default' => seedone_option('blog_before_author_word', ''),
				),
				'blog_show_date'                        => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show date', 'seedone'),
					'default' => seedone_option('blog_show_date', true),
				),
				'blog_before_date_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before date', 'seedone'),
					'default' => seedone_option('blog_before_date_word', ''),
				),
				'blog_show_categories'                  => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show categories', 'seedone'),
					'default' => seedone_option('blog_show_categories', true),
				),
				'blog_before_categories_word'           => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before categories', 'seedone'),
					'default' => seedone_option('blog_before_categories_word', ''),
				),
				'blog_show_tags'                        => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show tags', 'seedone'),
					'default' => seedone_option('blog_show_tags', true),
				),
				'blog_before_tags_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before tags', 'seedone'),
					'default' => seedone_option('blog_before_tags_word', ''),
				),
				'blog_show_views'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show views', 'seedone'),
					'default' => seedone_option('blog_show_views', true),
				),
				'blog_before_views_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before views', 'seedone'),
					'default' => seedone_option('blog_before_views_word', ''),
				),
				'blog_show_comments_link'               => array(
					'type'    => 'select',
					'section' => 'section_blog',
					'label'   => esc_html__('Show comments count', 'seedone'),
					'default' => seedone_option('blog_show_comments_link', true),
					'choices' => array(
						''       => esc_html__('None', 'seedone'),
						'text'   => esc_html__('Comments number with text', 'seedone'),
						'number' => esc_html__('Only comments number', 'seedone'),
					),
				),
				'blog_share_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog',
					'label'       => esc_html__('Share buttons', 'seedone'),
				),
				'blog_share_facebook'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button facebook', 'seedone'),
					'default' => seedone_option('blog_share_facebook', true),
				),
				'blog_share_twitter'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button facebook', 'seedone'),
					'default' => seedone_option('blog_share_twitter', true),
				),
				'blog_share_telegram'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button telegram', 'seedone'),
					'default' => seedone_option('blog_share_telegram', true),
				),
				'blog_share_pinterest'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button pinterest', 'seedone'),
					'default' => seedone_option('blog_share_pinterest', true),
				),
				'blog_share_linkedin'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button linkedin', 'seedone'),
					'default' => seedone_option('blog_share_linkedin', true),
				),
				'blog_button_background_img'                => array(
					'type'    => 'image',
					'section' => 'section_blog',
					'label'   => esc_html__('Button play background image', 'seedone'),
					'default' => seedone_option('blog_button_background_img', ''),
				),

				////////
				//post//
				////////
				//same as blog (except post nav and author bio)
				'blog_single_layout'                    => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Blog post layout', 'seedone'),
					'default' => seedone_option('blog_single_layout', ''),
					'choices' => seedone_get_post_layout_options(),
				),
				'blog_single_sidebar_position'          => array(
					'type'        => 'radio',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Blog post sidebar position', 'seedone'),
					'description' => esc_html__('Can be overriden for certain post by selecting appropriate post template', 'seedone'),
					'default'     => seedone_option('blog_single_sidebar_position', 'right'),
					'choices'     => seedone_get_sidebar_position_options(),
				),
				'blog_single_show_author_bio'           => array(
					'type'        => 'checkbox',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Show Author Bio', 'seedone'),
					'description' => esc_html__('You need to fill Biographical Info to display author bio', 'seedone'),
					'default'     => seedone_option('blog_single_show_author_bio', true),
				),
				'blog_single_author_bio_about_word'     => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'About author\' intro word', 'seedone'),
					'description' => esc_html__('Leave blank if not needed', 'seedone'),
					'default'     => seedone_option('blog_single_author_bio_about_word', ''),
				),
				'blog_single_post_nav_heading'          => array(
					'type'    => 'block-heading',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Posts navigation settings', 'seedone'),
				),
				'blog_single_post_nav'                  => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Posts Navigation', 'seedone'),
					'default' => seedone_option('blog_single_post_nav', ''),
					'choices' => array(
						''          => esc_html__('Disabled', 'seedone'),
						'title'     => esc_html__('Only title', 'seedone'),
						'bg'        => esc_html__('Background featured image', 'seedone'),
						'thumbnail' => esc_html__('Thumbnail featured image', 'seedone'),
					),
				),
				'blog_single_post_nav_word_prev'        => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'Previous post\' word', 'seedone'),
					'description' => esc_html__('Post navigation has to be chosen', 'seedone'),
					'default'     => seedone_option('blog_single_post_nav_word_prev', esc_html__('Prev', 'seedone')),
				),
				'blog_single_post_nav_word_next'        => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'Next post\' word', 'seedone'),
					'description' => esc_html__('Post navigation has to be chosen', 'seedone'),
					'default'     => seedone_option('blog_single_post_nav_word_next', esc_html__('Next', 'seedone')),
				),
				'blog_single_related_posts_heading'     => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts settings', 'seedone'),
					'description' => esc_html__('Related posts are based on post tags', 'seedone'),
				),
				'blog_single_related_posts'             => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Related posts', 'seedone'),
					'default' => seedone_option('blog_single_related_posts', ''),
					'choices' => array(
						''                => esc_html__('Hidden', 'seedone'),
						'list'            => esc_html__('Simple list', 'seedone'),
						'list-thumbnails' => esc_html__('List with thumbnails', 'seedone'),
						'grid'            => esc_html__('Posts grid', 'seedone'),
					),
				),
				'blog_single_related_posts_title'       => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts title', 'seedone'),
					'default'     => seedone_option('blog_single_related_posts_title', ''),
					'description' => esc_html__('Related posts heading title', 'seedone'),
				),
				'blog_single_related_posts_number'      => array(
					'type'        => 'number',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts number', 'seedone'),
					'default'     => seedone_option('blog_single_related_posts_number', ''),
					'description' => esc_html__('Related posts layout has to be chosen', 'seedone'),
				),
				'blog_single_meta_options_heading'      => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Single post meta options', 'seedone'),
					'description' => esc_html__('Select what post meta you want to show in single post. Not all layouts will show post meta even if it is checked.', 'seedone'),
				),
				'blog_single_hide_meta_icons'           => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Hide icons in the post meta', 'seedone'),
					'default' => seedone_option('blog_single_hide_meta_icons', false),
				),
				'blog_single_show_author'               => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show author', 'seedone'),
					'default' => seedone_option('blog_single_show_author', true),
				),
				'blog_single_before_author_word'        => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before author', 'seedone'),
					'default' => seedone_option('blog_single_before_author_word', ''),
				),
				'blog_single_show_date'                 => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show date', 'seedone'),
					'default' => seedone_option('blog_single_show_date', true),
				),
				'blog_single_before_date_word'          => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before date', 'seedone'),
					'default' => seedone_option('blog_single_before_date_word', ''),
				),
				'blog_single_show_categories'           => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show categories', 'seedone'),
					'default' => seedone_option('blog_single_show_categories', true),
				),
				'blog_single_before_categories_word'    => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before categories', 'seedone'),
					'default' => seedone_option('blog_single_before_categories_word', ''),
				),
				'blog_single_show_tags'                 => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show tags', 'seedone'),
					'default' => seedone_option('blog_single_show_tags', true),
				),
				'blog_single_before_tags_word'          => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before tags', 'seedone'),
					'default' => seedone_option('blog_single_before_tags_word', ''),
				),
				'blog_single_show_views'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show views', 'seedone'),
					'default' => seedone_option('blog_single_show_views', true),
				),
				'blog_single_before_views_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before views', 'seedone'),
					'default' => seedone_option('blog_single_before_views_word', ''),
				),
				'blog_single_show_comments_link'        => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show comments count', 'seedone'),
					'default' => seedone_option('blog_single_show_comments_link', true),
					'choices' => array(
						''       => esc_html__('None', 'seedone'),
						'text'   => esc_html__('Comments number with text', 'seedone'),
						'number' => esc_html__('Only comments number', 'seedone'),
					),
				),
				'blog_single_comments_title_reply'      => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Comments form title', 'seedone'),
					'default' => seedone_option('blog_single_comments_title_reply', ''),
				),
				'blog_single_share_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Share buttons', 'seedone'),
				),
				'blog_single_share_facebook'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button facebook', 'seedone'),
					'default' => seedone_option('blog_single_share_facebook', true),
				),
				'blog_single_share_twitter'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button facebook', 'seedone'),
					'default' => seedone_option('blog_single_share_twitter', true),
				),
				'blog_single_share_telegram'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button telegram', 'seedone'),
					'default' => seedone_option('blog_single_share_telegram', true),
				),
				'blog_single_share_pinterest'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button pinterest', 'seedone'),
					'default' => seedone_option('blog_single_share_pinterest', true),
				),
				'blog_single_share_linkedin'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button linkedin', 'seedone'),
					'default' => seedone_option('blog_single_share_linkedin', true),
				),
				'blog_single_blockquote_image'                => array(
					'type'    => 'image',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Blockquote Image', 'seedone'),
					'default' => seedone_option('blog_single_blockquote_image', ''),
				),

				///////////////
				// animation //
				///////////////
				'animation_enabled'                     => array(
					'type'        => 'checkbox',
					'section'     => 'section_animation',
					'label'       => esc_html__('Enable CSS animation for elements', 'seedone'),
					'default'     => seedone_option('animation_enabled', false),
					'description' => esc_html__('Please note that additional JS file (2 kB) and CSS file (25 kB) will be loaded if enabled', 'seedone'),
				),
				'animation_sidebar_widgets'             => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for main sidebar widgets', 'seedone'),
					'description' => esc_html__('If you want to animate main sidebar widgets - select one of predefined animation type', 'seedone'),
					'default'     => seedone_option('animation_sidebar_widgets', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'animation_footer_widgets'              => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for footer widgets', 'seedone'),
					'description' => esc_html__('If you want to animate footer widgets - select one of predefined animation type', 'seedone'),
					'default'     => seedone_option('animation_footer_widgets', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'animation_feed_posts'                  => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for posts in posts feed', 'seedone'),
					'description' => esc_html__('If you want to animate blog feed posts - select one of predefined animation type', 'seedone'),
					'default'     => seedone_option('animation_feed_posts', ''),
					'choices'     => seedone_get_animation_options(),
				),
				'animation_feed_posts_thumbnail'        => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for posts thumbnails in posts feed', 'seedone'),
					'description' => esc_html__('If you want to animate blog feed posts thumbnail - select one of predefined animation type', 'seedone'),
					'default'     => seedone_option('animation_feed_posts_thumbnail', ''),
					'choices'     => seedone_get_animation_options(),
				),
			) //options array
		); //apply_filters
	}
endif;

//init customizer with 'seedone_customizer_settings_array' settings filter
add_action('init', 'seedone_init_customizer_class');
if (!function_exists('seedone_init_customizer_class')) :
	function seedone_init_customizer_class()
	{
		$seedone_customizer = new Seedone_Customizer(
			seedone_customizer_settings_array()
		);
	}
endif;
