<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Seedone
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
$seedone_body_itemtype = seedone_get_body_schema_itemtype();

?>
<!doctype html>
<html <?php language_attributes(); ?> class="no-js-disabled<?php echo is_customize_preview() ? ' customize-preview' : ''; ?>">

<head>
	<meta charset="<?php bloginfo('charset'); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php wp_head(); ?>
</head>

<body id="body" <?php body_class(); ?> itemtype="https://schema.org/<?php echo esc_attr($seedone_body_itemtype); ?>" itemscope="itemscope" <?php seedone_animated_elements_markup(); ?>>
	<?php
	if (function_exists('wp_body_open')) {
		wp_body_open();
	}

	get_template_part('template-parts/header/header-preloader');

	/**
	 * Fires at the top of whole web page before the header.
	 *
	 * @since WBPlank 0.0.1
	 */
	do_action('seedone_action_before_header');

	?>
	<div id="search_dropdown">
		<?php get_search_form(); ?>
	</div><!-- #search_dropdown -->
	<button id="search_modal_close" class="nav-btn" aria-controls="search_dropdown" aria-expanded="true" aria-label="<?php esc_attr_e('Search Toggler', 'seedone'); ?>">
		<span></span>
	</button>
	<div id="login_dropdown" class="modalLoginWrap">
		<?php
		$seedone_logo_background     = seedone_option('header_logo_background', '');
		?>
		<div class="modal modal-login active">
			<div class="img-section" <?php echo (!empty($seedone_logo_background)) ? 'style="background-image: url(' . esc_url($seedone_logo_background) . ');"' : ''; ?>>
				<p><?php echo esc_html__('New user?', 'seedone') ?></p>
				<h4><?php echo esc_html__('Register', 'seedone') ?></h4>
				<button class="button" data-toggle="modal-registration"><?php echo esc_html__('Sign up', 'seedone') ?></button>
			</div>
			<div class="form-section">
				<h4 class="mb-1"><?php echo esc_html__('Log in', 'seedone') ?></h4>
				<?php
				if (!is_user_logged_in()) :
					wp_login_form(array(
						'label_username' => esc_html__('Email address', 'seedone'),
						'label_password' => esc_html__('Password', 'seedone'),
						'label_remember' => esc_html__('Remember Me', 'seedone'),
						'label_log_in' => esc_html__('Sign in', 'seedone'),
						'remember' => esc_html__('Remember me', 'seedone'),
					));

				else :
					$html = '<a href="' . esc_url(wp_logout_url()) . '" class="button">' . esc_html__('Log out', 'seedone') . '</a>';
					if (current_user_can('read')) {
						$html .= ' <a href="' . admin_url() . '" class="button is-dark mt-1">' . esc_html__('Site Admin', 'seedone') . '</a>';
					}
					echo wp_kses_post($html);
				endif; //is_user_logged_in
				?>
				<?php if (!is_user_logged_in()) : ?>
					<div class="divider-30"></div>
					<a href="<?php echo esc_url(wp_lostpassword_url()); ?>"><?php esc_html_e('Forgot password?', 'seedone'); ?></a>
				<?php endif; ?>
			</div>
		</div>
		<div class="modal modal-registration">
			<div class="form-section">
				<h4 class="mb-1"><?php echo esc_html__('Registration', 'seedone') ?></h4>
				<?php
				do_action('user_registration_form');
				?>
			</div>
			<div class="img-section" <?php echo (!empty($seedone_logo_background)) ? 'style="background-image: url(' . esc_url($seedone_logo_background) . ');"' : ''; ?>>
				<p><?php echo esc_html__('Also registered?', 'seedone') ?></p>
				<h4><?php echo esc_html__('Log in', 'seedone') ?></h4>
				<button class="button" data-toggle="modal-login"><?php echo esc_html__('Sign in', 'seedone') ?></button>
			</div>
		</div>
	</div><!-- #search_dropdown -->
	<button id="login_modal_close" aria-controls="login_dropdown" class="nav-btn" aria-expanded="true" aria-label="<?php esc_attr_e('Login Toggler', 'seedone'); ?>">
		<span></span>
	</button>
	<?php
	$seedone_box_fade_in_class = seedone_option('box_fade_in', '') ? 'box-fade-in' : 'box-normal';
	?>
	<div id="box" class="<?php echo esc_attr($seedone_box_fade_in_class); ?>">
		<?php

		//topline, header and title here:
		get_template_part('template-parts/header/header-top');

		//not opening container for 404 page or for full-width page template
		if (!is_page_template('page-templates/full-width.php') && !is_404()) :
			$seedone_main_sidebar_width   = seedone_option('main_sidebar_width', '');
			$seedone_main_gap_width       = seedone_option('main_gap_width', 'default');
			$seedone_extra_padding_top    = seedone_option('main_extra_padding_top', '');
			$seedone_extra_padding_bottom = seedone_option('main_extra_padding_bottom', '');
			$seedone_font_size            = seedone_option('main_font_size', '');
			$seedone_main_css_classes     = seedone_get_page_main_section_css_classes();
			$seedone_css_classes          = seedone_get_layout_css_classes();

			if (empty($seedone_extra_padding_top) && !seedone_is_title_section_is_shown()) {
				$seedone_extra_padding_top = 'pt-5';
			}
			//no top padding for page template without title and padding
			if (
				is_page_template('page-templates/no-sidebar-no-title.php')
				||
				is_page_template('page-templates/no-sidebar-no-padding.php')
			) {
				$seedone_extra_padding_top    = 'pt-0';
				$seedone_extra_padding_bottom = 'pb-0';
			}
		?>
			<div id="main" class="main <?php echo esc_attr('sidebar-' . $seedone_main_sidebar_width . ' sidebar-gap-' . $seedone_main_gap_width . ' ' . $seedone_main_css_classes); ?>">
				<div class="container <?php echo esc_attr($seedone_extra_padding_top . ' ' . $seedone_extra_padding_bottom); ?>">
					<?php
					//full width widget area before columns for home page
					if (seedone_is_front_page() && is_active_sidebar('sidebar-home-before-columns')) :
					?>
						<div class="sidebar-home sidebar-home-before sidebar-home-before-columns">
							<?php dynamic_sidebar('sidebar-home-before-columns'); ?>
						</div><!-- .sidebar-home-before-columns -->
					<?php endif; ?>
					<div id="columns" class="main-columns">
						<main id="col" class="<?php echo esc_attr($seedone_css_classes['main'] . ' ' . $seedone_font_size); ?>">
						<?php
						/**
						 * Fires at the top of main column.
						 *
						 * @since WBPlank 0.0.1
						 */
						do_action('seedone_action_top_of_main_column');

					endif; //full-width & 404
					if (seedone_is_front_page() && is_active_sidebar('sidebar-home-before-content')) :
						?>
							<div class="sidebar-home sidebar-home-before sidebar-home-before-content">
								<?php dynamic_sidebar('sidebar-home-before-content'); ?>
							</div><!-- .sidebar-home-before-content -->
						<?php
					endif; //seedone_is_front_page
