import { MoveableManagerInterface, SnappableProps, SnappableState, SnapBoundInfo, SnapGuideline, BoundType, DraggableProps } from "../../types";
interface DirectionSnapType<T> {
    vertical: T;
    horizontal: T;
}
export declare function solveEquation(pos1: number[], pos2: number[], snapOffset: number, isVertical: boolean): number[];
export declare function checkThrottleDragRotate(throttleDragRotate: number, [distX, distY]: number[], [isVerticalBound, isHorizontalBound]: boolean[], [isVerticalSnap, isHorizontalSnap]: boolean[], [verticalOffset, horizontalOffset]: number[]): number[];
export declare function checkSnapBoundsDrag(moveable: MoveableManagerInterface<SnappableProps & DraggableProps, any>, distX: number, distY: number, throttleDragRotate: number, ignoreSnap: boolean, datas: any): {
    isSnap: boolean;
    isBound: boolean;
    offset: number;
}[];
export declare function checkMoveableSnapBounds(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, ignoreSnap: boolean, poses: {
    vertical: number[];
    horizontal: number[];
}, boundPoses?: {
    vertical: number[];
    horizontal: number[];
}): DirectionSnapType<Required<SnapBoundInfo>>;
export declare function checkSnapBounds(guideines: SnapGuideline[], bounds: BoundType | undefined | false, posesX: number[], posesY: number[], snapHorizontalThreshold: number, snapVerticalThreshold: number, multiples?: number[]): DirectionSnapType<Required<SnapBoundInfo>>;
export declare function getSnapBoundInfo(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, poses: number[][], directions: number[][][], keepRatio: boolean, isRequest: boolean, datas: any): {
    isBound: boolean;
    isSnap: boolean;
    sign: number[];
    offset: number[];
}[];
export declare function checkSnapBoundsKeepRatio(moveable: MoveableManagerInterface<SnappableProps, SnappableState>, startPos: number[], endPos: number[], isRequest: boolean): DirectionSnapType<SnapBoundInfo>;
export declare function checkMaxBounds(moveable: MoveableManagerInterface<SnappableProps>, poses: number[][], direction: number[], fixedPosition: number[], datas: any): {
    maxWidth: number;
    maxHeight: number;
};
export {};
