"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.match = exports.isMergeStrategy = exports.isBufferSliding = exports.isBackPressure = exports.MergeStrategyTypeId = exports.BufferSliding = exports.BackPressure = void 0;
var _Function = require("../../Function.js");
var _Predicate = require("../../Predicate.js");
var OpCodes = _interopRequireWildcard(require("../opCodes/channelMergeStrategy.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** @internal */
const MergeStrategySymbolKey = "effect/ChannelMergeStrategy";
/** @internal */
const MergeStrategyTypeId = exports.MergeStrategyTypeId = /*#__PURE__*/Symbol.for(MergeStrategySymbolKey);
/** @internal */
const proto = {
  [MergeStrategyTypeId]: MergeStrategyTypeId
};
/** @internal */
const BackPressure = _ => {
  const op = Object.create(proto);
  op._tag = OpCodes.OP_BACK_PRESSURE;
  return op;
};
/** @internal */
exports.BackPressure = BackPressure;
const BufferSliding = _ => {
  const op = Object.create(proto);
  op._tag = OpCodes.OP_BUFFER_SLIDING;
  return op;
};
/** @internal */
exports.BufferSliding = BufferSliding;
const isMergeStrategy = u => (0, _Predicate.hasProperty)(u, MergeStrategyTypeId);
/** @internal */
exports.isMergeStrategy = isMergeStrategy;
const isBackPressure = self => self._tag === OpCodes.OP_BACK_PRESSURE;
/** @internal */
exports.isBackPressure = isBackPressure;
const isBufferSliding = self => self._tag === OpCodes.OP_BUFFER_SLIDING;
/** @internal */
exports.isBufferSliding = isBufferSliding;
const match = exports.match = /*#__PURE__*/(0, _Function.dual)(2, (self, {
  onBackPressure,
  onBufferSliding
}) => {
  switch (self._tag) {
    case OpCodes.OP_BACK_PRESSURE:
      {
        return onBackPressure();
      }
    case OpCodes.OP_BUFFER_SLIDING:
      {
        return onBufferSliding();
      }
  }
});
//# sourceMappingURL=mergeStrategy.js.map