'use client';
import { jsx } from 'react/jsx-runtime';
import { useId } from 'react';
import { useServerInsertedHTML } from 'next/navigation';

function NextSSRPlugin(props) {
    const id = useId();
    // Set routerConfig on server globalThis
    globalThis.__UPLOADTHING = props.routerConfig;
    useServerInsertedHTML(()=>{
        const html = [
            // Hydrate routerConfig on client globalThis
            `globalThis.__UPLOADTHING = ${JSON.stringify(props.routerConfig)};`
        ];
        return /*#__PURE__*/ jsx("script", {
            dangerouslySetInnerHTML: {
                __html: html.join("")
            }
        }, id);
    });
    return null;
}

export { NextSSRPlugin };
