'use client';
Object.defineProperty(exports, '__esModule', { value: true });

var jsxRuntime = require('react/jsx-runtime');
var react = require('react');
var navigation = require('next/navigation');

function NextSSRPlugin(props) {
    const id = react.useId();
    // Set routerConfig on server globalThis
    globalThis.__UPLOADTHING = props.routerConfig;
    navigation.useServerInsertedHTML(()=>{
        const html = [
            // Hydrate routerConfig on client globalThis
            `globalThis.__UPLOADTHING = ${JSON.stringify(props.routerConfig)};`
        ];
        return /*#__PURE__*/ jsxRuntime.jsx("script", {
            dangerouslySetInnerHTML: {
                __html: html.join("")
            }
        }, id);
    });
    return null;
}

exports.NextSSRPlugin = NextSSRPlugin;
