"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _ZCS6RONRcjs = require('./ZCS6RONR.cjs');


var _DQ3AW7HUcjs = require('./DQ3AW7HU.cjs');





var _6TI3NXX6cjs = require('./6TI3NXX6.cjs');





var _L5A2ID7Scjs = require('./L5A2ID7S.cjs');




var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/form/form-control.tsx
var _dom = require('@ariakit/core/utils/dom');
var _misc = require('@ariakit/core/utils/misc');
var _react = require('react');
var TagName = "input";
function getNamedElement(ref, name) {
  const element = ref.current;
  if (!element) return null;
  if (element.name === name) return element;
  if (element.form) {
    return element.form.elements.namedItem(name);
  }
  const document = _dom.getDocument.call(void 0, element);
  return document.getElementsByName(name)[0];
}
function useItem(store, name, type) {
  return store.useState(
    (state) => state.items.find((item) => item.type === type && item.name === name)
  );
}
var useFormControl = _6TI3NXX6cjs.createHook.call(void 0, 
  function useFormControl2(_a) {
    var _b = _a, {
      store,
      name: nameProp,
      getItem: getItemProp,
      touchOnBlur = true
    } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, [
      "store",
      "name",
      "getItem",
      "touchOnBlur"
    ]);
    const context = _ZCS6RONRcjs.useFormContext.call(void 0, );
    store = store || context;
    _misc.invariant.call(void 0, 
      store,
      process.env.NODE_ENV !== "production" && "FormControl must be wrapped in a Form component."
    );
    const name = `${nameProp}`;
    const id = _L5A2ID7Scjs.useId.call(void 0, props.id);
    const ref = _react.useRef.call(void 0, null);
    store.useValidate(async () => {
      const element = getNamedElement(ref, name);
      if (!element) return;
      await Promise.resolve();
      if ("validity" in element && !element.validity.valid) {
        store == null ? void 0 : store.setError(name, element.validationMessage);
      }
    });
    const getItem = _react.useCallback.call(void 0, 
      (item) => {
        const nextItem = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, item), { id: id || item.id, name, type: "field" });
        if (getItemProp) {
          return getItemProp(nextItem);
        }
        return nextItem;
      },
      [id, name, getItemProp]
    );
    const onBlurProp = props.onBlur;
    const touchOnBlurProp = _L5A2ID7Scjs.useBooleanEvent.call(void 0, touchOnBlur);
    const onBlur = _L5A2ID7Scjs.useEvent.call(void 0, (event) => {
      onBlurProp == null ? void 0 : onBlurProp(event);
      if (event.defaultPrevented) return;
      if (!touchOnBlurProp(event)) return;
      store == null ? void 0 : store.setFieldTouched(name, true);
    });
    const label = useItem(store, name, "label");
    const error = useItem(store, name, "error");
    const description = useItem(store, name, "description");
    const describedBy = _misc.cx.call(void 0, 
      error == null ? void 0 : error.id,
      description == null ? void 0 : description.id,
      props["aria-describedby"]
    );
    const invalid = store.useState(
      () => !!(store == null ? void 0 : store.getError(name)) && store.getFieldTouched(name)
    );
    props = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {
      id,
      "aria-labelledby": label == null ? void 0 : label.id,
      "aria-invalid": invalid
    }, props), {
      "aria-describedby": describedBy || void 0,
      ref: _L5A2ID7Scjs.useMergeRefs.call(void 0, ref, props.ref),
      onBlur
    });
    props = _DQ3AW7HUcjs.useCollectionItem.call(void 0, _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, { store }, props), { name, getItem }));
    return props;
  }
);
var FormControl = _6TI3NXX6cjs.memo.call(void 0, 
  _6TI3NXX6cjs.forwardRef.call(void 0, function FormControl2(props) {
    const htmlProps = useFormControl(props);
    return _6TI3NXX6cjs.createElement.call(void 0, TagName, htmlProps);
  })
);




exports.useFormControl = useFormControl; exports.FormControl = FormControl;
