import { Client, OnDrag, GestoOptions, GestoEvents } from "./types";
import EventEmitter, { TargetParam } from "@scena/event-emitter";
import { IObject } from "@daybrush/utils";
/**
 * You can set up drag, pinch events in any browser.
 */
declare class Gesto extends EventEmitter<GestoEvents> {
    options: GestoOptions;
    private flag;
    private pinchFlag;
    private data;
    private isDrag;
    private isPinch;
    private clientStores;
    private targets;
    private prevTime;
    private doubleFlag;
    private _useMouse;
    private _useTouch;
    private _useDrag;
    private _dragFlag;
    private _isTrusted;
    private _isMouseEvent;
    private _isSecondaryButton;
    private _preventMouseEvent;
    private _prevInputEvent;
    private _isDragAPI;
    private _isIdle;
    private _preventMouseEventId;
    private _window;
    /**
     *
     */
    constructor(targets: Array<Element | Window> | Element | Window, options?: GestoOptions);
    /**
     * Stop Gesto's drag events.
     */
    stop(): void;
    /**
     * The total moved distance
     */
    getMovement(clients?: Client[]): number;
    /**
     * Whether to drag
     */
    isDragging(): boolean;
    /**
     * Whether the operation of gesto is finished and is in idle state
     */
    isIdle(): boolean;
    /**
     * Whether to start drag
     */
    isFlag(): boolean;
    /**
     * Whether to start pinch
     */
    isPinchFlag(): boolean;
    /**
     * Whether to start double click
     */
    isDoubleFlag(): boolean;
    /**
     * Whether to pinch
     */
    isPinching(): boolean;
    /**
     * If a scroll event occurs, it is corrected by the scroll distance.
     */
    scrollBy(deltaX: number, deltaY: number, e: any, isCallDrag?: boolean): void;
    /**
     * Create a virtual drag event.
     */
    move([deltaX, deltaY]: number[], inputEvent: any): TargetParam<OnDrag>;
    /**
     * The dragStart event is triggered by an external event.
     */
    triggerDragStart(e: any): void;
    /**
     * Set the event data while dragging.
     */
    setEventData(data: IObject<any>): this;
    /**
     * Set the event data while dragging.
     * Use `setEventData`
     * @deprecated
     */
    setEventDatas(data: IObject<any>): this;
    /**
     * Get the current event state while dragging.
     */
    getCurrentEvent(inputEvent?: any): {
        movement: number;
        isDrag: boolean;
        isPinch: boolean;
        isScroll: boolean;
        inputEvent: any;
        distX: number;
        distY: number;
        clientX: number;
        clientY: number;
        originalClientX?: number | undefined;
        originalClientY?: number | undefined;
        deltaX: number;
        deltaY: number;
        data: IObject<any>;
        datas: IObject<any>;
    };
    /**
     * Get & Set the event data while dragging.
     */
    getEventData(): IObject<any>;
    /**
     * Get & Set the event data while dragging.
     * Use getEventData method
     * @depreacated
     */
    getEventDatas(): IObject<any>;
    /**
     * Unset Gesto
     */
    unset(): void;
    onDragStart: (e: any, isTrusted?: boolean) => false | undefined;
    onDrag: (e: any, isScroll?: boolean) => void;
    onDragEnd: (e?: any) => void;
    onPinchStart(e: TouchEvent): void;
    onPinch(e: TouchEvent, clients: Client[]): void;
    onPinchEnd(e: TouchEvent): void;
    private getCurrentStore;
    private moveClients;
    private onBlur;
    private _addStore;
    private _getPosition;
    private _allowClickEvent;
    private _attchDragEvent;
    private _dettachDragEvent;
    private _onClick;
    private _onContextMenu;
    private _allowMouseEvent;
    private _passCallback;
}
export default Gesto;
