import { EventCallback, EventHash, EventKey, EventMap, EventTriggerParams } from "./types";
import ComponentEvent from "./ComponentEvent";
declare class Component<T extends EventMap> {
    static VERSION: string;
    private _eventHandler;
    constructor();
    trigger<K extends EventKey<T>>(event: ComponentEvent<T[K], K, this> & T[K]): this;
    trigger<K extends EventKey<T>>(event: K, ...params: EventTriggerParams<T, K>): this;
    once<K extends EventKey<T>>(eventName: K, handlerToAttach: EventCallback<T, K, this>): this;
    once(eventHash: EventHash<T, this>): this;
    hasOn<K extends EventKey<T>>(eventName: K): boolean;
    on<K extends EventKey<T>>(eventName: K, handlerToAttach: EventCallback<T, K, this>): this;
    on(eventHash: EventHash<T, this>): this;
    off(eventHash?: EventHash<T, this>): this;
    off<K extends EventKey<T>>(eventName: K, handlerToDetach?: EventCallback<T, K, this>): this;
}
export default Component;
