/*
Copyright (c) NAVER Crop.
name: @cfcs/core
license: MIT
author: NAVER Crop.
repository: https://github.com/naver/cfcs
version: 0.0.6
*/
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.cfcs = factory());
})(this, (function () { 'use strict';

  /**
   * cfcs
   * Copyright (c) 2022-present NAVER Corp.
   * MIT license
   */
  function keys(obj) {
    return Object.keys(obj);
  }
  function camelize(str) {
    return str.replace(/[\s-_]([a-z])/g, function (all, letter) {
      return letter.toUpperCase();
    });
  }
  function isString(val) {
    return typeof val === "string";
  }
  function isObject(val) {
    return typeof val === "object";
  }
  function isFunction(val) {
    return typeof val === "function";
  }

  function findTarget(target) {
    var el;

    if (!target) {
      return null;
    }

    if (isString(target)) {
      el = document.querySelector(target);
    } else if (target instanceof Element) {
      el = target;
    } else if ("value" in target || "current" in target) {
      el = target.value || target.current;
    }

    return el;
  }
  function withClassMethods(methods) {
    return function (prototype, memberName) {
      methods.forEach(function (name) {
        if (name in prototype) {
          return;
        }

        prototype[name] = function () {
          var _a;

          var args = [];

          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }

          var result = (_a = this[memberName])[name].apply(_a, args); // fix `this` type to return your own `class` instance to the instance using the decorator.


          if (result === this[memberName]) {
            return this;
          } else {
            return result;
          }
        };
      });
    };
  }

  var OBSERVERS_PATH = "__observers__";

  /*
  Copyright (c) NAVER Corp.
  name: @egjs/component
  license: MIT
  author: NAVER Corp.
  repository: https://github.com/naver/egjs-component
  version: 3.0.2
  */
  /*! *****************************************************************************
  Copyright (c) Microsoft Corporation.

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** */
  function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator,
        m = s && o[s],
        i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
      next: function () {
        if (o && i >= o.length) o = void 0;
        return {
          value: o && o[i++],
          done: !o
        };
      }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
  }
  function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o),
        r,
        ar = [],
        e;

    try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    } catch (error) {
      e = {
        error: error
      };
    } finally {
      try {
        if (r && !r.done && (m = i["return"])) m.call(i);
      } finally {
        if (e) throw e.error;
      }
    }

    return ar;
  }
  function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));

    return ar;
  }

  /*
   * Copyright (c) 2015 NAVER Corp.
   * egjs projects are licensed under the MIT license
   */
  var isUndefined = function (value) {
    return typeof value === "undefined";
  };

  /**
   * Event class to provide additional properties
   * @ko Component에서 추가적인 프로퍼티를 제공하는 이벤트 클래스
   */

  var ComponentEvent =
  /*#__PURE__*/
  function () {
    /**
     * Create a new instance of ComponentEvent.
     * @ko ComponentEvent의 새로운 인스턴스를 생성한다.
     * @param eventType The name of the event.<ko>이벤트 이름.</ko>
     * @param props An object that contains additional event properties.<ko>추가적인 이벤트 프로퍼티 오브젝트.</ko>
     */
    function ComponentEvent(eventType, props) {
      var e_1, _a;

      this._canceled = false;

      if (props) {
        try {
          for (var _b = __values(Object.keys(props)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value; // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment

            this[key] = props[key];
          }
        } catch (e_1_1) {
          e_1 = {
            error: e_1_1
          };
        } finally {
          try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
      }

      this.eventType = eventType;
    }
    /**
     * Stop the event. {@link ComponentEvent#isCanceled} will return `true` after.
     * @ko 이벤트를 중단한다. 이후 {@link ComponentEvent#isCanceled}가 `true`를 반환한다.
     */


    var __proto = ComponentEvent.prototype;

    __proto.stop = function () {
      this._canceled = true;
    };
    /**
     * Returns a boolean value that indicates whether {@link ComponentEvent#stop} is called before.
     * @ko {@link ComponentEvent#stop}이 호출되었는지 여부를 반환한다.
     * @return {boolean} A boolean value that indicates whether {@link ComponentEvent#stop} is called before.<ko>이전에 {@link ComponentEvent#stop}이 불려졌는지 여부를 반환한다.</ko>
     */


    __proto.isCanceled = function () {
      return this._canceled;
    };

    return ComponentEvent;
  }();

  /**
   * A class used to manage events in a component
   * @ko 컴포넌트의 이벤트을 관리할 수 있게 하는 클래스
   */

  var Component =
  /*#__PURE__*/
  function () {
    /**
     * @support {"ie": "7+", "ch" : "latest", "ff" : "latest",  "sf" : "latest", "edge" : "latest", "ios" : "7+", "an" : "2.1+ (except 3.x)"}
     */
    function Component() {
      this._eventHandler = {};
    }
    /**
     * Trigger a custom event.
     * @ko 커스텀 이벤트를 발생시킨다
     * @param {string | ComponentEvent} event The name of the custom event to be triggered or an instance of the ComponentEvent<ko>발생할 커스텀 이벤트의 이름 또는 ComponentEvent의 인스턴스</ko>
     * @param {any[]} params Event data to be sent when triggering a custom event <ko>커스텀 이벤트가 발생할 때 전달할 데이터</ko>
     * @return An instance of the component itself<ko>컴포넌트 자신의 인스턴스</ko>
     * @example
     * ```ts
     * import Component, { ComponentEvent } from "@egjs/component";
     *
     * class Some extends Component<{
     *   beforeHi: ComponentEvent<{ foo: number; bar: string }>;
     *   hi: { foo: { a: number; b: boolean } };
     *   someEvent: (foo: number, bar: string) => void;
     *   someOtherEvent: void; // When there's no event argument
     * }> {
     *   some(){
     *     if(this.trigger("beforeHi")){ // When event call to stop return false.
     *       this.trigger("hi");// fire hi event.
     *     }
     *   }
     * }
     *
     * const some = new Some();
     * some.on("beforeHi", e => {
     *   if(condition){
     *     e.stop(); // When event call to stop, `hi` event not call.
     *   }
     *   // `currentTarget` is component instance.
     *   console.log(some === e.currentTarget); // true
     *
     *   typeof e.foo; // number
     *   typeof e.bar; // string
     * });
     * some.on("hi", e => {
     *   typeof e.foo.b; // boolean
     * });
     * // If you want to more know event design. You can see article.
     * // https://github.com/naver/egjs-component/wiki/How-to-make-Component-event-design%3F
     * ```
     */


    var __proto = Component.prototype;

    __proto.trigger = function (event) {
      var params = [];

      for (var _i = 1; _i < arguments.length; _i++) {
        params[_i - 1] = arguments[_i];
      }

      var eventName = event instanceof ComponentEvent ? event.eventType : event;

      var handlers = __spread(this._eventHandler[eventName] || []);

      if (handlers.length <= 0) {
        return this;
      }

      if (event instanceof ComponentEvent) {
        event.currentTarget = this;
        handlers.forEach(function (handler) {
          handler(event);
        });
      } else {
        handlers.forEach(function (handler) {
          // eslint-disable-next-line @typescript-eslint/no-unsafe-call
          handler.apply(void 0, __spread(params));
        });
      }

      return this;
    };
    /**
     * Executed event just one time.
     * @ko 이벤트가 한번만 실행된다.
     * @param {string} eventName The name of the event to be attached or an event name - event handler mapped object.<ko>등록할 이벤트의 이름 또는 이벤트 이름-핸들러 오브젝트</ko>
     * @param {function} handlerToAttach The handler function of the event to be attached <ko>등록할 이벤트의 핸들러 함수</ko>
     * @return An instance of the component itself<ko>컴포넌트 자신의 인스턴스</ko>
     * @example
     * ```ts
     * import Component, { ComponentEvent } from "@egjs/component";
     *
     * class Some extends Component<{
     *   hi: ComponentEvent;
     * }> {
     *   hi() {
     *     alert("hi");
     *   }
     *   thing() {
     *     this.once("hi", this.hi);
     *   }
     * }
     *
     * var some = new Some();
     * some.thing();
     * some.trigger(new ComponentEvent("hi"));
     * // fire alert("hi");
     * some.trigger(new ComponentEvent("hi"));
     * // Nothing happens
     * ```
     */


    __proto.once = function (eventName, handlerToAttach) {
      var _this = this;

      if (typeof eventName === "object" && isUndefined(handlerToAttach)) {
        var eventHash = eventName;

        for (var key in eventHash) {
          this.once(key, eventHash[key]);
        }

        return this;
      } else if (typeof eventName === "string" && typeof handlerToAttach === "function") {
        var listener_1 = function () {
          var args = [];

          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          } // eslint-disable-next-line @typescript-eslint/no-unsafe-call


          handlerToAttach.apply(void 0, __spread(args));

          _this.off(eventName, listener_1);
        };

        this.on(eventName, listener_1);
      }

      return this;
    };
    /**
     * Checks whether an event has been attached to a component.
     * @ko 컴포넌트에 이벤트가 등록됐는지 확인한다.
     * @param {string} eventName The name of the event to be attached <ko>등록 여부를 확인할 이벤트의 이름</ko>
     * @return {boolean} Indicates whether the event is attached. <ko>이벤트 등록 여부</ko>
     * @example
     * ```ts
     * import Component from "@egjs/component";
     *
     * class Some extends Component<{
     *   hi: void;
     * }> {
     *   some() {
     *     this.hasOn("hi");// check hi event.
     *   }
     * }
     * ```
     */


    __proto.hasOn = function (eventName) {
      return !!this._eventHandler[eventName];
    };
    /**
     * Attaches an event to a component.
     * @ko 컴포넌트에 이벤트를 등록한다.
     * @param {string} eventName The name of the event to be attached or an event name - event handler mapped object.<ko>등록할 이벤트의 이름 또는 이벤트 이름-핸들러 오브젝트</ko>
     * @param {function} handlerToAttach The handler function of the event to be attached <ko>등록할 이벤트의 핸들러 함수</ko>
     * @return An instance of a component itself<ko>컴포넌트 자신의 인스턴스</ko>
     * @example
     * ```ts
     * import Component, { ComponentEvent } from "@egjs/component";
     *
     * class Some extends Component<{
     *   hi: void;
     * }> {
     *   hi() {
     *     console.log("hi");
     *   }
     *   some() {
     *     this.on("hi",this.hi); //attach event
     *   }
     * }
     * ```
     */


    __proto.on = function (eventName, handlerToAttach) {
      if (typeof eventName === "object" && isUndefined(handlerToAttach)) {
        var eventHash = eventName;

        for (var name in eventHash) {
          this.on(name, eventHash[name]);
        }

        return this;
      } else if (typeof eventName === "string" && typeof handlerToAttach === "function") {
        var handlerList = this._eventHandler[eventName];

        if (isUndefined(handlerList)) {
          this._eventHandler[eventName] = [];
          handlerList = this._eventHandler[eventName];
        }

        handlerList.push(handlerToAttach);
      }

      return this;
    };
    /**
     * Detaches an event from the component.<br/>If the `eventName` is not given this will detach all event handlers attached.<br/>If the `handlerToDetach` is not given, this will detach all event handlers for `eventName`.
     * @ko 컴포넌트에 등록된 이벤트를 해제한다.<br/>`eventName`이 주어지지 않았을 경우 모든 이벤트 핸들러를 제거한다.<br/>`handlerToAttach`가 주어지지 않았을 경우 `eventName`에 해당하는 모든 이벤트 핸들러를 제거한다.
     * @param {string?} eventName The name of the event to be detached <ko>해제할 이벤트의 이름</ko>
     * @param {function?} handlerToDetach The handler function of the event to be detached <ko>해제할 이벤트의 핸들러 함수</ko>
     * @return An instance of a component itself <ko>컴포넌트 자신의 인스턴스</ko>
     * @example
     * ```ts
     * import Component, { ComponentEvent } from "@egjs/component";
     *
     * class Some extends Component<{
     *   hi: void;
     * }> {
     *   hi() {
     *     console.log("hi");
     *   }
     *   some() {
     *     this.off("hi",this.hi); //detach event
     *   }
     * }
     * ```
     */


    __proto.off = function (eventName, handlerToDetach) {
      var e_1, _a; // Detach all event handlers.


      if (isUndefined(eventName)) {
        this._eventHandler = {};
        return this;
      } // Detach all handlers for eventname or detach event handlers by object.


      if (isUndefined(handlerToDetach)) {
        if (typeof eventName === "string") {
          delete this._eventHandler[eventName];
          return this;
        } else {
          var eventHash = eventName;

          for (var name in eventHash) {
            this.off(name, eventHash[name]);
          }

          return this;
        }
      } // Detach single event handler


      var handlerList = this._eventHandler[eventName];

      if (handlerList) {
        var idx = 0;

        try {
          for (var handlerList_1 = __values(handlerList), handlerList_1_1 = handlerList_1.next(); !handlerList_1_1.done; handlerList_1_1 = handlerList_1.next()) {
            var handlerFunction = handlerList_1_1.value;

            if (handlerFunction === handlerToDetach) {
              handlerList.splice(idx, 1);

              if (handlerList.length <= 0) {
                delete this._eventHandler[eventName];
              }

              break;
            }

            idx++;
          }
        } catch (e_1_1) {
          e_1 = {
            error: e_1_1
          };
        } finally {
          try {
            if (handlerList_1_1 && !handlerList_1_1.done && (_a = handlerList_1.return)) _a.call(handlerList_1);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
      }

      return this;
    };
    /**
     * Version info string
     * @ko 버전정보 문자열
     * @name VERSION
     * @static
     * @example
     * Component.VERSION;  // ex) 3.0.0
     * @memberof Component
     */


    Component.VERSION = "3.0.2";
    return Component;
  }();

  var Observer =
  /*#__PURE__*/
  function () {
    function Observer(value) {
      this._emitter = new Component();
      this._current = value;
    }

    var __proto = Observer.prototype;
    Object.defineProperty(__proto, "current", {
      get: function () {
        return this._current;
      },
      set: function (value) {
        var isUpdate = value !== this._current;
        this._current = value;

        if (isUpdate) {
          this._emitter.trigger("update", value);
        }
      },
      enumerable: false,
      configurable: true
    });

    __proto.subscribe = function (callback) {
      this._emitter.on("update", callback);
    };

    __proto.unsubscribe = function (callback) {
      this._emitter.off("update", callback);
    };

    return Observer;
  }();

  function withReactiveMethods(ref, methods) {
    var obj = {};

    if (!methods) {
      return obj;
    }

    methods.forEach(function (name) {
      obj[name] = function () {
        var args = [];

        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }

        var current = ref.current || ref.value;
        return current[name].apply(current, args);
      };
    });
    return obj;
  }
  function observe(defaultValue) {
    return new Observer(defaultValue);
  }
  function defineObservers(instance) {
    var observers = {};
    Object.defineProperty(instance, OBSERVERS_PATH, {
      get: function () {
        return observers;
      }
    });
    return observers;
  }
  function getObservers(instance) {
    if (!instance[OBSERVERS_PATH]) {
      defineObservers(instance);
    }

    return instance[OBSERVERS_PATH];
  }
  function getObserver(instance, name, defaultValue) {
    var observers = getObservers(instance);

    if (!observers[name]) {
      observers[name] = observe(defaultValue);
    }

    return observers[name];
  }
  function setObserver(instance, name, observer) {
    var observers = getObservers(instance);
    observers[name] = observer;
  }
  function isObserver(val) {
    return val && isObject(val) && "current" in val && "subscribe" in val && "unsubscribe" in val;
  }

  function Reactive(name) {
    return function (prototype, memberName) {
      var publicName = name || memberName;
      Object.defineProperty(prototype, memberName, {
        get: function () {
          return getObserver(this, publicName).current;
        },
        set: function (value) {
          getObserver(this, publicName, value).current = value;
        }
      });

      if (publicName !== memberName) {
        Object.defineProperty(prototype, publicName, {
          get: function () {
            return getObserver(this, publicName).current;
          }
        });
      }
    };
  }

  function injectReactiveSubscribe(object) {
    object["subscribe"] = function (name, callback) {
      getObserver(this, name).subscribe(callback);
    };

    object["unsubscribe"] = function (name, callback) {
      var _this = this;

      if (!name) {
        keys(getObservers(this)).forEach(function (observerName) {
          _this.unsubscribe(observerName);
        });
        return;
      }

      if (!(name in this)) {
        return;
      }

      getObserver(this, name).unsubscribe(callback);
    };
  }
  function ReactiveSubscribe(Constructor) {
    var prototype = Constructor.prototype;
    injectReactiveSubscribe(prototype);
  }

  function reactive(setup) {
    var result = isFunction(setup) ? setup() : setup;
    var reactiveObject = {};
    defineObservers(reactiveObject);
    keys(result).forEach(function (name) {
      var value = result[name];

      if (isObserver(value)) {
        setObserver(reactiveObject, name, value);
        Reactive(name)(reactiveObject, name);
      } else {
        reactiveObject[name] = value;
      }
    });
    injectReactiveSubscribe(reactiveObject);
    return reactiveObject;
  }

  function adaptReactive(adapter) {
    var _a;

    function data() {
      var _a, _b;

      return (_b = (_a = adapter.data) === null || _a === void 0 ? void 0 : _a.call(adapter)) !== null && _b !== void 0 ? _b : {};
    }

    var instanceRef = {
      current: ((_a = adapter.created) === null || _a === void 0 ? void 0 : _a.call(adapter, data())) || null
    };
    var firstState = null;
    return {
      state: function () {
        var inst = instanceRef.current;

        if (firstState) {
          return firstState;
        }

        if (adapter.state) {
          firstState = adapter.state;
        } else if (inst) {
          var observers_1 = getObservers(inst);
          firstState = keys(observers_1).reduce(function (prev, cur) {
            prev[cur] = observers_1[cur].current;
            return prev;
          }, {});
        }

        return firstState || {};
      },
      instance: function () {
        return instanceRef.current;
      },
      mounted: function () {
        var _a;

        instanceRef.current = ((_a = adapter.mounted) === null || _a === void 0 ? void 0 : _a.call(adapter, data())) || instanceRef.current;
      },
      init: function () {
        var _a;

        (_a = adapter.init) === null || _a === void 0 ? void 0 : _a.call(adapter, instanceRef.current, data());
      },
      destroy: function () {
        var _a;

        (_a = adapter.destroy) === null || _a === void 0 ? void 0 : _a.call(adapter, instanceRef.current, data());
      },
      methods: function () {
        return withReactiveMethods(instanceRef, adapter.methods);
      },
      on: function (eventName, listener) {
        var _a;

        (_a = adapter.on) === null || _a === void 0 ? void 0 : _a.call(adapter, instanceRef.current, eventName, listener);
      },
      off: function (eventName, listener) {
        var _a;

        (_a = adapter.off) === null || _a === void 0 ? void 0 : _a.call(adapter, instanceRef.current, eventName, listener);
      }
    };
  }

  var modules = {
    __proto__: null,
    keys: keys,
    camelize: camelize,
    isString: isString,
    isObject: isObject,
    isFunction: isFunction,
    findTarget: findTarget,
    withClassMethods: withClassMethods,
    withReactiveMethods: withReactiveMethods,
    observe: observe,
    defineObservers: defineObservers,
    getObservers: getObservers,
    getObserver: getObserver,
    setObserver: setObserver,
    isObserver: isObserver,
    Observer: Observer,
    reactive: reactive,
    Reactive: Reactive,
    injectReactiveSubscribe: injectReactiveSubscribe,
    ReactiveSubscribe: ReactiveSubscribe,
    adaptReactive: adaptReactive
  };

  /**
   * cfcs
   * Copyright (c) 2022-present NAVER Corp.
   * MIT license
   */

  return modules;

}));
//# sourceMappingURL=cfcs.js.map
